/*
 * Decompiled with CFR 0.152.
 */
package gregapi.code;

import gregapi.code.ICondition;

public interface IMath<O> {
    public static final IMath ZERO = new Val(0L);
    public static final IMath ONE = new Val(1L);

    public long getLong(O var1);

    public double getDouble(O var1);

    public static class Mul<O>
    implements IMath<O> {
        private final IMath<O>[] mValues;

        public Mul(IMath<O> ... aValues) {
            this.mValues = aValues;
        }

        @Override
        public long getLong(O aObject) {
            long rValue = 0L;
            for (IMath<O> tValue : this.mValues) {
                rValue *= tValue.getLong(aObject);
            }
            return rValue;
        }

        @Override
        public double getDouble(O aObject) {
            double rValue = 0.0;
            for (IMath<O> tValue : this.mValues) {
                rValue *= tValue.getDouble(aObject);
            }
            return rValue;
        }
    }

    public static class Sum<O>
    implements IMath<O> {
        private final IMath<O>[] mValues;

        public Sum(IMath<O> ... aValues) {
            this.mValues = aValues;
        }

        @Override
        public long getLong(O aObject) {
            long rValue = 0L;
            for (IMath<O> tValue : this.mValues) {
                rValue += tValue.getLong(aObject);
            }
            return rValue;
        }

        @Override
        public double getDouble(O aObject) {
            double rValue = 0.0;
            for (IMath<O> tValue : this.mValues) {
                rValue += tValue.getDouble(aObject);
            }
            return rValue;
        }
    }

    public static class Ter<O>
    implements IMath<O> {
        private final ICondition<O> mCondition;
        private final IMath<O> mValueTrue;
        private final IMath<O> mValueFalse;

        public Ter(ICondition<O> aCondition, IMath<O> aValueTrue, IMath<O> aValueFalse) {
            this.mCondition = aCondition;
            this.mValueTrue = aValueTrue;
            this.mValueFalse = aValueFalse;
        }

        @Override
        public long getLong(O aObject) {
            return this.mCondition.isTrue(aObject) ? this.mValueTrue.getLong(aObject) : this.mValueFalse.getLong(aObject);
        }

        @Override
        public double getDouble(O aObject) {
            return this.mCondition.isTrue(aObject) ? this.mValueTrue.getDouble(aObject) : this.mValueFalse.getDouble(aObject);
        }
    }

    public static class Neg<O>
    implements IMath<O> {
        private final IMath<O> mValue;

        public Neg(IMath<O> aValue) {
            this.mValue = aValue;
        }

        @Override
        public long getLong(O aObject) {
            return -this.mValue.getLong(aObject);
        }

        @Override
        public double getDouble(O aObject) {
            return -this.mValue.getDouble(aObject);
        }
    }

    public static class Val<O>
    implements IMath<O> {
        private final long mValueLong;
        private final double mValueDouble;

        public Val(long aValue) {
            this.mValueLong = aValue;
            this.mValueDouble = aValue;
        }

        public Val(double aValue) {
            this.mValueLong = (long)aValue;
            this.mValueDouble = aValue;
        }

        @Override
        public long getLong(O aObject) {
            return this.mValueLong;
        }

        @Override
        public double getDouble(O aObject) {
            return this.mValueDouble;
        }
    }
}

