/*
 * Decompiled with CFR 0.152.
 */
package gregapi.block.prefixblock;

import gregapi.block.prefixblock.PrefixBlock;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.data.TD;
import gregapi.item.IItemGT;
import gregapi.item.IItemNoGTOverride;
import gregapi.item.IItemUpdatable;
import gregapi.oredict.IOreDictItemDataOverrideItem;
import gregapi.oredict.IOreDictOptimizedParsingItem;
import gregapi.oredict.OreDictItemData;
import gregapi.oredict.OreDictMaterial;
import gregapi.oredict.OreDictPrefix;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class PrefixBlockItem
extends ItemBlock
implements IItemUpdatable,
IItemGT,
IItemNoGTOverride,
IOreDictItemDataOverrideItem,
IOreDictOptimizedParsingItem {
    public final PrefixBlock mBlock;

    public PrefixBlockItem(Block aBlock) {
        super(aBlock);
        this.func_77656_e(0);
        this.func_77627_a(true);
        this.mBlock = (PrefixBlock)aBlock;
    }

    public void func_150895_a(Item var1, CreativeTabs aCreativeTab, List aList) {
        if (!(!CS.SHOW_HIDDEN_PREFIXES && this.mBlock.mPrefix.contains(TD.Creative.HIDDEN) || !CS.SHOW_ORE_BLOCK_PREFIXES && this.mBlock.mPrefix.contains(TD.Prefix.ORE))) {
            for (int i = 0; i < OreDictMaterial.MATERIAL_ARRAY.length; ++i) {
                if (!this.mBlock.mPrefix.isGeneratingItem(OreDictMaterial.MATERIAL_ARRAY[i]) || !CS.SHOW_HIDDEN_MATERIALS && OreDictMaterial.MATERIAL_ARRAY[i].contains(TD.Creative.HIDDEN)) continue;
                ItemStack tStack = UT.Stacks.make((Item)this, 1L, (long)i);
                this.updateItemStack(tStack);
                aList.add(tStack);
            }
        }
        if (aList.isEmpty()) {
            UT.Stacks.hide((Item)this);
        }
    }

    public boolean placeBlockAt(ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, int aSide, float hitX, float hitY, float hitZ, int aMeta) {
        if (this.mBlock.placeBlock(aWorld, aX, aY, aZ, (byte)aSide, UT.Stacks.meta(aStack), aStack.func_77978_p(), true, false)) {
            if (aWorld.func_147439_a(aX, aY, aZ) == this.field_150939_a) {
                this.field_150939_a.func_149689_a(aWorld, aX, aY, aZ, (EntityLivingBase)aPlayer, aStack);
                this.field_150939_a.func_149714_e(aWorld, aX, aY, aZ, (int)UT.Stacks.meta(aStack));
            }
            return true;
        }
        UT.Entities.sendchat((Object)aPlayer, "Cannot place Block in this Environment!");
        return false;
    }

    public int func_82790_a(ItemStack aStack, int aRenderPass) {
        short aMetaData;
        if (aRenderPass == 0 && UT.Code.exists(aMetaData = UT.Stacks.meta(aStack), OreDictMaterial.MATERIAL_ARRAY)) {
            return UT.Code.getRGBInt(OreDictMaterial.MATERIAL_ARRAY[aMetaData].mRGBa[this.mBlock.mPrefix.mState]);
        }
        return 0xFFFFFF;
    }

    public final String func_77667_c(ItemStack aStack) {
        short aMetaData = UT.Stacks.meta(aStack);
        if (aMetaData == Short.MAX_VALUE) {
            return this.mBlock.mNameInternal + "." + Short.MAX_VALUE;
        }
        if (UT.Code.exists(aMetaData, OreDictMaterial.MATERIAL_ARRAY)) {
            return "oredict." + this.mBlock.mPrefix.dat(OreDictMaterial.MATERIAL_ARRAY[aMetaData]).toString();
        }
        return this.mBlock.func_149739_a();
    }

    public void func_77624_a(ItemStack aStack, EntityPlayer aPlayer, List aList, boolean aF3_H) {
        super.func_77624_a(aStack, aPlayer, aList, aF3_H);
        if (this.mBlock.mSpawnProof) {
            aList.add(LH.Chat.CYAN + LH.get("gt.lang.spawnproof"));
        }
        OreDictMaterial aMaterial = this.mBlock.getMetaMaterial(this.getDamage(aStack));
        aList.add(LH.Chat.WHITE + LH.get("gt.lang.blastresistance") + LH.Chat.ORANGE + this.mBlock.mBaseResistance * (float)(1 + this.mBlock.getHarvestLevel(aMaterial == null ? (byte)0 : aMaterial.mToolQuality)));
    }

    @Override
    public OreDictItemData getOreDictItemData(ItemStack aStack) {
        if (this.mBlock.mPrefix != null && UT.Code.exists(UT.Stacks.meta(aStack), OreDictMaterial.MATERIAL_ARRAY)) {
            return new OreDictItemData(this.mBlock.mPrefix, OreDictMaterial.MATERIAL_ARRAY[UT.Stacks.meta(aStack)]);
        }
        return null;
    }

    public final String func_77658_a() {
        return this.mBlock.func_149739_a();
    }

    public final boolean hasContainerItem(ItemStack aStack) {
        return this.getContainerItem(aStack) != null;
    }

    public ItemStack getContainerItem(ItemStack aStack) {
        return null;
    }

    @Override
    public void updateItemStack(ItemStack aStack) {
        OreDictMaterial aMaterial;
        short aDamage = UT.Stacks.meta(aStack);
        if (UT.Code.exists(aDamage, OreDictMaterial.MATERIAL_ARRAY) && (aMaterial = OreDictMaterial.MATERIAL_ARRAY[aDamage]) != aMaterial.mTargetRegistration) {
            aStack.func_77964_b((int)aMaterial.mTargetRegistration.mID);
        }
    }

    public void func_77622_d(ItemStack aStack, World aWorld, EntityPlayer aPlayer) {
        this.updateItemStack(aStack);
    }

    public boolean isBookEnchantable(ItemStack aStack, ItemStack aBook) {
        return false;
    }

    public boolean func_82789_a(ItemStack aStack, ItemStack aMaterial) {
        return false;
    }

    public int func_77619_b() {
        return 0;
    }

    public int getItemStackLimit(ItemStack aStack) {
        return this.mBlock.mPrefix.mDefaultStackSize;
    }

    @Override
    public OreDictMaterial getMaterial(int aMetaData) {
        return UT.Code.exists(aMetaData, OreDictMaterial.MATERIAL_ARRAY) ? OreDictMaterial.MATERIAL_ARRAY[aMetaData] : null;
    }

    @Override
    public OreDictPrefix getPrefix(int aMetaData) {
        return this.mBlock.mPrefix;
    }
}

