/*
 * Decompiled with CFR 0.152.
 */
package gregapi.block.prefixblock;

import cpw.mods.fml.common.registry.GameRegistry;
import gregapi.GT_API_Proxy;
import gregapi.block.IBlockExtendedMetaData;
import gregapi.block.IBlockMaterial;
import gregapi.block.IBlockPlacable;
import gregapi.block.IBlockRetrievable;
import gregapi.block.IBlockSyncData;
import gregapi.block.IBlockToolable;
import gregapi.block.ToolCompat;
import gregapi.block.behaviors.Drops;
import gregapi.block.prefixblock.PrefixBlockFallingEntity;
import gregapi.block.prefixblock.PrefixBlockItem;
import gregapi.block.prefixblock.PrefixBlockTileEntity;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.data.MT;
import gregapi.data.OP;
import gregapi.data.TD;
import gregapi.item.CreativeTab;
import gregapi.lang.LanguageHandler;
import gregapi.network.INetworkHandler;
import gregapi.oredict.OreDictManager;
import gregapi.oredict.OreDictMaterial;
import gregapi.oredict.OreDictMaterialStack;
import gregapi.oredict.OreDictPrefix;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.IRenderedBlock;
import gregapi.render.IRenderedBlockObject;
import gregapi.render.ITexture;
import gregapi.render.RendererBlockTextured;
import gregapi.tileentity.ITileEntity;
import gregapi.util.OM;
import gregapi.util.UT;
import ic2.api.tile.ExplosionWhitelist;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.ForgeEventFactory;

public class PrefixBlock
extends Block
implements Runnable,
IBlockExtendedMetaData,
IBlockSyncData,
IRenderedBlock,
ITileEntityProvider,
IBlockToolable,
IBlockPlacable,
IBlockRetrievable,
IBlockMaterial {
    public static ThreadLocal<PrefixBlockTileEntity> sTemporaryTileEntity = new ThreadLocal();
    public Drops mDrops;
    public final float mMinX;
    public final float mMinY;
    public final float mMinZ;
    public final float mMaxX;
    public final float mMaxY;
    public final float mMaxZ;
    public final int mHarvestLevelOffset;
    public final int mHarvestLevelMinimum;
    public final int mHarvestLevelMaximum;
    public final ITexture mTexture;
    public final String mNameInternal;
    public final String mTool;
    public final String mModIDOwner;
    public final OreDictPrefix mPrefix;
    public final OreDictMaterialStack mHullMaterial;
    public final float mBaseHardness;
    public final float mBaseResistance;
    public final boolean mGravity;
    public final boolean mBeaconBase;
    public final boolean mEnderDragonProof;
    public final boolean mWitherProof;
    public final boolean mSpawnProof;
    public final boolean mOpaque;
    public final boolean mNormalCube;
    public final boolean mPlacementChecksTemperature;
    public final boolean mPlacementChecksAntimatter;
    public final boolean mCanBurn;
    public final boolean mCanExplode;
    public final boolean mRenderOverlayInWorld;
    public final boolean mCanGlow;
    public final boolean mCanLight;
    public TileEntity mRenderParameterTileEntity = null;
    public IRenderedBlockObject mRenderingObjectBlock = null;
    public IRenderedBlockObject mRenderingObjectStack = null;
    private static boolean LOCK = false;

    @Deprecated
    public PrefixBlock(String aModIDOwner, String aModIDTextures, String aNameInternal, OreDictPrefix aPrefix, OreDictMaterialStack aHullMaterial, Class<? extends PrefixBlockItem> aItemClass, Drops aDrops, ITexture aTexture, Material aVanillaMaterial, Block.SoundType aSoundType, String aTool, float aBaseHardness, float aBaseResistance, int aHarvestLevelOffset, int aHarvestLevelMinimum, int aHarvestLevelMaximum, boolean aGravity, boolean aBeaconBase, boolean aEnderDragonProof, boolean aWitherProof, boolean aOpaque, boolean aNormalCube, boolean aPlacementChecksTemperature, boolean aPlacementChecksAntimatter, boolean aCanBurn, boolean aCanExplode, boolean aRenderOverlayInWorld, boolean aCanGlow, boolean aCanLight, boolean aSpawnProof) {
        this(aModIDOwner, aModIDTextures, aNameInternal, aPrefix, aHullMaterial, aItemClass, aDrops, aTexture, aVanillaMaterial, aSoundType, aTool, aBaseHardness, aBaseResistance, aHarvestLevelOffset, aHarvestLevelMinimum, aHarvestLevelMaximum, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, aGravity, aBeaconBase, aEnderDragonProof, aWitherProof, aOpaque, aNormalCube, aPlacementChecksTemperature, aPlacementChecksAntimatter, aCanBurn, aCanExplode, aRenderOverlayInWorld, aCanGlow, aCanLight, aSpawnProof);
    }

    public PrefixBlock(String aModIDOwner, String aModIDTextures, String aNameInternal, OreDictPrefix aPrefix, OreDictMaterialStack aHullMaterial, Class<? extends PrefixBlockItem> aItemClass, Drops aDrops, ITexture aTexture, Material aVanillaMaterial, Block.SoundType aSoundType, String aTool, float aBaseHardness, float aBaseResistance, int aHarvestLevelOffset, int aHarvestLevelMinimum, int aHarvestLevelMaximum, double aMinX, double aMinY, double aMinZ, double aMaxX, double aMaxY, double aMaxZ, boolean aGravity, boolean aBeaconBase, boolean aEnderDragonProof, boolean aWitherProof, boolean aOpaque, boolean aNormalCube, boolean aPlacementChecksTemperature, boolean aPlacementChecksAntimatter, boolean aCanBurn, boolean aCanExplode, boolean aRenderOverlayInWorld, boolean aCanGlow, boolean aCanLight, boolean aSpawnProof) {
        super(aVanillaMaterial);
        this.mPrefix = aPrefix;
        this.mNameInternal = aNameInternal;
        GameRegistry.registerBlock((Block)this, aItemClass == null ? PrefixBlockItem.class : aItemClass, (String)this.mNameInternal);
        this.mMinX = (float)aMinX;
        this.mMinY = (float)aMinY;
        this.mMinZ = (float)aMinZ;
        this.mMaxX = (float)aMaxX;
        this.mMaxY = (float)aMaxY;
        this.mMaxZ = (float)aMaxZ;
        this.func_149672_a(aSoundType);
        this.mOpaque = aOpaque;
        this.mGravity = aGravity;
        this.mCanBurn = aCanBurn;
        this.mCanGlow = aCanGlow;
        this.mCanLight = aCanLight;
        this.mCanExplode = aCanExplode;
        this.mNormalCube = aNormalCube;
        this.mBeaconBase = aBeaconBase;
        this.mSpawnProof = aSpawnProof;
        this.mWitherProof = aWitherProof;
        this.mEnderDragonProof = aEnderDragonProof;
        this.mRenderOverlayInWorld = aRenderOverlayInWorld;
        this.mPlacementChecksAntimatter = aPlacementChecksAntimatter;
        this.mPlacementChecksTemperature = aPlacementChecksTemperature;
        this.mTool = aTool.toLowerCase();
        this.mDrops = aDrops == null ? new Drops((Block)this, (Block)this) : aDrops;
        this.mTexture = aTexture;
        this.mModIDOwner = aModIDOwner;
        this.mHullMaterial = aHullMaterial;
        this.mBaseHardness = aBaseHardness;
        this.mBaseResistance = aBaseResistance;
        this.mHarvestLevelOffset = aHarvestLevelOffset;
        this.mHarvestLevelMinimum = Math.max(0, aHarvestLevelMinimum);
        this.mHarvestLevelMaximum = Math.max(aHarvestLevelMinimum, aHarvestLevelMaximum);
        this.mPrefix.addTextureSet(aModIDTextures, false);
        LH.add("oredict." + this.mPrefix.dat(MT.Empty).toString() + ".name", this.getLocalName(this.mPrefix, MT.Empty));
        LH.add(this.mNameInternal + "." + Short.MAX_VALUE + ".name", "Any Sub-Block of this one");
        this.field_149787_q = this.func_149662_c();
        int n = this.field_149786_r = this.func_149662_c() ? 255 : 0;
        if (this.mPrefix.mCreativeTab == null) {
            this.mPrefix.mCreativeTab = new CreativeTab(this.mPrefix.mNameInternal, this.mPrefix.mNameCategory, Item.func_150898_a((Block)this), Short.MAX_VALUE);
        }
        this.func_149647_a(this.mPrefix.mCreativeTab);
        if (CS.CODE_CLIENT) {
            MinecraftForgeClient.registerItemRenderer((Item)Item.func_150898_a((Block)this), (IItemRenderer)RendererBlockTextured.INSTANCE);
        }
        try {
            ExplosionWhitelist.addWhitelistedBlock((Block)this);
        }
        catch (Throwable e) {
            // empty catch block
        }
        (CS.GAPI.mBeforeInit == null ? CS.GAPI.mBeforePostInit : CS.GAPI.mBeforeInit).add(0, this);
    }

    @Override
    public void run() {
        boolean tUnificationAllowed = this.mPrefix.contains(TD.Prefix.UNIFICATABLE) && !this.mPrefix.contains(TD.Prefix.UNIFICATABLE_RECIPES);
        for (int i = 0; i < OreDictMaterial.MATERIAL_ARRAY.length; i = (int)((short)(i + 1))) {
            if (OreDictMaterial.MATERIAL_ARRAY[i] == null || !this.mPrefix.isGeneratingItem(OreDictMaterial.MATERIAL_ARRAY[i])) continue;
            ItemStack tStack = UT.Stacks.make(this, 1L, (long)i);
            UT.Stacks.update_(tStack);
            LH.add("oredict." + this.mPrefix.dat(OreDictMaterial.MATERIAL_ARRAY[i]).toString() + ".name", this.getLocalName(this.mPrefix, OreDictMaterial.MATERIAL_ARRAY[i]));
            if (tUnificationAllowed) {
                OreDictManager.INSTANCE.addTarget_(this.mPrefix, OreDictMaterial.MATERIAL_ARRAY[i], tStack);
                continue;
            }
            OreDictManager.INSTANCE.registerOre_(this.mPrefix, OreDictMaterial.MATERIAL_ARRAY[i], tStack);
        }
    }

    public void func_149651_a(IIconRegister aIconRegister) {
    }

    public IIcon func_149673_e(IBlockAccess aWorld, int aX, int aY, int aZ, int aSide) {
        return this.func_149691_a(aSide, this.getMetaDataValue(aWorld, aX, aY, aZ));
    }

    public IIcon func_149691_a(int aSide, int aMetaData) {
        if (this.mPrefix.mIconIndexBlock >= 0) {
            OreDictMaterial aMaterial = this.getMetaMaterial(aMetaData);
            if (aMaterial != null && aMaterial.mTextureSetsBlock != null) {
                return aMaterial.mTextureSetsBlock.get(this.mPrefix.mIconIndexBlock).getIcon(0);
            }
            return MT.NULL.mTextureSetsBlock.get(this.mPrefix.mIconIndexBlock).getIcon(0);
        }
        return null;
    }

    public int func_149741_i(int aMetaData) {
        OreDictMaterial aMaterial = this.getMetaMaterial(aMetaData);
        return aMaterial == null ? super.func_149741_i(aMetaData) : UT.Code.getRGBInt(aMaterial.mRGBa[this.mPrefix.mState]);
    }

    public ITexture getTexture(short aMetaData, boolean aRendersInWorld) {
        if (!this.mRenderOverlayInWorld && aRendersInWorld) {
            return this.mTexture;
        }
        if (this.mPrefix.mIconIndexBlock >= 0) {
            OreDictMaterial aMaterial = this.getMetaMaterial(aMetaData);
            if (this.mTexture == null) {
                if (aMaterial != null && aMaterial.mTextureSetsBlock != null) {
                    return BlockTextureDefault.get(aMaterial, this.mPrefix, this.mCanGlow && aMaterial.contains(TD.Properties.GLOWING));
                }
                return BlockTextureDefault.get(MT.NULL, this.mPrefix, false);
            }
            if (aMaterial != null && aMaterial.mTextureSetsBlock != null) {
                return BlockTextureMulti.get(this.mTexture, BlockTextureDefault.get(aMaterial, this.mPrefix, this.mCanGlow && aMaterial.contains(TD.Properties.GLOWING)));
            }
            return BlockTextureMulti.get(this.mTexture, BlockTextureDefault.get(MT.NULL, this.mPrefix, false));
        }
        return null;
    }

    @Override
    public ITexture getTexture(int aRenderPass, byte aSide, ItemStack aStack) {
        return this.getTexture(UT.Stacks.meta(aStack), false);
    }

    @Override
    public ITexture getTexture(int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered, IBlockAccess aWorld, int aX, int aY, int aZ) {
        return aShouldSideBeRendered[aSide] ? this.getTexture(this.getMetaDataValue(aWorld, aX, aY, aZ), true) : null;
    }

    @Override
    public boolean setBlockBounds(int aRenderPass, ItemStack aStack) {
        return false;
    }

    @Override
    public boolean setBlockBounds(int aRenderPass, IBlockAccess aWorld, int aX, int aY, int aZ, boolean[] aShouldSideBeRendered) {
        return false;
    }

    @Override
    public int getRenderPasses(ItemStack aStack) {
        return 1;
    }

    @Override
    public int getRenderPasses(IBlockAccess aWorld, int aX, int aY, int aZ, boolean[] aShouldSideBeRendered) {
        return 1;
    }

    @Override
    public IRenderedBlockObject passRenderingToObject(IBlockAccess aWorld, int aX, int aY, int aZ) {
        this.mRenderParameterTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        return this.mRenderingObjectBlock != null ? this.mRenderingObjectBlock : (this.mRenderParameterTileEntity instanceof IRenderedBlockObject ? (IRenderedBlockObject)this.mRenderParameterTileEntity : null);
    }

    @Override
    public IRenderedBlockObject passRenderingToObject(ItemStack aStack) {
        return this.mRenderingObjectStack;
    }

    public PrefixBlock setRenderingObject(IRenderedBlockObject aBlock, IRenderedBlockObject aStack) {
        this.mRenderingObjectBlock = aBlock;
        this.mRenderingObjectStack = aStack;
        return this;
    }

    public void onNeighborChange(IBlockAccess aWorld, int aX, int aY, int aZ, int aTileX, int aTileY, int aTileZ) {
        if (!LOCK) {
            LOCK = true;
            TileEntity aTileEntity = aWorld.func_147438_o(aX, aY, aZ);
            if (aTileEntity instanceof ITileEntity) {
                ((ITileEntity)aTileEntity).onAdjacentBlockChange(aTileX, aTileY, aTileZ);
            }
            LOCK = false;
        }
    }

    public void func_149695_a(World aWorld, int aX, int aY, int aZ, Block aBlock) {
        if (!LOCK) {
            LOCK = true;
            TileEntity aTileEntity = aWorld.func_147438_o(aX, aY, aZ);
            if (aTileEntity instanceof ITileEntity) {
                ((ITileEntity)aTileEntity).onAdjacentBlockChange(aX, aY, aZ);
            }
            LOCK = false;
        }
        aWorld.func_147464_a(aX, aY, aZ, (Block)this, this.func_149738_a(aWorld));
    }

    public void onBlockExploded(World aWorld, int aX, int aY, int aZ, Explosion aExplosion) {
        if (aWorld.field_72995_K) {
            return;
        }
        OreDictMaterial aMaterial = this.getMetaMaterial((IBlockAccess)aWorld, aX, aY, aZ);
        aWorld.func_147468_f(aX, aY, aZ);
        if (aMaterial != null && (this.mCanExplode && aMaterial.contains(TD.Properties.EXPLOSIVE) || this.mCanBurn && aMaterial.contains(TD.Properties.FLAMMABLE) && this.mPrefix.mFamiliarPrefixes.contains(OP.dust))) {
            try {
                aWorld.func_72885_a(null, (double)aX + 0.5, (double)aY + 0.5, (double)aZ + 0.5, (float)(this.mPrefix.mAmount > 0L ? this.mPrefix.mAmount : 420076800L) * 0.7f / 4.200768E8f, true, true);
            }
            catch (StackOverflowError e) {
                CS.ERR.println("WARNING: StackOverflow during Explosion has been prevented at: " + aX + " ; " + aY + " ; " + aZ);
            }
        }
    }

    public float getExplosionResistance(Entity par1Entity, World aWorld, int aX, int aY, int aZ, double explosionX, double explosionY, double explosionZ) {
        OreDictMaterial aMaterial = this.getMetaMaterial((IBlockAccess)aWorld, aX, aY, aZ);
        if (aMaterial != null && (this.mCanExplode && aMaterial.contains(TD.Properties.EXPLOSIVE) || this.mCanBurn && aMaterial.contains(TD.Properties.FLAMMABLE) && this.mPrefix.mFamiliarPrefixes.contains(OP.dust))) {
            return 0.0f;
        }
        return this.mBaseResistance * (float)(1 + this.getHarvestLevel(aWorld.func_72805_g(aX, aY, aZ)));
    }

    public boolean func_149696_a(World aWorld, int aX, int aY, int aZ, int aID, int aData) {
        TileEntity aTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        return aTileEntity == null || aTileEntity.func_145842_c(aID, aData);
    }

    public int func_149643_k(World aWorld, int aX, int aY, int aZ) {
        return this.getMetaDataValue((IBlockAccess)aWorld, aX, aY, aZ);
    }

    public ItemStack getPickBlock(MovingObjectPosition aTarget, World aWorld, int aX, int aY, int aZ) {
        return this.getItemStackFromBlock((IBlockAccess)aWorld, aX, aY, aZ, (byte)6);
    }

    public void func_149749_a(World aWorld, int aX, int aY, int aZ, Block aBlock, int par6) {
        TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        if (tTileEntity instanceof PrefixBlockTileEntity) {
            sTemporaryTileEntity.set((PrefixBlockTileEntity)tTileEntity);
        }
        aWorld.func_147475_p(aX, aY, aZ);
    }

    @Override
    public boolean placeBlock(World aWorld, int aX, int aY, int aZ, byte aSide, short aMetaData, NBTTagCompound aNBT, boolean aCauseBlockUpdates, boolean aForcePlacement) {
        OreDictMaterial aMaterial = this.getMetaMaterial(aMetaData);
        if (!(aMaterial == null || !aForcePlacement && (this.mPlacementChecksAntimatter && aMaterial.contains(TD.Atomic.ANTIMATTER) || this.mPlacementChecksTemperature && aMaterial.mMeltingPoint <= UT.Worlds.getTemperature(aWorld, aX, aY, aZ)) || !aWorld.func_147465_d(aX, aY, aZ, (Block)this, (int)UT.Code.bind4(aMaterial.mToolQuality), aCauseBlockUpdates ? 3 : 0))) {
            TileEntity tTileEntity = this.createTileEntity(aWorld, aX, aY, aZ, aSide, aMetaData, aNBT);
            UT.Worlds.setTileEntity(aWorld, aX, aY, aZ, tTileEntity, aCauseBlockUpdates);
            aWorld.func_147464_a(aX, aY, aZ, (Block)this, this.func_149738_a(aWorld));
            if (!aWorld.field_72995_K) {
                GT_API_Proxy.SCHEDULED_TILEENTITY_UPDATES.add((PrefixBlockTileEntity)tTileEntity);
            }
            return true;
        }
        return false;
    }

    @Override
    public ItemStack getItemStackFromBlock(IBlockAccess aWorld, int aX, int aY, int aZ, byte aSide) {
        TileEntity aTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        return UT.Stacks.make((Block)this, 1L, (long)this.getMetaDataValue(aTileEntity), aTileEntity instanceof PrefixBlockTileEntity ? ((PrefixBlockTileEntity)aTileEntity).mItemNBT : null);
    }

    public int getFlammability(IBlockAccess aWorld, int aX, int aY, int aZ, ForgeDirection aSide) {
        OreDictMaterialStack aMaterial = this.getMaterialAtSide(aWorld, aX, aY, aZ, UT.Code.side(aSide));
        return aMaterial == null || !this.mCanBurn ? 0 : (aMaterial.mMaterial.contains(TD.Properties.FLAMMABLE) ? 100 : 0) + (aMaterial.mMaterial.contains(TD.Properties.BURNING) ? 200 : 0);
    }

    public int getFireSpreadSpeed(IBlockAccess aWorld, int aX, int aY, int aZ, ForgeDirection aSide) {
        OreDictMaterialStack aMaterial = this.getMaterialAtSide(aWorld, aX, aY, aZ, UT.Code.side(aSide));
        return aMaterial == null || !this.mCanBurn ? 0 : (aMaterial.mMaterial.contains(TD.Properties.FLAMMABLE) ? 100 : 0) + (aMaterial.mMaterial.contains(TD.Properties.BURNING) ? 200 : 0);
    }

    public boolean isFireSource(World aWorld, int aX, int aY, int aZ, ForgeDirection aSide) {
        OreDictMaterialStack aMaterial = this.getMaterialAtSide((IBlockAccess)aWorld, aX, aY, aZ, UT.Code.side(aSide));
        return aMaterial != null && this.mCanBurn && aMaterial.mMaterial.contains(TD.Properties.FLAMMABLE) && aMaterial.mMaterial.contains(TD.Properties.UNBURNABLE);
    }

    public boolean canEntityDestroy(IBlockAccess aWorld, int aX, int aY, int aZ, Entity aEntity) {
        if (aEntity instanceof EntityDragon) {
            if (this.mEnderDragonProof) {
                return false;
            }
            OreDictMaterialStack aMaterial = this.getMaterialAtSide(aWorld, aX, aY, aZ, (byte)6);
            return aMaterial == null || !aMaterial.mMaterial.contains(TD.Properties.ENDER_DRAGON_PROOF);
        }
        if (aEntity instanceof EntityWither) {
            if (this.mWitherProof) {
                return false;
            }
            OreDictMaterialStack aMaterial = this.getMaterialAtSide(aWorld, aX, aY, aZ, (byte)6);
            return aMaterial == null || !aMaterial.mMaterial.contains(TD.Properties.WITHER_PROOF);
        }
        return true;
    }

    @Override
    public long onToolClick(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, World aWorld, byte aSide, int aX, int aY, int aZ, float aHitX, float aHitY, float aHitZ) {
        OreDictMaterial aMaterial = this.getMetaMaterial((IBlockAccess)aWorld, aX, aY, aZ);
        if (!aWorld.field_72995_K && aTool.equals("crowbar")) {
            if (this.mPrefix == OP.crateGtGem) {
                UT.Sounds.send(aWorld, "random.break", 1.0f, -1.0f, aX, aY, aZ);
                aWorld.func_147468_f(aX, aY, aZ);
                aWorld.func_72838_d((Entity)new EntityItem(aWorld, (double)aX + 0.5, (double)aY + 0.5, (double)aZ + 0.5, OP.gem.mat(aMaterial, 16L)));
                return 10000L;
            }
            if (this.mPrefix == OP.crateGtDust) {
                UT.Sounds.send(aWorld, "random.break", 1.0f, -1.0f, aX, aY, aZ);
                aWorld.func_147468_f(aX, aY, aZ);
                aWorld.func_72838_d((Entity)new EntityItem(aWorld, (double)aX + 0.5, (double)aY + 0.5, (double)aZ + 0.5, OP.dust.mat(aMaterial, 16L)));
                return 10000L;
            }
            if (this.mPrefix == OP.crateGtIngot) {
                UT.Sounds.send(aWorld, "random.break", 1.0f, -1.0f, aX, aY, aZ);
                aWorld.func_147468_f(aX, aY, aZ);
                aWorld.func_72838_d((Entity)new EntityItem(aWorld, (double)aX + 0.5, (double)aY + 0.5, (double)aZ + 0.5, OP.ingot.mat(aMaterial, 16L)));
                return 10000L;
            }
            if (this.mPrefix == OP.crateGtPlate) {
                UT.Sounds.send(aWorld, "random.break", 1.0f, -1.0f, aX, aY, aZ);
                aWorld.func_147468_f(aX, aY, aZ);
                aWorld.func_72838_d((Entity)new EntityItem(aWorld, (double)aX + 0.5, (double)aY + 0.5, (double)aZ + 0.5, OP.plate.mat(aMaterial, 16L)));
                return 10000L;
            }
            if (this.mPrefix == OP.crateGtPlateGem) {
                UT.Sounds.send(aWorld, "random.break", 1.0f, -1.0f, aX, aY, aZ);
                aWorld.func_147468_f(aX, aY, aZ);
                aWorld.func_72838_d((Entity)new EntityItem(aWorld, (double)aX + 0.5, (double)aY + 0.5, (double)aZ + 0.5, OP.plateGem.mat(aMaterial, 16L)));
                return 10000L;
            }
        }
        if (!aWorld.field_72995_K && aTool.equals("magnifyingglass")) {
            if (aChatReturn != null) {
                aChatReturn.add("This is " + this.getLocalName(this.mPrefix, aMaterial));
            }
            return 1L;
        }
        return ToolCompat.onToolClick(this, aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aWorld, aSide, aX, aY, aZ, aHitX, aHitY, aHitZ);
    }

    @Override
    public OreDictMaterialStack getMaterialAtSide(IBlockAccess aWorld, int aX, int aY, int aZ, byte aSide) {
        if (this.mHullMaterial != null) {
            return this.mHullMaterial;
        }
        OreDictMaterial aMaterial = this.getMetaMaterial(aWorld, aX, aY, aZ);
        return aMaterial == null ? null : OM.stack(this.mPrefix, aMaterial);
    }

    @Override
    public void setExtendedMetaData(IBlockAccess aWorld, int aX, int aY, int aZ, short aMetaData) {
        TileEntity aTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        if (aTileEntity == null && aWorld instanceof World) {
            aTileEntity = UT.Worlds.setTileEntity((World)aWorld, aX, aY, aZ, this.createTileEntity((World)aWorld, aX, aY, aZ, (byte)6, aMetaData, null), false);
        }
        if (aTileEntity instanceof PrefixBlockTileEntity) {
            ((PrefixBlockTileEntity)aTileEntity).mMetaData = aMetaData;
        }
        if (aWorld instanceof World && ((World)aWorld).field_72995_K) {
            ((World)aWorld).func_147471_g(aX, aY, aZ);
        }
    }

    @Override
    public short getExtendedMetaData(IBlockAccess aWorld, int aX, int aY, int aZ) {
        return this.getMetaDataValue(aWorld, aX, aY, aZ);
    }

    @Override
    public boolean removeMaterialFromSide(World aWorld, int aX, int aY, int aZ, byte aSide, OreDictMaterialStack aMaterial) {
        OreDictMaterialStack tMaterial = this.getMaterialAtSide((IBlockAccess)aWorld, aX, aY, aZ, aSide);
        if (aMaterial.mMaterial == tMaterial.mMaterial && aMaterial.mAmount > 0L && aMaterial.mAmount <= tMaterial.mAmount) {
            ItemStack tStack = OM.dust(aMaterial.mMaterial, tMaterial.mAmount - aMaterial.mAmount);
            if (tStack != null) {
                aWorld.func_72838_d((Entity)new EntityItem(aWorld, (double)aX + 0.5, (double)aY + 0.5, (double)aZ + 0.5, tStack));
            }
            aWorld.func_147468_f(aX, aY, aZ);
            return true;
        }
        return false;
    }

    public void func_149674_a(World aWorld, int aX, int aY, int aZ, Random aRandom) {
        if (aWorld.field_72995_K || this.checkGravity(aWorld, aX, aY, aZ)) {
            return;
        }
        TileEntity aTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        OreDictMaterial aMaterial = this.getMetaMaterial(aTileEntity);
        if (aMaterial != null) {
            if (this.mCanBurn && (this.mPrefix.mFamiliarPrefixes.contains(OP.dust) || this.mCanExplode && aMaterial.contains(TD.Properties.EXPLOSIVE)) && aMaterial.contains(TD.Properties.FLAMMABLE) && UT.Worlds.getTemperature(aWorld, aX, aY, aZ) > 373L) {
                aWorld.func_147468_f(aX, aY, aZ);
                try {
                    aWorld.func_72885_a(null, (double)aX + 0.5, (double)aY + 0.5, (double)aZ + 0.5, (aMaterial.contains(TD.Properties.EXPLOSIVE) ? (float)(this.mPrefix.mAmount > 0L ? this.mPrefix.mAmount : 420076800L) * 0.5f : (float)(this.mPrefix.mAmount > 0L ? this.mPrefix.mAmount : 420076800L) * 0.33f) / 4.200768E8f, true, true);
                }
                catch (StackOverflowError e) {
                    CS.ERR.println("WARNING: StackOverflow during Explosion has been prevented at: " + aX + " ; " + aY + " ; " + aZ);
                }
                return;
            }
            if ((this.mCanBurn || this.mCanExplode) && aMaterial.contains(TD.Atomic.ALKALI_METAL)) {
                boolean tExplode = false;
                for (byte tSide : CS.ALL_SIDES_VALID) {
                    Block tBlock = aWorld.func_147439_a(aX + CS.OFFSETS_X[tSide], aY + CS.OFFSETS_Y[tSide], aZ + CS.OFFSETS_Z[tSide]);
                    if (tBlock != Blocks.field_150355_j && tBlock != Blocks.field_150358_i) continue;
                    aWorld.func_147468_f(aX + CS.OFFSETS_X[tSide], aY + CS.OFFSETS_Y[tSide], aZ + CS.OFFSETS_Z[tSide]);
                    tExplode = true;
                }
                if (tExplode) {
                    aWorld.func_147468_f(aX, aY, aZ);
                    try {
                        aWorld.func_72885_a(null, (double)aX + 0.5, (double)aY + 0.5, (double)aZ + 0.5, (aMaterial.contains(TD.Properties.EXPLOSIVE) ? (float)(this.mPrefix.mAmount > 0L ? this.mPrefix.mAmount : 420076800L) * 0.5f : (float)(this.mPrefix.mAmount > 0L ? this.mPrefix.mAmount : 420076800L) * 0.33f) / 4.200768E8f, true, true);
                    }
                    catch (StackOverflowError e) {
                        CS.ERR.println("WARNING: StackOverflow during Explosion has been prevented at: " + aX + " ; " + aY + " ; " + aZ);
                    }
                    return;
                }
            }
        }
    }

    public void func_149690_a(World aWorld, int aX, int aY, int aZ, int aMeta, float aChance, int aFortune) {
        ArrayList<ItemStack> tList = this.mDrops.getDrops(this, aWorld, aX, aY, aZ, aFortune, false);
        aChance = ForgeEventFactory.fireBlockHarvesting(tList, (World)aWorld, (Block)this, (int)aX, (int)aY, (int)aZ, (int)aMeta, (int)aFortune, (float)aChance, (boolean)false, (EntityPlayer)((EntityPlayer)this.harvesters.get()));
        for (ItemStack tStack : tList) {
            if (!(aWorld.field_73012_v.nextFloat() <= aChance)) continue;
            this.func_149642_a(aWorld, aX, aY, aZ, tStack);
        }
    }

    public void func_149636_a(World aWorld, EntityPlayer aPlayer, int aX, int aY, int aZ, int aMeta) {
        aPlayer.func_71064_a(StatList.field_75934_C[PrefixBlock.func_149682_b((Block)this)], 1);
        aPlayer.func_71020_j(0.025f);
        boolean aSilkTouch = EnchantmentHelper.func_77502_d((EntityLivingBase)aPlayer);
        int aFortune = EnchantmentHelper.func_77517_e((EntityLivingBase)aPlayer);
        ArrayList<ItemStack> tList = this.mDrops.getDrops(this, aWorld, aX, aY, aZ, aFortune, aSilkTouch);
        float aChance = ForgeEventFactory.fireBlockHarvesting(tList, (World)aWorld, (Block)this, (int)aX, (int)aY, (int)aZ, (int)aMeta, (int)aFortune, (float)1.0f, (boolean)aSilkTouch, (EntityPlayer)aPlayer);
        for (ItemStack tStack : tList) {
            if (!(aWorld.field_73012_v.nextFloat() <= aChance)) continue;
            this.func_149642_a(aWorld, aX, aY, aZ, tStack);
        }
    }

    public int func_149701_w() {
        return ITexture.Util.MC_ALPHA_BLENDING ? 1 : 0;
    }

    public final ArrayList<ItemStack> getDrops(World aWorld, int aX, int aY, int aZ, int aUnusableMetaData, int aFortune) {
        return this.mDrops.getDrops(this, aWorld, aX, aY, aZ, aFortune, false);
    }

    public void func_149666_a(Item aItem, CreativeTabs aCreativeTab, List aList) {
        aItem.func_150895_a(aItem, aCreativeTab, aList);
    }

    public final TileEntity func_149915_a(World aWorld, int aMeta) {
        return null;
    }

    public final TileEntity createTileEntity(World aWorld, int aMeta) {
        return null;
    }

    public String toString() {
        return this.mNameInternal;
    }

    public String func_149739_a() {
        return this.mNameInternal;
    }

    public String func_149732_F() {
        return StatCollector.func_74838_a((String)(this.mNameInternal + ".name"));
    }

    public String getHarvestTool(int aMaterialToolQuality) {
        return this.mTool;
    }

    public boolean isToolEffective(String aType, int aMeta) {
        return this.getHarvestTool(aMeta).equals(aType);
    }

    public AxisAlignedBB func_149668_a(World aWorld, int aX, int aY, int aZ) {
        return AxisAlignedBB.func_72330_a((double)((float)aX + this.mMinX), (double)((float)aY + this.mMinY), (double)((float)aZ + this.mMinZ), (double)((float)aX + this.mMaxX), (double)((float)aY + this.mMaxY), (double)((float)aZ + this.mMaxZ));
    }

    public AxisAlignedBB func_149633_g(World aWorld, int aX, int aY, int aZ) {
        return AxisAlignedBB.func_72330_a((double)((float)aX + this.mMinX), (double)((float)aY + this.mMinY), (double)((float)aZ + this.mMinZ), (double)((float)aX + this.mMaxX), (double)((float)aY + this.mMaxY), (double)((float)aZ + this.mMaxZ));
    }

    public void func_149719_a(IBlockAccess aWorld, int aX, int aY, int aZ) {
        this.func_149676_a(this.mMinX, this.mMinY, this.mMinZ, this.mMaxX, this.mMaxY, this.mMaxZ);
    }

    public float func_149712_f(World aWorld, int aX, int aY, int aZ) {
        return this.mBaseHardness < 0.0f ? -1.0f : this.mBaseHardness * (float)(1 + this.getHarvestLevel(aWorld.func_72805_g(aX, aY, aZ)));
    }

    public int func_149645_b() {
        return RendererBlockTextured.INSTANCE == null ? super.func_149645_b() : RendererBlockTextured.INSTANCE.mRenderID;
    }

    public int getHarvestLevel(int aMaterialToolQuality) {
        return (int)UT.Code.bind_(this.mHarvestLevelMinimum, this.mHarvestLevelMaximum, this.mHarvestLevelOffset + aMaterialToolQuality);
    }

    public int func_149738_a(World aWorld) {
        return 2;
    }

    public int func_149720_d(IBlockAccess aWorld, int aX, int aY, int aZ) {
        return this.func_149741_i(this.getMetaDataValue(aWorld, aX, aY, aZ));
    }

    public int func_149717_k() {
        return this.mOpaque ? 255 : 0;
    }

    public boolean isBeaconBase(IBlockAccess aWorld, int aX, int aY, int aZ, int aBeaconX, int aBeaconY, int aBeaconZ) {
        return this.mBeaconBase;
    }

    public boolean isSideSolid(IBlockAccess aWorld, int aX, int aY, int aZ, ForgeDirection aSide) {
        return this.mOpaque;
    }

    public boolean canBeReplacedByLeaves(IBlockAccess aWorld, int aX, int aY, int aZ) {
        return false;
    }

    public boolean isNormalCube(IBlockAccess aWorld, int aX, int aY, int aZ) {
        return this.mNormalCube;
    }

    public boolean hasTileEntity(int aMeta) {
        return true;
    }

    public boolean func_149686_d() {
        return true;
    }

    public boolean func_149662_c() {
        return this.mOpaque;
    }

    public boolean func_149700_E() {
        return false;
    }

    public boolean func_149730_j() {
        return this.mOpaque;
    }

    public boolean canCreatureSpawn(EnumCreatureType aType, IBlockAccess aWorld, int aX, int aY, int aZ) {
        return !this.mSpawnProof;
    }

    public boolean func_149646_a(IBlockAccess aWorld, int aX, int aY, int aZ, int aSide) {
        this.func_149719_a(aWorld, aX, aY, aZ);
        return super.func_149646_a(aWorld, aX, aY, aZ, aSide);
    }

    @Override
    public boolean usesRenderPass(int aRenderPass, ItemStack aStack) {
        return true;
    }

    @Override
    public boolean usesRenderPass(int aRenderPass, IBlockAccess aWorld, int aX, int aY, int aZ, boolean[] aShouldSideBeRendered) {
        return true;
    }

    public String getLocalName(OreDictPrefix aPrefix, OreDictMaterial aMaterial) {
        return LanguageHandler.getLocalName(aPrefix, aMaterial);
    }

    public short getMetaDataValue(TileEntity aTileEntity) {
        return aTileEntity instanceof PrefixBlockTileEntity ? ((PrefixBlockTileEntity)aTileEntity).mMetaData : (short)0;
    }

    public short getMetaDataValue(IBlockAccess aWorld, int aX, int aY, int aZ) {
        return this.getMetaDataValue(aWorld.func_147438_o(aX, aY, aZ));
    }

    public OreDictMaterial getMetaMaterial(int aMetaData) {
        return UT.Code.exists(aMetaData, OreDictMaterial.MATERIAL_ARRAY) ? OreDictMaterial.MATERIAL_ARRAY[aMetaData] : null;
    }

    public OreDictMaterial getMetaMaterial(TileEntity aTileEntity) {
        return this.getMetaMaterial(aTileEntity instanceof PrefixBlockTileEntity ? (int)((PrefixBlockTileEntity)aTileEntity).mMetaData : 0);
    }

    public OreDictMaterial getMetaMaterial(IBlockAccess aWorld, int aX, int aY, int aZ) {
        return this.getMetaMaterial(aWorld.func_147438_o(aX, aY, aZ));
    }

    public TileEntity createTileEntity(World aWorld, int aX, int aY, int aZ, byte aSide, short aMetaData, NBTTagCompound aNBT) {
        PrefixBlockTileEntity rTileEntity = new PrefixBlockTileEntity();
        if (aNBT != null) {
            rTileEntity.func_145839_a(aNBT);
        }
        rTileEntity.mMetaData = aMetaData;
        rTileEntity.mItemNBT = aNBT == null ? null : (aNBT.func_74764_b("gt.nbt.drop") ? aNBT.func_74775_l("gt.nbt.drop") : aNBT);
        return rTileEntity;
    }

    protected boolean checkGravity(World aWorld, int aX, int aY, int aZ) {
        if (this.mGravity && aY > 0 && aWorld.func_147438_o(aX, aY, aZ) != null && BlockFalling.func_149831_e((World)aWorld, (int)aX, (int)(aY - 1), (int)aZ)) {
            if (!BlockFalling.field_149832_M && aWorld.func_72904_c(aX - 32, aY - 32, aZ - 32, aX + 32, aY + 32, aZ + 32)) {
                if (!aWorld.field_72995_K) {
                    aWorld.func_72838_d((Entity)new PrefixBlockFallingEntity(aWorld, (double)aX + 0.5, (double)aY + 0.5, (double)aZ + 0.5, this, this.getItemStackFromBlock((IBlockAccess)aWorld, aX, aY, aZ, (byte)1)));
                }
            } else {
                short tMetaData = this.getMetaDataValue((IBlockAccess)aWorld, aX, aY, aZ);
                aWorld.func_147468_f(aX, aY, aZ);
                while (BlockFalling.func_149831_e((World)aWorld, (int)aX, (int)(aY - 1), (int)aZ) && aY > 0) {
                    --aY;
                }
                if (aY > 0) {
                    this.placeBlock(aWorld, aX, aY, aZ, (byte)1, tMetaData, null, false, true);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void receiveDataByte(IBlockAccess aWorld, int aX, int aY, int aZ, byte aData, INetworkHandler aNetworkHandler) {
    }

    @Override
    public void receiveDataShort(IBlockAccess aWorld, int aX, int aY, int aZ, short aData, INetworkHandler aNetworkHandler) {
        this.setExtendedMetaData(aWorld, aX, aY, aZ, aData);
    }

    @Override
    public void receiveDataInteger(IBlockAccess aWorld, int aX, int aY, int aZ, int aData, INetworkHandler aNetworkHandler) {
    }

    @Override
    public void receiveDataLong(IBlockAccess aWorld, int aX, int aY, int aZ, long aData, INetworkHandler aNetworkHandler) {
    }

    @Override
    public void receiveDataByteArray(IBlockAccess aWorld, int aX, int aY, int aZ, byte[] aData, INetworkHandler aNetworkHandler) {
    }

    @Override
    public void receiveDataName(IBlockAccess aWorld, int aX, int aY, int aZ, String aData, INetworkHandler aNetworkHandler) {
        TileEntity aTileEntity;
        if (UT.Code.stringValid(aData) && (aTileEntity = aWorld.func_147438_o(aX, aY, aZ)) instanceof PrefixBlockTileEntity) {
            if (((PrefixBlockTileEntity)aTileEntity).mItemNBT == null) {
                ((PrefixBlockTileEntity)aTileEntity).mItemNBT = new NBTTagCompound();
            }
            ((PrefixBlockTileEntity)aTileEntity).mItemNBT.func_74782_a("display", (NBTBase)UT.NBT.getNBTString(((PrefixBlockTileEntity)aTileEntity).mItemNBT.func_74775_l("display"), "Name", aData));
        }
    }
}

