/*
 * Decompiled with CFR 0.152.
 */
package gregapi.block.multitileentity.example;

import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.block.multitileentity.MultiTileEntityRegistry;
import gregapi.code.ArrayListNoNulls;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.network.INetworkHandler;
import gregapi.network.IPacket;
import gregapi.render.BlockTextureCopied;
import gregapi.render.ITexture;
import gregapi.tileentity.base.TileEntityBase04MultiTileEntities;
import gregapi.tileentity.data.ITileEntitySurface;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.tileentity.delegate.ITileEntityDelegating;
import gregapi.util.UT;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class MultiTileEntityPortalNether
extends TileEntityBase04MultiTileEntities
implements ITileEntitySurface,
ITileEntityDelegating,
IFluidHandler,
ISidedInventory,
IMultiTileEntity.IMTE_OnToolClick,
IMultiTileEntity.IMTE_IsProvidingWeakPower,
IMultiTileEntity.IMTE_GetComparatorInputOverride,
IMultiTileEntity.IMTE_RandomDisplayTick,
IMultiTileEntity.IMTE_GetExplosionResistance,
IMultiTileEntity.IMTE_GetBlockHardness,
IMultiTileEntity.IMTE_GetLightOpacity,
IMultiTileEntity.IMTE_AddToolTips,
IMultiTileEntity.IMTE_SyncDataByte {
    protected boolean mActive = false;
    protected boolean oActive = false;
    public static List<MultiTileEntityPortalNether> sListNetherSide = new ArrayListNoNulls<MultiTileEntityPortalNether>();
    public static List<MultiTileEntityPortalNether> sListWorldSide = new ArrayListNoNulls<MultiTileEntityPortalNether>();
    public MultiTileEntityPortalNether mTarget = null;
    public final byte[] mRedstone = new byte[]{0, 0, 0, 0, 0, 0};
    public final byte[] mComparator = new byte[]{0, 0, 0, 0, 0, 0};
    public final byte[] xRedstone = new byte[]{0, 0, 0, 0, 0, 0};
    public final byte[] xComparator = new byte[]{0, 0, 0, 0, 0, 0};
    public final byte[] wRedstone = new byte[]{0, 0, 0, 0, 0, 0};
    public final byte[] wComparator = new byte[]{0, 0, 0, 0, 0, 0};
    private static final String sToolTipFunction1 = "gt.tileentity.portal.nether.tooltip.1";
    private static final String sToolTipFunction2 = "gt.tileentity.portal.nether.tooltip.2";
    private static final String sToolTipFunction3 = "gt.tileentity.portal.nether.tooltip.3";
    private static float[][] sBlockBounds;
    private static boolean[][] sRenderedSides;
    public ITexture sNetherPortal = BlockTextureCopied.get((Block)Blocks.field_150427_aO, 6, 0, CS.UNCOLOURED, false, true, true);
    public ITexture sNetherPortalFrame = BlockTextureCopied.get(Blocks.field_150343_Z, 6, 0);
    public byte mLastSide = (byte)6;

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.func_74764_b("gt.active")) {
            this.mActive = aNBT.func_74767_n("gt.active");
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        UT.NBT.setBoolean(aNBT, "gt.active", this.mActive);
    }

    @Override
    public void addToolTips(List aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.CYAN + LH.get(sToolTipFunction1));
        aList.add(LH.Chat.CYAN + LH.get(sToolTipFunction2));
        aList.add(LH.Chat.CYAN + LH.get(sToolTipFunction3));
        aList.add(LH.Chat.ORANGE + LH.get("gt.lang.requirement.ignite.fire"));
        aList.add(LH.Chat.ORANGE + LH.get("gt.lang.requirement.chunk.loader"));
    }

    @Override
    public void onTickFirst(boolean aIsServerSide) {
        super.onTickFirst(aIsServerSide);
        if (aIsServerSide && this.mActive) {
            this.addThisPortalToLists();
            this.causeBlockUpdate();
        }
    }

    @Override
    public void onTickStart(long aTimer, boolean aIsServerSide) {
        super.onTickStart(aTimer, aIsServerSide);
        if (aIsServerSide) {
            for (byte tSide : CS.ALL_SIDES_VALID) {
                if (this.mActive) {
                    if (this.xRedstone[tSide] >= 0) {
                        if (this.mRedstone[tSide] != this.xRedstone[tSide]) {
                            this.mRedstone[tSide] = this.xRedstone[tSide];
                            this.causeBlockUpdate();
                        }
                        this.xRedstone[tSide] = -1;
                        this.wRedstone[tSide] = 0;
                    } else if (this.wRedstone[tSide] >= 100) {
                        if (this.mRedstone[tSide] != 0) {
                            this.mRedstone[tSide] = 0;
                            this.causeBlockUpdate();
                        }
                    } else {
                        byte by = tSide;
                        this.wRedstone[by] = (byte)(this.wRedstone[by] + 1);
                    }
                    if (this.xComparator[tSide] >= 0) {
                        if (this.mComparator[tSide] != this.xComparator[tSide]) {
                            this.mComparator[tSide] = this.xComparator[tSide];
                            this.causeBlockUpdate();
                        }
                        this.xComparator[tSide] = -1;
                        this.wComparator[tSide] = 0;
                        continue;
                    }
                    if (this.wComparator[tSide] >= 100) {
                        if (this.mComparator[tSide] == 0) continue;
                        this.mComparator[tSide] = 0;
                        this.causeBlockUpdate();
                        continue;
                    }
                    byte by = tSide;
                    this.wComparator[by] = (byte)(this.wComparator[by] + 1);
                    continue;
                }
                if (this.mRedstone[tSide] != 0) {
                    this.mRedstone[tSide] = 0;
                    this.causeBlockUpdate();
                }
                if (this.mComparator[tSide] == 0) continue;
                this.mComparator[tSide] = 0;
                this.causeBlockUpdate();
            }
        }
    }

    @Override
    public void onTick(long aTimer, boolean aIsServerSide) {
        super.onTick(aTimer, aIsServerSide);
        if (aIsServerSide && this.mTarget != null) {
            for (byte tSide : CS.ALL_SIDES_VALID) {
                this.mTarget.xRedstone[CS.OPPOSITES[tSide]] = (byte)UT.Code.bind_(this.mTarget.xRedstone[CS.OPPOSITES[tSide]], 15L, this.getRedstoneIncoming(tSide));
                this.mTarget.xComparator[CS.OPPOSITES[tSide]] = (byte)UT.Code.bind_(this.mTarget.xComparator[CS.OPPOSITES[tSide]], 15L, this.getComparatorIncoming(tSide));
            }
        }
    }

    public void findTargetPortal() {
        block4: {
            block5: {
                this.mTarget = null;
                if (this.field_145850_b == null || !this.isServerSide()) break block4;
                if (this.field_145850_b.field_73011_w.field_76574_g != 0) break block5;
                long tShortestDistance = 16384L;
                for (MultiTileEntityPortalNether tTarget : sListNetherSide) {
                    if (tTarget == this) continue;
                    long tXDifference = this.field_145851_c - tTarget.field_145851_c * 8;
                    long tZDifference = this.field_145849_e - tTarget.field_145849_e * 8;
                    long tTempDist = tXDifference * tXDifference + tZDifference * tZDifference;
                    if (tTempDist < tShortestDistance) {
                        tShortestDistance = tTempDist;
                        this.mTarget = tTarget;
                        continue;
                    }
                    if (tTempDist != tShortestDistance || this.mTarget != null && Math.abs(tTarget.field_145848_d - this.field_145848_d) >= Math.abs(this.mTarget.field_145848_d - this.field_145848_d)) continue;
                    this.mTarget = tTarget;
                }
                break block4;
            }
            if (this.field_145850_b.field_73011_w.field_76574_g != -1) break block4;
            long tShortestDistance = 16384L;
            for (MultiTileEntityPortalNether tTarget : sListWorldSide) {
                if (tTarget == this) continue;
                long tXDifference = tTarget.field_145851_c - this.field_145851_c * 8;
                long tZDifference = tTarget.field_145849_e - this.field_145849_e * 8;
                long tTempDist = tXDifference * tXDifference + tZDifference * tZDifference;
                if (tTempDist < tShortestDistance) {
                    tShortestDistance = tTempDist;
                    this.mTarget = tTarget;
                    continue;
                }
                if (tTempDist != tShortestDistance || this.mTarget != null && Math.abs(tTarget.field_145848_d - this.field_145848_d) >= Math.abs(this.mTarget.field_145848_d - this.field_145848_d)) continue;
                this.mTarget = tTarget;
            }
        }
    }

    public void addThisPortalToLists() {
        if (this.field_145850_b != null && this.isServerSide()) {
            if (this.field_145850_b.field_73011_w.field_76574_g == 0) {
                if (!sListWorldSide.contains(this)) {
                    sListWorldSide.add(this);
                }
                for (MultiTileEntityPortalNether tPortal : sListNetherSide) {
                    tPortal.findTargetPortal();
                }
                this.findTargetPortal();
            } else if (this.field_145850_b.field_73011_w.field_76574_g == -1) {
                if (!sListNetherSide.contains(this)) {
                    sListNetherSide.add(this);
                }
                for (MultiTileEntityPortalNether tPortal : sListWorldSide) {
                    tPortal.findTargetPortal();
                }
                this.findTargetPortal();
            }
        }
    }

    public void removeThisPortalFromLists() {
        if (sListWorldSide.remove(this)) {
            for (MultiTileEntityPortalNether tPortal : sListNetherSide) {
                if (tPortal.mTarget != this) continue;
                tPortal.findTargetPortal();
            }
        }
        if (sListNetherSide.remove(this)) {
            for (MultiTileEntityPortalNether tPortal : sListWorldSide) {
                if (tPortal.mTarget != this) continue;
                tPortal.findTargetPortal();
            }
        }
        this.mTarget = null;
    }

    public void setPortalActive() {
        if (!this.mActive) {
            this.mActive = true;
            this.addThisPortalToLists();
            this.causeBlockUpdate();
        }
    }

    public void setPortalInactive() {
        if (this.mActive) {
            this.mActive = false;
            this.removeThisPortalFromLists();
            for (byte tSide : CS.ALL_SIDES_VALID) {
                this.mRedstone[tSide] = 0;
                this.mComparator[tSide] = 0;
            }
            this.causeBlockUpdate();
        }
    }

    @Override
    public long onToolClick(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (this.isClientSide()) {
            return 0L;
        }
        if (aTool.equals("igniter")) {
            if (this.mActive) {
                this.setPortalInactive();
            } else {
                this.setPortalActive();
            }
            if (this.mTarget != null && aChatReturn != null) {
                aChatReturn.add("X: " + this.mTarget.field_145851_c + "   Y: " + this.mTarget.field_145848_d + "   Z: " + this.mTarget.field_145849_e);
            }
            return 10000L;
        }
        if (aTool.equals("extinguisher")) {
            if (this.mActive) {
                this.setPortalInactive();
            }
            return 10000L;
        }
        return 0L;
    }

    @Override
    public boolean onTickCheck(long aTimer) {
        return this.mActive != this.oActive || super.onTickCheck(aTimer);
    }

    @Override
    public void onTickResetChecks(long aTimer, boolean aIsServerSide) {
        super.onTickResetChecks(aTimer, aIsServerSide);
        this.oActive = this.mActive;
    }

    @Override
    public void func_145829_t() {
        super.func_145829_t();
        if (this.mActive) {
            this.addThisPortalToLists();
        }
    }

    @Override
    public void func_145843_s() {
        this.removeThisPortalFromLists();
        super.func_145843_s();
    }

    @Override
    public void onChunkUnload() {
        this.removeThisPortalFromLists();
        super.onChunkUnload();
    }

    @Override
    public IPacket getClientDataPacket(boolean aSendAll) {
        return this.getClientDataPacketByte(aSendAll, (byte)(this.mActive ? 1 : 0));
    }

    @Override
    public boolean receiveDataByte(byte aData, INetworkHandler aNetworkHandler) {
        if (this.mActive) {
            this.mActive = (aData & 1) != 0;
        } else {
            boolean bl = this.mActive = (aData & 1) != 0;
            if (this.mActive && this.mTimer > 20L) {
                UT.Sounds.play("portal.portal", 10, 1.0f, 1.0f, this.getCoords());
            }
        }
        return true;
    }

    @Override
    public int getLightOpacity() {
        return 1;
    }

    @Override
    public float getSurfaceSize(byte aSide) {
        return 1.0f;
    }

    @Override
    public float getSurfaceSizeAttachable(byte aSide) {
        return 0.75f;
    }

    @Override
    public float getSurfaceDistance(byte aSide) {
        return 0.0f;
    }

    @Override
    public boolean isSurfaceSolid(byte aSide) {
        return false;
    }

    @Override
    public boolean isSurfaceOpaque(byte aSide) {
        return false;
    }

    @Override
    public int getFireSpreadSpeed(byte aSide) {
        return 0;
    }

    @Override
    public int getFlammability(byte aSide) {
        return 0;
    }

    @Override
    public float getBlockHardness() {
        return Blocks.field_150343_Z.func_149712_f(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public float getExplosionResistance(Entity aExploder, double aExplosionX, double aExplosionY, double aExplosionZ) {
        return Blocks.field_150343_Z.func_149638_a(aExploder);
    }

    @Override
    public float getExplosionResistance() {
        return Blocks.field_150343_Z.func_149638_a(null);
    }

    @Override
    public void randomDisplayTick(Random aRandom) {
        if (this.mActive) {
            for (int i = 0; i < 4; ++i) {
                this.field_145850_b.func_72869_a("portal", (double)((float)this.field_145851_c + aRandom.nextFloat()), (double)((float)this.field_145848_d + aRandom.nextFloat()), (double)((float)this.field_145849_e + aRandom.nextFloat()), ((double)aRandom.nextFloat() - 0.5) * 0.5, ((double)aRandom.nextFloat() - 0.5) * 0.5, ((double)aRandom.nextFloat() - 0.5) * 0.5);
            }
        }
    }

    @Override
    public int getRenderPasses(Block aBlock, boolean[] aShouldSideBeRendered) {
        return 13;
    }

    @Override
    public boolean setBlockBounds(Block aBlock, int aRenderPass, boolean[] aShouldSideBeRendered) {
        float[] tBounds = sBlockBounds[aRenderPass];
        aBlock.func_149676_a(tBounds[0], tBounds[1], tBounds[2], tBounds[3], tBounds[4], tBounds[5]);
        return true;
    }

    @Override
    public ITexture getTexture(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        return sRenderedSides[aRenderPass][aSide] ? (aRenderPass == 0 ? (this.mActive || this.field_145850_b == null ? this.sNetherPortal : null) : this.sNetherPortalFrame) : null;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.portal.nether";
    }

    @Override
    public DelegatorTileEntity<TileEntity> getDelegateTileEntity(byte aSide) {
        if (this.mTarget == null) {
            return new DelegatorTileEntity<TileEntity>(this, aSide);
        }
        return this.mTarget.getAdjacentTileEntity(CS.OPPOSITES[aSide]);
    }

    @Override
    public boolean isExtender(byte aSide) {
        return this.mTarget != null;
    }

    @Override
    public int getComparatorInputOverride(byte aSide) {
        return this.mComparator[aSide];
    }

    @Override
    public int isProvidingWeakPower(byte aSide) {
        return this.mRedstone[CS.OPPOSITES[aSide]];
    }

    public ItemStack func_70298_a(int aSlot, int aDecrement) {
        if (this.mTarget != null) {
            DelegatorTileEntity<IInventory> tTileEntity = this.mTarget.getAdjacentInventory(CS.OPPOSITES[this.mLastSide]);
            if (tTileEntity.mTileEntity != null) {
                return ((IInventory)tTileEntity.mTileEntity).func_70298_a(aSlot, aDecrement);
            }
        }
        return null;
    }

    public ItemStack func_70304_b(int aSlot) {
        if (this.mTarget != null) {
            DelegatorTileEntity<IInventory> tTileEntity = this.mTarget.getAdjacentInventory(CS.OPPOSITES[this.mLastSide]);
            if (tTileEntity.mTileEntity != null) {
                return ((IInventory)tTileEntity.mTileEntity).func_70304_b(aSlot);
            }
        }
        return null;
    }

    public ItemStack func_70301_a(int aSlot) {
        if (this.mTarget != null) {
            DelegatorTileEntity<IInventory> tTileEntity = this.mTarget.getAdjacentInventory(CS.OPPOSITES[this.mLastSide]);
            if (tTileEntity.mTileEntity != null) {
                return ((IInventory)tTileEntity.mTileEntity).func_70301_a(aSlot);
            }
        }
        return null;
    }

    public String func_145825_b() {
        String rName;
        if (this.mTarget != null) {
            DelegatorTileEntity<IInventory> tTileEntity = this.mTarget.getAdjacentInventory(CS.OPPOSITES[this.mLastSide]);
            if (tTileEntity.mTileEntity != null) {
                return ((IInventory)tTileEntity.mTileEntity).func_145825_b();
            }
        }
        if (UT.Code.stringValid(rName = this.getCustomName())) {
            return rName;
        }
        MultiTileEntityRegistry tRegistry = MultiTileEntityRegistry.getRegistry(this.getMultiTileEntityRegistryID());
        return tRegistry == null ? this.getClass().getName() : tRegistry.getLocal(this.getMultiTileEntityID());
    }

    public int func_70302_i_() {
        if (this.mTarget != null) {
            DelegatorTileEntity<IInventory> tTileEntity = this.mTarget.getAdjacentInventory(CS.OPPOSITES[this.mLastSide]);
            if (tTileEntity.mTileEntity != null) {
                return ((IInventory)tTileEntity.mTileEntity).func_70302_i_();
            }
        }
        return 0;
    }

    public int func_70297_j_() {
        if (this.mTarget != null) {
            DelegatorTileEntity<IInventory> tTileEntity = this.mTarget.getAdjacentInventory(CS.OPPOSITES[this.mLastSide]);
            if (tTileEntity.mTileEntity != null) {
                return ((IInventory)tTileEntity.mTileEntity).func_70297_j_();
            }
        }
        return 0;
    }

    public void func_70299_a(int aSlot, ItemStack aStack) {
        if (this.mTarget != null) {
            DelegatorTileEntity<IInventory> tTileEntity = this.mTarget.getAdjacentInventory(CS.OPPOSITES[this.mLastSide]);
            if (tTileEntity.mTileEntity != null) {
                ((IInventory)tTileEntity.mTileEntity).func_70299_a(aSlot, aStack);
            }
        }
    }

    public boolean func_145818_k_() {
        if (this.mTarget != null) {
            DelegatorTileEntity<IInventory> tTileEntity = this.mTarget.getAdjacentInventory(CS.OPPOSITES[this.mLastSide]);
            if (tTileEntity.mTileEntity != null) {
                return ((IInventory)tTileEntity.mTileEntity).func_145818_k_();
            }
        }
        return this.getCustomName() != null;
    }

    public boolean func_94041_b(int aSlot, ItemStack aStack) {
        if (this.mTarget != null) {
            DelegatorTileEntity<IInventory> tTileEntity = this.mTarget.getAdjacentInventory(CS.OPPOSITES[this.mLastSide]);
            if (tTileEntity.mTileEntity != null) {
                return ((IInventory)tTileEntity.mTileEntity).func_94041_b(aSlot, aStack);
            }
        }
        return false;
    }

    public int[] func_94128_d(int aSide) {
        this.mLastSide = (byte)aSide;
        if (this.mTarget != null) {
            DelegatorTileEntity<IInventory> tTileEntity = this.mTarget.getAdjacentInventory(CS.OPPOSITES[this.mLastSide]);
            if (tTileEntity.mTileEntity instanceof ISidedInventory) {
                return ((ISidedInventory)tTileEntity.mTileEntity).func_94128_d((int)tTileEntity.mSideOfTileEntity);
            }
            if (tTileEntity.mTileEntity != null) {
                int[] tReturn = new int[((IInventory)tTileEntity.mTileEntity).func_70302_i_()];
                for (int i = 0; i < tReturn.length; ++i) {
                    tReturn[i] = i;
                }
                return tReturn;
            }
        }
        return CS.ZL_INTEGER;
    }

    public boolean func_102007_a(int aSlot, ItemStack aStack, int aSide) {
        this.mLastSide = (byte)aSide;
        if (this.mTarget != null) {
            DelegatorTileEntity<IInventory> tTileEntity = this.mTarget.getAdjacentInventory(CS.OPPOSITES[this.mLastSide]);
            if (tTileEntity.mTileEntity instanceof ISidedInventory) {
                return ((ISidedInventory)tTileEntity.mTileEntity).func_102007_a(aSlot, aStack, (int)tTileEntity.mSideOfTileEntity);
            }
            if (tTileEntity.mTileEntity != null) {
                return true;
            }
        }
        return false;
    }

    public boolean func_102008_b(int aSlot, ItemStack aStack, int aSide) {
        this.mLastSide = (byte)aSide;
        if (this.mTarget != null) {
            DelegatorTileEntity<IInventory> tTileEntity = this.mTarget.getAdjacentInventory(CS.OPPOSITES[this.mLastSide]);
            if (tTileEntity.mTileEntity instanceof ISidedInventory) {
                return ((ISidedInventory)tTileEntity.mTileEntity).func_102008_b(aSlot, aStack, (int)tTileEntity.mSideOfTileEntity);
            }
            if (tTileEntity.mTileEntity != null) {
                return true;
            }
        }
        return false;
    }

    @Override
    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (this.mTarget != null) {
            DelegatorTileEntity<IFluidHandler> tTileEntity = this.mTarget.getAdjacentTank(CS.OPPOSITES[UT.Code.side(from)]);
            if (tTileEntity.mTileEntity != null) {
                return ((IFluidHandler)tTileEntity.mTileEntity).fill(tTileEntity.getForgeSideOfTileEntity(), resource, doFill);
            }
        }
        return 0;
    }

    @Override
    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (this.mTarget != null) {
            DelegatorTileEntity<IFluidHandler> tTileEntity = this.mTarget.getAdjacentTank(CS.OPPOSITES[UT.Code.side(from)]);
            if (tTileEntity.mTileEntity != null) {
                return ((IFluidHandler)tTileEntity.mTileEntity).drain(tTileEntity.getForgeSideOfTileEntity(), resource, doDrain);
            }
        }
        return null;
    }

    @Override
    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (this.mTarget != null) {
            DelegatorTileEntity<IFluidHandler> tTileEntity = this.mTarget.getAdjacentTank(CS.OPPOSITES[UT.Code.side(from)]);
            if (tTileEntity.mTileEntity != null) {
                return ((IFluidHandler)tTileEntity.mTileEntity).drain(tTileEntity.getForgeSideOfTileEntity(), maxDrain, doDrain);
            }
        }
        return null;
    }

    @Override
    public boolean canFill(ForgeDirection from, Fluid fluid) {
        if (this.mTarget != null) {
            DelegatorTileEntity<IFluidHandler> tTileEntity = this.mTarget.getAdjacentTank(CS.OPPOSITES[UT.Code.side(from)]);
            if (tTileEntity.mTileEntity != null) {
                return ((IFluidHandler)tTileEntity.mTileEntity).canFill(tTileEntity.getForgeSideOfTileEntity(), fluid);
            }
        }
        return false;
    }

    @Override
    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        if (this.mTarget != null) {
            DelegatorTileEntity<IFluidHandler> tTileEntity = this.mTarget.getAdjacentTank(CS.OPPOSITES[UT.Code.side(from)]);
            if (tTileEntity.mTileEntity != null) {
                return ((IFluidHandler)tTileEntity.mTileEntity).canDrain(tTileEntity.getForgeSideOfTileEntity(), fluid);
            }
        }
        return false;
    }

    @Override
    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        if (this.mTarget != null) {
            DelegatorTileEntity<IFluidHandler> tTileEntity = this.mTarget.getAdjacentTank(CS.OPPOSITES[UT.Code.side(from)]);
            if (tTileEntity.mTileEntity != null) {
                return ((IFluidHandler)tTileEntity.mTileEntity).getTankInfo(tTileEntity.getForgeSideOfTileEntity());
            }
        }
        return CS.ZL_FLUIDTANKINFO;
    }

    public boolean func_70300_a(EntityPlayer aPlayer) {
        return aPlayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    static {
        LH.add(sToolTipFunction1, "Teleports Items, Fluids, Redstone, Comparator Signals, GT Energy and more!");
        LH.add(sToolTipFunction2, "Only works between the Nether and the Overworld with the x8 Distance Factor!");
        LH.add(sToolTipFunction3, "Always teleports things to the closest active Portal in Range!");
        sBlockBounds = new float[][]{{CS.PIXELS_POS[1], CS.PIXELS_POS[1], CS.PIXELS_POS[1], CS.PIXELS_NEG[1], CS.PIXELS_NEG[1], CS.PIXELS_NEG[1]}, {CS.PIXELS_POS[0], CS.PIXELS_POS[0], CS.PIXELS_POS[0], CS.PIXELS_NEG[0], CS.PIXELS_NEG[14], CS.PIXELS_NEG[14]}, {CS.PIXELS_POS[0], CS.PIXELS_POS[0], CS.PIXELS_POS[0], CS.PIXELS_NEG[14], CS.PIXELS_NEG[0], CS.PIXELS_NEG[14]}, {CS.PIXELS_POS[0], CS.PIXELS_POS[0], CS.PIXELS_POS[0], CS.PIXELS_NEG[14], CS.PIXELS_NEG[14], CS.PIXELS_NEG[0]}, {CS.PIXELS_POS[14], CS.PIXELS_POS[0], CS.PIXELS_POS[0], CS.PIXELS_NEG[0], CS.PIXELS_NEG[14], CS.PIXELS_NEG[0]}, {CS.PIXELS_POS[14], CS.PIXELS_POS[0], CS.PIXELS_POS[0], CS.PIXELS_NEG[0], CS.PIXELS_NEG[0], CS.PIXELS_NEG[14]}, {CS.PIXELS_POS[0], CS.PIXELS_POS[14], CS.PIXELS_POS[0], CS.PIXELS_NEG[14], CS.PIXELS_NEG[0], CS.PIXELS_NEG[0]}, {CS.PIXELS_POS[0], CS.PIXELS_POS[14], CS.PIXELS_POS[0], CS.PIXELS_NEG[0], CS.PIXELS_NEG[0], CS.PIXELS_NEG[14]}, {CS.PIXELS_POS[0], CS.PIXELS_POS[0], CS.PIXELS_POS[14], CS.PIXELS_NEG[14], CS.PIXELS_NEG[0], CS.PIXELS_NEG[0]}, {CS.PIXELS_POS[0], CS.PIXELS_POS[0], CS.PIXELS_POS[14], CS.PIXELS_NEG[0], CS.PIXELS_NEG[14], CS.PIXELS_NEG[0]}, {CS.PIXELS_POS[0], CS.PIXELS_POS[14], CS.PIXELS_POS[14], CS.PIXELS_NEG[0], CS.PIXELS_NEG[0], CS.PIXELS_NEG[0]}, {CS.PIXELS_POS[14], CS.PIXELS_POS[0], CS.PIXELS_POS[14], CS.PIXELS_NEG[0], CS.PIXELS_NEG[0], CS.PIXELS_NEG[0]}, {CS.PIXELS_POS[14], CS.PIXELS_POS[14], CS.PIXELS_POS[0], CS.PIXELS_NEG[0], CS.PIXELS_NEG[0], CS.PIXELS_NEG[0]}};
        sRenderedSides = new boolean[][]{{true, true, true, true, true, true}, {true, true, true, true, false, false}, {false, false, true, true, true, true}, {true, true, false, false, true, true}, {true, true, false, false, true, true}, {false, false, true, true, true, true}, {true, true, false, false, true, true}, {true, true, true, true, false, false}, {false, false, true, true, true, true}, {true, true, true, true, false, false}, {true, true, true, true, false, false}, {false, false, true, true, true, true}, {true, true, false, false, true, true}};
    }
}

