/*
 * Decompiled with CFR 0.152.
 */
package gregapi.block.multitileentity.example;

import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.block.multitileentity.MultiTileEntityBlockInternal;
import gregapi.block.multitileentity.MultiTileEntityContainer;
import gregapi.block.multitileentity.MultiTileEntityRegistry;
import gregapi.data.CS;
import gregapi.data.MD;
import gregapi.data.MT;
import gregapi.gui.ContainerClientChest;
import gregapi.gui.ContainerCommonChest;
import gregapi.network.INetworkHandler;
import gregapi.network.IPacket;
import gregapi.oredict.OreDictMaterial;
import gregapi.render.ITexture;
import gregapi.tileentity.ITileEntityAdjacentInventoryUpdatable;
import gregapi.tileentity.ITileEntityDecolorable;
import gregapi.tileentity.ITileEntityInventoryGUI;
import gregapi.tileentity.base.TileEntityBase05Inventories;
import gregapi.tileentity.data.ITileEntitySurface;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.util.UT;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraftforge.common.ChestGenHooks;
import org.lwjgl.opengl.GL11;

public class MultiTileEntityChest
extends TileEntityBase05Inventories
implements ITileEntityDecolorable,
ITileEntitySurface,
IMultiTileEntity.IMTE_OnRegistrationClient,
IMultiTileEntity.IMTE_OnRegistrationFirstClient,
IMultiTileEntity.IMTE_SyncDataByte,
IMultiTileEntity.IMTE_AddToolTips,
IMultiTileEntity.IMTE_SetBlockBoundsBasedOnState,
IMultiTileEntity.IMTE_GetSubItems,
IMultiTileEntity.IMTE_SyncDataByteArray,
IMultiTileEntity.IMTE_GetExplosionResistance,
IMultiTileEntity.IMTE_GetBlockHardness,
IMultiTileEntity.IMTE_GetComparatorInputOverride,
IMultiTileEntity.IMTE_GetSelectedBoundingBoxFromPool,
IMultiTileEntity.IMTE_GetCollisionBoundingBoxFromPool,
IMultiTileEntity.IMTE_OnPlaced,
IMultiTileEntity.IMTE_OnToolClick {
    protected boolean mIsPainted = false;
    protected int mRGBa = 0xFFFFFF;
    protected byte mFacing = (byte)3;
    protected byte mUsingPlayers = 0;
    protected byte oUsingPlayers = 0;
    protected float mLidAngle = 0.0f;
    protected float oLidAngle = 0.0f;
    protected float mHardness = 3.0f;
    protected float mResistance = 3.0f;
    protected OreDictMaterial mMaterial = MT.NULL;
    public String mTextureName = "";
    public String mDungeonLootName = "";
    private static final float minX = 0.0625f;
    private static final float minY = 0.0f;
    private static final float minZ = 0.0625f;
    private static final float maxX = 0.9375f;
    private static final float maxY = 0.875f;
    private static final float maxZ = 0.9375f;
    @SideOnly(value=Side.CLIENT)
    private static MultiTileEntityRendererChest RENDERER;

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.func_74764_b("gt.color")) {
            this.mRGBa = aNBT.func_74762_e("gt.color");
        }
        if (aNBT.func_74764_b("gt.facing")) {
            this.mFacing = aNBT.func_74771_c("gt.facing");
        }
        if (aNBT.func_74764_b("gt.painted")) {
            this.mIsPainted = aNBT.func_74767_n("gt.painted");
        }
        if (aNBT.func_74764_b("gt.texture")) {
            this.mTextureName = aNBT.func_74779_i("gt.texture");
        }
        if (aNBT.func_74764_b("gt.dungeonloot")) {
            this.mDungeonLootName = aNBT.func_74779_i("gt.dungeonloot");
        }
        if (aNBT.func_74764_b("gt.hardness")) {
            this.mHardness = aNBT.func_74760_g("gt.hardness");
        }
        if (aNBT.func_74764_b("gt.resistance")) {
            this.mResistance = aNBT.func_74760_g("gt.resistance");
        }
        if (aNBT.func_74764_b("gt.material")) {
            this.mMaterial = OreDictMaterial.get(aNBT.func_74779_i("gt.material"));
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        aNBT.func_74774_a("gt.facing", this.mFacing);
        if (UT.Code.stringValid(this.mDungeonLootName)) {
            aNBT.func_74778_a("gt.dungeonloot", this.mDungeonLootName);
        }
    }

    @Override
    public boolean onTickCheck(long aTimer) {
        return this.mUsingPlayers != this.oUsingPlayers || super.onTickCheck(aTimer);
    }

    @Override
    public void onTickResetChecks(long aTimer, boolean aIsServerSide) {
        super.onTickResetChecks(aTimer, aIsServerSide);
        this.oUsingPlayers = this.mUsingPlayers;
    }

    @Override
    public IPacket getClientDataPacket(boolean aSendAll) {
        if (aSendAll) {
            return this.getClientDataPacketByteArray(aSendAll, this.mFacing, this.mUsingPlayers, (byte)this.func_70302_i_(), (byte)UT.Code.getR(this.mRGBa), (byte)UT.Code.getG(this.mRGBa), (byte)UT.Code.getB(this.mRGBa));
        }
        return this.getClientDataPacketByte(aSendAll, this.mUsingPlayers);
    }

    @Override
    public boolean onPlaced(ItemStack aStack, EntityPlayer aPlayer, MultiTileEntityContainer aMTEContainer, World aWorld, int aX, int aY, int aZ, byte aSide, float aHitX, float aHitY, float aHitZ) {
        this.mFacing = UT.Code.getSideForPlayerPlacing((Entity)aPlayer, this.mFacing, CS.SIDES_HORIZONTAL);
        return true;
    }

    @Override
    public void onTick(long aTimer, boolean aIsServerSide) {
        super.onTick(aTimer, aIsServerSide);
        if (this.isServerSide()) {
            if (this.mInventoryChanged) {
                for (byte tSide : CS.ALL_SIDES_VALID) {
                    DelegatorTileEntity<TileEntity> tDelegator = this.getAdjacentTileEntity(tSide);
                    if (!(tDelegator.mTileEntity instanceof ITileEntityAdjacentInventoryUpdatable)) continue;
                    ((ITileEntityAdjacentInventoryUpdatable)tDelegator.mTileEntity).adjacentInventoryUpdated(tDelegator.mSideOfTileEntity, this);
                }
            }
            if (this.mUsingPlayers > 0 && aTimer % 1200L == 0L) {
                this.mUsingPlayers = UT.Code.bind7(this.getOpenGUIs());
            }
        }
        this.oLidAngle = this.mLidAngle;
        if (this.mUsingPlayers > 0 && this.mLidAngle == 0.0f) {
            this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "random.chestopen", 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
        if (this.mUsingPlayers == 0 && this.mLidAngle > 0.0f || this.mUsingPlayers > 0 && this.mLidAngle < 1.0f) {
            this.mLidAngle = this.mUsingPlayers > 0 ? (this.mLidAngle += 0.1f) : (this.mLidAngle -= 0.1f);
            if (this.mLidAngle > 1.0f) {
                this.mLidAngle = 1.0f;
            } else if (this.mLidAngle < 0.0f) {
                this.mLidAngle = 0.0f;
            }
            if (this.mLidAngle < 0.5f && this.oLidAngle >= 0.5f) {
                this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "random.chestclosed", 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
        }
    }

    @Override
    public long onToolClick(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ) {
        byte aTargetSide;
        if (this.isClientSide()) {
            return 0L;
        }
        if (aTool.equals("wrench") && (aTargetSide = UT.Code.getSideWrenching(aSide, aHitX, aHitY, aHitZ)) > 1) {
            this.mFacing = aTargetSide;
            this.updateClientData();
            this.causeBlockUpdate();
            return 10000L;
        }
        return 0L;
    }

    @Override
    public boolean onBlockActivated2(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (this.isServerSide() && !this.field_145850_b.isSideSolid(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e, CS.FORGE_DIR[0]) && this.isUseableByPlayerGUI(aPlayer)) {
            this.generateDungeonLoot();
            this.openGUI(aPlayer);
        }
        return true;
    }

    @Override
    public boolean breakBlock() {
        this.generateDungeonLoot();
        return super.breakBlock();
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return true;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.chest";
    }

    @Override
    public void openInventoryGUI() {
        this.mUsingPlayers = (byte)(this.mUsingPlayers + 1);
    }

    @Override
    public void closeInventoryGUI() {
        this.mUsingPlayers = (byte)(this.mUsingPlayers - 1);
    }

    @Override
    public float getExplosionResistance(Entity aExploder, double aExplosionX, double aExplosionY, double aExplosionZ) {
        return this.getExplosionResistance();
    }

    @Override
    public float getExplosionResistance() {
        return this.mResistance;
    }

    @Override
    public float getBlockHardness() {
        return this.mHardness;
    }

    @Override
    public int getComparatorInputOverride(byte aSide) {
        return Container.func_94526_b((IInventory)this);
    }

    @Override
    public ITexture getTexture(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        return null;
    }

    @Override
    public int getRenderPasses(Block aBlock, boolean[] aShouldSideBeRendered) {
        return 0;
    }

    @Override
    public boolean renderBlock(Block aBlock, RenderBlocks aRenderer) {
        return true;
    }

    protected void generateDungeonLoot() {
        if (this.isServerSide() && UT.Code.stringValid(this.mDungeonLootName)) {
            WeightedRandomChestContent.func_76293_a((Random)this.field_145850_b.field_73012_v, (WeightedRandomChestContent[])ChestGenHooks.getItems((String)this.mDungeonLootName, (Random)this.field_145850_b.field_73012_v), (IInventory)this, (int)ChestGenHooks.getCount((String)this.mDungeonLootName, (Random)this.field_145850_b.field_73012_v));
            this.mDungeonLootName = "";
        }
    }

    @Override
    public boolean getSubItems(MultiTileEntityBlockInternal aBlock, Item aItem, CreativeTabs aTab, List aList, short aID) {
        if (CS.D1) {
            for (String tLoot : new String[]{"mineshaftCorridor", "pyramidDesertyChest", "pyramidJungleChest", "pyramidJungleDispenser", "strongholdCorridor", "strongholdLibrary", "strongholdCrossing", "villageBlacksmith", "bonusChest", "dungeonChest"}) {
                aList.add(aBlock.mMultiTileEntityRegistry.getItem((int)aID, UT.NBT.getNBTString(null, "gt.dungeonloot", tLoot)));
            }
        }
        return true;
    }

    @Override
    public void addToolTips(List aList, ItemStack aStack, boolean aF3_H) {
        if (aStack.func_77978_p() != null && aStack.func_77978_p().func_74764_b("gt.dungeonloot")) {
            aList.add("Dungeon Loot: " + aStack.func_77978_p().func_74779_i("gt.dungeonloot"));
        }
    }

    @Override
    public boolean receiveDataByte(byte aData, INetworkHandler aNetworkHandler) {
        this.mUsingPlayers = aData;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return true;
    }

    @Override
    public boolean receiveDataByteArray(byte[] aData, INetworkHandler aNetworkHandler) {
        this.mFacing = (byte)(aData[0] & 7);
        this.mUsingPlayers = aData[1];
        if (UT.Code.unsignB(aData[2]) != this.func_70302_i_()) {
            this.setInventory(new ItemStack[UT.Code.unsignB(aData[2])]);
        }
        this.mRGBa = UT.Code.getRGBInt(new short[]{UT.Code.unsignB(aData[3]), UT.Code.unsignB(aData[4]), UT.Code.unsignB(aData[5])});
        return true;
    }

    @Override
    public boolean unpaint() {
        if (this.mIsPainted) {
            this.mIsPainted = false;
            this.mRGBa = UT.Code.getRGBInt(this.mMaterial.mRGBaSolid);
            this.updateClientData();
            return true;
        }
        return false;
    }

    @Override
    public boolean isPainted() {
        return this.mIsPainted || this.field_145850_b != null && this.isClientSide() && UT.Code.getRGBInt(this.mMaterial.mRGBaSolid) != this.mRGBa;
    }

    @Override
    public boolean paint(int aRGB) {
        if (aRGB != this.mRGBa) {
            this.mRGBa = aRGB;
            this.mIsPainted = true;
            return true;
        }
        return false;
    }

    @Override
    public int getPaint() {
        return this.mRGBa;
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool() {
        return AxisAlignedBB.func_72330_a((double)((float)this.field_145851_c + 0.0625f), (double)((float)this.field_145848_d + 0.0f), (double)((float)this.field_145849_e + 0.0625f), (double)((float)this.field_145851_c + 0.9375f), (double)((float)this.field_145848_d + 0.875f), (double)((float)this.field_145849_e + 0.9375f));
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBoxFromPool() {
        return AxisAlignedBB.func_72330_a((double)((float)this.field_145851_c + 0.0625f), (double)((float)this.field_145848_d + 0.0f), (double)((float)this.field_145849_e + 0.0625f), (double)((float)this.field_145851_c + 0.9375f), (double)((float)this.field_145848_d + 0.875f), (double)((float)this.field_145849_e + 0.9375f));
    }

    @Override
    public void setBlockBoundsBasedOnState(Block aBlock) {
        aBlock.func_149676_a(0.0625f, 0.0f, 0.0625f, 0.9375f, 0.875f, 0.9375f);
    }

    @Override
    public boolean setBlockBounds(Block aBlock, int aRenderPass, boolean[] aShouldSideBeRendered) {
        aBlock.func_149676_a(0.0625f, 0.0f, 0.0625f, 0.9375f, 0.875f, 0.9375f);
        return true;
    }

    @Override
    public float getSurfaceSize(byte aSide) {
        return 0.875f;
    }

    @Override
    public float getSurfaceSizeAttachable(byte aSide) {
        return 0.875f;
    }

    @Override
    public float getSurfaceDistance(byte aSide) {
        return aSide > 1 ? 0.0625f : (aSide == 1 ? 0.125f : 0.0f);
    }

    @Override
    public boolean isSurfaceSolid(byte aSide) {
        return false;
    }

    @Override
    public boolean isSurfaceOpaque(byte aSide) {
        return false;
    }

    @Override
    public Object getGUIClient(int aGUIID, EntityPlayer aPlayer) {
        return new ContainerClientChest(aPlayer.field_71071_by, (ITileEntityInventoryGUI)this);
    }

    @Override
    public Object getGUIServer(int aGUIID, EntityPlayer aPlayer) {
        return new ContainerCommonChest(aPlayer.field_71071_by, this);
    }

    @Override
    public boolean renderItem(Block aBlock, RenderBlocks aRenderer) {
        TileEntityRendererDispatcher.field_147556_a.func_147549_a((TileEntity)this, 0.0, 0.0, 0.0, 0.0f);
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onRegistrationFirstClient(MultiTileEntityRegistry aRegistry, short aID) {
        RENDERER = new MultiTileEntityRendererChest();
        ClientRegistry.bindTileEntitySpecialRenderer(this.getClass(), (TileEntitySpecialRenderer)RENDERER);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onRegistrationClient(MultiTileEntityRegistry aRegistry, short aID) {
        MultiTileEntityChest.RENDERER.mResources.put(this.mTextureName, new ResourceLocation[]{new ResourceLocation(MD.GT.mID, "textures/model/" + aRegistry.mNameInternal + "/" + this.mTextureName + ".colored.png"), new ResourceLocation(MD.GT.mID, "textures/model/" + aRegistry.mNameInternal + "/" + this.mTextureName + ".plain.png")});
    }

    @SideOnly(value=Side.CLIENT)
    public static class MultiTileEntityModelChest
    extends ModelBase {
        private final ModelRenderer mLid = new ModelRenderer((ModelBase)this, 0, 0).func_78787_b(64, 64);
        private final ModelRenderer mBottom;
        private final ModelRenderer mKnob;

        public MultiTileEntityModelChest() {
            this.mLid.func_78790_a(0.0f, -5.0f, -14.0f, 14, 5, 14, 0.0f);
            this.mLid.field_78800_c = 1.0f;
            this.mLid.field_78797_d = 7.0f;
            this.mLid.field_78798_e = 15.0f;
            this.mKnob = new ModelRenderer((ModelBase)this, 0, 0).func_78787_b(64, 64);
            this.mKnob.func_78790_a(-1.0f, -2.0f, -15.0f, 2, 4, 1, 0.0f);
            this.mKnob.field_78800_c = 8.0f;
            this.mKnob.field_78797_d = 7.0f;
            this.mKnob.field_78798_e = 15.0f;
            this.mBottom = new ModelRenderer((ModelBase)this, 0, 19).func_78787_b(64, 64);
            this.mBottom.func_78790_a(0.0f, 0.0f, 0.0f, 14, 10, 14, 0.0f);
            this.mBottom.field_78800_c = 1.0f;
            this.mBottom.field_78797_d = 6.0f;
            this.mBottom.field_78798_e = 1.0f;
        }

        public void render(float aLidAngle) {
            this.mKnob.field_78795_f = this.mLid.field_78795_f = aLidAngle;
            this.mLid.func_78785_a(0.0625f);
            this.mKnob.func_78785_a(0.0625f);
            this.mBottom.func_78785_a(0.0625f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class MultiTileEntityRendererChest
    extends TileEntitySpecialRenderer {
        private static final MultiTileEntityModelChest sModel = new MultiTileEntityModelChest();
        public final Map<String, ResourceLocation[]> mResources = new HashMap<String, ResourceLocation[]>();

        public void func_147500_a(TileEntity aTileEntity, double aX, double aY, double aZ, float aPartialTick) {
            if (aTileEntity instanceof MultiTileEntityChest) {
                ResourceLocation[] tLocation = this.mResources.get(((MultiTileEntityChest)aTileEntity).mTextureName);
                this.func_147499_a(tLocation[0]);
                GL11.glPushMatrix();
                GL11.glEnable((int)32826);
                short[] tRGBa = UT.Code.getRGBaArray(((MultiTileEntityChest)aTileEntity).mRGBa);
                GL11.glColor4f((float)((float)tRGBa[0] / 256.0f), (float)((float)tRGBa[1] / 256.0f), (float)((float)tRGBa[2] / 256.0f), (float)1.0f);
                GL11.glTranslatef((float)((float)aX), (float)((float)aY + 1.0f), (float)((float)aZ + 1.0f));
                GL11.glScalef((float)1.0f, (float)-1.0f, (float)-1.0f);
                GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
                switch (((MultiTileEntityChest)aTileEntity).mFacing) {
                    case 2: {
                        GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        break;
                    }
                    case 4: {
                        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        break;
                    }
                    case 5: {
                        GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        break;
                    }
                    default: {
                        GL11.glRotatef((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    }
                }
                GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
                float tLidAngle = 1.0f - (((MultiTileEntityChest)aTileEntity).oLidAngle + (((MultiTileEntityChest)aTileEntity).mLidAngle - ((MultiTileEntityChest)aTileEntity).oLidAngle) * aPartialTick);
                tLidAngle = -((1.0f - tLidAngle * tLidAngle * tLidAngle) * 3.141593f / 2.0f);
                sModel.render(tLidAngle);
                GL11.glDisable((int)32826);
                GL11.glPopMatrix();
                GL11.glEnable((int)32826);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.func_147499_a(tLocation[1]);
                GL11.glPushMatrix();
                GL11.glTranslatef((float)((float)aX), (float)((float)aY + 1.0f), (float)((float)aZ + 1.0f));
                GL11.glScalef((float)1.0f, (float)-1.0f, (float)-1.0f);
                GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
                switch (((MultiTileEntityChest)aTileEntity).mFacing) {
                    case 2: {
                        GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        break;
                    }
                    case 4: {
                        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        break;
                    }
                    case 5: {
                        GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        break;
                    }
                    default: {
                        GL11.glRotatef((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    }
                }
                GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
                sModel.render(tLidAngle);
                GL11.glDisable((int)32826);
                GL11.glPopMatrix();
                GL11.glEnable((int)32826);
            }
        }
    }
}

