/*
 * Decompiled with CFR 0.152.
 */
package gregapi.block.multitileentity.example;

import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.block.multitileentity.MultiTileEntityContainer;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.network.INetworkHandler;
import gregapi.network.IPacket;
import gregapi.old.Textures;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.notick.TileEntityBase05Paintable;
import gregapi.util.UT;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class MultiTileEntityBunkerBlock
extends TileEntityBase05Paintable
implements IMultiTileEntity.IMTE_GetPlayerRelativeBlockHardness,
IMultiTileEntity.IMTE_AddToolTips,
IMultiTileEntity.IMTE_OnPlaced {
    public UUID mOwner;
    public static IIconContainer sColored = new Textures.BlockIcons.CustomIcon("bunker/block/colored");
    public static IIconContainer sOverlay = new Textures.BlockIcons.CustomIcon("bunker/block/overlay");

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.func_74764_b("gt.owner")) {
            this.mOwner = UUID.fromString(aNBT.func_74779_i("gt.owner"));
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        if (this.mOwner != null) {
            aNBT.func_74778_a("gt.owner", this.mOwner.toString());
        }
    }

    @Override
    public void addToolTips(List aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.ORANGE + LH.get("gt.lang.owner.controlled"));
    }

    @Override
    public boolean allowInteraction(Entity aEntity) {
        if (aEntity != null) {
            UUID tUUID = aEntity.func_110124_au();
            return this.mOwner == null || tUUID != null && tUUID.equals(this.mOwner);
        }
        return this.mOwner == null;
    }

    @Override
    public boolean onPlaced(ItemStack aStack, EntityPlayer aPlayer, MultiTileEntityContainer aMTEContainer, World aWorld, int aX, int aY, int aZ, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (aPlayer != null) {
            this.mOwner = aPlayer.func_110124_au();
        }
        return true;
    }

    @Override
    public IPacket getClientDataPacket(boolean aSendAll) {
        if (aSendAll) {
            byte[] tName = this.mOwner == null ? CS.ZL_BYTE : this.mOwner.toString().getBytes();
            byte[] tData = new byte[tName.length + 3];
            tData[0] = (byte)UT.Code.getR(this.mRGBa);
            tData[1] = (byte)UT.Code.getG(this.mRGBa);
            tData[2] = (byte)UT.Code.getB(this.mRGBa);
            for (int i = 0; i < tName.length; i = (int)((short)(i + 1))) {
                tData[i + 3] = tName[i];
            }
            return this.getClientDataPacketByteArray(aSendAll, tData);
        }
        return null;
    }

    @Override
    public boolean receiveDataByteArray(byte[] aData, INetworkHandler aNetworkHandler) {
        this.mRGBa = UT.Code.getRGBInt(new short[]{UT.Code.unsignB(aData[0]), UT.Code.unsignB(aData[1]), UT.Code.unsignB(aData[2])});
        if (aData.length > 3) {
            this.mOwner = UUID.fromString(new String(aData, 4, aData.length - 4));
        }
        return true;
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        return aShouldSideBeRendered[aSide] ? BlockTextureMulti.get(BlockTextureDefault.get(sColored, this.mRGBa), BlockTextureDefault.get(sOverlay)) : null;
    }

    @Override
    public float getPlayerRelativeBlockHardness(EntityPlayer aPlayer, float aOriginal) {
        return this.allowInteraction((Entity)aPlayer) ? Math.max(aOriginal, 1.0E-4f) : 0.0f;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.bunker.block";
    }
}

