/*
 * Decompiled with CFR 0.152.
 */
package gregapi.block.multitileentity;

import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.block.multitileentity.MultiTileEntityBlock;
import gregapi.block.multitileentity.MultiTileEntityBlockInternal;
import gregapi.block.multitileentity.MultiTileEntityClassContainer;
import gregapi.block.multitileentity.MultiTileEntityContainer;
import gregapi.code.ArrayListNoNulls;
import gregapi.code.HashSetNoNulls;
import gregapi.code.ItemStackContainer;
import gregapi.code.ItemStackMap;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.item.CreativeTab;
import gregapi.recipes.GT_ModHandler;
import gregapi.recipes.Recipe;
import gregapi.util.UT;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class MultiTileEntityRegistry {
    private static final HashMap<String, MultiTileEntityRegistry> NAMED_REGISTRIES = new HashMap();
    private static final ItemStackMap<ItemStackContainer, MultiTileEntityRegistry> REGISTRIES = new ItemStackMap();
    private static final HashSetNoNulls<Class> sRegisteredTileEntities = new HashSetNoNulls();
    private final HashSetNoNulls<Class> mRegisteredTileEntities = new HashSetNoNulls();
    public HashMap<Short, CreativeTabs> mCreativeTabs = new HashMap();
    public Map<Short, MultiTileEntityClassContainer> mRegistry = new HashMap<Short, MultiTileEntityClassContainer>();
    public List<MultiTileEntityClassContainer> mRegistrations = new ArrayListNoNulls<MultiTileEntityClassContainer>();
    public final String mNameInternal;
    public final MultiTileEntityBlockInternal mBlock;

    public MultiTileEntityRegistry(String aNameInternal) {
        if (!CS.GAPI.mStartedPreInit) {
            throw new IllegalStateException("The MultiTileEntity Registry must be initialised at the Preload Phase and not before, because it relies on an ItemBlock being created!");
        }
        if (CS.GAPI.mStartedInit) {
            throw new IllegalStateException("The MultiTileEntity Registry must be initialised at the Preload Phase and not later, because it relies on an ItemBlock being created!");
        }
        this.mNameInternal = aNameInternal;
        this.mBlock = new MultiTileEntityBlockInternal(this);
        REGISTRIES.put(new ItemStackContainer(this.mBlock, 1L, 32767L), this);
        NAMED_REGISTRIES.put(this.mNameInternal, this);
    }

    public static MultiTileEntityRegistry getRegistry(int aRegistryID) {
        return (MultiTileEntityRegistry)REGISTRIES.get(new ItemStackContainer(Item.func_150899_d((int)aRegistryID), 1L, 32767L));
    }

    public static MultiTileEntityRegistry getRegistry(String aRegistryName) {
        return NAMED_REGISTRIES.get(aRegistryName);
    }

    public ItemStack add(String aLocalised, String aCategoricalName, int aID, int aCreativeTabID, Class<? extends TileEntity> aClass, int aBlockMetaData, int aStackSize, MultiTileEntityBlock aBlock, NBTTagCompound aParameters, Object ... aRecipe) {
        return this.add(aLocalised, aCategoricalName, new MultiTileEntityClassContainer(aID, aCreativeTabID, aClass, aBlockMetaData, aStackSize, aBlock, aParameters), aRecipe);
    }

    public ItemStack add(String aLocalised, String aCategoricalName, MultiTileEntityClassContainer aClassContainer, Object ... aRecipe) {
        Recipe.RecipeMap tMap;
        String tRecipeMapName;
        boolean tFailed = false;
        if (UT.Code.stringInvalid(aLocalised)) {
            CS.ERR.println("MTE REGISTRY ERROR: Localisation Missing!");
            tFailed = true;
        }
        if (aClassContainer == null) {
            CS.ERR.println("MTE REGISTRY ERROR: Class Container is null!");
            tFailed = true;
        } else {
            if (aClassContainer.mClass == null) {
                CS.ERR.println("MTE REGISTRY ERROR: Class inside Class Container is null!");
                tFailed = true;
            }
            if (aClassContainer.mID == Short.MAX_VALUE) {
                CS.ERR.println("MTE REGISTRY ERROR: Class Container uses Wildcard MetaData!");
                tFailed = true;
            }
            if (aClassContainer.mID < 0) {
                CS.ERR.println("MTE REGISTRY ERROR: Class Container uses negative MetaData!");
                tFailed = true;
            }
            if (this.mRegistry.containsKey(aClassContainer.mID)) {
                CS.ERR.println("MTE REGISTRY ERROR: Class Container uses occupied MetaData!");
                tFailed = true;
            }
        }
        if (tFailed) {
            CS.ERR.println("MTE REGISTRY ERROR: STACKTRACE START");
            int i = 0;
            for (StackTraceElement tElement : new Exception().getStackTrace()) {
                if (i++ >= 5 || tElement.getClassName().startsWith("sun")) break;
                CS.ERR.println("\tat " + tElement);
            }
            CS.ERR.println("MTE REGISTRY ERROR: STACKTRACE END");
            return null;
        }
        assert (aClassContainer != null);
        LH.add(this.mNameInternal + "." + aClassContainer.mID + ".name", aLocalised);
        this.mRegistry.put(aClassContainer.mID, aClassContainer);
        this.mRegistrations.add(aClassContainer);
        if (!this.mCreativeTabs.containsKey(aClassContainer.mCreativeTabID)) {
            this.mCreativeTabs.put(aClassContainer.mCreativeTabID, new CreativeTab(this.mNameInternal + "." + aClassContainer.mCreativeTabID, aCategoricalName, Item.func_150898_a((Block)this.mBlock), aClassContainer.mCreativeTabID));
        }
        if (sRegisteredTileEntities.add(aClassContainer.mCanonicalTileEntity.getClass())) {
            if (aClassContainer.mCanonicalTileEntity instanceof IMultiTileEntity.IMTE_OnRegistrationFirst) {
                ((IMultiTileEntity.IMTE_OnRegistrationFirst)aClassContainer.mCanonicalTileEntity).onRegistrationFirst(this, aClassContainer.mID);
            }
            if (CS.CODE_CLIENT && aClassContainer.mCanonicalTileEntity instanceof IMultiTileEntity.IMTE_OnRegistrationFirstClient) {
                ((IMultiTileEntity.IMTE_OnRegistrationFirstClient)aClassContainer.mCanonicalTileEntity).onRegistrationFirstClient(this, aClassContainer.mID);
            }
        }
        if (this.mRegisteredTileEntities.add(aClassContainer.mCanonicalTileEntity.getClass())) {
            if (aClassContainer.mCanonicalTileEntity instanceof IMultiTileEntity.IMTE_OnRegistrationFirstOfRegister) {
                ((IMultiTileEntity.IMTE_OnRegistrationFirstOfRegister)aClassContainer.mCanonicalTileEntity).onRegistrationFirstOfRegister(this, aClassContainer.mID);
            }
            if (aClassContainer.mCanonicalTileEntity instanceof IMultiTileEntity.IMTE_OnRegistrationFirstOfRegisterClient) {
                ((IMultiTileEntity.IMTE_OnRegistrationFirstOfRegisterClient)aClassContainer.mCanonicalTileEntity).onRegistrationFirstOfRegisterClient(this, aClassContainer.mID);
            }
        }
        if (aClassContainer.mCanonicalTileEntity instanceof IMultiTileEntity.IMTE_OnRegistration) {
            ((IMultiTileEntity.IMTE_OnRegistration)aClassContainer.mCanonicalTileEntity).onRegistration(this, aClassContainer.mID);
        }
        if (CS.CODE_CLIENT && aClassContainer.mCanonicalTileEntity instanceof IMultiTileEntity.IMTE_OnRegistrationClient) {
            ((IMultiTileEntity.IMTE_OnRegistrationClient)aClassContainer.mCanonicalTileEntity).onRegistrationClient(this, aClassContainer.mID);
        }
        if (aRecipe != null && aRecipe.length > 1) {
            if (aRecipe[0] instanceof Object[]) {
                aRecipe = (Object[])aRecipe[0];
            }
            if (aRecipe.length > 2) {
                GT_ModHandler.addCraftingRecipe(this.getItem(aClassContainer.mID), GT_ModHandler.RecipeBits.DEFAULT_REV_NCC, aRecipe);
            }
        }
        if (UT.Code.stringValid(tRecipeMapName = aClassContainer.mParameters.func_74779_i("gt.recipemap")) && (tMap = Recipe.RecipeMap.RECIPE_MAPS.get(tRecipeMapName)) != null) {
            tMap.mRecipeMachineList.add(this.getItem(aClassContainer.mID));
        }
        if (UT.Code.stringValid(tRecipeMapName = aClassContainer.mParameters.func_74779_i("gt.fuelmap")) && (tMap = Recipe.RecipeMap.RECIPE_MAPS.get(tRecipeMapName)) != null) {
            tMap.mRecipeMachineList.add(this.getItem(aClassContainer.mID));
        }
        return this.getItem(aClassContainer.mID);
    }

    public ItemStack getItem(int aID) {
        return this.getItem(aID, 1L, null);
    }

    public ItemStack getItem(int aID, NBTTagCompound aNBT) {
        return this.getItem(aID, 1L, aNBT);
    }

    public ItemStack getItem(int aID, long aAmount) {
        return this.getItem(aID, aAmount, null);
    }

    public ItemStack getItem(int aID, long aAmount, NBTTagCompound aNBT) {
        MultiTileEntityContainer tTileEntityContainer;
        ItemStack rStack = UT.Stacks.make(this.mBlock, (long)((int)aAmount), (long)aID);
        if ((aNBT == null || aNBT.func_82582_d()) && (tTileEntityContainer = this.getNewTileEntityContainer(aID, aNBT = new NBTTagCompound())) != null) {
            ((IMultiTileEntity)tTileEntityContainer.mTileEntity).writeItemNBT(aNBT);
        }
        rStack.func_77982_d(aNBT.func_82582_d() ? null : aNBT);
        return rStack;
    }

    public String getLocal(int aID) {
        return LH.get(this.mNameInternal + "." + aID + ".name");
    }

    public TileEntity getNewTileEntity(int aID) {
        MultiTileEntityContainer tContainer = this.getNewTileEntityContainer(aID, null);
        return tContainer == null ? null : tContainer.mTileEntity;
    }

    public TileEntity getNewTileEntity(ItemStack aStack) {
        MultiTileEntityContainer tContainer = this.getNewTileEntityContainer(aStack);
        return tContainer == null ? null : tContainer.mTileEntity;
    }

    public MultiTileEntityContainer getNewTileEntityContainer(ItemStack aStack) {
        return this.getNewTileEntityContainer(UT.Stacks.meta(aStack), aStack.func_77978_p());
    }

    public MultiTileEntityClassContainer getClassContainer(int aID) {
        return this.mRegistry.get((short)aID);
    }

    public MultiTileEntityClassContainer getClassContainer(ItemStack aStack) {
        return this.mRegistry.get(UT.Stacks.meta(aStack));
    }

    public MultiTileEntityContainer getNewTileEntityContainer(int aID, NBTTagCompound aNBT) {
        MultiTileEntityClassContainer tClass = this.mRegistry.get((short)aID);
        if (tClass == null || tClass.mBlock == null) {
            return null;
        }
        MultiTileEntityContainer rContainer = new MultiTileEntityContainer((TileEntity)UT.Reflection.callConstructor(tClass.mClass, -1, null, true, new Object[0]), tClass.mBlock, tClass.mBlockMetaData);
        if (rContainer.mTileEntity == null) {
            return null;
        }
        ((IMultiTileEntity)rContainer.mTileEntity).initFromNBT(aNBT == null || aNBT.func_82582_d() ? tClass.mParameters : UT.NBT.fuseNBTs(aNBT, tClass.mParameters), (short)aID, (short)Block.func_149682_b((Block)this.mBlock));
        return rContainer;
    }

    public static void onServerLoad(File aSaveLocation) {
        for (Class tClass : sRegisteredTileEntities) {
            if (!IMultiTileEntity.IMTE_OnServerLoad.class.isAssignableFrom(tClass)) continue;
            try {
                ((IMultiTileEntity.IMTE_OnServerLoad)tClass.newInstance()).onServerLoad(aSaveLocation);
            }
            catch (Throwable e) {
                e.printStackTrace(CS.ERR);
            }
        }
    }

    public static void onServerSave(File aSaveLocation) {
        for (Class tClass : sRegisteredTileEntities) {
            if (!IMultiTileEntity.IMTE_OnServerSave.class.isAssignableFrom(tClass)) continue;
            try {
                ((IMultiTileEntity.IMTE_OnServerSave)tClass.newInstance()).onServerSave(aSaveLocation);
            }
            catch (Throwable e) {
                e.printStackTrace(CS.ERR);
            }
        }
    }
}

