/*
 * Decompiled with CFR 0.152.
 */
package gregapi.block.multitileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.block.multitileentity.MultiTileEntityBlockInternal;
import gregapi.block.multitileentity.MultiTileEntityClassContainer;
import gregapi.block.multitileentity.MultiTileEntityContainer;
import gregapi.code.ArrayListNoNulls;
import gregapi.cover.CoverData;
import gregapi.cover.ITileEntityCoverable;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.data.MT;
import gregapi.item.CreativeTab;
import gregapi.item.IItemGT;
import gregapi.item.IItemNoGTOverride;
import gregapi.item.IItemUpdatable;
import gregapi.oredict.IOreDictItemDataOverrideItem;
import gregapi.oredict.OreDictItemData;
import gregapi.oredict.OreDictMaterialStack;
import gregapi.tileentity.ITileEntity;
import gregapi.tileentity.ITileEntityFoamable;
import gregapi.tileentity.ITileEntityMachineBlockUpdateable;
import gregapi.util.OM;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSnow;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class MultiTileEntityItemInternal
extends ItemBlock
implements IItemUpdatable,
IOreDictItemDataOverrideItem,
IItemGT,
IItemNoGTOverride,
IFluidContainerItem {
    public final MultiTileEntityBlockInternal mBlock;

    public MultiTileEntityItemInternal(Block aBlock) {
        super(aBlock);
        this.func_77656_e(0);
        this.func_77627_a(true);
        this.mBlock = (MultiTileEntityBlockInternal)aBlock;
    }

    public String func_77653_i(ItemStack aStack) {
        MultiTileEntityContainer tTileEntityContainer = this.mBlock.mMultiTileEntityRegistry.getNewTileEntityContainer(aStack);
        if (tTileEntityContainer != null && tTileEntityContainer.mTileEntity instanceof IMultiTileEntity.IMTE_GetItemName) {
            return ((IMultiTileEntity.IMTE_GetItemName)tTileEntityContainer.mTileEntity).getItemName(aStack, super.func_77653_i(aStack));
        }
        return super.func_77653_i(aStack);
    }

    public void func_77624_a(ItemStack aStack, EntityPlayer aPlayer, List aList, boolean aF3_H) {
        MultiTileEntityContainer tTileEntityContainer = this.mBlock.mMultiTileEntityRegistry.getNewTileEntityContainer(aStack);
        if (tTileEntityContainer == null) {
            aList.add("INVALID ITEM! THIS IS A BUG IF ACQUIRED IN A LEGIT WAY!");
            return;
        }
        if (tTileEntityContainer.mTileEntity instanceof IMultiTileEntity.IMTE_AddToolTips) {
            try {
                ((IMultiTileEntity.IMTE_AddToolTips)tTileEntityContainer.mTileEntity).addToolTips(aList, aStack, aF3_H);
            }
            catch (Throwable e) {
                e.printStackTrace(CS.ERR);
            }
        }
        if (tTileEntityContainer.mTileEntity instanceof IMultiTileEntity.IMTE_GetExplosionResistance) {
            double tResistance = ((IMultiTileEntity.IMTE_GetExplosionResistance)tTileEntityContainer.mTileEntity).getExplosionResistance();
            aList.add(LH.Chat.WHITE + LH.get("gt.lang.blastresistance") + LH.Chat.ORANGE + (tResistance > 0.0 ? Double.valueOf(tResistance) : "None"));
        }
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.tool.to.harvest") + ": " + LH.Chat.WHITE + LH.get("gt.lang.tool.name." + tTileEntityContainer.mBlock.getHarvestTool(tTileEntityContainer.mBlockMetaData), "Unknown") + " (" + tTileEntityContainer.mBlock.getHarvestLevel(tTileEntityContainer.mBlockMetaData) + ")");
        int j = aList.size();
        for (int i = 0; i < j; ++i) {
            if (aList.get(i) == null) {
                aList.remove(i--);
                --j;
                continue;
            }
            aList.set(i, LH.Chat.GRAY + aList.get(i) + LH.Chat.RESET);
        }
    }

    public int onDespawn(EntityItem aEntity, ItemStack aStack) {
        MultiTileEntityContainer tTileEntityContainer = this.mBlock.mMultiTileEntityRegistry.getNewTileEntityContainer(aStack);
        if (tTileEntityContainer != null && tTileEntityContainer.mTileEntity instanceof IMultiTileEntity.IMTE_OnDespawn) {
            try {
                return ((IMultiTileEntity.IMTE_OnDespawn)tTileEntityContainer.mTileEntity).onDespawn(aEntity, aStack);
            }
            catch (Throwable e) {
                e.printStackTrace(CS.ERR);
            }
        }
        return 0;
    }

    public int getEntityLifespan(ItemStack aStack, World aWorld) {
        MultiTileEntityContainer tTileEntityContainer = this.mBlock.mMultiTileEntityRegistry.getNewTileEntityContainer(aStack);
        if (tTileEntityContainer != null && tTileEntityContainer.mTileEntity instanceof IMultiTileEntity.IMTE_GetLifeSpan) {
            try {
                return ((IMultiTileEntity.IMTE_GetLifeSpan)tTileEntityContainer.mTileEntity).getLifeSpan(aWorld, aStack);
            }
            catch (Throwable e) {
                e.printStackTrace(CS.ERR);
            }
        }
        return super.getEntityLifespan(aStack, aWorld);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item aItem, CreativeTabs aTab, List aList) {
        if (aTab instanceof CreativeTab) {
            for (MultiTileEntityClassContainer tClass : this.mBlock.mMultiTileEntityRegistry.mRegistrations) {
                if (tClass.mHidden && !CS.SHOW_HIDDEN_ITEMS || ((CreativeTab)aTab).mMetaData != tClass.mCreativeTabID || tClass.mCanonicalTileEntity instanceof IMultiTileEntity.IMTE_GetSubItems && !((IMultiTileEntity.IMTE_GetSubItems)tClass.mCanonicalTileEntity).getSubItems(this.mBlock, aItem, aTab, aList, tClass.mID)) continue;
                aList.add(this.mBlock.mMultiTileEntityRegistry.getItem(tClass.mID));
            }
        } else {
            for (MultiTileEntityClassContainer tClass : this.mBlock.mMultiTileEntityRegistry.mRegistrations) {
                if (tClass.mHidden && !CS.SHOW_HIDDEN_ITEMS || tClass.mCanonicalTileEntity instanceof IMultiTileEntity.IMTE_GetSubItems && !((IMultiTileEntity.IMTE_GetSubItems)tClass.mCanonicalTileEntity).getSubItems(this.mBlock, aItem, aTab, aList, tClass.mID)) continue;
                aList.add(this.mBlock.mMultiTileEntityRegistry.getItem(tClass.mID));
            }
        }
    }

    public CreativeTabs[] getCreativeTabs() {
        return this.mBlock.mMultiTileEntityRegistry.mCreativeTabs.values().toArray(new CreativeTabs[this.mBlock.mMultiTileEntityRegistry.mCreativeTabs.size()]);
    }

    public boolean func_77648_a(ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, int aSide, float aHitX, float aHitY, float aHitZ) {
        if (aY < 0 || aY > aWorld.func_72800_K()) {
            return false;
        }
        try {
            Block tClickedBlock = aWorld.func_147439_a(aX, aY, aZ);
            if (tClickedBlock instanceof BlockSnow && (aWorld.func_72805_g(aX, aY, aZ) & 7) < 1) {
                aSide = 1;
            } else if (tClickedBlock != Blocks.field_150395_bd && tClickedBlock != Blocks.field_150329_H && tClickedBlock != Blocks.field_150330_I && !tClickedBlock.isReplaceable((IBlockAccess)aWorld, aX, aY, aZ)) {
                aX += CS.OFFSETS_X[aSide];
                aY += CS.OFFSETS_Y[aSide];
                aZ += CS.OFFSETS_Z[aSide];
            }
            Block tReplacedBlock = aWorld.func_147439_a(aX, aY, aZ);
            if (aStack.field_77994_a == 0 || aPlayer != null && !aPlayer.func_82247_a(aX, aY, aZ, aSide, aStack)) {
                return false;
            }
            MultiTileEntityContainer aMTEContainer = this.mBlock.mMultiTileEntityRegistry.getNewTileEntityContainer(aStack);
            if (aMTEContainer != null && aWorld.func_147472_a((Block)aMTEContainer.mBlock, aX, aY, aZ, false, aSide, (Entity)aPlayer, aStack) && (!(aMTEContainer.mTileEntity instanceof IMultiTileEntity.IMTE_CanPlace) || ((IMultiTileEntity.IMTE_CanPlace)aMTEContainer.mTileEntity).canPlace(aStack, aPlayer, aWorld, aX, aY, aZ, (byte)aSide, aHitX, aHitY, aHitZ)) && aWorld.func_147465_d(aX, aY, aZ, (Block)aMTEContainer.mBlock, 15 - aMTEContainer.mBlockMetaData, 2)) {
                ((IMultiTileEntity)aMTEContainer.mTileEntity).setShouldRefresh(false);
                UT.Worlds.setTileEntity(aWorld, aX, aY, aZ, aMTEContainer.mTileEntity, false);
                aWorld.func_147465_d(aX, aY, aZ, (Block)aMTEContainer.mBlock, (int)aMTEContainer.mBlockMetaData, 0);
                ((IMultiTileEntity)aMTEContainer.mTileEntity).setShouldRefresh(true);
                UT.Worlds.setTileEntity(aWorld, aX, aY, aZ, aMTEContainer.mTileEntity, true);
                if (!(aMTEContainer.mTileEntity instanceof IMultiTileEntity.IMTE_OnPlaced) || ((IMultiTileEntity.IMTE_OnPlaced)aMTEContainer.mTileEntity).onPlaced(aStack, aPlayer, aMTEContainer, aWorld, aX, aY, aZ, (byte)aSide, aHitX, aHitY, aHitZ)) {
                    aWorld.func_72908_a((double)aX + 0.5, (double)aY + 0.5, (double)aZ + 0.5, aMTEContainer.mBlock.field_149762_H.func_150496_b(), (aMTEContainer.mBlock.field_149762_H.func_150497_c() + 1.0f) / 2.0f, aMTEContainer.mBlock.field_149762_H.func_150494_d() * 0.8f);
                }
                if (aMTEContainer.mTileEntity instanceof IMultiTileEntity.IMTE_HasMultiBlockMachineRelevantData && ((IMultiTileEntity.IMTE_HasMultiBlockMachineRelevantData)aMTEContainer.mTileEntity).hasMultiBlockMachineRelevantData()) {
                    ITileEntityMachineBlockUpdateable.Util.causeMachineUpdate(aWorld, new ChunkCoordinates(aX, aY, aZ), aMTEContainer.mBlock, aMTEContainer.mBlockMetaData, false);
                }
                if (!aWorld.field_72995_K) {
                    aWorld.func_147444_c(aX, aY, aZ, tReplacedBlock);
                    aWorld.func_147453_f(aX, aY, aZ, (Block)aMTEContainer.mBlock);
                }
                if (aMTEContainer.mTileEntity instanceof ITileEntity) {
                    ((ITileEntity)aMTEContainer.mTileEntity).onTileEntityPlaced();
                }
                aWorld.func_147451_t(aX, aY, aZ);
                --aStack.field_77994_a;
                return true;
            }
        }
        catch (Throwable e) {
            e.printStackTrace(CS.ERR);
        }
        return false;
    }

    @Override
    public void updateItemStack(ItemStack aStack) {
    }

    public int getItemStackLimit(ItemStack aStack) {
        MultiTileEntityClassContainer tContainer = this.mBlock.mMultiTileEntityRegistry.getClassContainer(aStack);
        return tContainer == null ? (byte)1 : tContainer.mStackSize;
    }

    public void func_77622_d(ItemStack aStack, World aWorld, EntityPlayer aPlayer) {
        MultiTileEntityContainer tTileEntityContainer = this.mBlock.mMultiTileEntityRegistry.getNewTileEntityContainer(aStack);
        if (tTileEntityContainer != null && tTileEntityContainer.mTileEntity instanceof IMultiTileEntity.IMTE_OnCrafted) {
            this.updateItemStack(aStack);
            ((IMultiTileEntity.IMTE_OnCrafted)tTileEntityContainer.mTileEntity).onCrafted(aPlayer, aWorld, aStack);
        }
        this.updateItemStack(aStack);
    }

    @Override
    public OreDictItemData getOreDictItemData(ItemStack aStack) {
        CoverData tCoverData;
        ArrayListNoNulls<OreDictItemData> rList = new ArrayListNoNulls<OreDictItemData>(false, OM.data(aStack));
        MultiTileEntityContainer tTileEntityContainer = this.mBlock.mMultiTileEntityRegistry.getNewTileEntityContainer(aStack);
        if (tTileEntityContainer != null && tTileEntityContainer.mTileEntity instanceof ITileEntityCoverable && (tCoverData = ((ITileEntityCoverable)tTileEntityContainer.mTileEntity).getCoverData()) != null) {
            for (byte tSide : CS.ALL_SIDES_VALID) {
                rList.add(OM.anydata(tCoverData.getCoverItem(tSide)));
            }
        }
        if (tTileEntityContainer != null && tTileEntityContainer.mTileEntity instanceof ITileEntityFoamable && ((ITileEntityFoamable)tTileEntityContainer.mTileEntity).hasFoam((byte)6)) {
            rList.add(new OreDictItemData(MT.ConstructionFoam, 420076800L, new OreDictMaterialStack[0]));
        }
        return rList.isEmpty() ? null : new OreDictItemData(rList);
    }

    public FluidStack getFluid(ItemStack aStack) {
        MultiTileEntityContainer tTileEntityContainer = this.mBlock.mMultiTileEntityRegistry.getNewTileEntityContainer(aStack);
        if (tTileEntityContainer != null && tTileEntityContainer.mTileEntity instanceof IFluidContainerItem) {
            FluidStack rFluid = ((IFluidContainerItem)tTileEntityContainer.mTileEntity).getFluid(aStack);
            this.updateItemStack(aStack);
            return rFluid;
        }
        return CS.NF;
    }

    public int getCapacity(ItemStack aStack) {
        MultiTileEntityContainer tTileEntityContainer = this.mBlock.mMultiTileEntityRegistry.getNewTileEntityContainer(aStack);
        if (tTileEntityContainer != null && tTileEntityContainer.mTileEntity instanceof IFluidContainerItem) {
            int rCapacity = ((IFluidContainerItem)tTileEntityContainer.mTileEntity).getCapacity(aStack);
            this.updateItemStack(aStack);
            return rCapacity;
        }
        return 0;
    }

    public int fill(ItemStack aStack, FluidStack aFluid, boolean aDoFill) {
        MultiTileEntityContainer tTileEntityContainer = this.mBlock.mMultiTileEntityRegistry.getNewTileEntityContainer(aStack);
        if (tTileEntityContainer != null && tTileEntityContainer.mTileEntity instanceof IFluidContainerItem) {
            int tFilled = ((IFluidContainerItem)tTileEntityContainer.mTileEntity).fill(aStack, aFluid, aDoFill);
            this.updateItemStack(aStack);
            return tFilled;
        }
        return 0;
    }

    public FluidStack drain(ItemStack aStack, int aMaxDrain, boolean aDoDrain) {
        MultiTileEntityContainer tTileEntityContainer = this.mBlock.mMultiTileEntityRegistry.getNewTileEntityContainer(aStack);
        if (tTileEntityContainer != null && tTileEntityContainer.mTileEntity instanceof IFluidContainerItem) {
            FluidStack rFluid = ((IFluidContainerItem)tTileEntityContainer.mTileEntity).drain(aStack, aMaxDrain, aDoDrain);
            this.updateItemStack(aStack);
            return rFluid;
        }
        return CS.NF;
    }

    public final String func_77658_a() {
        return this.mBlock.mMultiTileEntityRegistry.mNameInternal;
    }

    public final String func_77667_c(ItemStack aStack) {
        return this.mBlock.mMultiTileEntityRegistry.mNameInternal + "." + this.getDamage(aStack);
    }

    public final boolean hasContainerItem(ItemStack aStack) {
        return this.getContainerItem(aStack) != null;
    }

    public ItemStack getContainerItem(ItemStack aStack) {
        return null;
    }

    public int func_94901_k() {
        return 0;
    }

    public void func_94581_a(IIconRegister aRegister) {
    }

    public boolean isBookEnchantable(ItemStack aStack, ItemStack aBook) {
        return false;
    }

    public boolean func_82789_a(ItemStack aStack, ItemStack aMaterial) {
        return false;
    }

    public int func_77619_b() {
        return 0;
    }
}

