/*
 * Decompiled with CFR 0.152.
 */
package gregapi.block.metatype;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregapi.block.BlockBase;
import gregapi.data.CS;
import gregapi.data.OP;
import gregapi.oredict.OreDictMaterial;
import gregapi.recipes.GT_ModHandler;
import gregapi.render.IIconContainer;
import gregapi.util.UT;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockMetaType
extends BlockBase {
    public final float mHardnessMultiplier;
    public final float mResistanceMultiplier;
    public final int mHarvestLevel;
    public final byte mSide;
    public final byte mCount;
    public final IIconContainer[] mIcons;
    public final BlockMetaType mBlock;
    public final BlockMetaType[] mSlabs;

    public BlockMetaType(Class<? extends ItemBlock> aItemClass, Material aVanillaMaterial, Block.SoundType aVanillaSoundType, String aName, String aDefaultLocalised, OreDictMaterial aMaterial, float aResistanceMultiplier, float aHardnessMultiplier, int aHarvestLevel, int aCount, IIconContainer[] aIcons) {
        super(aItemClass, aName, aVanillaMaterial);
        this.func_149672_a(aVanillaSoundType);
        this.func_149711_c(aHardnessMultiplier * 1.5f);
        this.func_149752_b(aResistanceMultiplier * 10.0f);
        this.func_149647_a(CreativeTabs.field_78030_b);
        this.mBlock = this;
        this.mIcons = aIcons;
        this.mCount = (byte)(UT.Code.bind4(aCount - 1) + 1);
        this.mSide = (byte)6;
        this.mHarvestLevel = aHarvestLevel;
        this.mHardnessMultiplier = aHardnessMultiplier;
        this.mResistanceMultiplier = aResistanceMultiplier;
        this.mSlabs = new BlockMetaType[]{this.makeSlab(aItemClass, aVanillaMaterial, aVanillaSoundType, aName, aDefaultLocalised, aMaterial, aResistanceMultiplier / 2.0f, aHardnessMultiplier / 2.0f, aHarvestLevel, this.mCount, aIcons, (byte)0, this), this.makeSlab(aItemClass, aVanillaMaterial, aVanillaSoundType, aName, aDefaultLocalised, aMaterial, aResistanceMultiplier / 2.0f, aHardnessMultiplier / 2.0f, aHarvestLevel, this.mCount, aIcons, (byte)1, this), this.makeSlab(aItemClass, aVanillaMaterial, aVanillaSoundType, aName, aDefaultLocalised, aMaterial, aResistanceMultiplier / 2.0f, aHardnessMultiplier / 2.0f, aHarvestLevel, this.mCount, aIcons, (byte)2, this), this.makeSlab(aItemClass, aVanillaMaterial, aVanillaSoundType, aName, aDefaultLocalised, aMaterial, aResistanceMultiplier / 2.0f, aHardnessMultiplier / 2.0f, aHarvestLevel, this.mCount, aIcons, (byte)3, this), this.makeSlab(aItemClass, aVanillaMaterial, aVanillaSoundType, aName, aDefaultLocalised, aMaterial, aResistanceMultiplier / 2.0f, aHardnessMultiplier / 2.0f, aHarvestLevel, this.mCount, aIcons, (byte)4, this), this.makeSlab(aItemClass, aVanillaMaterial, aVanillaSoundType, aName, aDefaultLocalised, aMaterial, aResistanceMultiplier / 2.0f, aHardnessMultiplier / 2.0f, aHarvestLevel, this.mCount, aIcons, (byte)5, this), null};
        this.mSlabs[6] = this.mSlabs[0];
        UT.Stacks.hide(this.mSlabs[1]);
        UT.Stacks.hide(this.mSlabs[2]);
        UT.Stacks.hide(this.mSlabs[3]);
        UT.Stacks.hide(this.mSlabs[4]);
        UT.Stacks.hide(this.mSlabs[5]);
        for (int i = 0; i < 16; i = (int)((byte)(i + 1))) {
            GT_ModHandler.addSawingRecipe(16L, 16L, false, 5L, UT.Stacks.make(this, 1L, (long)i), UT.Stacks.make(this.mSlabs[0], 2L, (long)i));
            GT_ModHandler.addCraftingRecipe(UT.Stacks.make(this.mSlabs[0], 2L, (long)i), GT_ModHandler.RecipeBits.DEFAULT_NAC, new Object[]{"sX", Character.valueOf('X'), UT.Stacks.make(this, 1L, (long)i)});
            GT_ModHandler.addCraftingRecipe(UT.Stacks.make(this, 1L, (long)i), GT_ModHandler.RecipeBits.DEFAULT_NAC, new Object[]{"X", "X", Character.valueOf('X'), UT.Stacks.make(this.mSlabs[0], 1L, (long)i)});
        }
    }

    protected BlockMetaType makeSlab(Class<? extends ItemBlock> aItemClass, Material aVanillaMaterial, Block.SoundType aVanillaSoundType, String aName, String aDefaultLocalised, OreDictMaterial aMaterial, float aResistanceMultiplier, float aHardnessMultiplier, int aHarvestLevel, int aCount, IIconContainer[] aIcons, byte aSlabType, BlockMetaType aBlock) {
        return new BlockMetaType(aItemClass, aVanillaMaterial, aVanillaSoundType, aName, aDefaultLocalised, aMaterial, aResistanceMultiplier, aHardnessMultiplier, aHarvestLevel, aCount, aIcons, aSlabType, aBlock);
    }

    protected BlockMetaType(Class<? extends ItemBlock> aItemClass, Material aVanillaMaterial, Block.SoundType aVanillaSoundType, String aName, String aDefaultLocalised, OreDictMaterial aMaterial, float aResistanceMultiplier, float aHardnessMultiplier, int aHarvestLevel, int aCount, IIconContainer[] aIcons, byte aSlabType, BlockMetaType aBlock) {
        super(aItemClass, aName + ".slab." + aSlabType, aVanillaMaterial);
        this.func_149672_a(aVanillaSoundType);
        this.func_149711_c(aHardnessMultiplier * 1.5f);
        this.func_149752_b(aResistanceMultiplier * 10.0f);
        this.mSlabs = null;
        this.mBlock = aBlock;
        this.mIcons = aIcons;
        this.mCount = (byte)(UT.Code.bind4(aCount - 1) + 1);
        this.mSide = aSlabType;
        this.mHarvestLevel = aHarvestLevel;
        this.mHardnessMultiplier = aHardnessMultiplier;
        this.mResistanceMultiplier = aResistanceMultiplier;
        this.func_149676_a(this.mSide == 5 ? 0.5f : 0.0f, this.mSide == 1 ? 0.5f : 0.0f, this.mSide == 3 ? 0.5f : 0.0f, this.mSide == 4 ? 0.5f : 1.0f, this.mSide == 0 ? 0.5f : 1.0f, this.mSide == 2 ? 0.5f : 1.0f);
    }

    public boolean func_149727_a(World aWorld, int aX, int aY, int aZ, EntityPlayer aPlayer, int aSide, float aHitX, float aHitY, float aHitZ) {
        byte aMetaData;
        if (this.mBlock == this || aSide != CS.OPPOSITES[this.mSide] || this.mBlock.func_149668_a(aWorld, aX, aY, aZ) != null && !aWorld.func_72855_b(this.mBlock.func_149668_a(aWorld, aX, aY, aZ))) {
            return false;
        }
        ItemStack aStack = aPlayer.func_71045_bC();
        if (UT.Stacks.equal(aStack, UT.Stacks.make(this.mBlock.mSlabs[0], 1L, (long)(aMetaData = (byte)aWorld.func_72805_g(aX, aY, aZ))), true)) {
            aWorld.func_147465_d(aX, aY, aZ, (Block)this.mBlock, (int)aMetaData, 3);
            aWorld.func_72908_a((double)((float)aX + 0.5f), (double)((float)aY + 0.5f), (double)((float)aZ + 0.5f), this.mBlock.field_149762_H.func_150496_b(), (this.mBlock.field_149762_H.func_150497_c() + 1.0f) / 2.0f, this.mBlock.field_149762_H.func_150494_d() * 0.8f);
            if (!UT.Entities.hasInfiniteItems(aPlayer)) {
                --aStack.field_77994_a;
            }
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess aWorld, int aX, int aY, int aZ, int aSide) {
        Block aBlock;
        if (aSide == CS.OPPOSITES[this.mSide]) {
            return true;
        }
        if (aSide != this.mSide && CS.SIDES_VALID[this.mSide] && (aBlock = aWorld.func_147439_a(aX, aY, aZ)) instanceof BlockMetaType && ((BlockMetaType)aBlock).mSide == this.mSide) {
            return aBlock.func_149701_w() != 0;
        }
        return super.func_149646_a(aWorld, aX, aY, aZ, aSide);
    }

    @Override
    public String getHarvestTool(int aMeta) {
        return "pickaxe";
    }

    public int getHarvestLevel(int aMeta) {
        return this.mHarvestLevel;
    }

    public float func_149712_f(World aWorld, int aX, int aY, int aZ) {
        return Blocks.field_150348_b.func_149712_f(aWorld, aX, aY, aZ) * this.mHardnessMultiplier;
    }

    public float getExplosionResistance(Entity aEntity, World aWorld, int aX, int aY, int aZ, double eX, double eY, double eZ) {
        return this.getExplosionResistance(aWorld.func_72805_g(aX, aY, aZ));
    }

    public float func_149638_a(Entity aEntity) {
        return this.getExplosionResistance(0);
    }

    @Override
    public float getExplosionResistance(int aMeta) {
        return Blocks.field_150348_b.func_149638_a(null) * this.mResistanceMultiplier;
    }

    @Override
    public boolean isNormalCube(IBlockAccess aWorld, int aX, int aY, int aZ) {
        return this.mBlock == this;
    }

    @Override
    public boolean func_149686_d() {
        return this.mBlock == this;
    }

    @Override
    public boolean func_149662_c() {
        return this.mBlock == this;
    }

    @Override
    public int func_149717_k() {
        return this.mBlock == this ? 255 : 3;
    }

    @Override
    public boolean isSideSolid(IBlockAccess aWorld, int aX, int aY, int aZ, ForgeDirection aDirection) {
        return this.mBlock == this || this.mSide == UT.Code.side(aDirection);
    }

    @Override
    public int getItemStackLimit(ItemStack aStack) {
        return UT.Code.bindStack(OP.stone.mDefaultStackSize * (this.mBlock.mBlock == this.mBlock ? 1 : 2));
    }

    @Override
    public Item func_149650_a(int par1, Random par2Random, int par3) {
        return Item.func_150898_a((Block)(this.mBlock == this ? this.mBlock : this.mBlock.mSlabs[0]));
    }

    public void func_149666_a(Item aItem, CreativeTabs par2CreativeTabs, List aList) {
        if (this.mBlock == this || this.mBlock.mSlabs[0] == this) {
            for (byte i = 0; i < this.mCount; i = (byte)(i + 1)) {
                aList.add(UT.Stacks.make(aItem, 1L, (long)i));
            }
        }
    }

    public IIcon func_149673_e(IBlockAccess aWorld, int aX, int aY, int aZ, int aSide) {
        return this.func_149691_a(aSide, aWorld.func_72805_g(aX, aY, aZ));
    }

    public IIcon func_149691_a(int aSide, int aMeta) {
        if (aMeta >= 0 && aMeta < this.mIcons.length) {
            return this.mIcons[aMeta].getIcon(0);
        }
        return this.mIcons[0].getIcon(0);
    }

    @Override
    public Item func_149694_d(World aWorld, int aX, int aY, int aZ) {
        return Item.func_150898_a((Block)(this.mBlock == this ? this.mBlock : this.mBlock.mSlabs[0]));
    }
}

