/*
 * Decompiled with CFR 0.152.
 */
package gregapi;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.ItemList;
import codechicken.nei.PositionedStack;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.guihook.IContainerInputHandler;
import codechicken.nei.guihook.IContainerTooltipHandler;
import codechicken.nei.recipe.GuiCraftingRecipe;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.GuiUsageRecipe;
import codechicken.nei.recipe.RecipeInfo;
import codechicken.nei.recipe.TemplateRecipeHandler;
import cpw.mods.fml.common.event.FMLInterModComms;
import gregapi.NEI_GT_API_Config;
import gregapi.code.ArrayListNoNulls;
import gregapi.code.ItemStackContainer;
import gregapi.data.CS;
import gregapi.data.IL;
import gregapi.data.MD;
import gregapi.gui.ContainerClient;
import gregapi.lang.LanguageHandler;
import gregapi.oredict.OreDictItemData;
import gregapi.oredict.OreDictManager;
import gregapi.oredict.OreDictPrefix;
import gregapi.recipes.Recipe;
import gregapi.util.OM;
import gregapi.util.UT;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class NEI_RecipeMap
extends TemplateRecipeHandler {
    protected final Recipe.RecipeMap mRecipeMap;
    public static final int sOffsetX = 5;
    public static final int sOffsetY = 11;

    public NEI_RecipeMap(Recipe.RecipeMap aRecipeMap) {
        this.mRecipeMap = aRecipeMap;
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(65, 13, 36, 18), this.getOverlayIdentifier(), new Object[0]));
        if (!NEI_GT_API_Config.sIsAdded) {
            FMLInterModComms.sendRuntimeMessage((Object)CS.GAPI, (String)"NEIPlugins", (String)"register-crafting-handler", (String)(MD.GAPI.mID + "@" + this.getRecipeName() + "@" + this.getOverlayIdentifier()));
            GuiCraftingRecipe.craftinghandlers.add(this);
            GuiUsageRecipe.usagehandlers.add(this);
        }
    }

    public TemplateRecipeHandler newInstance() {
        return new NEI_RecipeMap(this.mRecipeMap);
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getOverlayIdentifier())) {
            for (Recipe tRecipe : this.mRecipeMap.getNEIAllRecipes()) {
                this.arecipes.add(new CachedDefaultRecipe(tRecipe));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack aResult) {
        FluidStack tFluid;
        if (UT.Stacks.invalid(aResult)) {
            return;
        }
        OreDictItemData tPrefixMaterial = OM.association_(aResult);
        ArrayListNoNulls<ItemStack> tResults = new ArrayListNoNulls<ItemStack>();
        ArrayList tRedirects = CS.ItemsGT.sNEIRedirects.get(new ItemStackContainer(aResult));
        ((ArrayList)tResults).add(aResult);
        ((ArrayList)tResults).add(OM.get_(aResult));
        if (tRedirects != null) {
            ((ArrayList)tResults).addAll(tRedirects);
        }
        if (tPrefixMaterial != null && !tPrefixMaterial.mBlackListed) {
            for (OreDictPrefix tPrefix : tPrefixMaterial.mPrefix.mFamiliarPrefixes) {
                ((ArrayList)tResults).add(tPrefix.mat(tPrefixMaterial.mMaterial.mMaterial, 1L));
            }
        }
        if ((tFluid = UT.Fluids.getFluidForFilledItem(aResult, true)) != null) {
            ((ArrayList)tResults).add(UT.Fluids.display(tFluid, false));
            for (FluidContainerRegistry.FluidContainerData tData : FluidContainerRegistry.getRegisteredFluidContainerData()) {
                if (!tData.fluid.isFluidEqual(tFluid)) continue;
                ((ArrayList)tResults).add(UT.Stacks.copy(tData.filledContainer));
            }
        }
        ArrayListNoNulls<Recipe> tRecipes = new ArrayListNoNulls<Recipe>();
        for (Recipe tRecipe : this.mRecipeMap.getNEIRecipes(tResults.toArray(CS.ZL_ITEMSTACK))) {
            if (tRecipes.contains(tRecipe)) continue;
            ((ArrayList)tRecipes).add(tRecipe);
        }
        for (Recipe tRecipe : tRecipes) {
            this.arecipes.add(new CachedDefaultRecipe(tRecipe));
        }
    }

    public void loadUsageRecipes(ItemStack aInput) {
        FluidStack tFluid;
        if (UT.Stacks.invalid(aInput)) {
            return;
        }
        OreDictItemData tPrefixMaterial = OM.association_(aInput);
        ArrayListNoNulls<ItemStack> tInputs = new ArrayListNoNulls<ItemStack>();
        ArrayList tRedirects = CS.ItemsGT.sNEIRedirects.get(new ItemStackContainer(aInput));
        ((ArrayList)tInputs).add(aInput);
        ((ArrayList)tInputs).add(OreDictManager.INSTANCE.getStack_(false, aInput));
        if (tRedirects != null) {
            ((ArrayList)tInputs).addAll(tRedirects);
        }
        if (tPrefixMaterial != null) {
            for (OreDictPrefix tPrefix : tPrefixMaterial.mPrefix.mFamiliarPrefixes) {
                ((ArrayList)tInputs).add(tPrefix.mat(tPrefixMaterial.mMaterial.mMaterial, 1L));
            }
        }
        if ((tFluid = UT.Fluids.getFluidForFilledItem(aInput, true)) != null) {
            ((ArrayList)tInputs).add(UT.Fluids.display(tFluid, false));
            for (FluidContainerRegistry.FluidContainerData tData : FluidContainerRegistry.getRegisteredFluidContainerData()) {
                if (!tData.fluid.isFluidEqual(tFluid)) continue;
                ((ArrayList)tInputs).add(UT.Stacks.copy(tData.filledContainer));
            }
        }
        ArrayListNoNulls<Recipe> tRecipes = new ArrayListNoNulls<Recipe>();
        for (Recipe tRecipe : this.mRecipeMap.getNEIUsages(tInputs.toArray(CS.ZL_ITEMSTACK))) {
            if (tRecipes.contains(tRecipe)) continue;
            ((ArrayList)tRecipes).add(tRecipe);
        }
        for (Recipe tRecipe : tRecipes) {
            this.arecipes.add(new CachedDefaultRecipe(tRecipe));
        }
    }

    public String getOverlayIdentifier() {
        return this.mRecipeMap.mNameNEI;
    }

    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)(CS.RES_PATH_GUI + "machines/NEI.png"));
        GuiDraw.drawTexturedModalRect((int)-5, (int)-16, (int)0, (int)0, (int)176, (int)166);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)-5, (int)-8, (int)0, (int)3, (int)176, (int)79);
    }

    public static void drawText(int aX, int aY, String aString, int aColor) {
        Minecraft.func_71410_x().field_71466_p.func_78276_b(aString, aX, aY, aColor);
    }

    public int recipiesPerPage() {
        return 1;
    }

    public String getRecipeName() {
        return LanguageHandler.translate(this.mRecipeMap.mNameInternal, this.mRecipeMap.mNameInternal);
    }

    public String getGuiTexture() {
        return UT.Code.stringValid(this.mRecipeMap.mGUIPath) ? this.mRecipeMap.mGUIPath : CS.RES_PATH_GUI + this.mRecipeMap.mNameInternal + ".png";
    }

    public List<String> handleItemTooltip(GuiRecipe gui, ItemStack aStack, List<String> currenttip, int aRecipeIndex) {
        TemplateRecipeHandler.CachedRecipe tObject = (TemplateRecipeHandler.CachedRecipe)this.arecipes.get(aRecipeIndex);
        if (tObject instanceof CachedDefaultRecipe) {
            CachedDefaultRecipe tRecipe = (CachedDefaultRecipe)tObject;
            for (PositionedStack tStack : tRecipe.mOutputs) {
                if (aStack != tStack.item) continue;
                if (!(tStack instanceof FixedPositionedStack) || ((FixedPositionedStack)tStack).mChance <= 0 || ((FixedPositionedStack)tStack).mChance == ((FixedPositionedStack)tStack).mMaxChance) break;
                long tChance = UT.Code.units(((FixedPositionedStack)tStack).mChance, ((FixedPositionedStack)tStack).mMaxChance, 10000L, false);
                currenttip.add(1, "Chance: " + tChance / 100L + "." + (tChance % 100L < 10L ? "0" + tChance % 100L : Long.valueOf(tChance % 100L)) + "%" + (tStack.item.field_77994_a > 1 ? " each" : ""));
                break;
            }
            for (PositionedStack tStack : tRecipe.mInputs) {
                if (aStack != tStack.item) continue;
                if (IL.Display_Fluid.equal(tStack.item, true, true) || tStack.item.field_77994_a != 0) break;
                currenttip.add(1, "Does not get consumed in the process");
                break;
            }
        }
        return currenttip;
    }

    public void drawExtras(int aRecipeIndex) {
        long tEUt = ((CachedDefaultRecipe)((Object)this.arecipes.get((int)aRecipeIndex))).mRecipe.mEUt;
        long tDuration = ((CachedDefaultRecipe)((Object)this.arecipes.get((int)aRecipeIndex))).mRecipe.mDuration;
        if (tEUt == 0L) {
            NEI_RecipeMap.drawText(10, 93, "Tier: unspecified", -16777216);
        } else if (tEUt > 0L) {
            NEI_RecipeMap.drawText(10, 73, "Costs: " + tDuration * tEUt + " GU", -16777216);
            NEI_RecipeMap.drawText(10, 83, "Usage: " + tEUt + " GU/t", -16777216);
            if (this.mRecipeMap.mShowVoltageAmperageInNEI) {
                NEI_RecipeMap.drawText(10, 93, "Tier: " + tEUt / this.mRecipeMap.mPower + " GU", -16777216);
                NEI_RecipeMap.drawText(10, 103, "Power: " + this.mRecipeMap.mPower, -16777216);
            }
        } else {
            NEI_RecipeMap.drawText(10, 73, "Gain: " + tDuration * (tEUt *= -1L) + " GU", -16777216);
            NEI_RecipeMap.drawText(10, 83, "Output: " + tEUt + " GU/t", -16777216);
            if (this.mRecipeMap.mShowVoltageAmperageInNEI) {
                NEI_RecipeMap.drawText(10, 93, "Tier: " + tEUt / this.mRecipeMap.mPower + " GU", -16777216);
                NEI_RecipeMap.drawText(10, 103, "Power: " + this.mRecipeMap.mPower, -16777216);
            }
        }
        if (tDuration > 0L) {
            NEI_RecipeMap.drawText(10, 113, "Time: " + (tDuration < 1200L ? tDuration + " ticks" : (tDuration < 36000L ? tDuration / 20L + " secs" : tDuration / 1200L + " mins")), -16777216);
        }
        if (UT.Code.stringValid(this.mRecipeMap.mNEISpecialValuePre) || UT.Code.stringValid(this.mRecipeMap.mNEISpecialValuePost)) {
            NEI_RecipeMap.drawText(10, 123, this.mRecipeMap.mNEISpecialValuePre + ((CachedDefaultRecipe)((Object)this.arecipes.get((int)aRecipeIndex))).mRecipe.mSpecialValue * this.mRecipeMap.mNEISpecialValueMultiplier + this.mRecipeMap.mNEISpecialValuePost, -16777216);
        }
    }

    static {
        GuiContainerManager.addInputHandler((IContainerInputHandler)new GT_RectHandler());
        GuiContainerManager.addTooltipHandler((IContainerTooltipHandler)new GT_RectHandler());
    }

    public static class GT_RectHandler
    implements IContainerInputHandler,
    IContainerTooltipHandler {
        public boolean mouseClicked(GuiContainer gui, int mousex, int mousey, int button) {
            if (this.canHandle(gui)) {
                if (button == 0) {
                    return this.transferRect(gui, false);
                }
                if (button == 1) {
                    return this.transferRect(gui, true);
                }
            }
            return false;
        }

        public boolean lastKeyTyped(GuiContainer gui, char keyChar, int keyCode) {
            return false;
        }

        public boolean canHandle(GuiContainer gui) {
            return gui instanceof ContainerClient && UT.Code.stringValid(((ContainerClient)gui).mNEI);
        }

        public List<String> handleTooltip(GuiContainer gui, int mousex, int mousey, List<String> currenttip) {
            if (this.canHandle(gui) && currenttip.isEmpty() && new Rectangle(65, 13, 36, 18).contains(new Point(GuiDraw.getMousePosition().x - ((ContainerClient)gui).getLeft() - RecipeInfo.getGuiOffset((GuiContainer)gui)[0], GuiDraw.getMousePosition().y - ((ContainerClient)gui).getTop() - RecipeInfo.getGuiOffset((GuiContainer)gui)[1]))) {
                currenttip.add("Recipes");
            }
            return currenttip;
        }

        private boolean transferRect(GuiContainer gui, boolean usage) {
            return this.canHandle(gui) && new Rectangle(65, 13, 36, 18).contains(new Point(GuiDraw.getMousePosition().x - ((ContainerClient)gui).getLeft() - RecipeInfo.getGuiOffset((GuiContainer)gui)[0], GuiDraw.getMousePosition().y - ((ContainerClient)gui).getTop() - RecipeInfo.getGuiOffset((GuiContainer)gui)[1])) && (usage ? GuiUsageRecipe.openRecipeGui((String)((ContainerClient)gui).mNEI, (Object[])new Object[0]) : GuiCraftingRecipe.openRecipeGui((String)((ContainerClient)gui).mNEI, (Object[])new Object[0]));
        }

        public List<String> handleItemDisplayName(GuiContainer gui, ItemStack itemstack, List<String> currenttip) {
            return currenttip;
        }

        public List<String> handleItemTooltip(GuiContainer gui, ItemStack itemstack, int mousex, int mousey, List<String> currenttip) {
            return currenttip;
        }

        public boolean keyTyped(GuiContainer gui, char keyChar, int keyCode) {
            return false;
        }

        public void onKeyTyped(GuiContainer gui, char keyChar, int keyID) {
        }

        public void onMouseClicked(GuiContainer gui, int mousex, int mousey, int button) {
        }

        public void onMouseUp(GuiContainer gui, int mousex, int mousey, int button) {
        }

        public boolean mouseScrolled(GuiContainer gui, int mousex, int mousey, int scrolled) {
            return false;
        }

        public void onMouseScrolled(GuiContainer gui, int mousex, int mousey, int scrolled) {
        }

        public void onMouseDragged(GuiContainer gui, int mousex, int mousey, int button, long heldTime) {
        }
    }

    public class CachedDefaultRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public final Recipe mRecipe;
        public final List<PositionedStack> mOutputs;
        public final List<PositionedStack> mInputs;

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(NEI_RecipeMap.this.cycleticks / 10, this.mInputs);
        }

        public PositionedStack getResult() {
            return null;
        }

        public List<PositionedStack> getOtherStacks() {
            return this.mOutputs;
        }

        public CachedDefaultRecipe(Recipe aRecipe) {
            int i;
            super((TemplateRecipeHandler)NEI_RecipeMap.this);
            this.mOutputs = new ArrayListNoNulls<PositionedStack>();
            this.mInputs = new ArrayListNoNulls<PositionedStack>();
            this.mRecipe = aRecipe;
            int tStartIndex = 0;
            switch (NEI_RecipeMap.this.mRecipeMap.mInputItemsCount) {
                case 0: {
                    break;
                }
                case 1: {
                    if (aRecipe.getRepresentativeInput(tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 53, NEI_RecipeMap.this.mRecipeMap.mInputFluidCount > 6 ? 7 : 25));
                    }
                    ++tStartIndex;
                    break;
                }
                case 2: {
                    if (aRecipe.getRepresentativeInput(tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 35, NEI_RecipeMap.this.mRecipeMap.mInputFluidCount > 6 ? 7 : 25));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 53, NEI_RecipeMap.this.mRecipeMap.mInputFluidCount > 6 ? 7 : 25));
                    }
                    ++tStartIndex;
                    break;
                }
                case 3: {
                    if (aRecipe.getRepresentativeInput(tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 17, NEI_RecipeMap.this.mRecipeMap.mInputFluidCount > 6 ? 7 : 25));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 35, NEI_RecipeMap.this.mRecipeMap.mInputFluidCount > 6 ? 7 : 25));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 53, NEI_RecipeMap.this.mRecipeMap.mInputFluidCount > 6 ? 7 : 25));
                    }
                    ++tStartIndex;
                    break;
                }
                case 4: {
                    if (aRecipe.getRepresentativeInput(tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 35, NEI_RecipeMap.this.mRecipeMap.mInputFluidCount > 3 ? 7 : 16));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 53, NEI_RecipeMap.this.mRecipeMap.mInputFluidCount > 3 ? 7 : 16));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 35, NEI_RecipeMap.this.mRecipeMap.mInputFluidCount > 3 ? 25 : 34));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 53, NEI_RecipeMap.this.mRecipeMap.mInputFluidCount > 3 ? 25 : 34));
                    }
                    ++tStartIndex;
                    break;
                }
                case 5: {
                    if (aRecipe.getRepresentativeInput(tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 17, NEI_RecipeMap.this.mRecipeMap.mInputFluidCount > 3 ? 7 : 16));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 35, NEI_RecipeMap.this.mRecipeMap.mInputFluidCount > 3 ? 7 : 16));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 53, NEI_RecipeMap.this.mRecipeMap.mInputFluidCount > 3 ? 7 : 16));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 35, NEI_RecipeMap.this.mRecipeMap.mInputFluidCount > 3 ? 25 : 34));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 53, NEI_RecipeMap.this.mRecipeMap.mInputFluidCount > 3 ? 25 : 34));
                    }
                    ++tStartIndex;
                    break;
                }
                case 6: {
                    if (aRecipe.getRepresentativeInput(tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 17, NEI_RecipeMap.this.mRecipeMap.mInputFluidCount > 3 ? 7 : 16));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 35, NEI_RecipeMap.this.mRecipeMap.mInputFluidCount > 3 ? 7 : 16));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 53, NEI_RecipeMap.this.mRecipeMap.mInputFluidCount > 3 ? 7 : 16));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 17, NEI_RecipeMap.this.mRecipeMap.mInputFluidCount > 3 ? 25 : 34));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 35, NEI_RecipeMap.this.mRecipeMap.mInputFluidCount > 3 ? 25 : 34));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 53, NEI_RecipeMap.this.mRecipeMap.mInputFluidCount > 3 ? 25 : 34));
                    }
                    ++tStartIndex;
                    break;
                }
                case 7: {
                    if (aRecipe.getRepresentativeInput(tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 17, 7));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 35, 7));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 53, 7));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 17, 25));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 35, 25));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 53, 25));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 17, 43));
                    }
                    ++tStartIndex;
                    break;
                }
                case 8: {
                    if (aRecipe.getRepresentativeInput(tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 17, 7));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 35, 7));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 53, 7));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 17, 25));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 35, 25));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 53, 25));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 17, 43));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 35, 43));
                    }
                    ++tStartIndex;
                    break;
                }
                case 9: {
                    if (aRecipe.getRepresentativeInput(tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 17, 7));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 35, 7));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 53, 7));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 17, 25));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 35, 25));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 53, 25));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 17, 43));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 35, 43));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 53, 43));
                    }
                    ++tStartIndex;
                    break;
                }
                case 10: {
                    if (aRecipe.getRepresentativeInput(tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 17, 7));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 35, 7));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 53, 7));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 17, 25));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 35, 25));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 53, 25));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 17, 43));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 35, 43));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 53, 43));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 53, 61));
                    }
                    ++tStartIndex;
                    break;
                }
                case 11: {
                    if (aRecipe.getRepresentativeInput(tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 17, 7));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 35, 7));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 53, 7));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 17, 25));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 35, 25));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 53, 25));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 17, 43));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 35, 43));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 53, 43));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 35, 61));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 53, 61));
                    }
                    ++tStartIndex;
                    break;
                }
                default: {
                    if (aRecipe.getRepresentativeInput(tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 17, 7));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 35, 7));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 53, 7));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 17, 25));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 35, 25));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 53, 25));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 17, 43));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 35, 43));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 53, 43));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 17, 61));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 35, 61));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 53, 61));
                    }
                    ++tStartIndex;
                }
            }
            if (aRecipe.mSpecialItems != null) {
                this.mInputs.add(new FixedPositionedStack(aRecipe.mSpecialItems, 80, 43));
            }
            if (!NEI_RecipeMap.this.mRecipeMap.mRecipeMachineList.isEmpty()) {
                this.mInputs.add(new FixedPositionedStack(NEI_RecipeMap.this.mRecipeMap.mRecipeMachineList, 152, 83));
            }
            tStartIndex = 0;
            switch (NEI_RecipeMap.this.mRecipeMap.mOutputItemsCount) {
                case 0: {
                    break;
                }
                case 1: {
                    if (aRecipe.getOutput(tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 107, NEI_RecipeMap.this.mRecipeMap.mOutputFluidCount > 6 ? 7 : 25, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    ++tStartIndex;
                    break;
                }
                case 2: {
                    if (aRecipe.getOutput(tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 107, NEI_RecipeMap.this.mRecipeMap.mOutputFluidCount > 6 ? 7 : 25, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 125, NEI_RecipeMap.this.mRecipeMap.mOutputFluidCount > 6 ? 7 : 25, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    ++tStartIndex;
                    break;
                }
                case 3: {
                    if (aRecipe.getOutput(tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 107, NEI_RecipeMap.this.mRecipeMap.mOutputFluidCount > 6 ? 7 : 25, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 125, NEI_RecipeMap.this.mRecipeMap.mOutputFluidCount > 6 ? 7 : 25, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 143, NEI_RecipeMap.this.mRecipeMap.mOutputFluidCount > 6 ? 7 : 25, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    ++tStartIndex;
                    break;
                }
                case 4: {
                    if (aRecipe.getOutput(tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 107, NEI_RecipeMap.this.mRecipeMap.mOutputFluidCount > 3 ? 7 : 16, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 125, NEI_RecipeMap.this.mRecipeMap.mOutputFluidCount > 3 ? 7 : 16, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 107, NEI_RecipeMap.this.mRecipeMap.mOutputFluidCount > 3 ? 25 : 34, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 125, NEI_RecipeMap.this.mRecipeMap.mOutputFluidCount > 3 ? 25 : 34, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    ++tStartIndex;
                    break;
                }
                case 5: {
                    if (aRecipe.getOutput(tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 107, NEI_RecipeMap.this.mRecipeMap.mOutputFluidCount > 3 ? 7 : 16, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 125, NEI_RecipeMap.this.mRecipeMap.mOutputFluidCount > 3 ? 7 : 16, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 143, NEI_RecipeMap.this.mRecipeMap.mOutputFluidCount > 3 ? 7 : 16, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 107, NEI_RecipeMap.this.mRecipeMap.mOutputFluidCount > 3 ? 25 : 34, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 125, NEI_RecipeMap.this.mRecipeMap.mOutputFluidCount > 3 ? 25 : 34, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    ++tStartIndex;
                    break;
                }
                case 6: {
                    if (aRecipe.getOutput(tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 107, NEI_RecipeMap.this.mRecipeMap.mOutputFluidCount > 3 ? 7 : 16, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 125, NEI_RecipeMap.this.mRecipeMap.mOutputFluidCount > 3 ? 7 : 16, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 143, NEI_RecipeMap.this.mRecipeMap.mOutputFluidCount > 3 ? 7 : 16, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 107, NEI_RecipeMap.this.mRecipeMap.mOutputFluidCount > 3 ? 25 : 34, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 125, NEI_RecipeMap.this.mRecipeMap.mOutputFluidCount > 3 ? 25 : 34, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 143, NEI_RecipeMap.this.mRecipeMap.mOutputFluidCount > 3 ? 25 : 34, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    ++tStartIndex;
                    break;
                }
                case 7: {
                    if (aRecipe.getOutput(tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 107, 7, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 125, 7, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 143, 7, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 107, 25, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 125, 25, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 143, 25, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 107, 43, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    ++tStartIndex;
                    break;
                }
                case 8: {
                    if (aRecipe.getOutput(tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 107, 7, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 125, 7, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 143, 7, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 107, 25, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 125, 25, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 143, 25, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 107, 43, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 125, 43, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    ++tStartIndex;
                    break;
                }
                case 9: {
                    if (aRecipe.getOutput(tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 107, 7, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 125, 7, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 143, 7, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 107, 25, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 125, 25, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 143, 25, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 107, 43, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 125, 43, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 143, 43, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    ++tStartIndex;
                    break;
                }
                case 10: {
                    if (aRecipe.getOutput(tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 107, 7, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 125, 7, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 143, 7, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 107, 25, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 125, 25, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 143, 25, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 107, 43, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 125, 43, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 143, 43, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 143, 61, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    ++tStartIndex;
                    break;
                }
                case 11: {
                    if (aRecipe.getOutput(tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 107, 7, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 125, 7, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 143, 7, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 107, 25, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 125, 25, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 143, 25, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 107, 43, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 125, 43, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 143, 43, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 125, 61, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 143, 61, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    ++tStartIndex;
                    break;
                }
                default: {
                    if (aRecipe.getOutput(tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 107, 7, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 125, 7, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 143, 7, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 107, 25, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 125, 25, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 143, 25, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 107, 43, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 125, 43, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 143, 43, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 107, 61, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 125, 61, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 143, 61, aRecipe.getOutputChance(tStartIndex), aRecipe.getMaxChance(tStartIndex)));
                    }
                    ++tStartIndex;
                }
            }
            for (i = 0; i < aRecipe.mFluidInputs.length && i < NEI_RecipeMap.this.mRecipeMap.mInputFluidCount; ++i) {
                if (aRecipe.mFluidInputs[i] == null || aRecipe.mFluidInputs[i].getFluid() == null) continue;
                this.mInputs.add(new FixedPositionedStack(UT.Fluids.display(aRecipe.mFluidInputs[i], true), 53 - i % 3 * 18, 63 - i / 3 * 18));
            }
            for (i = 0; i < aRecipe.mFluidOutputs.length && i < NEI_RecipeMap.this.mRecipeMap.mOutputFluidCount; ++i) {
                if (aRecipe.mFluidOutputs[i] == null || aRecipe.mFluidOutputs[i].getFluid() == null) continue;
                this.mOutputs.add(new FixedPositionedStack(UT.Fluids.display(aRecipe.mFluidOutputs[i], true), 107 + i % 3 * 18, 63 - i / 3 * 18));
            }
        }
    }

    public class FixedPositionedStack
    extends PositionedStack {
        public boolean permutated;
        public final int mChance;
        public final int mMaxChance;

        public FixedPositionedStack(Object object, int x, int y) {
            this(object, x, y, 0, 0);
        }

        public FixedPositionedStack(Object object, int x, int y, int aChance, int aMaxChance) {
            super(object, x - 5, y - 11, true);
            this.permutated = false;
            this.mMaxChance = aMaxChance;
            this.mChance = aChance;
        }

        public void generatePermutations() {
            if (this.permutated) {
                return;
            }
            ArrayListNoNulls<ItemStack> tDisplayStacks = new ArrayListNoNulls<ItemStack>();
            for (ItemStack tStack : this.items) {
                if (!UT.Stacks.valid(tStack)) continue;
                if (UT.Stacks.meta(tStack) == Short.MAX_VALUE) {
                    List permutations = ItemList.itemMap.get((Object)tStack.func_77973_b());
                    if (!permutations.isEmpty()) {
                        for (ItemStack stack : permutations) {
                            ((ArrayList)tDisplayStacks).add(UT.Stacks.amount(tStack.field_77994_a, stack));
                        }
                        continue;
                    }
                    ItemStack base = UT.Stacks.make(tStack.func_77973_b(), (long)tStack.field_77994_a, 0L);
                    base.field_77990_d = tStack.field_77990_d;
                    ((ArrayList)tDisplayStacks).add(base);
                    continue;
                }
                ((ArrayList)tDisplayStacks).add(UT.Stacks.copy(tStack));
            }
            this.items = tDisplayStacks.toArray(new ItemStack[0]);
            if (this.items.length == 0) {
                this.items = new ItemStack[]{UT.Stacks.make((Block)Blocks.field_150480_ab, 1L, 0L)};
            }
            this.permutated = true;
            this.setPermutationToRender(0);
        }
    }
}

