/*
 * Decompiled with CFR 0.152.
 */
package gregapi;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.IFuelHandler;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppedEvent;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import gregapi.api.Abstract_Mod;
import gregapi.api.Abstract_Proxy;
import gregapi.block.IBlockPlacable;
import gregapi.block.IBlockToolable;
import gregapi.block.multitileentity.MultiTileEntityItemInternal;
import gregapi.block.multitileentity.MultiTileEntityRegistry;
import gregapi.code.ArrayListNoNulls;
import gregapi.code.HashSetNoNulls;
import gregapi.code.ItemStackContainer;
import gregapi.data.CS;
import gregapi.data.IL;
import gregapi.data.MT;
import gregapi.data.TD;
import gregapi.item.IItemNoGTOverride;
import gregapi.item.IItemProjectile;
import gregapi.item.multiitem.MultiItemRandom;
import gregapi.item.multiitem.MultiItemTool;
import gregapi.network.packets.PacketConfig;
import gregapi.network.packets.PacketPrefix;
import gregapi.oredict.IOreDictListenerItem;
import gregapi.oredict.OreDictItemData;
import gregapi.oredict.OreDictMaterialStack;
import gregapi.oredict.OreDictPrefix;
import gregapi.recipes.GT_ModHandler;
import gregapi.tileentity.ITileEntityGUI;
import gregapi.tileentity.ITileEntityScheduledUpdate;
import gregapi.tileentity.ITileEntityServerTickPost;
import gregapi.tileentity.ITileEntityServerTickPre;
import gregapi.tileentity.ITileEntitySpecificPlacementBehavior;
import gregapi.tileentity.ITileEntitySynchronising;
import gregapi.tileentity.inventories.ITileEntityBookShelf;
import gregapi.util.OM;
import gregapi.util.UT;
import java.io.File;
import java.util.ConcurrentModificationException;
import java.util.List;
import net.minecraft.block.BlockJukebox;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.item.ItemExpireEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.ArrowNockEvent;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ChunkWatchEvent;
import net.minecraftforge.event.world.WorldEvent;

public abstract class GT_API_Proxy
extends Abstract_Proxy
implements IGuiHandler,
IFuelHandler {
    private World mUniverse = null;
    public File mSaveLocation = null;
    public static List<ITileEntityServerTickPre> SERVER_TICK_PRE = new ArrayListNoNulls<ITileEntityServerTickPre>();
    public static List<ITileEntityServerTickPost> SERVER_TICK_POST = new ArrayListNoNulls<ITileEntityServerTickPost>();
    public static List<ITileEntityScheduledUpdate> SCHEDULED_TILEENTITY_UPDATES = new ArrayListNoNulls<ITileEntityScheduledUpdate>();
    private static List<ITileEntityScheduledUpdate> SCHEDULED_TILEENTITY_UPDATES_2 = new ArrayListNoNulls<ITileEntityScheduledUpdate>();
    public static List<EntityPlayerMP> mNewPlayers = new ArrayListNoNulls<EntityPlayerMP>();

    public GT_API_Proxy() {
        GameRegistry.registerFuelHandler((IFuelHandler)this);
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    public EntityPlayer getThePlayer() {
        return null;
    }

    public Object getServerGuiElement(int aGUIID, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ) {
        TileEntity tTileEntity = UT.Worlds.getTileEntity(aWorld, aX, aY, aZ, true);
        return tTileEntity instanceof ITileEntityGUI ? ((ITileEntityGUI)tTileEntity).getGUIServer(aGUIID, aPlayer) : null;
    }

    public Object getClientGuiElement(int aGUIID, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ) {
        TileEntity tTileEntity = UT.Worlds.getTileEntity(aWorld, aX, aY, aZ, true);
        return tTileEntity instanceof ITileEntityGUI ? ((ITileEntityGUI)tTileEntity).getGUIClient(aGUIID, aPlayer) : null;
    }

    @Override
    public void onProxyBeforeServerStarting(Abstract_Mod aMod, FMLServerStartingEvent aEvent) {
        CS.SERVER_TIME = 0L;
    }

    @Override
    public void onProxyAfterServerStopped(Abstract_Mod aMod, FMLServerStoppedEvent aEvent) {
        if (this.mSaveLocation != null) {
            new File(this.mSaveLocation, "gregtech").mkdirs();
            MultiTileEntityRegistry.onServerSave(this.mSaveLocation);
        }
        this.mUniverse = null;
        this.mSaveLocation = null;
    }

    public File getSaveDirectory() {
        if (this.mUniverse != null) {
            this.mSaveLocation = this.mUniverse.func_72860_G().func_75765_b();
        }
        return this.mSaveLocation;
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load aEvent) {
        if (this.mUniverse == null) {
            this.mUniverse = aEvent.world;
            this.getSaveDirectory();
            if (this.mSaveLocation != null) {
                new File(this.mSaveLocation, "gregtech").mkdirs();
                MultiTileEntityRegistry.onServerLoad(this.mSaveLocation);
            }
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent aEvent) {
        if (aEvent.side.isServer()) {
            int i;
            if (aEvent.phase == TickEvent.Phase.START) {
                ++CS.SERVER_TIME;
                for (i = 0; i < SERVER_TICK_PRE.size(); ++i) {
                    ITileEntityServerTickPre iTileEntityServerTickPre = SERVER_TICK_PRE.get(i);
                    if (iTileEntityServerTickPre.isDead()) {
                        SERVER_TICK_PRE.remove(i--);
                        continue;
                    }
                    iTileEntityServerTickPre.onServerTickPre();
                }
                if (CS.SERVER_TIME > 10L) {
                    for (ITileEntityScheduledUpdate iTileEntityScheduledUpdate : SCHEDULED_TILEENTITY_UPDATES_2) {
                        if (iTileEntityScheduledUpdate.isDead()) continue;
                        iTileEntityScheduledUpdate.onScheduledUpdate();
                    }
                    SCHEDULED_TILEENTITY_UPDATES_2.clear();
                    List<ITileEntityScheduledUpdate> tList = SCHEDULED_TILEENTITY_UPDATES_2;
                    SCHEDULED_TILEENTITY_UPDATES_2 = SCHEDULED_TILEENTITY_UPDATES;
                    SCHEDULED_TILEENTITY_UPDATES = tList;
                    while (!mNewPlayers.isEmpty()) {
                        EntityPlayerMP entityPlayerMP = mNewPlayers.remove(0);
                        CS.NW_API.sendToPlayer(new PacketConfig(), entityPlayerMP);
                        for (OreDictPrefix tPrefix : OreDictPrefix.VALUES) {
                            if (tPrefix.contains(TD.Prefix.PREFIX_UNUSED)) continue;
                            CS.NW_API.sendToPlayer(new PacketPrefix(tPrefix), entityPlayerMP);
                        }
                    }
                }
            }
            if (aEvent.phase == TickEvent.Phase.END) {
                for (i = 0; i < SERVER_TICK_POST.size(); ++i) {
                    ITileEntityServerTickPost iTileEntityServerTickPost = SERVER_TICK_POST.get(i);
                    if (iTileEntityServerTickPost.isDead()) {
                        SERVER_TICK_POST.remove(i--);
                        continue;
                    }
                    iTileEntityServerTickPost.onServerTickPost();
                }
            }
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent aEvent) {
        if (aEvent.side.isServer() && aEvent.phase == TickEvent.Phase.END) {
            for (int i = 0; i < aEvent.world.field_72996_f.size(); ++i) {
                Object aEntity = aEvent.world.field_72996_f.get(i);
                if (!(aEntity instanceof EntityItem) || ((EntityItem)aEntity).field_70128_L) continue;
                boolean tBreak = false;
                ItemStack aStack = ((EntityItem)aEntity).func_92059_d();
                ItemStack rStack = UT.Stacks.copy(aStack);
                OreDictItemData aData = OM.anydata(rStack);
                if (aData == null) continue;
                if (aData.mPrefix != null) {
                    for (IOreDictListenerItem tListener : aData.mPrefix.mListenersItem) {
                        rStack = tListener.onTickWorld(aData.mPrefix, aData.mMaterial.mMaterial, rStack, (EntityItem)aEntity);
                        if (UT.Stacks.equal(rStack, aStack) && rStack.field_77994_a == aStack.field_77994_a) continue;
                        tBreak = true;
                        break;
                    }
                }
                if (!tBreak && aData.mMaterial != null) {
                    block2: for (OreDictMaterialStack tMaterial : aData.getAllMaterialStacks()) {
                        if (tBreak) break;
                        for (IOreDictListenerItem tListener : tMaterial.mMaterial.mListenersItem) {
                            rStack = tListener.onTickWorld(aData.mPrefix, tMaterial.mMaterial, rStack, (EntityItem)aEntity);
                            if (UT.Stacks.equal(rStack, aStack) && rStack.field_77994_a == aStack.field_77994_a) continue;
                            tBreak = true;
                            continue block2;
                        }
                    }
                }
                if (rStack == null || rStack.field_77994_a <= 0) {
                    ((EntityItem)aEntity).func_92058_a(CS.NI);
                    ((EntityItem)aEntity).func_70106_y();
                    continue;
                }
                ((EntityItem)aEntity).func_92058_a(rStack);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerItemPickupEvent(PlayerEvent.ItemPickupEvent aEvent) {
        ItemStack aStack = aEvent.pickedUp.func_92059_d();
        if (UT.Stacks.valid(aStack) && aEvent.player != null) {
            OreDictItemData tData = OM.association_(aStack);
            if (OM.is_("logWood", aStack) || OM.is_("logRubber", aStack)) {
                aEvent.player.func_71029_a((StatBase)AchievementList.field_76004_f);
                aEvent.player.func_71029_a((StatBase)AchievementList.field_76005_g);
            }
            if (aStack.func_77973_b() == Items.field_151101_aQ) {
                aEvent.player.func_71029_a((StatBase)AchievementList.field_76004_f);
                aEvent.player.func_71029_a((StatBase)AchievementList.field_76005_g);
                aEvent.player.func_71029_a((StatBase)AchievementList.field_76017_h);
                aEvent.player.func_71029_a((StatBase)AchievementList.field_76018_i);
                aEvent.player.func_71029_a((StatBase)AchievementList.field_76015_j);
                aEvent.player.func_71029_a((StatBase)AchievementList.field_76026_p);
            }
            if (aStack.func_77973_b() == Items.field_151025_P) {
                aEvent.player.func_71029_a((StatBase)AchievementList.field_76004_f);
                aEvent.player.func_71029_a((StatBase)AchievementList.field_76005_g);
                aEvent.player.func_71029_a((StatBase)AchievementList.field_76017_h);
                aEvent.player.func_71029_a((StatBase)AchievementList.field_76013_l);
                aEvent.player.func_71029_a((StatBase)AchievementList.field_76014_m);
            }
            if (aStack.func_77973_b() == Items.field_151105_aU) {
                aEvent.player.func_71029_a((StatBase)AchievementList.field_76004_f);
                aEvent.player.func_71029_a((StatBase)AchievementList.field_76005_g);
                aEvent.player.func_71029_a((StatBase)AchievementList.field_76017_h);
                aEvent.player.func_71029_a((StatBase)AchievementList.field_76013_l);
                aEvent.player.func_71029_a((StatBase)AchievementList.field_76011_n);
            }
            if (tData != null && tData.mMaterial.mMaterial == MT.Diamond && tData.mPrefix.contains(TD.Prefix.GEM_BASED)) {
                aEvent.player.func_71029_a((StatBase)AchievementList.field_76004_f);
                aEvent.player.func_71029_a((StatBase)AchievementList.field_76005_g);
                aEvent.player.func_71029_a((StatBase)AchievementList.field_76017_h);
                aEvent.player.func_71029_a((StatBase)AchievementList.field_76018_i);
                aEvent.player.func_71029_a((StatBase)AchievementList.field_76015_j);
                aEvent.player.func_71029_a((StatBase)AchievementList.field_76016_k);
                aEvent.player.func_71029_a((StatBase)AchievementList.field_76019_w);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerTickEventServer(TickEvent.PlayerTickEvent aEvent) {
        if (!aEvent.player.field_70128_L && aEvent.phase == TickEvent.Phase.END && aEvent.side.isServer()) {
            boolean tHungerEffect;
            if (CS.SURVIVAL_INTO_ADVENTURE_MODE && aEvent.player.field_70173_aa % 200 == 0 && aEvent.player.field_71075_bZ.field_75099_e && !UT.Entities.isCreative(aEvent.player)) {
                aEvent.player.func_71033_a(WorldSettings.GameType.ADVENTURE);
                aEvent.player.field_71075_bZ.field_75099_e = false;
                if (CS.ADVENTURE_MODE_AXE) {
                    UT.Entities.chat((Object)aEvent.player, "It's dangerous to go alone! Take this.");
                    aEvent.player.field_70170_p.func_72838_d((Entity)new EntityItem(aEvent.player.field_70170_p, aEvent.player.field_70165_t, aEvent.player.field_70163_u, aEvent.player.field_70161_v, CS.ToolsGT.sMetaTool == null ? UT.Stacks.make(Items.field_151049_t, 1L, 0L) : CS.ToolsGT.sMetaTool.getToolWithStats(6, 1, MT.Flint, MT.Wood, 0L, 0L)));
                }
            }
            boolean bl = tHungerEffect = CS.HUNGER_BY_INVENTORY_WEIGT && aEvent.player.field_70173_aa % 2400 == 1200;
            if (aEvent.player.field_70173_aa % 120 == 0) {
                float tHeat;
                ItemStack tStack;
                int i;
                int tCount = 64;
                for (i = 0; i < 36; ++i) {
                    tStack = aEvent.player.field_71071_by.func_70301_a(i);
                    if (tStack == null) continue;
                    if (!UT.Entities.isInvincible(aEvent.player)) {
                        UT.Entities.applyRadioactivity((Entity)aEvent.player, UT.Entities.getRadioactivityLevel(tStack), tStack.field_77994_a);
                        tHeat = UT.Entities.getHeatDamageFromItem(tStack);
                        if (tHeat != 0.0f) {
                            if (tHeat > 0.0f) {
                                UT.Entities.applyHeatDamage((Entity)aEvent.player, tHeat);
                            } else {
                                UT.Entities.applyFrostDamage((Entity)aEvent.player, -tHeat);
                            }
                        }
                    }
                    if (tHungerEffect) {
                        tCount += tStack.field_77994_a * 64 / Math.max(1, tStack.func_77976_d());
                    }
                    if (CS.INVENTORY_UNIFICATION) {
                        OM.set_(tStack);
                    }
                    UT.Stacks.update(tStack);
                }
                for (i = 0; i < 4; ++i) {
                    tStack = aEvent.player.field_71071_by.field_70460_b[i];
                    if (tStack == null) continue;
                    if (!UT.Entities.isInvincible(aEvent.player)) {
                        UT.Entities.applyRadioactivity((Entity)aEvent.player, UT.Entities.getRadioactivityLevel(tStack), tStack.field_77994_a);
                        tHeat = UT.Entities.getHeatDamageFromItem(tStack);
                        if (tHeat != 0.0f) {
                            if (tHeat > 0.0f) {
                                UT.Entities.applyHeatDamage((Entity)aEvent.player, tHeat);
                            } else {
                                UT.Entities.applyFrostDamage((Entity)aEvent.player, -tHeat);
                            }
                        }
                    }
                    if (!tHungerEffect) continue;
                    tCount += 256;
                }
                if (tHungerEffect) {
                    aEvent.player.func_71020_j(Math.max(1.0f, (float)tCount / 666.6f));
                }
            }
        }
    }

    @SubscribeEvent
    public void onChunkWatchEvent(ChunkWatchEvent.Watch aEvent) {
        Chunk tChunk = aEvent.player.field_70170_p.func_72964_e(aEvent.chunk.field_77276_a, aEvent.chunk.field_77275_b);
        if (tChunk != null && tChunk.field_76646_k) {
            int tIterates = 8;
            HashSetNoNulls tSet = new HashSetNoNulls();
            while (true) {
                int n = tIterates;
                tIterates = (byte)(tIterates - 1);
                if (n <= 0) break;
                try {
                    for (Object tTileEntity : tChunk.field_150816_i.values()) {
                        if (!(tTileEntity instanceof ITileEntitySynchronising) || !tSet.add(tTileEntity)) continue;
                        ((ITileEntitySynchronising)tTileEntity).sendUpdateToPlayer(aEvent.player);
                    }
                    tIterates = 0;
                }
                catch (ConcurrentModificationException e) {
                    if (tIterates > 0) continue;
                    CS.ERR.println("Failed to Iterate 8 times. Giving up!");
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerDestroyItem(PlayerDestroyItemEvent aEvent) {
        if (!UT.Entities.isPlayer(aEvent.entityPlayer) || aEvent.original == null || UT.Entities.hasInfiniteItems(aEvent.entityPlayer) || aEvent.entityPlayer.field_71071_by.field_70462_a.length != 36) {
            return;
        }
        if ((aEvent.entityPlayer.field_71071_by.func_70301_a(aEvent.entityPlayer.field_71071_by.field_70461_c) == null || aEvent.entityPlayer.field_71071_by.func_70301_a((int)aEvent.entityPlayer.field_71071_by.field_70461_c).field_77994_a == 0) && UT.Stacks.equal(aEvent.original, aEvent.entityPlayer.field_71071_by.func_70301_a(aEvent.entityPlayer.field_71071_by.field_70461_c + 27))) {
            if (UT.Stacks.equal(aEvent.original, aEvent.entityPlayer.field_71071_by.func_70301_a(aEvent.entityPlayer.field_71071_by.field_70461_c + 18))) {
                if (UT.Stacks.equal(aEvent.original, aEvent.entityPlayer.field_71071_by.func_70301_a(aEvent.entityPlayer.field_71071_by.field_70461_c + 9))) {
                    aEvent.entityPlayer.field_71071_by.func_70299_a(aEvent.entityPlayer.field_71071_by.field_70461_c, aEvent.entityPlayer.field_71071_by.func_70301_a(aEvent.entityPlayer.field_71071_by.field_70461_c + 9));
                    aEvent.entityPlayer.field_71071_by.func_70299_a(aEvent.entityPlayer.field_71071_by.field_70461_c + 9, null);
                    if (aEvent.entityPlayer.field_71070_bA != null) {
                        aEvent.entityPlayer.field_71070_bA.func_75142_b();
                    }
                    return;
                }
                aEvent.entityPlayer.field_71071_by.func_70299_a(aEvent.entityPlayer.field_71071_by.field_70461_c, aEvent.entityPlayer.field_71071_by.func_70301_a(aEvent.entityPlayer.field_71071_by.field_70461_c + 18));
                aEvent.entityPlayer.field_71071_by.func_70299_a(aEvent.entityPlayer.field_71071_by.field_70461_c + 18, null);
                if (aEvent.entityPlayer.field_71070_bA != null) {
                    aEvent.entityPlayer.field_71070_bA.func_75142_b();
                }
                return;
            }
            aEvent.entityPlayer.field_71071_by.func_70299_a(aEvent.entityPlayer.field_71071_by.field_70461_c, aEvent.entityPlayer.field_71071_by.func_70301_a(aEvent.entityPlayer.field_71071_by.field_70461_c + 27));
            aEvent.entityPlayer.field_71071_by.func_70299_a(aEvent.entityPlayer.field_71071_by.field_70461_c + 27, null);
            if (aEvent.entityPlayer.field_71070_bA != null) {
                aEvent.entityPlayer.field_71070_bA.func_75142_b();
            }
            return;
        }
    }

    @SubscribeEvent
    public void onPlayerInteraction(PlayerInteractEvent aEvent) {
        if (aEvent.entityPlayer == null || aEvent.entityPlayer.field_70170_p == null || aEvent.action == null || aEvent.world.field_73011_w == null || aEvent.action == null) {
            return;
        }
        ItemStack aStack = aEvent.entityPlayer.field_71071_by.func_70448_g();
        TileEntity aTileEntity = aEvent.world.func_147438_o(aEvent.x, aEvent.y, aEvent.z);
        if ((aEvent.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK || aEvent.action == PlayerInteractEvent.Action.RIGHT_CLICK_AIR) && UT.Stacks.valid(aStack) && aTileEntity instanceof ITileEntityBookShelf && ((ITileEntityBookShelf)aTileEntity).isShelfFace((byte)aEvent.face)) {
            aEvent.useBlock = Event.Result.ALLOW;
            if (CS.BooksGT.BOOK_REGISTER.containsKey(new ItemStackContainer(aStack)) || CS.BooksGT.BOOK_REGISTER.containsKey(new ItemStackContainer(UT.Stacks.copyMeta(32767L, aStack)))) {
                aEvent.useItem = Event.Result.DENY;
            }
            return;
        }
        if (aEvent.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) {
            if (aTileEntity instanceof BlockJukebox.TileEntityJukebox) {
                ItemStack tStack = ((BlockJukebox.TileEntityJukebox)aTileEntity).func_145856_a();
                if (tStack != null) {
                    tStack.field_77994_a = 1;
                }
                return;
            }
            if (UT.Stacks.valid(aStack) && !(aStack.func_77973_b() instanceof IItemNoGTOverride)) {
                if (IL.JABBA_Dolly.equal(aStack, true, true) || IL.JABBA_Dolly_Diamond.equal(aStack, true, true)) {
                    if (aTileEntity instanceof ITileEntitySpecificPlacementBehavior) {
                        UT.Entities.chat((Object)aEvent.entityPlayer, "The Code of the Dolly is by far not smart enough to move this TileEntity.", "It would crash if it actually did, so be glad I prevented that mistake.");
                        aEvent.setCanceled(true);
                    }
                    return;
                }
                if (IL.RC_Crowbar_Iron.equal(aStack, true, true) || IL.RC_Crowbar_Steel.equal(aStack, true, true) || IL.RC_Crowbar_Thaumium.equal(aStack, true, true) || IL.RC_Crowbar_Voidmetal.equal(aStack, true, true)) {
                    ArrayListNoNulls<String> tChatReturn = new ArrayListNoNulls<String>();
                    long tDamage = IBlockToolable.Util.onToolClick("crowbar", Long.MAX_VALUE, 2L, (Entity)aEvent.entityPlayer, tChatReturn, (IInventory)aEvent.entityPlayer.field_71071_by, aEvent.entityPlayer.func_70093_af(), aStack, aEvent.entityPlayer.field_70170_p, (byte)aEvent.face, aEvent.x, aEvent.y, aEvent.z, 0.5f, 0.5f, 0.5f);
                    UT.Entities.chat((Object)aEvent.entityPlayer, tChatReturn, false);
                    if (tDamage > 0L) {
                        aStack.func_77972_a((int)UT.Code.units(tDamage, 10000L, 1L, true), (EntityLivingBase)aEvent.entityPlayer);
                        if (aStack.func_77960_j() >= aStack.func_77958_k()) {
                            --aStack.field_77994_a;
                        }
                        if (aStack.field_77994_a <= 0) {
                            ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)aEvent.entityPlayer, (ItemStack)aStack);
                        }
                        aEvent.setCanceled(true);
                    }
                    return;
                }
            }
        }
    }

    @SubscribeEvent
    public void onBlockBreakSpeedEvent(PlayerEvent.BreakSpeed aEvent) {
        if (aEvent.newSpeed > 0.0f) {
            ItemStackContainer tBlock;
            ItemStack aStack;
            if (aEvent.entityPlayer != null && (aStack = aEvent.entityPlayer.func_71045_bC()) != null && aStack.func_77973_b() instanceof MultiItemTool) {
                aEvent.newSpeed = ((MultiItemTool)aStack.func_77973_b()).onBlockBreakSpeedEvent(aEvent.newSpeed, aStack, aEvent.entityPlayer, aEvent.block, aEvent.x, aEvent.y, aEvent.z, (byte)aEvent.metadata, aEvent);
            }
            if (CS.BlocksGT.stoneToBrokenOres.containsKey(tBlock = new ItemStackContainer(aEvent.block, 1L, (long)aEvent.metadata)) || CS.BlocksGT.stoneToNormalOres.containsKey(tBlock) || CS.BlocksGT.stoneToSmallOres.containsKey(tBlock)) {
                aEvent.newSpeed = aEvent.block.func_149688_o() == Material.field_151595_p || aEvent.block.func_149688_o() == Material.field_151571_B || aEvent.block.func_149688_o() == Material.field_151577_b || aEvent.block.func_149688_o() == Material.field_151578_c ? (float)((double)aEvent.newSpeed / CS.HARDNESS_MULTIPLIER_SAND) : (float)((double)aEvent.newSpeed / CS.HARDNESS_MULTIPLIER_ROCK);
            } else if (aEvent.block instanceof IBlockPlacable) {
                if (CS.BlocksGT.stoneToBrokenOres.containsValue(aEvent.block) || CS.BlocksGT.stoneToNormalOres.containsValue(aEvent.block) || CS.BlocksGT.stoneToSmallOres.containsValue(aEvent.block)) {
                    aEvent.newSpeed = (float)((double)aEvent.newSpeed / CS.HARDNESS_MULTIPLIER_ORES);
                }
            } else if (OM.prefixcontains(UT.Stacks.make(aEvent.block, 1L, (long)aEvent.metadata), TD.Prefix.ORE)) {
                aEvent.newSpeed = (float)((double)aEvent.newSpeed / CS.HARDNESS_MULTIPLIER_ORES);
            }
        }
    }

    @SubscribeEvent
    public void onBlockHarvestingEvent(BlockEvent.HarvestDropsEvent aEvent) {
        if (aEvent.harvester != null) {
            ItemStack aStack = aEvent.harvester.func_71045_bC();
            if (aStack != null) {
                if (aStack.func_77973_b() instanceof MultiItemTool) {
                    ((MultiItemTool)aStack.func_77973_b()).onHarvestBlockEvent(aEvent.drops, aStack, aEvent.harvester, aEvent.block, aEvent.x, aEvent.y, aEvent.z, (byte)aEvent.blockMetadata, aEvent.fortuneLevel, aEvent.isSilkTouching, aEvent);
                }
                if (EnchantmentHelper.func_77506_a((int)Enchantment.field_77334_n.field_77352_x, (ItemStack)aStack) > 2) {
                    for (ItemStack tDrop : aEvent.drops) {
                        ItemStack tSmeltingOutput = GT_ModHandler.getSmeltingOutput(tDrop, false, null);
                        if (tSmeltingOutput == null) continue;
                        tDrop.field_77994_a *= tSmeltingOutput.field_77994_a;
                        tSmeltingOutput.field_77994_a = tDrop.field_77994_a;
                        UT.Stacks.set(tDrop, tSmeltingOutput);
                    }
                }
            }
            UT.Inventories.removeNullStacksFromInventory((IInventory)aEvent.harvester.field_71071_by);
        }
    }

    @SubscribeEvent
    public void onLoginEvent(PlayerEvent.PlayerLoggedInEvent aEvent) {
        if (aEvent.player.field_70170_p.field_72995_K) {
            return;
        }
        if (aEvent.player instanceof EntityPlayerMP) {
            mNewPlayers.add((EntityPlayerMP)aEvent.player);
        }
    }

    @SubscribeEvent
    public void onItemExpireEvent(ItemExpireEvent aEvent) {
        ItemStack aStack = aEvent.entityItem.func_92059_d();
        if (aStack != null && aStack.func_77973_b() instanceof MultiTileEntityItemInternal) {
            int tExtraLife = ((MultiTileEntityItemInternal)aStack.func_77973_b()).onDespawn(aEvent.entityItem, aStack);
            if (aStack.field_77994_a <= 0) {
                aEvent.entityItem.func_70106_y();
                return;
            }
            aEvent.entityItem.func_92058_a(aStack);
            if (tExtraLife > 0) {
                aEvent.extraLife += tExtraLife;
                aEvent.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onEntitySpawningEvent(EntityJoinWorldEvent aEvent) {
        if (aEvent.entity != null && !aEvent.entity.field_70170_p.field_72995_K && aEvent.entity instanceof EntityItem) {
            ((EntityItem)aEvent.entity).func_92058_a(UT.Stacks.update(OM.get(((EntityItem)aEvent.entity).func_92059_d())));
        }
    }

    @SubscribeEvent
    public void onArrowNockEvent(ArrowNockEvent aEvent) {
        if (!aEvent.isCanceled() && UT.Stacks.valid(aEvent.result) && UT.Inventories.getProjectile(TD.Projectiles.ARROW, (IInventory)aEvent.entityPlayer.field_71071_by) != null) {
            aEvent.entityPlayer.func_71008_a(aEvent.result, aEvent.result.func_77973_b().func_77626_a(aEvent.result));
            aEvent.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onArrowLooseEvent(ArrowLooseEvent aEvent) {
        ItemStack aArrow = UT.Inventories.getProjectile(TD.Projectiles.ARROW, (IInventory)aEvent.entityPlayer.field_71071_by);
        if (!aEvent.isCanceled() && UT.Stacks.valid(aEvent.bow) && aArrow != null && aEvent.bow.func_77973_b() instanceof ItemBow) {
            int tLevel;
            float tSpeed = (float)aEvent.charge / 20.0f;
            if ((double)(tSpeed = (tSpeed * tSpeed + tSpeed * 2.0f) / 3.0f) < 0.1) {
                return;
            }
            if ((double)tSpeed > 1.0) {
                tSpeed = 1.0f;
            }
            IItemProjectile.EntityProjectile tArrowEntity = ((IItemProjectile)aArrow.func_77973_b()).getProjectile(TD.Projectiles.ARROW, aArrow, aEvent.entityPlayer.field_70170_p, (EntityLivingBase)aEvent.entityPlayer, tSpeed * 2.0f);
            if (tSpeed >= 1.0f) {
                tArrowEntity.func_70243_d(true);
            }
            if ((tLevel = EnchantmentHelper.func_77506_a((int)Enchantment.field_77345_t.field_77352_x, (ItemStack)aEvent.bow)) > 0) {
                tArrowEntity.func_70239_b(tArrowEntity.func_70242_d() + (double)tLevel * 0.5 + 0.5);
            }
            if ((tLevel = EnchantmentHelper.func_77506_a((int)Enchantment.field_77344_u.field_77352_x, (ItemStack)aEvent.bow)) > 0) {
                tArrowEntity.func_70240_a(tLevel);
            }
            if ((tLevel = EnchantmentHelper.func_77506_a((int)Enchantment.field_77343_v.field_77352_x, (ItemStack)aEvent.bow)) > 0) {
                tArrowEntity.func_70015_d(tLevel * 100);
            }
            aEvent.bow.func_77972_a(1, (EntityLivingBase)aEvent.entityPlayer);
            aEvent.bow.func_77973_b();
            aEvent.entityPlayer.field_70170_p.func_72956_a((Entity)aEvent.entityPlayer, "random.bow", 1.0f, 1.0f / (CS.RANDOM.nextFloat() * 0.4f + 1.2f) + tSpeed * 0.5f);
            tArrowEntity.field_70251_a = 1;
            if (!UT.Entities.hasInfiniteItems(aEvent.entityPlayer)) {
                --aArrow.field_77994_a;
            }
            if (aArrow.field_77994_a == 0) {
                UT.Inventories.removeNullStacksFromInventory((IInventory)aEvent.entityPlayer.field_71071_by);
            }
            if (!aEvent.entityPlayer.field_70170_p.field_72995_K) {
                aEvent.entityPlayer.field_70170_p.func_72838_d((Entity)tArrowEntity);
            }
            aEvent.setCanceled(true);
        }
    }

    public int getBurnTime(ItemStack aFuel) {
        OreDictItemData tData;
        if (UT.Stacks.invalid(aFuel) || UT.Fluids.getFluidForFilledItem(aFuel, true) != null) {
            return 0;
        }
        long rFuelValue = 0L;
        if (aFuel.func_77973_b() instanceof MultiItemRandom) {
            Short tFuelValue = ((MultiItemRandom)aFuel.func_77973_b()).mBurnValues.get(UT.Stacks.meta(aFuel));
            if (tFuelValue != null) {
                rFuelValue = (short)Math.max(rFuelValue, (long)tFuelValue.shortValue());
            }
        } else if (OM.is_("logWood", aFuel)) {
            return CS.TICKS_PER_SMELT * 6;
        }
        NBTTagCompound tNBT = aFuel.func_77978_p();
        if (tNBT != null) {
            rFuelValue = Math.max(rFuelValue, (long)UT.Code.bind15(tNBT.func_74763_f("gt.fuelvalue")));
        }
        if ((tData = OM.anydata_(aFuel)) != null && (tData.mPrefix == null || tData.mPrefix.contains(TD.Prefix.BURNABLE))) {
            long tBurnTime = 0L;
            for (OreDictMaterialStack tMaterial : tData.getAllMaterialStacks()) {
                tBurnTime += UT.Code.units(tMaterial.mMaterial.mFurnaceBurnTime, 420076800L, tMaterial.mAmount, false);
            }
            rFuelValue = Math.max(rFuelValue, tBurnTime);
        }
        return UT.Code.bind15(rFuelValue);
    }
}

