/*
 * Decompiled with CFR 0.152.
 */
package com.temportalist.origin.screwdriver.api;

import com.temportalist.origin.screwdriver.api.Behavior;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;

public abstract class BehaviorSingleItem
extends Behavior {
    private ItemStack itemStack;
    private String itemStackName;

    private static ItemStack getItemStackFromName(String name) {
        if (!name.matches("(.*):(.*)")) {
            return null;
        }
        int endNameIndex = name.length();
        int metadata = Short.MAX_VALUE;
        if (name.matches("(.*):(.*):(.*)")) {
            endNameIndex = name.lastIndexOf(58);
            metadata = Integer.parseInt(name.substring(endNameIndex + 1, name.length()));
        }
        String modid = name.substring(0, name.indexOf(58));
        String itemName = name.substring(name.indexOf(58) + 1, endNameIndex);
        Block block = GameRegistry.findBlock((String)modid, (String)itemName);
        Item item = GameRegistry.findItem((String)modid, (String)itemName);
        return block != null && Item.func_150898_a((Block)block) != null ? new ItemStack(block, 1, metadata) : (item != null ? new ItemStack(item, 1, metadata) : null);
    }

    public BehaviorSingleItem(String name, ItemStack stack) {
        this(name, false, stack);
    }

    public BehaviorSingleItem(String name, String stackQualifier) {
        this(name, false, stackQualifier);
    }

    public BehaviorSingleItem(String name, boolean isDefaultBehavior, ItemStack stack) {
        super(name, isDefaultBehavior);
        this.itemStack = stack;
    }

    public BehaviorSingleItem(String name, boolean isDefaultBehavior, String stackQualifier) {
        super(name, isDefaultBehavior);
        this.itemStackName = stackQualifier;
    }

    @Override
    public void postInit() {
        super.postInit();
        if (this.itemStack == null) {
            this.itemStack = BehaviorSingleItem.getItemStackFromName(this.itemStackName);
        }
    }

    protected ItemStack getTemplateItemStack() {
        if (this.itemStack == null) {
            FMLLog.log((String)"Origin Screwdriver API", (Level)Level.ERROR, (String)("Error! Internal stack for behavior " + this.getName() + " is null! " + this.getClass().getCanonicalName()), (Object[])new Object[0]);
        }
        return this.itemStack;
    }

    @Override
    public boolean isValidStackForSimulation(ItemStack stack) {
        return this.itemStack != null && stack != null && this.itemStack.func_77973_b() == stack.func_77973_b() && (!this.shouldValidateMetadata() || this.itemStack.func_77960_j() == stack.func_77960_j()) && ItemStack.func_77970_a((ItemStack)this.itemStack, (ItemStack)stack);
    }

    public boolean shouldValidateMetadata() {
        return this.itemStack != null && this.itemStack.func_77960_j() != Short.MAX_VALUE;
    }

    @Override
    public boolean onItemUseFirst(ItemStack container, ItemStack source, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        return source != null && source.func_77973_b().onItemUseFirst(source, player, world, x, y, z, side, hitX, hitY, hitZ);
    }

    @Override
    public boolean itemInteractionForEntity(ItemStack container, ItemStack source, EntityPlayer player, EntityLivingBase entity) {
        return source != null && source.func_77973_b().func_111207_a(source, player, entity);
    }

    @Override
    public boolean onBlockStartBreak(ItemStack container, ItemStack source, int x, int y, int z, EntityPlayer player) {
        return source != null && source.func_77973_b().onBlockStartBreak(source, x, y, z, player);
    }
}

