/*
 * Decompiled with CFR 0.152.
 */
package com.temportalist.origin.internal.common.extended;

import com.temportalist.origin.api.common.utility.WorldHelper$;
import com.temportalist.origin.foundation.common.extended.ExtendedEntity;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.IExtendedEntityProperties;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import scala.Function1;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ExtendedEntityHandler$ {
    public static final ExtendedEntityHandler$ MODULE$;
    private final Map<Class<? extends ExtendedEntity>, Tuple2<String, Object>> extendedProperties;
    private final Map<String, Class<? extends ExtendedEntity>> extendedKeys;
    private final Map<UUID, Map<Class<? extends ExtendedEntity>, NBTTagCompound>> persistenceTags;

    static {
        new ExtendedEntityHandler$();
    }

    private Map<Class<? extends ExtendedEntity>, Tuple2<String, Object>> extendedProperties() {
        return this.extendedProperties;
    }

    private Map<String, Class<? extends ExtendedEntity>> extendedKeys() {
        return this.extendedKeys;
    }

    private Map<UUID, Map<Class<? extends ExtendedEntity>, NBTTagCompound>> persistenceTags() {
        return this.persistenceTags;
    }

    public String getClassKey(Class<? extends ExtendedEntity> extendedClass) {
        return (String)((Tuple2)this.extendedProperties().apply(extendedClass))._1();
    }

    public boolean shouldSaveOnDeath(Class<? extends ExtendedEntity> extendedClass) {
        return ((Tuple2)this.extendedProperties().apply(extendedClass))._2$mcZ$sp();
    }

    public void registerExtended(String classKey, Class<? extends ExtendedEntity> extendedClass, boolean persistPastDeath) {
        this.extendedProperties().update(extendedClass, (Object)new Tuple2((Object)classKey, (Object)BoxesRunTime.boxToBoolean((boolean)persistPastDeath)));
        this.extendedKeys().update((Object)classKey, extendedClass);
    }

    public final <T extends ExtendedEntity> T getExtended(EntityPlayer living, Class<T> extendedClass) {
        while (living != null && this.extendedProperties().contains(extendedClass)) {
            IExtendedEntityProperties iExtendedEntityProperties = living.getExtendedProperties(this.getClassKey(extendedClass));
            if (iExtendedEntityProperties instanceof ExtendedEntity) {
                ExtendedEntity extendedEntity;
                ExtendedEntity extendedEntity2 = extendedEntity = (ExtendedEntity)iExtendedEntityProperties;
                return (T)extendedEntity2;
            }
            this.register(living, extendedClass);
        }
        return null;
    }

    public final ExtendedEntity getExtendedByKey(EntityPlayer living, String key) {
        return this.getExtended(living, (Class)this.extendedKeys().apply((Object)key));
    }

    public final void register(EntityPlayer entity, Class<? extends ExtendedEntity> extendedClass) {
        this.register(entity, this.getClassKey(extendedClass), extendedClass);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void register(EntityPlayer entity, String classKey, Class<? extends ExtendedEntity> extendedClass) {
        ExtendedEntity extendedEntity;
        if (entity.getExtendedProperties(classKey) != null) return;
        try {
            extendedEntity = extendedClass.getConstructor(EntityPlayer.class).newInstance(entity);
        }
        catch (Exception exception) {
            return;
        }
        ExtendedEntity ent = extendedEntity;
        if (ent == null) return;
        entity.registerExtendedProperties(classKey, ent);
    }

    public void updatePersistenceFor(UUID uuid) {
        if (!this.persistenceTags().contains((Object)uuid)) {
            this.persistenceTags().update((Object)uuid, (Object)Map$.MODULE$.apply((Seq)Nil$.MODULE$));
        }
    }

    public <T extends ExtendedEntity> void storeEntityData(Class<T> extendedClass, EntityPlayer player, NBTTagCompound data) {
        UUID uuid = player.func_146103_bH().getId();
        this.updatePersistenceFor(uuid);
        ((scala.collection.mutable.MapLike)this.persistenceTags().apply((Object)uuid)).update(extendedClass, (Object)data);
    }

    public <T extends ExtendedEntity> NBTTagCompound getDataAndRemove(Class<T> extendedClass, EntityPlayer player) {
        UUID uuid = player.func_146103_bH().getId();
        this.updatePersistenceFor(uuid);
        return ((MapLike)this.persistenceTags().apply((Object)uuid)).contains(extendedClass) ? (NBTTagCompound)((scala.collection.mutable.MapLike)this.persistenceTags().apply((Object)uuid)).remove(extendedClass).get() : null;
    }

    @SubscribeEvent
    public void onEntityConstructing(EntityEvent.EntityConstructing event) {
        Entity entity = event.entity;
        if (entity instanceof EntityPlayer) {
            EntityPlayer entityPlayer = (EntityPlayer)entity;
            this.extendedProperties().foreach((Function1)new Serializable(entityPlayer){
                private final EntityPlayer x2$1;

                public final void apply(Tuple2<Class<? extends ExtendedEntity>, Tuple2<String, Object>> seq) {
                    ExtendedEntityHandler$.MODULE$.register(this.x2$1, (String)((Tuple2)seq._2())._1(), (Class)seq._1());
                }
                {
                    this.x2$1 = x2$1;
                }
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        EntityLivingBase entityLivingBase = event.entityLiving;
        if (entityLivingBase instanceof EntityPlayer) {
            BoxedUnit boxedUnit;
            EntityPlayer entityPlayer = (EntityPlayer)entityLivingBase;
            if (WorldHelper$.MODULE$.isServer()) {
                this.extendedProperties().foreach((Function1)new Serializable(entityPlayer){
                    private final EntityPlayer x2$2;

                    public final void apply(Tuple2<Class<? extends ExtendedEntity>, Tuple2<String, Object>> seq) {
                        if (((Tuple2)seq._2())._2$mcZ$sp()) {
                            NBTTagCompound data = new NBTTagCompound();
                            ((ExtendedEntity)ExtendedEntityHandler$.MODULE$.getExtended(this.x2$2, (Class)seq._1())).saveNBTData(data);
                            ExtendedEntityHandler$.MODULE$.storeEntityData((Class)seq._1(), this.x2$2, data);
                        }
                    }
                    {
                        this.x2$2 = x2$2;
                    }
                });
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        Entity entity = event.entity;
        if (entity instanceof EntityPlayer) {
            BoxedUnit boxedUnit;
            EntityPlayer entityPlayer = (EntityPlayer)entity;
            if (WorldHelper$.MODULE$.isServer()) {
                this.extendedProperties().foreach((Function1)new Serializable(entityPlayer){
                    private final EntityPlayer x2$3;

                    public final void apply(Tuple2<Class<? extends ExtendedEntity>, Tuple2<String, Object>> seq) {
                        if (((Tuple2)seq._2())._2$mcZ$sp()) {
                            T t = ExtendedEntityHandler$.MODULE$.getExtended(this.x2$3, (Class)seq._1());
                            if (t != null) {
                                T t2 = t;
                                NBTTagCompound data = ExtendedEntityHandler$.MODULE$.getDataAndRemove((Class)seq._1(), this.x2$3);
                                if (data != null) {
                                    ((ExtendedEntity)t2).loadNBTData(data);
                                }
                                ((ExtendedEntity)t2).syncEntityFull();
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            } else {
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            }
                        }
                    }
                    {
                        this.x2$3 = x2$3;
                    }
                });
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private ExtendedEntityHandler$() {
        MODULE$ = this;
        this.extendedProperties = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.extendedKeys = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.persistenceTags = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

