/*
 * Decompiled with CFR 0.152.
 */
package com.thecodewarrior.codechicken.lib.tool.module;

import com.thecodewarrior.codechicken.lib.render.QBImporter;
import com.thecodewarrior.codechicken.lib.tool.module.JOptModule;
import java.io.File;
import java.util.Arrays;
import joptsimple.OptionParser;
import joptsimple.OptionSet;

public class ModuleQBConverter
extends JOptModule {
    public ModuleQBConverter() {
        this.parser.acceptsAll(Arrays.asList("?", "h", "help"), "Show the help");
        this.parser.acceptsAll(Arrays.asList("i", "input"), "comma separated list of paths to models (.qb or directories)").withRequiredArg().ofType(File.class).withValuesSeparatedBy(',').required();
        this.parser.acceptsAll(Arrays.asList("o", "out"), "Output Directory").withRequiredArg().ofType(File.class);
        this.parser.acceptsAll(Arrays.asList("o2", "textureplanes"), "2nd level optimisation. Merges coplanar polygons. Increases texture size");
        this.parser.acceptsAll(Arrays.asList("s", "squaretextures"), "Produce square textures");
        this.parser.acceptsAll(Arrays.asList("t", "mergetextures"), "Use the same texture for all models");
        this.parser.acceptsAll(Arrays.asList("r", "scalemc"), "Resize model to mc standard (shrink by factor of 16)");
    }

    @Override
    protected void main(OptionParser parser, OptionSet options) {
        int flags = 0;
        if (options.has("o2")) {
            flags |= 1;
        }
        if (options.has("s")) {
            flags |= 2;
        }
        if (options.has("t")) {
            flags |= 4;
        }
        if (options.has("r")) {
            flags |= 8;
        }
        File[] input = options.valuesOf("input").toArray(new File[0]);
        File[] outDir = new File[input.length];
        if (options.has("out")) {
            File output = (File)options.valueOf("out");
            if (output.isFile()) {
                throw new RuntimeException("Output Path is not a directory");
            }
            if (!output.exists()) {
                output.mkdirs();
            }
            for (int i = 0; i < input.length; ++i) {
                outDir[i] = output;
            }
        } else {
            for (int i = 0; i < input.length; ++i) {
                outDir[i] = input[i].isDirectory() ? input[i] : input[i].getParentFile();
            }
        }
        for (int i = 0; i < input.length; ++i) {
            File file = input[i];
            if (file.isDirectory()) {
                for (File file2 : file.listFiles()) {
                    if (!file2.getName().endsWith(".qb")) continue;
                    this.convert(file2, outDir[i], flags);
                }
                continue;
            }
            this.convert(file, outDir[i], flags);
        }
    }

    private void convert(File in, File outDir, int flags) {
        System.out.println("Converting: " + in.getName());
        QBImporter.RasterisedModel m = QBImporter.loadQB(in).toRasterisedModel(flags);
        m.export(new File(outDir, in.getName().replace(".qb", ".obj")), outDir);
    }

    @Override
    public String name() {
        return "QBConverter";
    }
}

