/*
 * Decompiled with CFR 0.152.
 */
package com.thecodewarrior.codechicken.lib.render;

import com.thecodewarrior.codechicken.lib.colour.Colour;
import com.thecodewarrior.codechicken.lib.colour.ColourARGB;
import com.thecodewarrior.codechicken.lib.render.PlaceholderTexture;
import com.thecodewarrior.codechicken.lib.render.TextureDataHolder;
import com.thecodewarrior.codechicken.lib.render.TextureSpecial;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import org.lwjgl.opengl.GL11;

public class TextureUtils {
    private static ArrayList<IIconSelfRegister> iconRegistrars;

    public static void addIconRegistrar(IIconSelfRegister registrar) {
        iconRegistrars.add(registrar);
    }

    @SubscribeEvent
    public void textureLoad(TextureStitchEvent.Pre event) {
        for (IIconSelfRegister reg : iconRegistrars) {
            if (reg.atlasIndex() != event.map.func_130086_a()) continue;
            reg.registerIcons((IIconRegister)event.map);
        }
    }

    public static int[] loadTextureData(ResourceLocation resource) {
        return TextureUtils.loadTexture((ResourceLocation)resource).data;
    }

    public static Colour[] loadTextureColours(ResourceLocation resource) {
        int[] idata = TextureUtils.loadTextureData(resource);
        Colour[] data = new Colour[idata.length];
        for (int i = 0; i < data.length; ++i) {
            data[i] = new ColourARGB(idata[i]);
        }
        return data;
    }

    public static InputStream getTextureResource(ResourceLocation textureFile) throws IOException {
        return Minecraft.func_71410_x().func_110442_L().func_110536_a(textureFile).func_110527_b();
    }

    public static BufferedImage loadBufferedImage(ResourceLocation textureFile) {
        try {
            return TextureUtils.loadBufferedImage(TextureUtils.getTextureResource(textureFile));
        }
        catch (Exception e) {
            System.err.println("Failed to load texture file: " + textureFile);
            e.printStackTrace();
            return null;
        }
    }

    public static BufferedImage loadBufferedImage(InputStream in) throws IOException {
        BufferedImage img = ImageIO.read(in);
        in.close();
        return img;
    }

    public static TextureManager engine() {
        return Minecraft.func_71410_x().field_71446_o;
    }

    public static void copySubImg(int[] fromTex, int fromWidth, int fromX, int fromY, int width, int height, int[] toTex, int toWidth, int toX, int toY) {
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int fp = (y + fromY) * fromWidth + x + fromX;
                int tp = (y + toX) * toWidth + x + toX;
                toTex[tp] = fromTex[fp];
            }
        }
    }

    public static void bindAtlas(int atlasIndex) {
        TextureUtils.engine().func_110577_a(atlasIndex == 0 ? TextureMap.field_110575_b : TextureMap.field_110576_c);
    }

    public static IIcon getBlankIcon(int size, IIconRegister iconRegister) {
        TextureMap textureMap = (TextureMap)iconRegister;
        String s = "blank_" + size;
        if (textureMap.getTextureExtry(s) == null) {
            TextureSpecial icon = new TextureSpecial(s).blank(size);
            textureMap.setTextureEntry(s, (TextureAtlasSprite)icon);
        }
        return iconRegister.func_94245_a(s);
    }

    public static TextureSpecial getTextureSpecial(IIconRegister iconRegister, String name) {
        TextureMap textureMap = (TextureMap)iconRegister;
        TextureAtlasSprite entry = textureMap.getTextureExtry(name);
        if (entry != null) {
            throw new IllegalStateException("Texture: " + name + " is already registered");
        }
        TextureSpecial icon = new TextureSpecial(name);
        textureMap.setTextureEntry(name, (TextureAtlasSprite)icon);
        return icon;
    }

    public static void prepareTexture(int target, int texture, int min_mag_filter, int wrap) {
        GL11.glBindTexture((int)target, (int)texture);
        GL11.glTexParameteri((int)target, (int)10241, (int)min_mag_filter);
        GL11.glTexParameteri((int)target, (int)10240, (int)min_mag_filter);
        switch (target) {
            case 32879: {
                GL11.glTexParameteri((int)target, (int)32882, (int)wrap);
            }
            case 3553: {
                GL11.glTexParameteri((int)target, (int)10243, (int)wrap);
            }
            case 3552: {
                GL11.glTexParameteri((int)target, (int)10242, (int)wrap);
            }
        }
    }

    public static TextureDataHolder loadTexture(ResourceLocation resource) {
        BufferedImage img = TextureUtils.loadBufferedImage(resource);
        if (img == null) {
            throw new RuntimeException("Texture not found: " + resource);
        }
        return new TextureDataHolder(img);
    }

    public static boolean refreshTexture(TextureMap map, String name) {
        if (map.getTextureExtry(name) == null) {
            map.setTextureEntry(name, (TextureAtlasSprite)new PlaceholderTexture(name));
            return true;
        }
        return false;
    }

    public static IIcon safeIcon(IIcon icon) {
        if (icon == null) {
            icon = ((TextureMap)TextureUtils.engine().func_110581_b(TextureMap.field_110575_b)).func_110572_b("missingno");
        }
        return icon;
    }

    public static boolean isMissing(IIcon icon, ResourceLocation atlas) {
        if (icon == null) {
            return true;
        }
        TextureAtlasSprite missing = ((TextureMap)TextureUtils.engine().func_110581_b(atlas)).func_110572_b("missingno");
        return icon.func_94209_e() == missing.func_94209_e() && icon.func_94206_g() == missing.func_94206_g();
    }

    static {
        MinecraftForge.EVENT_BUS.register((Object)new TextureUtils());
        iconRegistrars = new ArrayList();
    }

    public static interface IIconSelfRegister {
        public void registerIcons(IIconRegister var1);

        public int atlasIndex();
    }
}

