/*
 * Decompiled with CFR 0.152.
 */
package com.thecodewarrior.codechicken.lib.config;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;

public class SimpleProperties {
    public HashMap<String, String> propertyMap = new HashMap();
    public File propertyFile;
    public boolean saveOnChange = false;
    public String encoding;
    private boolean loading = false;

    public SimpleProperties(File file, boolean saveOnChange, String encoding) {
        this.propertyFile = file;
        this.saveOnChange = saveOnChange;
        this.encoding = encoding;
    }

    public SimpleProperties(File file, boolean saveOnChange) {
        this(file, saveOnChange, Charset.defaultCharset().name());
    }

    public SimpleProperties(File file) {
        this(file, true);
    }

    public void load() {
        this.clear();
        this.loading = true;
        try {
            String read;
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.propertyFile), this.encoding));
            while ((read = reader.readLine()) != null) {
                int equalIndex = read.indexOf(61);
                if (equalIndex == -1) continue;
                this.setProperty(read.substring(0, equalIndex), read.substring(equalIndex + 1));
            }
            reader.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.loading = false;
    }

    public void save() {
        try {
            PrintStream writer = new PrintStream(this.propertyFile);
            for (Map.Entry<String, String> entry : this.propertyMap.entrySet()) {
                writer.println(entry.getKey() + "=" + entry.getValue());
            }
            writer.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void clear() {
        this.propertyMap.clear();
    }

    public boolean hasProperty(String key) {
        return this.propertyMap.containsKey(key);
    }

    public void removeProperty(String key) {
        if (this.propertyMap.remove(key) != null && this.saveOnChange && !this.loading) {
            this.save();
        }
    }

    public void setProperty(String key, int value) {
        this.setProperty(key, Integer.toString(value));
    }

    public void setProperty(String key, boolean value) {
        this.setProperty(key, Boolean.toString(value));
    }

    public void setProperty(String key, String value) {
        this.propertyMap.put(key, value);
        if (this.saveOnChange && !this.loading) {
            this.save();
        }
    }

    public int getProperty(String property, int defaultvalue) {
        try {
            return Integer.parseInt(this.getProperty(property, Integer.toString(defaultvalue)));
        }
        catch (NumberFormatException nfe) {
            return defaultvalue;
        }
    }

    public boolean getProperty(String property, boolean defaultvalue) {
        try {
            return Boolean.parseBoolean(this.getProperty(property, Boolean.toString(defaultvalue)));
        }
        catch (NumberFormatException nfe) {
            return defaultvalue;
        }
    }

    public String getProperty(String property, String defaultvalue) {
        String value = this.propertyMap.get(property);
        if (value == null) {
            this.setProperty(property, defaultvalue);
            return defaultvalue;
        }
        return value;
    }

    public String getProperty(String property) {
        return this.propertyMap.get(property);
    }
}

