/*
 * Decompiled with CFR 0.152.
 */
package com.thecodewarrior.catwalks.render;

import com.thecodewarrior.catwalks.block.BlockSupportColumn;
import com.thecodewarrior.catwalks.render.TransformingTessellator;
import com.thecodewarrior.codechicken.lib.vec.Vector3;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class SupportRenderer
implements ISimpleBlockRenderingHandler {
    int typeID;
    public static int[] sideMap = new int[]{0, 0, 1, 1, 2, 2};

    public SupportRenderer(int id) {
        this.typeID = id;
    }

    public void renderInventoryBlock(Block block, int meta, int modelId, RenderBlocks renderer) {
        double blockWidth = ((BlockSupportColumn)block).getWidth();
        double d = (1.0 - blockWidth) / 2.0;
        double D = 1.0 - d;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        renderer.func_147770_b(d, 0.0, d, D, 1.0, D);
        tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
        renderer.func_147768_a(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 100, meta));
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        renderer.func_147806_b(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 101, meta));
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        renderer.func_147761_c(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 102, meta));
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        renderer.func_147734_d(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 103, meta));
        tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
        renderer.func_147798_e(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 104, meta));
        tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
        renderer.func_147764_f(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 105, meta));
        renderer.func_147762_c();
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        tessellator.func_78381_a();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        int meta = world.func_72805_g(x, y, z);
        Tessellator.field_78398_a.func_78372_c((float)x, (float)y, (float)z);
        Tessellator.field_78398_a.func_78380_c(block.func_149677_c(world, x, y, z));
        Tessellator.field_78398_a.func_78386_a(0.5f, 0.5f, 0.5f);
        for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
            this.renderExtension(block, world, x, y, z, d);
        }
        Tessellator.field_78398_a.func_78372_c((float)(-x), (float)(-y), (float)(-z));
        return true;
    }

    public void renderFace(double x1, double y1, double z1, double x2, double y2, double z2, double x3, double y3, double z3, double x4, double y4, double z4, float nX, float nY, float nZ, IIcon icon, int[][] corners, boolean back) {
        TransformingTessellator t = TransformingTessellator.instance;
        Vector3 normal = new Vector3(nX, nY, nZ);
        t.applyN(normal);
        nX = (float)normal.x;
        nY = (float)normal.y;
        nZ = (float)normal.z;
        float f3 = 0.5f;
        float f4 = 1.0f;
        float f5 = 0.8f;
        float f6 = 0.6f;
        float f7 = f4;
        float f8 = f4;
        float f9 = f4;
        float f10 = f3;
        float f11 = f5;
        float f12 = f6;
        float f13 = f3;
        float f14 = f5;
        float f15 = f6;
        float f16 = f3;
        float f17 = f5;
        float f18 = f6;
        if (nX == 1.0f) {
            t.func_78386_a(f12, f15, f18);
        } else if (nX == -1.0f) {
            t.func_78386_a(f12, f15, f18);
        } else if (nY == 1.0f) {
            t.func_78386_a(f7, f8, f9);
        } else if (nY == -1.0f) {
            t.func_78386_a(f10, f13, f16);
        } else if (nZ == 1.0f) {
            t.func_78386_a(f11, f14, f17);
        } else if (nZ == -1.0f) {
            t.func_78386_a(f11, f14, f17);
        }
        t.func_78375_b(nX, nY, nZ);
        t.func_78374_a(x1, y1, z1, icon.func_94214_a((double)((float)corners[3][0] / 2.0f)), icon.func_94207_b((double)((float)corners[3][1] / 2.0f)));
        t.func_78374_a(x2, y2, z2, icon.func_94214_a((double)((float)corners[2][0] / 2.0f)), icon.func_94207_b((double)((float)corners[2][1] / 2.0f)));
        t.func_78374_a(x3, y3, z3, icon.func_94214_a((double)((float)corners[1][0] / 2.0f)), icon.func_94207_b((double)((float)corners[1][1] / 2.0f)));
        t.func_78374_a(x4, y4, z4, icon.func_94214_a((double)((float)corners[0][0] / 2.0f)), icon.func_94207_b((double)((float)corners[0][1] / 2.0f)));
        if (!back) {
            return;
        }
        t.func_78375_b(-nX, -nY, -nZ);
        t.func_78374_a(x4, y4, z4, icon.func_94214_a((double)((float)corners[0][0] / 2.0f)), icon.func_94207_b((double)((float)corners[0][1] / 2.0f)));
        t.func_78374_a(x3, y3, z3, icon.func_94214_a((double)((float)corners[1][0] / 2.0f)), icon.func_94207_b((double)((float)corners[1][1] / 2.0f)));
        t.func_78374_a(x2, y2, z2, icon.func_94214_a((double)((float)corners[2][0] / 2.0f)), icon.func_94207_b((double)((float)corners[2][1] / 2.0f)));
        t.func_78374_a(x1, y1, z1, icon.func_94214_a((double)((float)corners[3][0] / 2.0f)), icon.func_94207_b((double)((float)corners[3][1] / 2.0f)));
    }

    public void renderExtension(Block block, IBlockAccess world, int x, int y, int z, ForgeDirection dir) {
        int meta = world.func_72805_g(x, y, z);
        int ax = x + dir.offsetX;
        int ay = y + dir.offsetY;
        int az = z + dir.offsetZ;
        Block adjacentBlock = world.func_147439_a(ax, ay, az);
        boolean shouldExtend = false;
        boolean isAdjacentSupport = false;
        boolean solid = false;
        if (meta == sideMap[dir.ordinal()]) {
            shouldExtend = true;
        }
        if (adjacentBlock instanceof BlockSupportColumn) {
            shouldExtend = true;
            isAdjacentSupport = true;
        } else if (shouldExtend && world.isSideSolid(ax, ay, az, dir.getOpposite(), false)) {
            solid = true;
        }
        TransformingTessellator t = TransformingTessellator.instance;
        t.pushMatrix();
        t.translate(0.5, 0.5, 0.5);
        switch (dir) {
            case UP: {
                break;
            }
            case DOWN: {
                t.rotate(180.0, 1.0, 0.0, 0.0);
                break;
            }
            case NORTH: {
                t.rotate(-90.0, 1.0, 0.0, 0.0);
                t.rotate(-180.0, 0.0, 1.0, 0.0);
                break;
            }
            case SOUTH: {
                t.rotate(90.0, 1.0, 0.0, 0.0);
                break;
            }
            case WEST: {
                t.rotate(90.0, 0.0, 0.0, 1.0);
                t.rotate(-90.0, 0.0, 1.0, 0.0);
                break;
            }
            case EAST: {
                t.rotate(-90.0, 0.0, 0.0, 1.0);
                t.rotate(90.0, 0.0, 1.0, 0.0);
                break;
            }
        }
        t.translate(-0.5, -0.5, -0.5);
        IIcon icon = ((BlockSupportColumn)block).support;
        double blockWidth = ((BlockSupportColumn)block).getWidth();
        double d = (1.0 - blockWidth) / 2.0;
        double D = 1.0 - d;
        double smidge = 9.765625E-4;
        double m = 0.0;
        double M = 1.0;
        double o = D;
        boolean back = false;
        int _m = 0;
        int _M = 32;
        int _d = 7;
        int _D = _M - _d;
        int[][][] sides = new int[][][]{new int[][]{{_d, _m}, {_D, _m}, {_D, _d}, {_d, _d}}, new int[][]{{_M, _d}, {_M, _D}, {_D, _D}, {_D, _d}}, new int[][]{{_d, _M}, {_D, _M}, {_D, _D}, {_d, _D}}, new int[][]{{_m, _D}, {_m, _d}, {_d, _d}, {_d, _D}}, new int[][]{{_d, _d}, {_D, _d}, {_D, _D}, {_d, _D}}};
        if (solid) {
            m = smidge;
            M = 1.0 - smidge;
        } else {
            m = 0.0;
            M = 1.0;
        }
        o = D;
        int side = 0;
        if (shouldExtend) {
            o = M;
            switch (dir) {
                case NORTH: {
                    side = 0;
                    break;
                }
                case SOUTH: {
                    side = 2;
                    break;
                }
                case EAST: {
                    side = 1;
                    break;
                }
                case WEST: {
                    side = 3;
                    break;
                }
                case UP: {
                    side = 0;
                    break;
                }
                case DOWN: {
                    side = 2;
                }
            }
            this.renderFace(D, D, d, d, D, d, d, M, d, D, M, d, 0.0f, 0.0f, -1.0f, icon, sides[side], back);
            switch (dir) {
                case NORTH: {
                    side = 2;
                    break;
                }
                case SOUTH: {
                    side = 0;
                    break;
                }
                case EAST: {
                    side = 1;
                    break;
                }
                case WEST: {
                    side = 3;
                    break;
                }
                case UP: {
                    side = 0;
                    break;
                }
                case DOWN: {
                    side = 2;
                }
            }
            this.renderFace(d, D, D, D, D, D, D, 1.0, D, d, 1.0, D, 0.0f, 0.0f, 1.0f, icon, sides[side], back);
            if (dir.offsetY == 0) {
                side = 3;
            }
            this.renderFace(D, D, D, D, D, d, D, M, d, D, M, D, 1.0f, 0.0f, 0.0f, icon, sides[side], back);
            if (dir.offsetY == 0) {
                side = 1;
            }
            this.renderFace(d, D, d, d, D, D, d, M, D, d, M, d, -1.0f, 0.0f, 0.0f, icon, sides[side], back);
        }
        side = 4;
        if (!isAdjacentSupport) {
            this.renderFace(d, o, D, D, o, D, D, o, d, d, o, d, 0.0f, 1.0f, 0.0f, icon, sides[side], back);
        }
        t.popMatrix();
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return this.typeID;
    }
}

