/*
 * Decompiled with CFR 0.152.
 */
package com.thecodewarrior.catwalks.render;

import com.thecodewarrior.catwalks.CatwalkMod;
import com.thecodewarrior.catwalks.ICagedLadderConnectable;
import com.thecodewarrior.catwalks.block.BlockCagedLadder;
import com.thecodewarrior.catwalks.render.TransformingTessellator;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class LadderRenderer
implements ISimpleBlockRenderingHandler {
    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
        int meta = 0;
        double px = 0.0625;
        renderer.func_147770_b(px, 0.0, px, 1.0 - px, 1.0, 1.0 - px);
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        tessellator.func_78382_b();
        renderer.field_147842_e = true;
        renderer.field_147838_g = true;
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        renderer.func_147768_a(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 100, meta));
        tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
        renderer.func_147806_b(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 101, meta));
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        renderer.func_147761_c(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 102, meta));
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        renderer.func_147734_d(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 103, meta));
        tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
        renderer.func_147798_e(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 104, meta));
        tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
        renderer.func_147764_f(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 105, meta));
        renderer.field_147842_e = false;
        renderer.field_147838_g = false;
        tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
        renderer.func_147768_a(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 100, meta));
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        renderer.func_147806_b(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 101, meta));
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        renderer.func_147761_c(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 102, meta));
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        renderer.func_147734_d(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 103, meta));
        tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
        renderer.func_147798_e(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 104, meta));
        tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
        renderer.func_147764_f(block, 0.0, 0.0, 0.0, renderer.func_147787_a(block, 105, meta));
        boolean a = GL11.glGetBoolean((int)2884);
        GL11.glEnable((int)2884);
        tessellator.func_78381_a();
        if (!a) {
            GL11.glDisable((int)2884);
        }
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        renderer.func_147762_c();
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block _block, int modelId, RenderBlocks renderer) {
        BlockCagedLadder block = (BlockCagedLadder)_block;
        boolean lights = block.lights;
        if (block.direction == ForgeDirection.EAST || block.direction == ForgeDirection.WEST) {
            renderer.field_147865_v = 1;
        }
        double px = 0.0625;
        renderer.func_147770_b(px, 0.0, px, 1.0 - px, 1.0, 1.0 - px);
        renderer.field_147842_e = true;
        renderer.field_147838_g = true;
        renderer.func_147784_q(_block, x, y, z);
        renderer.field_147842_e = false;
        renderer.field_147838_g = false;
        renderer.func_147784_q(_block, x, y, z);
        boolean force = false;
        int meta = world.func_72805_g(x, y, z);
        if (lights) {
            boolean oldAO = renderer.field_147863_w;
            renderer.field_147863_w = false;
            Tessellator.field_78398_a.func_78380_c(0xF000F0);
            renderer.field_147842_e = true;
            renderer.field_147838_g = true;
            if (block.func_149646_a(world, x, y - 1, z, 0) || force) {
                renderer.func_147768_a((Block)block, (double)x, (double)y, (double)z, block.getLightIcon(0, meta));
            }
            if (block.func_149646_a(world, x, y, z - 1, 2) || force) {
                renderer.func_147761_c((Block)block, (double)x, (double)y, (double)z, block.getLightIcon(2, meta));
            }
            if (block.func_149646_a(world, x, y, z + 1, 3) || force) {
                renderer.func_147734_d((Block)block, (double)x, (double)y, (double)z, block.getLightIcon(3, meta));
            }
            if (block.func_149646_a(world, x - 1, y, z, 4) || force) {
                renderer.func_147798_e((Block)block, (double)x, (double)y, (double)z, block.getLightIcon(4, meta));
            }
            if (block.func_149646_a(world, x + 1, y, z, 5) || force) {
                renderer.func_147764_f((Block)block, (double)x, (double)y, (double)z, block.getLightIcon(5, meta));
            }
            renderer.field_147842_e = false;
            renderer.field_147838_g = false;
            if (block.func_149646_a(world, x, y - 1, z, 0) || force) {
                renderer.func_147768_a((Block)block, (double)x, (double)y, (double)z, block.getLightIcon(0, meta));
            }
            if (block.func_149646_a(world, x, y, z - 1, 2) || force) {
                renderer.func_147761_c((Block)block, (double)x, (double)y, (double)z, block.getLightIcon(2, meta));
            }
            if (block.func_149646_a(world, x, y, z + 1, 3) || force) {
                renderer.func_147734_d((Block)block, (double)x, (double)y, (double)z, block.getLightIcon(3, meta));
            }
            if (block.func_149646_a(world, x - 1, y, z, 4) || force) {
                renderer.func_147798_e((Block)block, (double)x, (double)y, (double)z, block.getLightIcon(4, meta));
            }
            if (block.func_149646_a(world, x + 1, y, z, 5) || force) {
                renderer.func_147764_f((Block)block, (double)x, (double)y, (double)z, block.getLightIcon(5, meta));
            }
            renderer.field_147863_w = oldAO;
        }
        renderer.field_147865_v = 0;
        renderer.func_147762_c();
        Tessellator.field_78398_a.func_78380_c(block.func_149677_c(world, x, y - 1, z));
        Tessellator.field_78398_a.func_78386_a(0.5f, 0.5f, 0.5f);
        ForgeDirection[] cardinal = new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.EAST, ForgeDirection.WEST};
        for (int i = 0; i < cardinal.length; ++i) {
            ForgeDirection side = cardinal[i];
            BlockCagedLadder.RelativeSide relSide = BlockCagedLadder.RelativeSide.FDtoRS(side, block.direction);
            if (!block.isOpen(relSide, meta)) continue;
            this.drawWideLanding(block, world, x, y, z, side);
        }
        return true;
    }

    public void drawWideLanding(BlockCagedLadder block, IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        double rot;
        ForgeDirection diagDir1;
        TransformingTessellator tess = TransformingTessellator.instance;
        int meta = world.func_72805_g(x, y, z);
        int adjX = x + side.offsetX;
        int adjY = y + side.offsetY;
        int adjZ = z + side.offsetZ;
        switch (side) {
            case NORTH: {
                diagDir1 = ForgeDirection.WEST;
                break;
            }
            case SOUTH: {
                diagDir1 = ForgeDirection.EAST;
                break;
            }
            case EAST: {
                diagDir1 = ForgeDirection.NORTH;
                break;
            }
            case WEST: {
                diagDir1 = ForgeDirection.SOUTH;
                break;
            }
            default: {
                diagDir1 = ForgeDirection.NORTH;
            }
        }
        ForgeDirection diagDir2 = diagDir1.getOpposite();
        Block adjacentBlock = world.func_147439_a(adjX, adjY, adjZ);
        Block diagBlock1 = world.func_147439_a(adjX + diagDir1.offsetX, adjY + diagDir1.offsetY, adjZ + diagDir1.offsetZ);
        Block diagBlock2 = world.func_147439_a(adjX + diagDir2.offsetX, adjY + diagDir2.offsetY, adjZ + diagDir2.offsetZ);
        boolean isThin = false;
        boolean bottom = false;
        if (adjacentBlock instanceof ICagedLadderConnectable) {
            ICagedLadderConnectable iclc = (ICagedLadderConnectable)adjacentBlock;
            if (!iclc.shouldConnectToSide(world, adjX, adjY, adjZ, side.getOpposite())) {
                return;
            }
            isThin = iclc.isThin(world, adjX, adjY, adjZ, side.getOpposite());
            bottom = iclc.shouldHaveBottom(world, adjX, adjY, adjZ, side.getOpposite());
        } else if (!world.isSideSolid(adjX, adjY, adjZ, side.getOpposite(), false) && world.isSideSolid(adjX, adjY - 1, adjZ, ForgeDirection.UP, false)) {
            bottom = true;
        }
        if (world.isSideSolid(x, y - 1, z, ForgeDirection.UP, true)) {
            bottom = false;
        }
        if (!block.shouldHaveBottom(world, x, y, z, side)) {
            bottom = false;
        }
        double p = 0.0625;
        double P = 1.0 - p;
        IIcon c = block.tape ? BlockCagedLadder.landing_tape : BlockCagedLadder.landing;
        float u = c.func_94209_e();
        float v = c.func_94206_g();
        float U = c.func_94212_f();
        float V = c.func_94210_h();
        float u1 = c.func_94214_a(1.0);
        float u2 = c.func_94214_a(2.0);
        float v1 = c.func_94207_b(1.0);
        double g = isThin && side.offsetZ != 0 ? p : 0.0;
        double h = isThin && side.offsetX != 0 ? p : 0.0;
        double G = 1.0 - g;
        double H = 1.0 - h;
        switch (side) {
            case NORTH: {
                rot = 0.0;
                break;
            }
            case SOUTH: {
                rot = 180.0;
                break;
            }
            case EAST: {
                rot = -90.0;
                break;
            }
            case WEST: {
                rot = 90.0;
                break;
            }
            default: {
                rot = 0.0;
            }
        }
        tess.func_78372_c(x, y, z);
        tess.pushMatrix();
        tess.translate(0.5, 0.0, 0.5);
        tess.rotate(rot, 0.0, 1.0, 0.0);
        tess.translate(-0.5, 0.0, -0.5);
        if (this.shouldCornerShow(world, x, y, z, block, meta, side, diagDir1)) {
            this.drawBothSides(tess, g, 0.0, h, u, V, g, 1.0, h, u, v, p, 1.0, p, u1, v, p, 0.0, p, u1, V);
        }
        if (this.shouldCornerShow(world, x, y, z, block, meta, side, diagDir2)) {
            this.drawBothSides(tess, G, 0.0, h, u, V, G, 1.0, h, u, v, P, 1.0, p, u1, v, P, 0.0, p, u1, V);
        }
        if (bottom) {
            this.drawBothSides(tess, p, 0.0, 0.0, u2, v, P, 0.0, 0.0, U, v, P, 0.0, p, U, v1, p, 0.0, p, u2, v1);
            if (!isThin) {
                this.drawBothSides(tess, 0.0, 0.0, 0.0, u1, v, p, 0.0, 0.0, u2, v, p, 0.0, p, u2, v1, 0.0, 0.0, 0.0, u1, v);
                this.drawBothSides(tess, 1.0, 0.0, 0.0, u1, v, P, 0.0, 0.0, u2, v, P, 0.0, p, u2, v1, 1.0, 0.0, 0.0, u1, v);
            }
        }
        tess.popMatrix();
        tess.func_78372_c(-x, -y, -z);
    }

    public boolean shouldCornerShow(IBlockAccess w, int x, int y, int z, BlockCagedLadder block, int meta, ForgeDirection a, ForgeDirection b) {
        if (block.isOpen(b, meta)) {
            return false;
        }
        Block tmp = w.func_147439_a(x + a.offsetX, y + a.offsetY, z + a.offsetZ);
        boolean hasWallToConnect = false;
        if (tmp instanceof ICagedLadderConnectable) {
            hasWallToConnect = ((ICagedLadderConnectable)tmp).doesSideHaveWall(w, x + a.offsetX, y + a.offsetY, z + a.offsetZ, b);
        }
        if ((tmp = w.func_147439_a(x + b.offsetX, y + b.offsetY, z + b.offsetZ)) instanceof ICagedLadderConnectable) {
            ICagedLadderConnectable iclc = (ICagedLadderConnectable)tmp;
            boolean bl = hasWallToConnect = hasWallToConnect || !iclc.doesSideHaveWall(w, x + b.offsetX, y + b.offsetY, z + b.offsetZ, a) && iclc.doesSideHaveWall(w, x + b.offsetX, y + b.offsetY, z + b.offsetZ, b.getOpposite());
        }
        if (!hasWallToConnect && (tmp = w.func_147439_a(x + a.offsetX + b.offsetX, y + a.offsetY + b.offsetY, z + a.offsetZ + b.offsetZ)) instanceof ICagedLadderConnectable) {
            boolean bl = hasWallToConnect = ((ICagedLadderConnectable)tmp).doesSideHaveWall(w, x + a.offsetX + b.offsetX, y + a.offsetY + b.offsetY, z + a.offsetZ + b.offsetZ, a.getOpposite()) && !((ICagedLadderConnectable)tmp).doesSideHaveWall(w, x + a.offsetX + b.offsetX, y + a.offsetY + b.offsetY, z + a.offsetZ + b.offsetZ, b.getOpposite());
        }
        return hasWallToConnect;
    }

    public void drawBothSides(Tessellator tess, double x1, double y1, double z1, double u1, double v1, double x2, double y2, double z2, double u2, double v2, double x3, double y3, double z3, double u3, double v3, double x4, double y4, double z4, double u4, double v4) {
        tess.func_78374_a(x1, y1, z1, u1, v1);
        tess.func_78374_a(x2, y2, z2, u2, v2);
        tess.func_78374_a(x3, y3, z3, u3, v3);
        tess.func_78374_a(x4, y4, z4, u4, v4);
        tess.func_78374_a(x4, y4, z4, u4, v4);
        tess.func_78374_a(x3, y3, z3, u3, v3);
        tess.func_78374_a(x2, y2, z2, u2, v2);
        tess.func_78374_a(x1, y1, z1, u1, v1);
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return CatwalkMod.ladderRenderType;
    }
}

