/*
 * Decompiled with CFR 0.152.
 */
package com.thecodewarrior.catwalks.legacy;

import com.thecodewarrior.catwalks.CatwalkMod;
import com.thecodewarrior.catwalks.legacy.BlockLegacyCagedLadder;
import com.thecodewarrior.catwalks.legacy.BlockLegacyCatwalk;
import com.thecodewarrior.catwalks.legacy.ItemBlockLegacy;
import com.thecodewarrior.catwalks.legacy.ItemLegacy;
import com.thecodewarrior.catwalks.legacy.TileEntityCagedLadder;
import com.thecodewarrior.catwalks.legacy.TileEntityCatwalk;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

@Mod(modid="catwalkmod", version="x.x.x", name="Legacy Catwalk Compat", dependencies="required-after:catwalks")
public class LegacyCatwalkMod {
    public static final String MODID = "catwalkmod";
    public static final String MODVER = "x.x.x";
    public static final String MODNAME = "Legacy Catwalk Compat";
    public static Block LEGACY_catwalk;
    public static Block LEGACY_ladder;
    public static Item lightRopeLegacy;
    public static Item blowtorchLegacy;
    public static Item steelGrateLegacy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        LEGACY_catwalk = new BlockLegacyCatwalk();
        LEGACY_ladder = new BlockLegacyCagedLadder();
        GameRegistry.registerBlock((Block)LEGACY_catwalk, ItemBlockLegacy.class, (String)"scaffold");
        GameRegistry.registerBlock((Block)LEGACY_ladder, ItemBlockLegacy.class, (String)"cagedLadder");
        lightRopeLegacy = new ItemLegacy("item.legacy.lightrope", "catwalkmod:light_rope");
        blowtorchLegacy = new ItemLegacy("item.legacy.blowtorch", "catwalkmod:blowtorch");
        steelGrateLegacy = new ItemLegacy("item.legacy.steelgrate", "catwalkmod:steel_grate");
        GameRegistry.registerItem((Item)lightRopeLegacy, (String)"ropeLight");
        GameRegistry.registerItem((Item)blowtorchLegacy, (String)"blowtorch");
        GameRegistry.registerItem((Item)steelGrateLegacy, (String)"steelGrate");
        GameRegistry.registerTileEntity(TileEntityCatwalk.class, (String)"catwalkmod:tileEntityScaffold");
        GameRegistry.registerTileEntity(TileEntityCagedLadder.class, (String)"catwalkmod:tileEntityCagedLadder");
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        this.registerLegacyRecipe(Item.func_150898_a((Block)LEGACY_catwalk), Item.func_150898_a((Block)CatwalkMod.defaultCatwalk));
        this.registerLegacyRecipe(Item.func_150898_a((Block)LEGACY_ladder), Item.func_150898_a((Block)CatwalkMod.defaultLadder));
        this.registerLegacyRecipe(lightRopeLegacy, CatwalkMod.itemRopeLight);
        this.registerLegacyRecipe(blowtorchLegacy, CatwalkMod.itemBlowtorch);
        this.registerLegacyRecipe(steelGrateLegacy, CatwalkMod.itemSteelGrate);
    }

    public void registerLegacyRecipe(Item oldItem, Item newItem) {
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(newItem, 1), (Object[])new Object[]{new ItemStack(oldItem, 1)});
    }
}

