/*
 * Decompiled with CFR 0.152.
 */
package texturegeneratorlib.texturestitching;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import texturegeneratorlib.TextureGeneratorLib;
import texturegeneratorlib.loader.impl.CodeRefs;
import texturegeneratorlib.texturestitching.AbstractModIntegration;

@SideOnly(value=Side.CLIENT)
public class ShadersModIntegration
extends AbstractModIntegration {
    private static boolean isAvailable = false;
    private static int tallGrassEntityData;
    private static int leavesEntityData;

    private ShadersModIntegration() {
    }

    public static void init() {
        tallGrassEntityData = Block.field_149771_c.func_148757_b((Object)Blocks.field_150329_H) & 0xFFFF | Blocks.field_150329_H.func_149645_b() << 16;
        leavesEntityData = Block.field_149771_c.func_148757_b((Object)Blocks.field_150362_t) & 0xFFFF | Blocks.field_150362_t.func_149645_b() << 16;
        if (ShadersModIntegration.isAllAvailable(CodeRefs.shaders)) {
            isAvailable = true;
            TextureGeneratorLib.log.info("Found Shaders Mod");
        }
    }

    public static void startGrassQuads() {
        if (!isAvailable) {
            return;
        }
        ShadersModIntegration.setShadersEntityData(tallGrassEntityData);
    }

    public static void startLeavesQuads() {
        if (!isAvailable) {
            return;
        }
        ShadersModIntegration.setShadersEntityData(leavesEntityData);
    }

    private static void setShadersEntityData(int data) {
        try {
            int[] entityData = (int[])CodeRefs.fShadersEntityData.getStaticField();
            int entityDataIndex = (Integer)CodeRefs.fShadersEntityDataIndex.getStaticField();
            entityData[entityDataIndex * 2] = data;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static int getBlockIdOverride(int original, Block block) {
        return original;
    }

    public static boolean isSpecialTexture(ResourceLocation resource) {
        return resource.func_110623_a().toLowerCase().endsWith("_n.png") || resource.func_110623_a().toLowerCase().endsWith("_s.png");
    }
}

