/*
 * Decompiled with CFR 0.152.
 */
package texturegeneratorlib.texturestitching;

import com.google.common.collect.Maps;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Map;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import texturegeneratorlib.TextureGeneratorLib;
import texturegeneratorlib.texturestitching.BlockTextureGenerator;
import texturegeneratorlib.texturestitching.BufferedImageResource;
import texturegeneratorlib.texturestitching.ResourceUtils;
import texturegeneratorlib.texturestitching.TextureInformation;

public class CustomTextureGenerator
extends BlockTextureGenerator {
    public Map<ResourceLocation, IResource> resourceCache = Maps.newHashMap();

    public CustomTextureGenerator(String domainName, ResourceLocation missingResource) {
        super(domainName);
    }

    public IResource func_110536_a(ResourceLocation resourceLocation) throws IOException {
        ResourceLocation originalresourcelocation = resourceLocation;
        IResourceManager resourceManager = Minecraft.func_71410_x().func_110442_L();
        if ((resourceLocation = ResourceUtils.unwrapResource(resourceLocation)).func_110623_a().toLowerCase().endsWith(".mcmeta")) {
            return resourceManager.func_110536_a(resourceLocation);
        }
        TextureInformation textureinfo = TextureGeneratorLib.alphaMaskMap.get(resourceLocation.func_110623_a());
        if (textureinfo != null) {
            BufferedImage result;
            try {
                result = this.generateTexture(resourceLocation, textureinfo);
            }
            catch (TextureGenerationException e) {
                TextureGeneratorLib.log.info(String.format("Error generating for resource: %s", resourceLocation.toString()));
                return resourceManager.func_110536_a(resourceLocation);
            }
            BufferedImageResource generated = new BufferedImageResource(result, originalresourcelocation);
            this.resourceCache.put(resourceLocation, generated);
            return generated;
        }
        TextureGeneratorLib.log.info("No hashmap entry found for " + resourceLocation.func_110623_a());
        return null;
    }

    protected BufferedImage loadMaskImage(TextureInformation textureinfo, ResourceLocation blockResourceLocation, int size) throws IOException {
        IResourceManager resourceManager = Minecraft.func_71410_x().func_110442_L();
        IResource maskResource = null;
        String masktype = textureinfo.alphaMaskTexture;
        if (masktype == null) {
            TextureGeneratorLib.log.info("AlphaMask type not found in hashmap " + blockResourceLocation.toString());
        }
        String maskLocation = textureinfo.overlayDomain + masktype + "_" + size + ".png";
        try {
            maskResource = resourceManager.func_110536_a(new ResourceLocation(maskLocation));
        }
        catch (Exception e) {
            // empty catch block
        }
        if (maskResource == null) {
            for (int sizeloop = 512; maskResource == null && sizeloop > 15; sizeloop /= 2) {
                maskLocation = textureinfo.overlayDomain + masktype + "_" + sizeloop + ".png";
            }
            try {
                maskResource = resourceManager.func_110536_a(new ResourceLocation(maskLocation));
            }
            catch (Exception e) {
                // empty catch block
            }
            BufferedImage maskImage = ImageIO.read(maskResource.func_110527_b());
            BufferedImage dimg = new BufferedImage(size, size, 2);
            Graphics2D g2d = dimg.createGraphics();
            g2d.drawImage(maskImage, 0, 0, size, size, null);
            g2d.dispose();
            return dimg;
        }
        return ImageIO.read(maskResource.func_110527_b());
    }

    protected BufferedImage generateTexture(ResourceLocation originalResource, TextureInformation textureinfo) throws IOException, TextureGenerationException {
        BufferedImage parentIcon = ImageIO.read(Minecraft.func_71410_x().func_110442_L().func_110536_a(textureinfo.parentTexture).func_110527_b());
        int size = parentIcon.getWidth();
        BufferedImage maskImage = this.loadMaskImage(textureinfo, originalResource, size);
        if (parentIcon.getHeight() != maskImage.getHeight()) {
            TextureGeneratorLib.log.info("Found Animated Texture : " + originalResource.toString());
            BufferedImage genIcon = new BufferedImage(parentIcon.getWidth(), parentIcon.getWidth(), 6);
            Graphics2D genGraphics = genIcon.createGraphics();
            genGraphics.drawImage((Image)parentIcon, 0, 0, null);
            parentIcon = genIcon;
        }
        if (maskImage.getWidth() != parentIcon.getWidth()) {
            TextureGeneratorLib.log.info("Image to overlay file is incorrect size : " + originalResource.toString());
        }
        if (textureinfo.alphaMask) {
            return this.ApplyTransparency(parentIcon, maskImage);
        }
        return this.ApplyOverlay(parentIcon, maskImage);
    }

    private BufferedImage ApplyTransparency(BufferedImage image, BufferedImage mask) {
        BufferedImage dest = new BufferedImage(image.getWidth(), image.getHeight(), 2);
        Graphics2D g2 = dest.createGraphics();
        g2.drawImage((Image)image, 0, 0, null);
        AlphaComposite ac = AlphaComposite.getInstance(6, 1.0f);
        g2.setComposite(ac);
        g2.drawImage((Image)mask, 0, 0, null);
        g2.dispose();
        return dest;
    }

    private BufferedImage ApplyOverlay(BufferedImage image, BufferedImage overlay) {
        BufferedImage dest = new BufferedImage(image.getWidth(), image.getHeight(), 2);
        Graphics2D g2 = dest.createGraphics();
        g2.drawImage((Image)image, 0, 0, null);
        g2.drawImage((Image)overlay, 0, 0, null);
        g2.dispose();
        return dest;
    }

    @Override
    @SubscribeEvent
    public void handleTextureReload(TextureStitchEvent.Pre event) {
        super.handleTextureReload(event);
        if (event.map.func_130086_a() != 0) {
            return;
        }
        this.resourceCache.clear();
    }

    @Override
    @SubscribeEvent
    public void endTextureReload(TextureStitchEvent.Post event) {
        super.endTextureReload(event);
        if (event.map.func_130086_a() != 0) {
            return;
        }
        TextureGeneratorLib.log.info(String.format("Loaded overlaid textures", new Object[0]));
    }

    @SideOnly(value=Side.CLIENT)
    public static class TextureGenerationException
    extends Exception {
        private static final long serialVersionUID = 7339757761980002651L;
    }
}

