/*
 * Decompiled with CFR 0.152.
 */
package texturegeneratorlib.loader;

import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import texturegeneratorlib.loader.FieldRef;
import texturegeneratorlib.loader.MethodRef;
import texturegeneratorlib.loader.Namespace;

public abstract class AbstractMethodTransformer {
    protected ClassNode currentClass;
    protected MethodNode currentMethod;
    protected Namespace environment;

    public abstract void transform();

    protected void insertAfter(IInstructionMatch filter, AbstractInsnNode ... added) {
        InsnList listAdd = new InsnList();
        for (AbstractInsnNode inst : added) {
            listAdd.add(inst);
        }
        AbstractInsnNode targetNode = this.findNext(this.currentMethod.instructions.getFirst(), filter);
        this.currentMethod.instructions.insert(targetNode, listAdd);
    }

    protected void insertBefore(IInstructionMatch filter, AbstractInsnNode ... added) {
        InsnList listAdd = new InsnList();
        for (AbstractInsnNode inst : added) {
            listAdd.add(inst);
        }
        AbstractInsnNode targetNode = this.findNext(this.currentMethod.instructions.getFirst(), filter);
        this.currentMethod.instructions.insertBefore(targetNode, listAdd);
    }

    protected AbstractInsnNode findNext(AbstractInsnNode start, IInstructionMatch match) {
        AbstractInsnNode current;
        for (current = start; current != null && !match.matches(current); current = current.getNext()) {
        }
        return current;
    }

    protected AbstractInsnNode findPrevious(AbstractInsnNode start, IInstructionMatch match) {
        AbstractInsnNode current;
        for (current = start; current != null && !match.matches(current); current = current.getPrevious()) {
        }
        return current;
    }

    protected IInstructionMatch matchOpcode(final int opcode) {
        return new IInstructionMatch(){

            @Override
            public boolean matches(AbstractInsnNode node) {
                return node.getOpcode() == opcode;
            }
        };
    }

    protected IInstructionMatch matchVarInsn(final int opcode, final int var) {
        return new IInstructionMatch(){

            @Override
            public boolean matches(AbstractInsnNode node) {
                if (node instanceof VarInsnNode) {
                    return node.getOpcode() == opcode && ((VarInsnNode)node).var == var;
                }
                return false;
            }
        };
    }

    protected FieldInsnNode createGetField(FieldRef field) {
        return new FieldInsnNode(180, field.parent.getName(this.environment).replace(".", "/"), field.getName(this.environment), field.getAsmDescriptor(this.environment));
    }

    protected MethodInsnNode createInvokeStatic(MethodRef method) {
        return new MethodInsnNode(184, method.parent.getName(this.environment).replace(".", "/"), method.getName(this.environment), method.getAsmDescriptor(this.environment));
    }

    public static interface IInstructionMatch {
        public boolean matches(AbstractInsnNode var1);
    }
}

