/*
 * Decompiled with CFR 0.152.
 */
package cyano.lootable.entities;

import com.google.common.collect.Iterables;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import cyano.lootable.LootableBodies;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.potion.Potion;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.StringUtils;
import net.minecraft.world.World;

public class EntityLootableBody
extends EntityLiving
implements IInventory {
    public static final int INVENTORY_SIZE = 54;
    public static int additionalItemDamage = 10;
    public static float corpseHP = 40.0f;
    public static boolean hurtByFire = false;
    public static boolean hurtByBlast = false;
    public static boolean hurtByFall = false;
    public static boolean hurtByCactus = false;
    public static boolean hurtByWeapons = false;
    public static boolean hurtByBlockSuffocation = false;
    public static boolean hurtByAll = false;
    public static boolean hurtByOther = false;
    public static boolean invulnerable = false;
    static final byte VACUUM_TIMELIMIT = 20;
    static final int VACUUM_RADIUS = 3;
    static final int WATCHER_ID_OWNER = 28;
    private static final DamageSource selfDestruct = new DamageSource(EntityLootableBody.class.getSimpleName());
    protected final ItemStack[] field_82182_bS = new ItemStack[54];
    protected final Deque<ItemStack> auxInventory = new LinkedList<ItemStack>();
    private byte vacuumTime = 0;
    private GameProfile owner = null;
    private int shovelHits = 0;
    private static final int shovelHitLimit = 3;
    private long deathTimestamp = Long.MAX_VALUE;
    private boolean deadMode = false;

    public EntityLootableBody(World w) {
        super(w);
        this.func_70105_a(0.85f, 0.75f);
        this.field_70178_ae = !hurtByFire || invulnerable;
        this.vacuumTime = 0;
        this.func_70096_w().func_75682_a(28, (Object)"");
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)corpseHP);
    }

    protected void func_70088_a() {
        super.func_70088_a();
    }

    public float getRotation() {
        return this.field_70177_z;
    }

    public void setRotation(float newRot) {
        this.field_70761_aq = this.field_70177_z = newRot;
        this.field_70760_ar = this.field_70177_z;
        this.field_70126_B = this.field_70177_z;
        this.field_70712_bm = this.field_70177_z;
        if (this.field_70170_p.field_72995_K) {
            this.func_70034_d(this.field_70177_z);
        }
    }

    protected void func_70626_be() {
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public void setOwner(GameProfile gp) {
        try {
            this.owner = gp;
            this.updatePlayerProfile();
            if (gp.getName() != null) {
                this.func_70096_w().func_75692_b(28, (Object)gp.getName());
            } else {
                this.func_70096_w().func_75692_b(28, (Object)"");
            }
        }
        catch (Exception e) {
            System.err.println("Error: " + e);
            this.func_70096_w().func_75692_b(28, (Object)"");
        }
    }

    public GameProfile getOwner() {
        if (this.owner == null) {
            this.owner = this.getGameProfileFromName(this.func_70096_w().func_75681_e(28));
        } else if (this.func_70096_w().func_75681_e(28).isEmpty()) {
            this.owner = null;
        }
        return this.owner;
    }

    private void updatePlayerProfile() {
        if (this.owner == null || StringUtils.func_151246_b((String)this.owner.getName())) {
            return;
        }
        if (this.owner.isComplete() && this.owner.getProperties().containsKey((Object)"textures")) {
            return;
        }
        GameProfile field_152110_j = MinecraftServer.func_71276_C().func_152358_ax().func_152655_a(this.owner.getName());
        if (field_152110_j == null) {
            return;
        }
        if (Iterables.getFirst((Iterable)field_152110_j.getProperties().get((Object)"textures"), null) == null) {
            field_152110_j = MinecraftServer.func_71276_C().func_147130_as().fillProfileProperties(field_152110_j, true);
        }
        this.owner = field_152110_j;
    }

    private GameProfile getGameProfileFromName(String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        GameProfile gp = new GameProfile((UUID)null, name);
        return gp;
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (LootableBodies.allowCorpseDecay && !this.field_70170_p.field_72995_K && this.field_70170_p.func_72820_D() % 20L == 0L) {
            if (LootableBodies.decayOnlyWhenEmpty) {
                for (int i = 0; i < this.field_82182_bS.length; ++i) {
                    if (this.field_82182_bS[i] == null) continue;
                    this.deathTimestamp = this.field_70170_p.func_82737_E();
                    break;
                }
            }
            if (this.field_70170_p.func_82737_E() - this.deathTimestamp > LootableBodies.corpseDecayTime) {
                this.func_82160_b(true, 0);
                this.func_70076_C();
            }
        }
        if (this.vacuumTime < 20) {
            double z2;
            double y2;
            double x2;
            double z1;
            double y1;
            double x1;
            List ae;
            if (!this.field_70170_p.field_72995_K && this.notFull() && !(ae = this.field_70170_p.func_72872_a(EntityItem.class, AxisAlignedBB.func_72330_a((double)(x1 = this.field_70165_t - 3.0), (double)(y1 = this.field_70163_u - 3.0), (double)(z1 = this.field_70161_v - 3.0), (double)(x2 = this.field_70165_t + 3.0), (double)(y2 = this.field_70163_u + 3.0), (double)(z2 = this.field_70161_v + 3.0)))).isEmpty()) {
                for (int n = ae.size() - 1; n >= 0; --n) {
                    Entity e = (Entity)ae.get(n);
                    ItemStack leftover = this.vacuumItem(((EntityItem)e).func_92059_d());
                    this.field_70170_p.func_72900_e(e);
                    if (leftover == null) continue;
                    this.func_70099_a(leftover, 0.0f);
                }
            }
            this.vacuumTime = (byte)(this.vacuumTime + 1);
        }
        this.shiftInventory();
        if (this.deadMode) {
            this.func_82160_b(true, 0);
            this.field_70170_p.func_72900_e((Entity)this);
        }
    }

    private void shiftInventory() {
        if (!this.auxInventory.isEmpty()) {
            if (this.field_82182_bS[this.field_82182_bS.length - 1] == null) {
                this.field_82182_bS[this.field_82182_bS.length - 1] = this.auxInventory.pop();
            }
            for (int dstSlot = 5; dstSlot < this.field_82182_bS.length; ++dstSlot) {
                int srcSlot;
                if (this.field_82182_bS[dstSlot] != null) continue;
                for (srcSlot = dstSlot + 1; srcSlot < this.field_82182_bS.length && this.field_82182_bS[srcSlot] == null; ++srcSlot) {
                }
                if (srcSlot == this.field_82182_bS.length) {
                    return;
                }
                this.field_82182_bS[dstSlot] = this.field_82182_bS[srcSlot];
                this.field_82182_bS[srcSlot] = null;
            }
        }
    }

    public void func_70014_b(NBTTagCompound root) {
        super.func_70014_b(root);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.field_82182_bS.length; ++i) {
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            if (this.field_82182_bS[i] != null) {
                this.field_82182_bS[i].func_77955_b(nbttagcompound1);
            }
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        root.func_74782_a("Equipment", (NBTBase)nbttaglist);
        if (!this.auxInventory.isEmpty()) {
            NBTTagList nbtauxtaglist = new NBTTagList();
            for (ItemStack i : this.auxInventory) {
                if (i == null) continue;
                NBTTagCompound nbttagcompound1 = new NBTTagCompound();
                i.func_77955_b(nbttagcompound1);
                nbtauxtaglist.func_74742_a((NBTBase)nbttagcompound1);
            }
            root.func_74782_a("Aux", (NBTBase)nbtauxtaglist);
        }
        if (this.vacuumTime < 20) {
            root.func_74774_a("Vac", this.vacuumTime);
        }
        if (this.owner != null) {
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            NBTUtil.func_152460_a((NBTTagCompound)nbtTagCompound, (GameProfile)this.owner);
            root.func_74782_a("Owner", (NBTBase)nbtTagCompound);
        }
        root.func_74772_a("DeathTime", this.deathTimestamp);
    }

    public void func_70037_a(NBTTagCompound root) {
        String string;
        int i;
        NBTTagList nbttaglist;
        if (root.func_150297_b("Equipment", 9)) {
            nbttaglist = root.func_150295_c("Equipment", 10);
            for (i = 0; i < this.field_82182_bS.length && i < nbttaglist.func_74745_c(); ++i) {
                this.field_82182_bS[i] = ItemStack.func_77949_a((NBTTagCompound)nbttaglist.func_150305_b(i));
            }
        }
        root.func_82580_o("Equipment");
        if (root.func_74764_b("Aux")) {
            nbttaglist = root.func_150295_c("Aux", 10);
            for (i = 0; i < this.field_82182_bS.length && i < nbttaglist.func_74745_c(); ++i) {
                this.auxInventory.addLast(ItemStack.func_77949_a((NBTTagCompound)nbttaglist.func_150305_b(i)));
            }
        }
        super.func_70037_a(root);
        this.vacuumTime = root.func_74764_b("Vac") ? root.func_74771_c("Vac") : (byte)20;
        if (root.func_74764_b("DeathTime")) {
            this.deathTimestamp = root.func_74763_f("DeathTime");
        }
        if (root.func_74764_b("Yaw")) {
            this.field_70177_z = root.func_74760_g("Yaw");
        }
        if (root.func_74764_b("Owner")) {
            this.setOwner(NBTUtil.func_152459_a((NBTTagCompound)root.func_74775_l("Owner")));
        }
        if (root.func_74764_b("Name")) {
            this.setOwner(new GameProfile(null, root.func_74779_i("Name")));
        } else if (root.func_150297_b("ExtraType", 8) && !StringUtils.func_151246_b((String)(string = root.func_74779_i("ExtraType")))) {
            this.setOwner(new GameProfile((UUID)null, string));
        }
        this.setRotation(this.field_70177_z);
    }

    public boolean func_70097_a(DamageSource src, float amount) {
        String s;
        if (this.func_85032_ar()) {
            return false;
        }
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        this.field_70708_bq = 0;
        if (this.func_110143_aJ() <= 0.0f) {
            return false;
        }
        if (src.func_76347_k() && this.func_70644_a(Potion.field_76426_n)) {
            return false;
        }
        boolean flag = true;
        if ((float)this.field_70172_ad > (float)this.field_70771_an / 2.0f) {
            if (amount <= this.field_110153_bc) {
                return false;
            }
            this.func_70665_d(src, amount - this.field_110153_bc);
            this.field_110153_bc = amount;
            flag = false;
        } else {
            this.field_110153_bc = amount;
            this.field_70735_aL = this.func_110143_aJ();
            this.field_70172_ad = this.field_70771_an;
            this.func_70665_d(src, amount);
            int n = 10;
            this.field_70738_aO = 10;
            this.field_70737_aN = 10;
        }
        Entity entity = src.func_76346_g();
        if (entity != null) {
            EntityTameable entitywolf;
            if (entity instanceof EntityPlayer) {
                this.field_70718_bc = 100;
                this.field_70717_bb = (EntityPlayer)entity;
            } else if (entity instanceof EntityTameable && (entitywolf = (EntityTameable)entity).func_70909_n()) {
                this.field_70718_bc = 100;
                this.field_70717_bb = null;
            }
        }
        if (flag) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)2);
            if (src != DamageSource.field_76369_e) {
                this.func_70018_K();
            }
            if (entity != null) {
                double d1 = entity.field_70165_t - this.field_70165_t;
                double d2 = entity.field_70161_v - this.field_70161_v;
                while (d1 * d1 + d2 * d2 < 1.0E-4) {
                    d1 = (Math.random() - Math.random()) * 0.01;
                    d2 = (Math.random() - Math.random()) * 0.01;
                }
                this.func_70653_a(entity, amount, d1, d2);
            }
        }
        if (this.func_110143_aJ() <= 0.0f) {
            s = this.func_70673_aS();
            if (flag && s != null) {
                this.func_85030_a(s, this.func_70599_aP(), this.func_70647_i());
            }
            this.func_70645_a(src);
        } else {
            s = this.func_70621_aR();
            if (flag && s != null) {
                this.func_85030_a(s, this.func_70599_aP(), this.func_70647_i());
            }
        }
        return true;
    }

    protected void func_70665_d(DamageSource src, float amount) {
        ItemStack itemStack;
        Item item;
        if (src == selfDestruct) {
            super.func_70665_d(src, amount);
            return;
        }
        if (src.func_76346_g() != null && src.func_76346_g() instanceof EntityPlayer && ((EntityPlayer)src.func_76346_g()).func_70694_bm() != null && ((item = (itemStack = ((EntityPlayer)src.func_76346_g()).func_70694_bm()).func_77973_b()) instanceof ItemSpade || item.getHarvestLevel(itemStack, "shovel") >= 0)) {
            ++this.shovelHits;
            super.func_70665_d(src, amount);
            if (this.shovelHits >= 3) {
                this.func_70076_C();
            }
        }
        if (this.field_70163_u < -1.0) {
            this.func_70076_C();
        }
        if (src.equals(DamageSource.field_76368_d)) {
            this.jumpOutOfWall();
        }
        if (invulnerable) {
            return;
        }
        if (hurtByAll) {
            super.func_70665_d(src, amount);
        }
        if (src.func_76346_g() != null && src.func_76346_g() instanceof EntityLivingBase) {
            if (hurtByWeapons) {
                super.func_70665_d(src, amount);
            }
        }
        if (src.func_76347_k()) {
            if (hurtByFire) {
                super.func_70665_d(src, amount);
            }
        }
        if (src.func_94541_c()) {
            if (hurtByBlast) {
                super.func_70665_d(src, amount);
            }
        }
        if (src == DamageSource.field_76379_h) {
            if (hurtByFall) {
                super.func_70665_d(src, amount);
            }
        }
        if (src == DamageSource.field_76367_g) {
            if (hurtByCactus) {
                super.func_70665_d(src, amount);
            }
        }
        if (src == DamageSource.field_76368_d) {
            if (hurtByBlockSuffocation) {
                super.func_70665_d(src, amount);
            }
        }
        if (hurtByOther) {
            super.func_70665_d(src, amount);
        }
        if (super.func_110143_aJ() <= 0.0f) {
            this.deadMode = true;
        }
    }

    public void jumpOutOfWall() {
        double root2 = 1.414213562;
        double[] currentCoord = new double[]{(int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v};
        double[] vector = new double[]{this.field_70165_t - (currentCoord[0] + 0.5), 0.0, this.field_70161_v - (currentCoord[2] + 0.5)};
        double normalizer = 1.0 / Math.sqrt(vector[0] * vector[0] + vector[1] * vector[1] + vector[2] * vector[2]);
        vector[0] = vector[0] * normalizer;
        vector[1] = vector[1] * normalizer;
        vector[2] = vector[2] * normalizer;
        Block block = this.field_70170_p.func_147439_a((int)(this.field_70165_t + vector[0]), (int)(this.field_70163_u + vector[1]), (int)(this.field_70161_v + vector[2]));
        if (!block.func_149688_o().func_76230_c()) {
            this.func_70107_b((double)((int)(this.field_70165_t + vector[0])) + 0.5, (int)(this.field_70163_u + vector[1]), (double)((int)(this.field_70161_v + vector[2])) + 0.5);
            return;
        }
        int[] n = new int[]{(int)currentCoord[0], (int)currentCoord[1], (int)currentCoord[2]};
        n[1] = n[1] + 1;
        if (!this.field_70170_p.func_147439_a(n[0], n[1], n[2]).func_149688_o().func_76230_c()) {
            this.func_70107_b((double)n[0] + 0.5, (double)n[1] + 0.015625, (double)n[2] + 0.5);
            return;
        }
        n[0] = (int)currentCoord[0];
        n[1] = (int)currentCoord[1];
        n[2] = (int)currentCoord[2];
        n[0] = n[0] + 1;
        if (!this.field_70170_p.func_147439_a(n[0], n[1], n[2]).func_149688_o().func_76230_c()) {
            this.func_70107_b((double)n[0] + 0.5, (double)n[1] + 0.015625, (double)n[2] + 0.5);
            return;
        }
        n[0] = (int)currentCoord[0];
        n[1] = (int)currentCoord[1];
        n[2] = (int)currentCoord[2];
        n[0] = n[0] - 1;
        if (!this.field_70170_p.func_147439_a(n[0], n[1], n[2]).func_149688_o().func_76230_c()) {
            this.func_70107_b((double)n[0] + 0.5, (double)n[1] + 0.015625, (double)n[2] + 0.5);
            return;
        }
        n[0] = (int)currentCoord[0];
        n[1] = (int)currentCoord[1];
        n[2] = (int)currentCoord[2];
        n[2] = n[2] + 1;
        if (!this.field_70170_p.func_147439_a(n[0], n[1], n[2]).func_149688_o().func_76230_c()) {
            this.func_70107_b((double)n[0] + 0.5, (double)n[1] + 0.015625, (double)n[2] + 0.5);
            return;
        }
        n[0] = (int)currentCoord[0];
        n[1] = (int)currentCoord[1];
        n[2] = (int)currentCoord[2];
        n[2] = n[2] - 1;
        if (!this.field_70170_p.func_147439_a(n[0], n[1], n[2]).func_149688_o().func_76230_c()) {
            this.func_70107_b((double)n[0] + 0.5, (double)n[1] + 0.015625, (double)n[2] + 0.5);
            return;
        }
        n[0] = (int)currentCoord[0];
        n[1] = (int)currentCoord[1];
        n[2] = (int)currentCoord[2];
        n[1] = n[1] - 1;
        if (!this.field_70170_p.func_147439_a(n[0], n[1], n[2]).func_149688_o().func_76230_c()) {
            this.func_70107_b((double)n[0] + 0.5, (double)n[1] + 0.015625, (double)n[2] + 0.5);
            return;
        }
        vector[0] = this.field_70170_p.field_73012_v.nextDouble();
        vector[1] = this.field_70170_p.field_73012_v.nextDouble();
        vector[2] = this.field_70170_p.field_73012_v.nextDouble();
        normalizer = root2 / Math.sqrt(vector[0] * vector[0] + vector[1] * vector[1] + vector[2] * vector[2]);
        this.func_70107_b(this.field_70165_t + vector[0], this.field_70163_u + vector[1], this.field_70161_v + vector[2]);
    }

    protected void func_70076_C() {
        this.deadMode = true;
        this.func_70097_a(selfDestruct, this.func_110138_aP());
        this.func_70296_d();
    }

    public void func_70619_bc() {
    }

    public ItemStack func_70694_bm() {
        return this.field_82182_bS[0];
    }

    public ItemStack func_71124_b(int slot) {
        return this.field_82182_bS[slot % this.field_82182_bS.length];
    }

    @Deprecated
    public ItemStack getCurrentArmor(int armorSlot) {
        return this.func_71124_b(armorSlot + 1);
    }

    public ItemStack armorItemInSlot(int i) {
        return this.getCurrentArmor(i);
    }

    public void func_70062_b(int slot, ItemStack item) {
        this.field_82182_bS[slot] = item;
    }

    @Deprecated
    public ItemStack[] getInventory() {
        return this.field_82182_bS;
    }

    protected void func_82160_b(boolean doDrop, int dropProbability) {
        if (!doDrop) {
            return;
        }
        for (int j = this.field_82182_bS.length - 1; j >= 0; --j) {
            ItemStack itemstack = this.field_82182_bS[j];
            if (itemstack == null) continue;
            this.func_70099_a(itemstack, 0.0f);
            this.field_82182_bS[j] = null;
        }
        if (!this.auxInventory.isEmpty()) {
            for (ItemStack itemstack : this.auxInventory) {
                if (itemstack == null) continue;
                this.func_70099_a(itemstack, 0.0f);
            }
            this.auxInventory.clear();
        }
    }

    boolean notFull() {
        for (int i = 5; i < this.field_82182_bS.length; ++i) {
            if (this.field_82182_bS[i] != null) continue;
            return true;
        }
        return this.auxInventory.size() < LootableBodies.corpseAuxilleryInventorySize;
    }

    public ItemStack vacuumItem(ItemStack item) {
        if (item == null) {
            return null;
        }
        for (int nextIndex = 5; nextIndex < this.field_82182_bS.length; ++nextIndex) {
            if (this.field_82182_bS[nextIndex] != null) {
                if (!this.canStack(item, this.field_82182_bS[nextIndex])) continue;
                ItemStack remainder = this.stackItemStacks(this.field_82182_bS[nextIndex], item);
                if (remainder != null) {
                    item = remainder;
                    continue;
                }
                return null;
            }
            this.field_82182_bS[nextIndex] = EntityLootableBody.applyItemDamage(item);
            return null;
        }
        if (this.auxInventory.size() < LootableBodies.corpseAuxilleryInventorySize) {
            for (ItemStack bufferItem : this.auxInventory) {
                if (!this.canStack(bufferItem, item) || (item = this.stackItemStacks(bufferItem, item)) != null) continue;
                return null;
            }
            this.auxInventory.addLast(EntityLootableBody.applyItemDamage(item));
            return null;
        }
        return item.func_77946_l();
    }

    ItemStack stackItemStacks(ItemStack dest, ItemStack src) {
        if (src.field_77994_a == 0) {
            return null;
        }
        if (this.canStack(dest, src)) {
            int maxStackSize = Math.min(dest.func_77976_d(), this.func_70297_j_());
            if (src.field_77994_a + dest.field_77994_a < maxStackSize) {
                dest.field_77994_a += src.field_77994_a;
                return null;
            }
            if (dest.field_77994_a < maxStackSize) {
                int difference = maxStackSize - dest.field_77994_a;
                dest.field_77994_a += difference;
                src.field_77994_a -= difference;
                if (src.field_77994_a == 0) {
                    return null;
                }
                return src;
            }
            return src;
        }
        return src;
    }

    private boolean canStack(ItemStack a, ItemStack b) {
        if (a == null || b == null) {
            return false;
        }
        if (a.func_77973_b() == b.func_77973_b() && a.func_77985_e()) {
            if (a.func_77960_j() != b.func_77960_j()) {
                return false;
            }
            if (!a.func_77985_e()) {
                return false;
            }
            if (a.field_77994_a + b.field_77994_a > Math.min(a.func_77976_d(), this.func_70297_j_())) {
                return false;
            }
            if (!a.func_77942_o() && !b.func_77942_o()) {
                return true;
            }
            if (a.func_77942_o() && b.func_77942_o()) {
                return ItemStack.func_77970_a((ItemStack)a, (ItemStack)b);
            }
        }
        return false;
    }

    public static ItemStack applyItemDamage(ItemStack itemstack) {
        if (additionalItemDamage == 0) {
            return itemstack;
        }
        if (itemstack != null && itemstack.func_77984_f() && itemstack.func_77973_b().func_77645_m() && !itemstack.func_77985_e() && !itemstack.func_77973_b().func_77614_k() && itemstack.func_77973_b().func_77612_l() > 0) {
            int newDamageValue = itemstack.func_77960_j() + additionalItemDamage;
            itemstack.func_77964_b(Math.min(newDamageValue, itemstack.func_77958_k() - 1));
        }
        return itemstack;
    }

    public void setDeathTime(long timestamp) {
        this.deathTimestamp = timestamp;
    }

    public int func_70627_aG() {
        return 1200;
    }

    public void func_70642_aH() {
    }

    public boolean func_70648_aU() {
        return true;
    }

    protected int func_70693_a(EntityPlayer p_getExperiencePoints_1_) {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte p_handleHealthUpdate_1_) {
    }

    protected String func_70639_aQ() {
        return null;
    }

    protected Item func_146068_u() {
        return null;
    }

    public boolean func_82171_bF() {
        return false;
    }

    public void func_96120_a(int p_setEquipmentDropChance_1_, float p_setEquipmentDropChance_2_) {
    }

    public boolean func_98052_bS() {
        return false;
    }

    public void func_98053_h(boolean p_setCanPickUpLoot_1_) {
    }

    protected boolean func_70085_c(EntityPlayer player) {
        player.func_71007_a((IInventory)this);
        return true;
    }

    public boolean func_110164_bC() {
        return false;
    }

    protected void playSound(String soundID) {
        if (!this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72956_a((Entity)this, soundID, 0.5f, 0.4f);
        }
    }

    public void clear() {
        for (int i = 0; i < this.field_82182_bS.length; ++i) {
            this.field_82182_bS[i] = null;
        }
        this.auxInventory.clear();
    }

    public void clearInventory() {
        this.clear();
    }

    public void func_70305_f() {
        this.playSound("mob.horse.leather");
    }

    public ItemStack func_70298_a(int index, int count) {
        if (this.field_82182_bS[index] == null) {
            return null;
        }
        if (this.field_82182_bS[index].field_77994_a <= count) {
            ItemStack itemStack = this.field_82182_bS[index];
            this.field_82182_bS[index] = null;
            this.func_70296_d();
            return itemStack;
        }
        ItemStack splitStack = this.field_82182_bS[index].func_77979_a(count);
        if (this.field_82182_bS[index].field_77994_a == 0) {
            this.field_82182_bS[index] = null;
        }
        this.func_70296_d();
        return splitStack;
    }

    public int func_70297_j_() {
        return 64;
    }

    public int func_70302_i_() {
        return this.field_82182_bS.length;
    }

    public ItemStack func_70301_a(int index) {
        return this.field_82182_bS[index];
    }

    public ItemStack func_70304_b(int index) {
        if (this.field_82182_bS[index] != null) {
            ItemStack itemStack = this.field_82182_bS[index];
            this.field_82182_bS[index] = null;
            return itemStack;
        }
        return null;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return index >= 5 || index <= 0 || EntityLootableBody.func_82159_b((ItemStack)stack) == index;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.deadMode) {
            return false;
        }
        return player.func_70092_e(this.field_70165_t, this.field_70163_u, this.field_70161_v) <= 16.0;
    }

    public void func_70296_d() {
    }

    public void func_70295_k_() {
        this.playSound("mob.horse.armor");
    }

    public void func_70299_a(int slot, ItemStack item) {
        this.field_82182_bS[slot] = item;
        if (item != null && item.field_77994_a > this.func_70297_j_()) {
            item.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public String func_145825_b() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public boolean func_145818_k_() {
        return false;
    }
}

