/*
 * Decompiled with CFR 0.152.
 */
package cyano.lootable;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.EntityRegistry;
import cyano.lootable.Proxy;
import cyano.lootable.ServerProxy;
import cyano.lootable.entities.EntityLootableBody;
import cyano.lootable.events.PlayerDeathEventHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;

@Mod(modid="lootablebodies", name="DrCyano's Lootable Bodies", version="1.3.7")
public class LootableBodies {
    public static final String MODID = "lootablebodies";
    public static final String NAME = "DrCyano's Lootable Bodies";
    public static final String VERSION = "1.3.7";
    public static boolean addBonesToCorpse = true;
    public static boolean fancyCorpses = false;
    public static int corpseAuxilleryInventorySize = 54;
    public static boolean allowCorpseDecay = false;
    public static boolean decayOnlyWhenEmpty = false;
    public static long corpseDecayTime = 72000L;
    public static int eioSoulboundID;
    @SidedProxy(clientSide="cyano.lootable.ClientProxy", serverSide="cyano.lootable.ServerProxy")
    public static Proxy proxy;
    private int entityIndex = 0;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        EntityLootableBody.additionalItemDamage = config.getInt("item_damage_on_death", "options", 32, 0, 1000, "The amount of damage suffered by damageable items when you \ndie, to a minimum of 1 durability remaining (items will \nnot be destroyed).");
        EntityLootableBody.corpseHP = config.getFloat("corpse_HP", "options", 50.0f, 1.0f, 32767.0f, "The amount of damage a corpse can suffer before being \ndestroyed and releasing its items. \nNote that 10 hearts = 20 HP.");
        EntityLootableBody.hurtByAll = config.getBoolean("hurt_by_all", "corpse damage", false, "If true, corpses will be damaged by anything that damages a player.");
        EntityLootableBody.hurtByFire = config.getBoolean("hurt_by_fire", "corpse damage", false, "If true, corpses will be damaged by fire and lava.");
        EntityLootableBody.hurtByBlast = config.getBoolean("hurt_by_explosions", "corpse damage", false, "If true, corpses will be damaged by creepers and TNT. \nIf you don't want bodies to be destroyed by explosions, \nalso disable fall damage.");
        EntityLootableBody.hurtByFall = config.getBoolean("hurt_by_fall", "corpse damage", false, "If true, corpses will be damaged by falling long distances.");
        EntityLootableBody.hurtByCactus = config.getBoolean("hurt_by_cactus", "corpse damage", false, "If true, corpses will be damaged by cacti.");
        EntityLootableBody.hurtByWeapons = config.getBoolean("hurt_by_weapons", "corpse damage", false, "If true, corpses will be damaged by attacking it.");
        EntityLootableBody.hurtByBlockSuffocation = config.getBoolean("hurt_by_block_suffocation", "corpse damage", false, "If true, corpses will be damaged by being stuck inside a block.");
        EntityLootableBody.hurtByOther = config.getBoolean("hurt_by_other", "corpse damage", false, "If true, corpses will be damaged by damage sources not covered by the other options in this section.");
        EntityLootableBody.invulnerable = !LootableBodies.or(EntityLootableBody.hurtByAll, EntityLootableBody.hurtByBlast, EntityLootableBody.hurtByBlockSuffocation, EntityLootableBody.hurtByCactus, EntityLootableBody.hurtByFall, EntityLootableBody.hurtByFire, EntityLootableBody.hurtByOther, EntityLootableBody.hurtByWeapons);
        addBonesToCorpse = config.getBoolean("add_bones_to_corpse", "options", true, "If true, corpses will have bones and rotten flesh added to them.");
        corpseAuxilleryInventorySize = Math.max(config.getInt("corpse_inventory_size", "options", corpseAuxilleryInventorySize + 54, 54, 16383, "The maximum number of items that can be stored in a \ncorpse. Note that only 54 can be seen at a time") - 54, 0);
        allowCorpseDecay = config.getBoolean("enable_corpse_decay", "corpse decay", false, "If true, corpses will self-destruct after a preiod of time.");
        decayOnlyWhenEmpty = config.getBoolean("empty_only_decay", "corpse decay", false, "If true and enable_corpse_decay is also true, corpses will \nself-destruct after being empty for a period of time (will \nnot decay if there are any items on the corpse). If using this \noption, you will probably want to also disable the \nadd_bones_to_corpse option.");
        String decayTime = config.getString("corpse_decay_time", "corpse decay", "1:00:00", "Time after death before a corpse will self-destruct (if the \nenable_corpse_decay option is set to true). \nThe format is hours:minutes:seconds or just hours:minutes");
        corpseDecayTime = Math.max(this.parseTimeInSeconds(decayTime), 2) * 20;
        eioSoulboundID = config.get("options", "eio_Soulbound_id", -1, "EnderIO Soulbound enchantment id").getInt();
        config.save();
        proxy.preInit(event);
    }

    private int parseTimeInSeconds(String time) {
        String[] component = time.split(":");
        int hr = 0;
        int min = 0;
        int sec = 0;
        if (component.length > 0) {
            hr = Integer.parseInt(component[0].trim());
        }
        if (component.length > 1) {
            min = Integer.parseInt(component[1].trim());
        }
        if (component.length > 2) {
            sec = Integer.parseInt(component[2].trim());
        }
        return 3600 * hr + 60 * min + sec;
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        this.registerItemRenders();
        this.registerEntity(EntityLootableBody.class);
        MinecraftForge.EVENT_BUS.register((Object)new PlayerDeathEventHandler());
        proxy.init(event);
    }

    private void registerEntity(Class entityClass) {
        String idName = "lootablebodies_" + entityClass.getSimpleName();
        EntityRegistry.registerGlobalEntityID((Class)entityClass, (String)idName, (int)EntityRegistry.findGlobalUniqueEntityId());
        EntityRegistry.registerModEntity((Class)entityClass, (String)idName, (int)this.entityIndex++, (Object)this, (int)64, (int)10, (boolean)true);
    }

    private void registerItemRenders() {
        if (proxy instanceof ServerProxy) {
            return;
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit(event);
    }

    private static boolean or(boolean ... bools) {
        for (int i = 0; i < bools.length; ++i) {
            if (!bools[i]) continue;
            return true;
        }
        return false;
    }

    private static boolean and(boolean ... bools) {
        for (int i = 0; i < bools.length; ++i) {
            if (bools[i]) continue;
            return false;
        }
        return true;
    }
}

