/*
 * Decompiled with CFR 0.152.
 */
package openmodularturrets;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import openmodularturrets.blocks.Blocks;
import openmodularturrets.client.gui.ModularTurretsTab;
import openmodularturrets.compatability.ModCompatibility;
import openmodularturrets.handler.ConfigHandler;
import openmodularturrets.handler.DungeonLootHandler;
import openmodularturrets.handler.GuiHandler;
import openmodularturrets.handler.NetworkingHandler;
import openmodularturrets.handler.ProjectileEntityHandler;
import openmodularturrets.handler.TileEntityHandler;
import openmodularturrets.handler.recipes.RecipeHandler;
import openmodularturrets.items.Items;
import openmodularturrets.proxy.CommonProxy;
import openmodularturrets.util.CommandChangeOwner;

@Mod(modid="openmodularturrets", name="Open Modular Turrets", version="2.2.9-232", acceptedMinecraftVersions="1.7.10", dependencies="after:ThermalFoundation;after:ThermalExpansion;after:OpenComputers;after:ComputerCraft;after:Mekanism;after:EnderIO;after:Thaumcraft")
public class ModularTurrets {
    @Mod.Instance(value="openmodularturrets")
    public static ModularTurrets instance;
    @SidedProxy(clientSide="openmodularturrets.proxy.ClientProxy", serverSide="openmodularturrets.proxy.CommonProxy")
    public static CommonProxy proxy;
    public static CreativeTabs modularTurretsTab;
    private GuiHandler gui;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        ConfigHandler.init(event.getSuggestedConfigurationFile());
        this.gui = new GuiHandler();
        modularTurretsTab = new ModularTurretsTab("openmodularturrets");
        ModCompatibility.checkForMods();
        Items.init();
        Blocks.init();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        ModCompatibility.performModCompat();
        NetworkingHandler.initNetworking();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)this.gui);
        TileEntityHandler.init();
        proxy.initRenderers();
        proxy.initHandlers();
        RecipeHandler.initRecipes();
        ProjectileEntityHandler.registerProjectiles(this);
        DungeonLootHandler.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        ModCompatibility.fixIC2Loading();
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandChangeOwner());
    }
}

