/*
 * Decompiled with CFR 0.152.
 */
package cavebiomes.worldgeneration.cavetypes.shallow;

import cavebiomes.api.CaveType;
import cavebiomes.api.DungeonSet;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import wtfcore.api.BlockSets;

public class CaveTypeSwamp
extends CaveType {
    public CaveTypeSwamp(int cavedepth, DungeonSet swampSet) {
        super("Swamp", cavedepth, swampSet);
    }

    @Override
    public void generateCeiling(World world, Random random, int x, int y, int z) {
        if (random.nextInt(4) == 0) {
            gen.transformBlock(world, x, y, z, BlockSets.Modifier.lavaDrippinStone);
        }
    }

    @Override
    public void generateCeilingAddons(World world, Random random, int x, int y, int z) {
        if (random.nextBoolean() && !gen.GenVines(world, x, y, z)) {
            gen.genStalactite(world, x, y, z, this.depth);
        }
    }

    @Override
    public void generateFloor(World world, Random random, int x, int y, int z) {
        int height = 6 + MathHelper.func_76130_a((int)(MathHelper.func_76130_a((int)(x - z)) % 10 - 5)) + (random.nextInt(3) - 1);
        BlockSets.Modifier[] swampBlock = new BlockSets.Modifier[]{BlockSets.Modifier.mossy_cobblestone, BlockSets.Modifier.cobblestone, BlockSets.Modifier.MossyStone};
        BlockSets.Modifier addonblock = swampBlock[random.nextInt(swampBlock.length)];
        if (height < 9) {
            if (gen.IsBlockSurrounded(world, x, y, z)) {
                gen.setFluid(world, x, y, z, Blocks.field_150355_j, addonblock);
                if (random.nextInt(8) == 0 && Blocks.field_150392_bi.func_149718_j(world, x, y + 1, z)) {
                    gen.setBlockWithoutNotify(world, x, y + 1, z, Blocks.field_150392_bi, 0);
                }
            }
        } else if (this.shouldGenFloorAddon(random) && addonblock == null) {
            gen.genStalagmite(world, x, y, z, this.depth);
        }
    }
}

