/*
 * Decompiled with CFR 0.152.
 */
package cavebiomes.worldgeneration;

import cavebiomes.EventListener;
import cavebiomes.WTFCaveBiomesConfig;
import cavebiomes.utilities.gencores.VanillaGen;
import java.util.HashSet;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import wtfcore.WTFCore;
import wtfcore.utilities.DungeonBlockPosition;

public class DungeonType {
    int xmin = -5;
    int xmax = 5;
    int ymin = -5;
    int ymax = 5;
    int zmin = -5;
    int zmax = 5;
    float radius = 6.0f;
    protected Random random = new Random();
    protected Block modifier;
    public String name;
    protected static VanillaGen gen;

    public DungeonType(String name) {
        this.name = name;
        gen = VanillaGen.getGenMethods();
    }

    public void SpawnDungeon(World world, Random rand, int x, int y, int z, int ceiling, int floor) {
        int k;
        int i;
        this.modifier = BiomeDictionary.isBiomeOfType((BiomeGenBase)world.func_72807_a(x, z), (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY) ? Blocks.field_150432_aD : null;
        if (WTFCaveBiomesConfig.logDungeons) {
            EventListener.thePlayer.func_145747_a((IChatComponent)new ChatComponentText("Spawning " + this.name + " @ " + x + " " + y + " " + z));
            WTFCore.log.info("Spawning " + this.name + " @ " + x + " " + y + " " + z);
        }
        HashSet<DungeonBlockPosition> hashset = new HashSet<DungeonBlockPosition>();
        HashSet<DungeonBlockPosition> air = new HashSet<DungeonBlockPosition>();
        for (int xloop = this.xmin; xloop < this.xmax + 1; ++xloop) {
            for (int yloop = this.ymin; yloop < this.ymax + 1; ++yloop) {
                for (int zloop = this.zmin; zloop < this.zmax + 1; ++zloop) {
                    if (xloop != this.xmin && xloop != this.xmax && yloop != this.ymin && yloop != this.ymax && zloop != this.zmin && zloop != this.zmax) continue;
                    double d3 = 0 + xloop;
                    double d4 = 0 + yloop;
                    double d5 = 0 + zloop;
                    double vectorLength = Math.sqrt(d3 * d3 + d4 * d4 + d5 * d5);
                    d3 /= vectorLength;
                    d4 /= vectorLength;
                    d5 /= vectorLength;
                    double currentX = (double)x + 0.5;
                    double currentY = (double)y + 0.5;
                    double currentZ = (double)z + 0.5;
                    Boolean cont = true;
                    float f2 = 0.3f;
                    for (float vectorStr = this.radius; vectorStr > 0.0f && cont.booleanValue(); vectorStr -= f2 * 0.75f) {
                        int k2;
                        int j;
                        int i2 = MathHelper.func_76128_c((double)currentX);
                        if (!world.func_147437_c(i2, j = MathHelper.func_76128_c((double)currentY), k2 = MathHelper.func_76128_c((double)currentZ))) {
                            hashset.add(new DungeonBlockPosition(i2, j, k2, false));
                            cont = false;
                        } else {
                            air.add(new DungeonBlockPosition(i2, j, k2, false));
                        }
                        vectorStr -= 0.3f;
                        currentX += d3 * (double)f2;
                        currentY += d4 * (double)f2;
                        currentZ += d5 * (double)f2;
                    }
                }
            }
        }
        for (DungeonBlockPosition chunkposition : hashset) {
            i = chunkposition.field_151329_a;
            int j = chunkposition.field_151327_b;
            k = chunkposition.field_151328_c;
            if (j < y && !world.func_147439_a(i, j + 1, k).func_149686_d()) {
                this.generateFloor(world, rand, i, j, k);
                continue;
            }
            if (j > y && !world.func_147439_a(i, j - 1, k).func_149686_d()) {
                this.generateCeiling(world, rand, i, j, k);
                continue;
            }
            this.generateWalls(world, rand, i, j, k);
        }
        this.generateCenter(world, rand, x, y, z, ceiling, floor);
        for (DungeonBlockPosition chunkposition : air) {
            i = chunkposition.field_151329_a;
            int j = chunkposition.field_151327_b;
            k = chunkposition.field_151328_c;
            this.generateFill(world, rand, i, j, k);
        }
    }

    public void generateCeiling(World world, Random rand, int x, int y, int z) {
    }

    public void generateFloor(World world, Random rand, int x, int y, int z) {
    }

    public void generateWalls(World world, Random rand, int x, int y, int z) {
    }

    public void generateCenter(World world, Random rand, int x, int y, int z, int ceiling, int floor) {
    }

    public void generateFill(World world, Random rand, int x, int y, int z) {
    }
}

