/*
 * Decompiled with CFR 0.152.
 */
package cavebiomes.utilities.gencores;

import cavebiomes.WTFCaveBiomesConfig;
import cavebiomes.blocks.BlockIcicle;
import cavebiomes.blocks.CaveBlocks;
import cavebiomes.utilities.gencores.UBCGen;
import cpw.mods.fml.common.Loader;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.util.BlockSnapshot;
import wtfcore.WTFCore;
import wtfcore.api.BlockInfo;
import wtfcore.api.BlockSets;
import wtfcore.api.GenCoreBase;
import wtfcore.api.Replacer;

public class VanillaGen
implements GenCoreBase {
    public Random random = new Random();

    public static VanillaGen getGenMethods() {
        if (Loader.isModLoaded((String)"UndergroundBiomes")) {
            return new UBCGen();
        }
        return new VanillaGen();
    }

    public void transformBlock(World world, int x, int y, int z, BlockSets.Modifier modifier) {
        BlockInfo blockandmeta = this.getBlockToReplace(world, x, y, z);
        Block blockToSet = (Block)BlockSets.blockTransformer.get(new BlockInfo(blockandmeta.block, blockandmeta.meta, modifier));
        if (blockToSet != null) {
            this.setBlockWithoutNotify(world, x, y, z, blockToSet, blockandmeta.meta);
        }
    }

    public void replaceBlock(World world, int x, int y, int z, Block block, int metadata) {
        if (BlockSets.ReplaceHashset.contains(world.func_147439_a(x, y, z))) {
            this.setBlockWithoutNotify(world, x, y, z, block, metadata);
        }
    }

    public void setStoneAddon(World world, int x, int y, int z, BlockSets.Modifier modifier) {
        BlockInfo blockandmeta = this.getBlockToReplace(world, x, y, z);
        Block blockToSet = (Block)BlockSets.blockTransformer.get(new BlockInfo(blockandmeta.block, blockandmeta.meta, modifier));
        if (blockToSet != null) {
            this.setBlockWithoutNotify(world, x, y + 1, z, blockToSet, blockandmeta.meta);
        }
    }

    public void freezeBlock(World world, int x, int y, int z) {
        if (world.func_147439_a(x, y, z).func_149686_d() && world.func_147437_c(x, y + 1, z)) {
            this.setBlockWithoutNotify(world, x, y + 1, z, CaveBlocks.IcePatch, 0);
        }
    }

    public void setFluid(World world, int x, int y, int z, Block fluid) {
        this.setFluid(world, x, y, z, fluid, null);
    }

    public void setFluid(World world, int x, int y, int z, Block fluid, BlockSets.Modifier modifier) {
        if (BlockSets.ReplaceHashset.contains(world.func_147439_a(x, y, z))) {
            this.setBlockWithoutNotify(world, x, y, z, fluid, 0);
            world.func_147464_a(x, y, z, fluid, this.random.nextInt(200) + 100);
            if (modifier != null) {
                this.transformBlock(world, x, y - 1, z, modifier);
            }
        }
    }

    public void genFloatingStone(World world, int x, int y, int z, Block modifier) {
        this.setBlockWithoutNotify(world, x, y, z, modifier, 0);
    }

    public void genStalagmite(World world, int x, int y, int z, int depth) {
        this.genStalagmite(world, x, y, z, depth, null);
    }

    public void genStalagmite(World world, int x, int y, int z, int depth, Block modifier) {
        float size = this.random.nextFloat();
        switch (depth) {
            case 1: {
                if (size < 0.95f) {
                    this.genStalagmite(world, x, y, z, modifier, 1);
                    break;
                }
                this.genStalagmite(world, x, y, z, modifier, 2);
                break;
            }
            case 2: {
                if (size < 0.85f) {
                    this.genStalagmite(world, x, y, z, modifier, 1);
                    break;
                }
                if (size < 0.95f) {
                    this.genStalagmite(world, x, y, z, modifier, 2);
                    break;
                }
                this.genStalagmite(world, x, y, z, modifier, 3);
                break;
            }
            case 3: {
                if (size < 0.55f) {
                    this.genStalagmite(world, x, y, z, modifier, 1);
                    break;
                }
                if (size < 0.85f) {
                    this.genStalagmite(world, x, y, z, modifier, 2);
                    break;
                }
                this.genStalagmite(world, x, y, z, modifier, 3);
            }
        }
    }

    public void genStalagmite(World world, int x, int y, int z, Block modifier, int size) {
        BlockInfo blockandmetadata = this.getBlockToReplace(world, x, y, z);
        Block block = blockandmetadata.block;
        int metadata = blockandmetadata.meta;
        if (!CaveBlocks.speleothemMap.containsKey(block)) {
            return;
        }
        ++y;
        Block[] speleothemSet = CaveBlocks.getSpeleothemSet(block, modifier);
        if (size == 1) {
            this.setBlockWithoutNotify(world, x, y, z, speleothemSet[4], metadata);
        } else if (size == 2) {
            this.setBlockWithoutNotify(world, x, y, z, speleothemSet[5], metadata);
            this.setBlockWithoutNotify(world, x, y + 1, z, speleothemSet[6], metadata);
        } else {
            this.setBlockWithoutNotify(world, x, y, z, speleothemSet[5], metadata);
            this.setBlockWithoutNotify(world, x, y + 1, z, speleothemSet[3], metadata);
            if (world.func_147439_a(x, y + 3, z) == block) {
                this.setBlockWithoutNotify(world, x, y + 2, z, speleothemSet[1], metadata);
                return;
            }
            this.setBlockWithoutNotify(world, x, y + 2, z, speleothemSet[6], metadata);
            return;
        }
    }

    public void genStalactite(World world, int x, int y, int z, int depth) {
        this.genStalactite(world, x, y, z, depth, null);
    }

    public void genStalactite(World world, int x, int y, int z, int depth, Block modifier) {
        float size = this.random.nextFloat();
        switch (depth) {
            case 1: {
                if (size < 0.85f) {
                    this.genStalactite(world, x, y, z, depth, modifier, 1);
                    break;
                }
                this.genStalactite(world, x, y, z, depth, modifier, 2);
                break;
            }
            case 2: {
                if (size < 0.65f) {
                    this.genStalactite(world, x, y, z, depth, modifier, 1);
                    break;
                }
                if (size < 0.9f) {
                    this.genStalactite(world, x, y, z, depth, modifier, 2);
                    break;
                }
                this.genStalactite(world, x, y, z, depth, modifier, 3);
                break;
            }
            case 3: {
                if (size < 0.5f) {
                    this.genStalactite(world, x, y, z, depth, modifier, 1);
                    break;
                }
                if (size < 0.85f) {
                    this.genStalactite(world, x, y, z, depth, modifier, 2);
                    break;
                }
                this.genStalactite(world, x, y, z, depth, modifier, 3);
            }
        }
    }

    public void genStalactite(World world, int x, int y, int z, int depth, Block modifier, int size) {
        if (!world.func_147437_c(x, y - 1, z)) {
            return;
        }
        BlockInfo blockandmetadata = this.getBlockToReplace(world, x, y, z);
        Block base = blockandmetadata.block;
        int metadata = blockandmetadata.meta;
        Block[] speleothemSet = CaveBlocks.getSpeleothemSet(base, modifier);
        if (CaveBlocks.speleothemMap.containsKey(base)) {
            for (int i = 0; i < size; ++i) {
                Block down1 = world.func_147439_a(x, y - i - 1, z);
                if (i == 0) {
                    if (size > 1 && down1 == Blocks.field_150350_a) {
                        this.setBlockWithoutNotify(world, x, y - i, z, speleothemSet[1], metadata);
                        continue;
                    }
                    this.setBlockWithoutNotify(world, x, y - i, z, speleothemSet[0], metadata);
                } else {
                    if (i < size - 1 && down1 == Blocks.field_150350_a) {
                        this.setBlockWithoutNotify(world, x, y - i, z, speleothemSet[3], metadata);
                        continue;
                    }
                    if (down1 == base) {
                        this.setBlockWithoutNotify(world, x, y - i, z, speleothemSet[5], metadata);
                    } else {
                        this.setBlockWithoutNotify(world, x, y - i, z, speleothemSet[2], metadata);
                    }
                }
                break;
            }
        } else if (base == Blocks.field_150346_d && depth < 2) {
            if (modifier == Blocks.field_150432_aD) {
                this.setBlockWithoutNotify(world, x, y, z, CaveBlocks.frozenRoots, 0);
            } else {
                this.setBlockWithoutNotify(world, x, y, z, CaveBlocks.Roots, 0);
            }
        }
    }

    public void genIcicle(World world, int x, int y, int z) {
        if (this.random.nextBoolean()) {
            this.setBlockWithoutNotify(world, x, y, z, BlockIcicle.IcicleLargeBase, 0);
            this.setBlockWithoutNotify(world, x, y - 1, z, BlockIcicle.IcicleLargeTip, 0);
        } else {
            this.setBlockWithoutNotify(world, x, y, z, BlockIcicle.IcicleSmall, 0);
        }
    }

    public boolean IsBlockSurrounded(World world, int x, int y, int z) {
        return !world.func_147437_c(x + 1, y, z) && !world.func_147437_c(x - 1, y, z) && !world.func_147437_c(x, y, z + 1) && !world.func_147437_c(x, y, z - 1) && !world.func_147437_c(x, y - 1, z);
    }

    public boolean GenVines(World world, int x, int y, int z) {
        int metadata = 0;
        boolean spawn = false;
        if (!(world.func_147437_c(x + 1, y, z) || world.func_147437_c(x - 1, y, z) || world.func_147437_c(x, y, z + 1) || world.func_147437_c(x, y, z - 1))) {
            return false;
        }
        if (world.func_147439_a(x, y, z - 1).func_149686_d()) {
            metadata = 4;
            spawn = true;
        } else if (world.func_147439_a(x, y, z + 1).func_149686_d()) {
            metadata = 1;
            spawn = true;
        } else if (world.func_147439_a(x - 1, y, z).func_149686_d()) {
            metadata = 2;
            spawn = true;
        } else if (world.func_147439_a(x + 1, y, z).func_149686_d()) {
            metadata = 8;
            spawn = true;
        }
        if (spawn) {
            for (int loop = 0; loop < this.random.nextInt(4) + 3 && world.func_147437_c(x, y - loop, z); ++loop) {
                world.func_147465_d(x, y - loop, z, CaveBlocks.lavaVine, metadata, 0);
            }
        }
        return spawn;
    }

    public BlockInfo getBlockToReplace(World world, int x, int y, int z) {
        return new BlockInfo(world.func_147439_a(x, y, z), world.func_72805_g(x, y, z));
    }

    public void spawnVanillaSpawner(World world, int x, int y, int z, String entityName) {
        if (WTFCaveBiomesConfig.EnableMobSpawners) {
            world.func_147465_d(x, y, z, Blocks.field_150474_ac, 0, 2);
            TileEntityMobSpawner spawner = (TileEntityMobSpawner)world.func_147438_o(x, y, z);
            if (spawner != null) {
                spawner.func_145881_a().func_98272_a(entityName);
            } else {
                WTFCore.log.info("VanillaGen: SpawnVanillaSpawner- failed to set spawner entity");
            }
        }
    }

    public void spawnRareVanillaSpawner(World world, int x, int y, int z, String entityName) {
        if (WTFCaveBiomesConfig.EnableMobSpawners) {
            world.func_147465_d(x, y, z, Blocks.field_150474_ac, 0, 2);
            TileEntityMobSpawner spawner = (TileEntityMobSpawner)world.func_147438_o(x, y, z);
            spawner.func_145881_a().func_98272_a(entityName);
            NBTTagCompound nbt = new NBTTagCompound();
            spawner.func_145841_b(nbt);
            nbt.func_74777_a("spawnCount", (short)2);
            nbt.func_74777_a("MinSpawnDelay", (short)600);
            spawner.func_145839_a(nbt);
        }
    }

    public boolean setBlockWithoutNotify(World world, int x, int y, int z, Block block, int metadata) {
        boolean flag;
        int flags = 0;
        Chunk chunk = world.func_72964_e(x >> 4, z >> 4);
        BlockSnapshot blockSnapshot = null;
        if (flags & true) {
            // empty if block
        }
        if (world.captureBlockSnapshots && !world.field_72995_K) {
            blockSnapshot = BlockSnapshot.getBlockSnapshot((World)world, (int)x, (int)y, (int)z, (int)flags);
            world.capturedBlockSnapshots.add(blockSnapshot);
        }
        if (!(flag = chunk.func_150807_a(x & 0xF, y, z & 0xF, block, metadata)) && blockSnapshot != null) {
            world.capturedBlockSnapshots.remove(blockSnapshot);
            blockSnapshot = null;
        }
        return flag;
    }

    public void replaceBlockDuringGen(Chunk chunk, Block oldBlock, int x, int y, int z) {
        Replacer replacer = (Replacer)BlockSets.genReplace.get(oldBlock);
        replacer.doReplace(chunk, x, y, z, oldBlock);
    }
}

