/*
 * Decompiled with CFR 0.152.
 */
package cavebiomes.utilities;

import cavebiomes.blocks.BlockMagmaCrust;
import cavebiomes.blocks.BlockSpeleothems;
import cavebiomes.blocks.DrippingBlock;
import cavebiomes.blocks.MossyStone;
import net.minecraft.block.Block;
import wtfcore.api.BlockInfo;
import wtfcore.api.BlockSets;
import wtfcore.api.IStoneRegister;
import wtfcore.utilities.LoadBlockSets;

public class StoneRegister
implements IStoneRegister {
    private Block stone;
    private Block cobblestone;
    private String unlocalisedName;
    private String[] stoneTextureNames;
    private String[] cobbleTextureNames;
    private String domain;
    public boolean speleothems = true;
    public boolean lavacrust = true;
    public boolean mossyStone = true;
    public boolean mossyCobble = true;
    public boolean drippingWater = true;
    public boolean drippingLava = true;
    public boolean cobbleFall = true;
    public boolean genReplaceable = true;

    public StoneRegister(Block stone, Block cobblestone, String unlocalisedName, String[] stoneTextureNames, String[] cobbleTextureNames, String domain) {
        this.stone = stone;
        this.cobblestone = cobblestone;
        this.unlocalisedName = unlocalisedName;
        this.stoneTextureNames = stoneTextureNames;
        this.cobbleTextureNames = cobbleTextureNames;
        this.domain = domain;
    }

    public StoneRegister(Block stone, Block cobblestone, String unlocalisedName, String stoneTextureName, String cobbleTextureName, String domain) {
        this.stone = stone;
        this.cobblestone = cobblestone;
        this.unlocalisedName = unlocalisedName;
        this.stoneTextureNames = new String[1];
        this.stoneTextureNames[0] = stoneTextureName;
        this.cobbleTextureNames = new String[1];
        this.cobbleTextureNames[0] = cobbleTextureName;
        this.domain = domain;
    }

    public void register() {
        BlockSets.blockTransformer.put(new BlockInfo(this.stone, 0, BlockSets.Modifier.cobblestone), this.cobblestone);
        if (this.genReplaceable) {
            BlockSets.ReplaceHashset.add(this.stone);
        }
        BlockSets.surfaceBlocks.add(this.stone);
        if (this.cobbleFall) {
            LoadBlockSets.addDefaultFallingBlock((Block)this.cobblestone, (int)1);
        }
        if (this.mossyStone) {
            String mossyStoneName = this.unlocalisedName;
            if (!mossyStoneName.endsWith("stone")) {
                mossyStoneName = mossyStoneName + "_stone";
            }
            MossyStone.registerMossyBlock(this.stone, mossyStoneName, this.stoneTextureNames, this.domain);
        }
        if (this.mossyCobble) {
            String mossyCobbleName = this.unlocalisedName;
            if (!mossyCobbleName.endsWith("cobblestone")) {
                mossyCobbleName = mossyCobbleName + "_cobblestone";
            }
            MossyStone.registerMossyCobble(this.cobblestone, mossyCobbleName, this.cobbleTextureNames, this.domain);
        }
        if (this.lavacrust) {
            BlockMagmaCrust.registerMagmaCrust(this.stone, this.unlocalisedName, this.cobbleTextureNames, this.domain);
        }
        if (this.speleothems) {
            BlockSpeleothems.registerSpeleothemSet(this.stone, this.unlocalisedName, this.stoneTextureNames, this.domain);
        }
        DrippingBlock.registerDrippingStoneSet(this.stone, this.unlocalisedName, this.stoneTextureNames.length, this.drippingWater, this.drippingLava);
        BlockSets.stoneRegisters.put(this.unlocalisedName, this);
    }
}

