/*
 * Decompiled with CFR 0.152.
 */
package cavebiomes.blocks;

import cavebiomes.CaveBiomes;
import cavebiomes.items.ItemMoss;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import texturegeneratorlib.TextureGeneratorLib;
import wtfcore.WTFCore;
import wtfcore.api.BlockInfo;
import wtfcore.api.BlockSets;
import wtfcore.blocks.ChildBlockCarryMetadata;
import wtfcore.items.ItemMetadataSubblock;
import wtfcore.utilities.LoadBlockSets;

public class MossyStone
extends ChildBlockCarryMetadata {
    protected String[] textureNames;
    protected String[] parentLocations;
    public static Block MossyStone;
    public static Block MossyIgneous;
    public static Block MossyMetamorphic;
    public static Block MossySedimentary;
    public static Block MossyIgneousCobble;
    public static Block MossyMetamorphicCobble;
    public static Block blockToRegister;
    int parentMeta;
    static Block childBlockToRegister;
    private IIcon[] textures;

    protected MossyStone(Block block, String[] stoneNames, String domain) {
        super(block);
        this.loadTextureStrings(stoneNames, domain);
        this.func_149647_a(CaveBiomes.tabCaveDecorations);
    }

    public void loadTextureStrings(String[] stoneNames, String domain) {
        this.textureNames = new String[stoneNames.length];
        this.parentLocations = new String[stoneNames.length];
        for (int loop = 0; loop < stoneNames.length; ++loop) {
            this.textureNames[loop] = "mossy_" + stoneNames[loop];
            this.parentLocations[loop] = domain + ":" + stoneNames[loop];
        }
    }

    public static Block registerMossyBlock(Block block, String unlocalisedName, String[] stoneNames, String domain) {
        String name = "mossy_" + unlocalisedName;
        blockToRegister = new MossyStone(block, stoneNames, domain).func_149663_c(name);
        GameRegistry.registerBlock((Block)blockToRegister, ItemMetadataSubblock.class, (String)name);
        BlockSets.blockTransformer.put(new BlockInfo(block, 0, BlockSets.Modifier.MossyStone), blockToRegister);
        return blockToRegister;
    }

    public static Block registerMossyCobble(Block block, String unlocalisedName, String[] stoneNames, String domain) {
        String name = "mossy_" + unlocalisedName;
        blockToRegister = new MossyStone(block, stoneNames, domain).func_149663_c(name);
        GameRegistry.registerBlock((Block)blockToRegister, ItemMetadataSubblock.class, (String)name);
        BlockSets.blockTransformer.put(new BlockInfo(block, 0, BlockSets.Modifier.mossy_cobblestone), blockToRegister);
        LoadBlockSets.addDefaultFallingBlock((Block)blockToRegister, (int)1);
        return blockToRegister;
    }

    public boolean canSilkHarvest(World world, EntityPlayer player, int x, int y, int z, int metadata) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return this.textures[meta];
    }

    public void func_149651_a(IIconRegister iconRegister) {
        this.textures = new IIcon[16];
        for (int loop = 0; loop < this.textureNames.length; ++loop) {
            this.textures[loop] = iconRegister.func_94245_a("CaveBiomes:" + this.textureNames[loop]);
            TextureGeneratorLib.registerBlockOverlay((Block)this, (String)this.textureNames[loop], (String)this.parentLocations[loop], (String)"moss_overlay", (String)CaveBiomes.overlayDomain, (boolean)false);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < this.textureNames.length; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    public void func_149636_a(World world, EntityPlayer player, int x, int y, int z, int meta) {
        player.func_71064_a(StatList.field_75934_C[cavebiomes.blocks.MossyStone.func_149682_b((Block)this)], 1);
        player.func_71020_j(0.025f);
        if (this.canSilkHarvest(world, player, x, y, z, meta) && EnchantmentHelper.func_77502_d((EntityLivingBase)player)) {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            ItemStack itemstack = this.func_149644_j(meta);
            if (itemstack != null) {
                items.add(itemstack);
            }
            ForgeEventFactory.fireBlockHarvesting(items, (World)world, (Block)this, (int)x, (int)y, (int)z, (int)meta, (int)0, (float)1.0f, (boolean)true, (EntityPlayer)player);
            for (ItemStack is : items) {
                this.func_149642_a(world, x, y, z, is);
            }
        } else {
            float f = 0.7f;
            double d0 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d1 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            EntityItem mossdrop = new EntityItem(world, (double)x + d0, (double)y + d1, (double)z + d2, new ItemStack(ItemMoss.moss));
            world.func_72838_d((Entity)mossdrop);
            WTFCore.log.info("Dropping moss");
            this.parentBlock.func_149636_a(world, player, x, y, z, meta);
        }
    }
}

