/*
 * Decompiled with CFR 0.152.
 */
package cavebiomes.blocks;

import cavebiomes.CaveBiomes;
import cavebiomes.WTFCaveBiomesConfig;
import cavebiomes.renderers.RenderRegisterer;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import texturegeneratorlib.TextureGeneratorLib;
import wtfcore.api.BlockInfo;
import wtfcore.api.BlockSets;
import wtfcore.blocks.ChildBlockCarryMetadata;
import wtfcore.items.ItemMetadataSubblock;

public class BlockMagmaCrust
extends ChildBlockCarryMetadata {
    public ResourceLocation resourceDomain;
    public ResourceLocation textureLocation;
    private IIcon[] textures;
    protected String[] textureNames;
    protected String[] parentLocations;

    public BlockMagmaCrust(Block block, String[] stoneNames, String domain) {
        super(block);
        this.func_149647_a(CaveBiomes.tabCaveDecorations);
        this.loadTextureStrings(stoneNames, domain);
        if (WTFCaveBiomesConfig.lavacrustGlow) {
            this.func_149715_a(0.2f);
        }
    }

    public void loadTextureStrings(String[] stoneNames, String domain) {
        this.textureNames = new String[stoneNames.length];
        this.parentLocations = new String[stoneNames.length];
        for (int loop = 0; loop < stoneNames.length; ++loop) {
            this.textureNames[loop] = stoneNames[loop] + "_lavacrust";
            this.parentLocations[loop] = domain + ":" + stoneNames[loop];
        }
    }

    public static Block registerMagmaCrust(Block block, String unlocalisedName, String[] stoneNames, String domain) {
        unlocalisedName = unlocalisedName + "_lavacrust";
        Block blockToRegister = new BlockMagmaCrust(block, stoneNames, domain).func_149663_c(unlocalisedName);
        GameRegistry.registerBlock((Block)blockToRegister, ItemMetadataSubblock.class, (String)unlocalisedName);
        BlockSets.blockTransformer.put(new BlockInfo(block, 0, BlockSets.Modifier.stoneMagmaCrust), blockToRegister);
        BlockSets.meltBlocks.add(blockToRegister);
        return blockToRegister;
    }

    public void func_149651_a(IIconRegister iconRegister) {
        this.textures = new IIcon[16];
        for (int loop = 0; loop < this.textureNames.length; ++loop) {
            this.textures[loop] = iconRegister.func_94245_a("CaveBiomes:" + this.textureNames[loop]);
            TextureGeneratorLib.registerBlockOverlay((Block)this, (String)this.textureNames[loop], (String)this.parentLocations[loop], (String)"lavacrust", (String)CaveBiomes.alphaMaskDomain, (boolean)true);
        }
    }

    public boolean canSilkHarvest(World world, EntityPlayer player, int x, int y, int z, int metadata) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < this.textureNames.length; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return this.textures[meta];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        return this.func_149691_a(side, world.func_72805_g(x, y, z));
    }

    public Item func_149650_a(int metadata, Random random, int fortune) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149686_d() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149645_b() {
        return RenderRegisterer.MagmaCrustRenderType;
    }

    public void func_149664_b(World world, int x, int y, int z, int meta) {
        world.func_147465_d(x, y, z, (Block)Blocks.field_150356_k, 0, 3);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random random) {
        double d7;
        double d6;
        double d5;
        if (!WTFCaveBiomesConfig.lavacrustAnimations) {
            return;
        }
        if (random.nextInt(30) == 0 && world.func_147437_c(x, y - 1, z) && WTFCaveBiomesConfig.enableDrippingBlocks) {
            d5 = (float)x + random.nextFloat();
            d6 = (double)y - 0.05;
            d7 = (float)z + random.nextFloat();
            world.func_72869_a("dripLava", d5, d6, d7, 0.0, 0.0, 0.0);
        }
        if (random.nextInt(15) == 0 && world.func_147437_c(x, y + 1, z)) {
            d5 = (float)x + random.nextFloat();
            d6 = (double)y + this.field_149756_F;
            d7 = (float)z + random.nextFloat();
            world.func_72869_a("smoke", d5, d6, d7, 0.0, 0.0, 0.0);
            world.func_72980_b(d5, d6, d7, "liquid.lavapop", 0.2f + random.nextFloat() * 0.2f, 0.9f + random.nextFloat() * 0.15f, false);
        }
        if (random.nextInt(200) == 0) {
            world.func_72980_b((double)x, (double)y, (double)z, "liquid.lava", 0.2f + random.nextFloat() * 0.2f, 0.9f + random.nextFloat() * 0.15f, false);
        }
    }
}

