/*
 * Decompiled with CFR 0.152.
 */
package cavebiomes;

import cavebiomes.api.APICaveBiomes;
import cavebiomes.api.CaveType;
import cavebiomes.api.DungeonType;
import cavebiomes.blocks.CaveBlocks;
import cavebiomes.utilities.BiomeAndHeight;
import cavebiomes.utilities.StoneRegister;
import cavebiomes.worldgeneration.CaveTypeRegister;
import cavebiomes.worldgeneration.dungeontypes.DungeonTypeRegister;
import net.minecraft.block.Block;
import net.minecraft.world.biome.BiomeGenBase;
import wtfcore.WTFCore;

public class CaveBiomesAPI
extends APICaveBiomes {
    @Override
    public void addCaveType(CaveType cavetype, BiomeGenBase biome, int depth) {
        if (depth > 0 && depth < 4) {
            CaveTypeRegister.cavebiomemap.put(new BiomeAndHeight(biome, depth), cavetype);
        } else {
            WTFCore.log.info("CaveBiomesAPI: CaveType had depth outside acceptable range " + cavetype.name);
        }
    }

    @Override
    public void addDungeon(DungeonType dungeon, APICaveBiomes.DungeonBiomeType biometype) {
        if (biometype == APICaveBiomes.DungeonBiomeType.DEFAULT) {
            DungeonTypeRegister.defaultSet.addDungeon(dungeon);
        } else if (biometype == APICaveBiomes.DungeonBiomeType.FOREST) {
            DungeonTypeRegister.forestSet.addDungeon(dungeon);
        } else if (biometype == APICaveBiomes.DungeonBiomeType.WET) {
            DungeonTypeRegister.wetSet.addDungeon(dungeon);
        } else if (biometype == APICaveBiomes.DungeonBiomeType.SWAMP) {
            DungeonTypeRegister.swampSet.addDungeon(dungeon);
        } else if (biometype == APICaveBiomes.DungeonBiomeType.DESERT) {
            DungeonTypeRegister.desertSet.addDungeon(dungeon);
        } else if (biometype == APICaveBiomes.DungeonBiomeType.JUNGLE) {
            DungeonTypeRegister.jungleSet.addDungeon(dungeon);
        } else if (biometype == APICaveBiomes.DungeonBiomeType.COLD) {
            DungeonTypeRegister.coldSet.addDungeon(dungeon);
        } else if (biometype == APICaveBiomes.DungeonBiomeType.VOLCANIC) {
            DungeonTypeRegister.volcanicSet.addDungeon(dungeon);
        } else if (biometype == APICaveBiomes.DungeonBiomeType.MOUNTAIN) {
            DungeonTypeRegister.mountainSet.addDungeon(dungeon);
        }
    }

    @Override
    public StoneRegister getStoneInfo(Block stone, Block cobblestone, String unlocalisedName, String[] stoneTextureNames, String[] cobbleTextureNames, String domain) {
        return CaveBlocks.getStoneRegister(stone, cobblestone, unlocalisedName, stoneTextureNames, cobbleTextureNames, domain);
    }
}

