/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI;

import Reika.DragonAPI.Auxiliary.Trackers.ReflectiveFailureTracker;
import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.Base.ModHandlerBase;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Interfaces.Registry.Dependency;
import Reika.DragonAPI.Interfaces.Registry.ModEntry;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Java.ReikaStringParser;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public enum ModList implements ModEntry,
Dependency
{
    ROTARYCRAFT("RotaryCraft", "Reika.RotaryCraft.Registry.BlockRegistry", "Reika.RotaryCraft.Registry.ItemRegistry"),
    REACTORCRAFT("ReactorCraft", "Reika.ReactorCraft.Registry.ReactorBlocks", "Reika.ReactorCraft.Registry.ReactorItems"),
    EXPANDEDREDSTONE("ExpandedRedstone"),
    GEOSTRATA("GeoStrata"),
    CRITTERPET("CritterPet"),
    VOIDMONSTER("VoidMonster"),
    USEFULTNT("UsefulTNT"),
    METEORCRAFT("MeteorCraft"),
    CAVECONTROL("CaveControl"),
    LEGACYCRAFT("LegacyCraft"),
    ELECTRICRAFT("ElectriCraft", "Reika.ElectriCraft.Registry.ElectriBlocks", "Reika.ElectriCraft.Registry.ElectriItems"),
    CHROMATICRAFT("ChromatiCraft", "Reika.ChromatiCraft.Registry.ChromaBlocks", "Reika.ChromatiCraft.Registry.ChromaItems"),
    CONDENSEDORES("CondensedOres"),
    BUILDCRAFT("BuildCraft|Core", "buildcraft.BuildCraftCore"),
    BCENERGY("BuildCraft|Energy", "buildcraft.BuildCraftEnergy"),
    BCFACTORY("BuildCraft|Factory", "buildcraft.BuildCraftFactory"),
    BCTRANSPORT("BuildCraft|Transport", "buildcraft.BuildCraftTransport"),
    BCSILICON("BuildCraft|Silicon", "buildcraft.BuildCraftSilicon"),
    THAUMCRAFT("Thaumcraft", "thaumcraft.common.config.ConfigBlocks", "thaumcraft.common.config.ConfigItems"),
    IC2("IC2", "ic2.core.Ic2Items"),
    GREGTECH("gregtech"),
    FORESTRY("Forestry"),
    APPENG("appliedenergistics2"),
    MFFS("MFFS", "mffs.ModularForceFieldSystem"),
    REDPOWER("RedPower"),
    TWILIGHT("TwilightForest", "twilightforest.block.TFBlocks", "twilightforest.item.TFItems"),
    NATURA("Natura", "mods.natura.common.NContent"),
    BOP("BiomesOPlenty", "biomesoplenty.api.content.BOPCBlocks", "biomesoplenty.api.content.BOPCItems"),
    BXL("ExtraBiomesXL"),
    MINEFACTORY("MineFactoryReloaded", "powercrystals.minefactoryreloaded.setup.MFRThings"),
    DARTCRAFT("DartCraft", "bluedart.Blocks.DartBlock", "bluedart.Items.DartItem"),
    TINKERER("TConstruct", "tconstruct.world.TinkerWorld"),
    THERMALEXPANSION("ThermalExpansion", new String[]{"thermalexpansion.block.TEBlocks", "cofh.thermalexpansion.block.TEBlocks"}, new String[]{"thermalexpansion.item.TEItems", "cofh.thermalexpansion.item.TEItems"}),
    THERMALFOUNDATION("ThermalFoundation", new String[]{"thermalfoundation.block.TFBlocks", "cofh.thermalfoundation.block.TFBlocks"}, new String[]{"thermalfoundation.item.TFItems", "cofh.thermalfoundation.item.TFItems"}),
    MEKANISM("Mekanism", "mekanism.common.MekanismBlocks", "mekanism.common.MekanismItems"),
    MEKTOOLS("MekanismTools", "mekanism.tools.common.ToolsItems"),
    RAILCRAFT("Railcraft", "mods.railcraft.common.blocks.RailcraftBlocks", new String[0]),
    ICBM("ICBM|Explosion"),
    ARSMAGICA("arsmagica2", "am2.blocks.BlocksCommonProxy", "am2.items.ItemsCommonProxy"),
    TRANSITIONAL("TransitionalAssistance", "modTA.Core.TACore"),
    ENDERSTORAGE("EnderStorage"),
    TREECAPITATOR("TreeCapitator"),
    HARVESTCRAFT("harvestcraft", "com.pam.harvestcraft.BlockRegistry", "com.pam.harvestcraft.ItemRegistry"),
    MYSTCRAFT("Mystcraft", new String[]{"com.xcompwiz.mystcraft.api.MystObjects$Blocks", "com.xcompwiz.mystcraft.api.MystObjects"}, new String[]{"com.xcompwiz.mystcraft.api.MystObjects$Items", "com.xcompwiz.mystcraft.api.MystObjects"}),
    MAGICCROPS("magicalcrops", new String[]{"com.mark719.magicalcrops.MagicalCrops", "com.mark719.magicalcrops.handlers.MBlocks"}, new String[]{"com.mark719.magicalcrops.MagicalCrops", "com.mark719.magicalcrops.handlers.MItems"}),
    MIMICRY("Mimicry", "com.sparr.mimicry.block.MimicryBlock", "com.sparr.mimicry.item.MimicryItem"),
    QCRAFT("QuantumCraft", "dan200.QCraft"),
    OPENBLOCKS("OpenBlocks", "openblocks.OpenBlocks$Blocks", "openblocks.OpenBlocks$Items"),
    FACTORIZATION("factorization", "factorization.common.Registry"),
    UE("UniversalElectricity"),
    EXTRAUTILS("ExtraUtilities", "com.rwtema.extrautils.ExtraUtils"),
    POWERSUITS("powersuits", "net.machinemuse.powersuits.common.ModularPowersuits"),
    ARSENAL("RedstoneArsenal", new String[]{"redstonearsenal.item.RAItems", "cofh.redstonearsenal.item.RAItems"}),
    EMASHER("emashercore", "emasher.core.EmasherCore"),
    HIGHLANDS("Highlands", "highlands.api.HighlandsBlocks"),
    PROJRED("ProjRed|Core"),
    WITCHERY("witchery", "com.emoniph.witchery.WitcheryBlocks", "com.emoniph.witchery.WitcheryItems"),
    GALACTICRAFT("GalacticraftCore", "micdoodle8.mods.galacticraft.core.blocks.GCBlocks", "micdoodle8.mods.galacticraft.core.items.GCItems"),
    MULTIPART("ForgeMicroblock"),
    OPENCOMPUTERS("OpenComputers"),
    NEI("NotEnoughItems"),
    ATG("ATG"),
    WAILA("Waila"),
    BLUEPOWER("bluepower", "com.bluepowermod.init.BPBlocks", "com.bluepowermod.init.BPItems"),
    COLORLIGHT("easycoloredlights"),
    ENDERIO("EnderIO", "crazypants.enderio.EnderIO"),
    COMPUTERCRAFT("ComputerCraft", "dan200.ComputerCraft"),
    ROUTER("RouterReborn", "router.reborn.RouterReborn"),
    PNEUMATICRAFT("PneumaticCraft", "pneumaticCraft.common.block.Blockss", "pneumaticCraft.common.item.Itemss"),
    PROJECTE("ProjectE", "moze_intel.projecte.gameObjs.ObjHandler"),
    BLOODMAGIC("AWWayofTime", "WayofTime.alchemicalWizardry.ModBlocks", "WayofTime.alchemicalWizardry.ModItems"),
    LYCANITE("lycanitesmobs"),
    CRAFTMANAGER("zcraftingmanager"),
    MINECHEM("minechem"),
    TFC("terrafirmacraft"),
    BOTANIA("Botania", "vazkii.botania.common.block.ModBlocks", "vazkii.botania.common.item.ModItems"),
    GENDUSTRY("gendustry"),
    FLUXEDCRYSTALS("fluxedcrystals", "fluxedCrystals.init.FCBlocks", "fluxedCrystals.init.FCItems"),
    HUNGEROVERHAUL("HungerOverhaul"),
    CHISEL("chisel", new String[]{"com.cricketcraft.chisel.init.ChiselBlocks", "team.chisel.init.ChiselBlocks"}, new String[]{"com.cricketcraft.chisel.init.ChiselItems", "team.chisel.init.ChiselItems"}),
    CARPENTER("CarpentersBlocks", "com.carpentersblocks.util.registry.BlockRegistry", "com.carpentersblocks.util.registry.ItemRegistry"),
    ENDEREXPANSION("HardcoreEnderExpansion"),
    AGRICRAFT("AgriCraft", "com.InfinityRaider.AgriCraft.init.Blocks", "com.InfinityRaider.AgriCraft.init.Items"),
    THAUMICTINKER("ThaumicTinkerer"),
    RFTOOLS("rftools"),
    DRACONICEVO("DraconicEvolution"),
    MAGICBEES("MagicBees", "magicbees.main.Config"),
    IMMERSIVEENG("ImmersiveEngineering", "blusunrize.immersiveengineering.common.IEContent");

    private final boolean condition;
    public final String modLabel;
    private final String[] itemClasses;
    private final String[] blockClasses;
    private final HashMap<String, ModHandlerBase> handlers;
    private Class blockClass;
    private Class itemClass;
    private static final HashMap<String, ModList> modIDs;
    public static final ModList[] modList;

    private ModList(String label, String[] blocks, String[] items) {
        this.handlers = new HashMap();
        this.modLabel = label;
        this.condition = Loader.isModLoaded((String)this.modLabel);
        this.itemClasses = items;
        this.blockClasses = blocks;
        if (this.condition) {
            ReikaJavaLibrary.pConsole("DRAGONAPI: " + this + " detected in the MC installation. Adjusting behavior accordingly.");
        } else {
            ReikaJavaLibrary.pConsole("DRAGONAPI: " + this + " not detected in the MC installation. No special action taken.");
        }
        if (this.condition) {
            ReikaJavaLibrary.pConsole("DRAGONAPI: Attempting to load data from " + this);
            if (blocks == null) {
                ReikaJavaLibrary.pConsole("DRAGONAPI: Could not block class for " + this + ": Specified class was null. This may not be an error.");
            }
            if (items == null) {
                ReikaJavaLibrary.pConsole("DRAGONAPI: Could not item class for " + this + ": Specified class was null. This may not be an error.");
            }
        }
    }

    private ModList(String label, String modClass) {
        this(label, modClass, modClass);
    }

    private ModList(String label, String[] modClass) {
        this(label, modClass, modClass);
    }

    private ModList(String label, String blocks, String items) {
        String[] stringArray;
        String[] stringArray2;
        if (blocks != null) {
            String[] stringArray3 = new String[1];
            stringArray2 = stringArray3;
            stringArray3[0] = blocks;
        } else {
            stringArray2 = null;
        }
        if (items != null) {
            String[] stringArray4 = new String[1];
            stringArray = stringArray4;
            stringArray4[0] = items;
        } else {
            stringArray = null;
        }
        this(label, stringArray2, stringArray);
    }

    private ModList(String label, String[] blocks, String items) {
        String[] stringArray;
        if (items != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = items;
        } else {
            stringArray = null;
        }
        this(label, blocks, stringArray);
    }

    private ModList(String label, String blocks, String[] items) {
        String[] stringArray;
        if (blocks != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = blocks;
        } else {
            stringArray = null;
        }
        this(label, stringArray, items);
    }

    private ModList(String label) {
        this(label, (String)null);
    }

    private Class findClass(String s) {
        try {
            return Class.forName(s);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @Override
    public Class getBlockClass() {
        if (this.blockClasses == null || this.blockClasses.length == 0) {
            DragonAPICore.logError("Could not load block class for " + this + ". Null class provided.");
            ReikaJavaLibrary.dumpStack();
            return null;
        }
        if (this.blockClass == null) {
            for (String s : this.blockClasses) {
                this.blockClass = this.findClass(s);
                if (this.blockClass == null) continue;
                DragonAPICore.log("Found block class for " + this + ": " + this.blockClass);
                break;
            }
            if (this.blockClass == null) {
                String sgs = Arrays.toString(this.blockClasses);
                DragonAPICore.logError("Could not load block class for " + this + ". Not found: " + sgs);
                ReflectiveFailureTracker.instance.logModReflectiveFailure(this, new ClassNotFoundException(sgs));
                return null;
            }
        }
        return this.blockClass;
    }

    @Override
    public Class getItemClass() {
        if (this.itemClasses == null || this.itemClasses.length == 0) {
            DragonAPICore.logError("Could not load item class for " + this + ". Null class provided.");
            ReikaJavaLibrary.dumpStack();
            return null;
        }
        if (this.itemClass == null) {
            for (String s : this.itemClasses) {
                this.itemClass = this.findClass(s);
                if (this.itemClass == null) continue;
                DragonAPICore.log("Found item class for " + this + ": " + this.itemClass);
                break;
            }
            if (this.itemClass == null) {
                String sgs = Arrays.toString(this.itemClasses);
                DragonAPICore.logError("Could not load item class for " + this + ". Not found: " + sgs);
                ReflectiveFailureTracker.instance.logModReflectiveFailure(this, new ClassNotFoundException(sgs));
                return null;
            }
        }
        return this.itemClass;
    }

    @Override
    public boolean isLoaded() {
        return this.condition;
    }

    @Override
    public String getModLabel() {
        return this.modLabel;
    }

    @Override
    public String getDisplayName() {
        if (this.isReikasMod()) {
            return this.modLabel;
        }
        return ReikaStringParser.capFirstChar(this.name());
    }

    public ModContainer getModContainer() {
        return (ModContainer)Loader.instance().getIndexedModList().get(this.modLabel);
    }

    public Object getModObject() {
        return this.getModContainer().getMod();
    }

    @Override
    public String getVersion() {
        Object o = this.getModObject();
        return o instanceof DragonAPIMod ? ((DragonAPIMod)o).getModVersion().toString() : this.getModContainer().getVersion();
    }

    public String toString() {
        return this.getModLabel();
    }

    public boolean isReikasMod() {
        return this.ordinal() <= CONDENSEDORES.ordinal();
    }

    public void registerHandler(ModHandlerBase h, String id) {
        this.handlers.put(id, h);
    }

    public Collection<ModHandlerBase> getHandlers() {
        return this.handlers.values();
    }

    public ModHandlerBase getHandler(String id) {
        return this.handlers.get(id);
    }

    public static List<ModList> getReikasMods() {
        ArrayList<ModList> li = new ArrayList<ModList>();
        for (int i = 0; i < modList.length; ++i) {
            ModList mod = modList[i];
            if (!mod.isReikasMod()) continue;
            li.add(mod);
        }
        return li;
    }

    public static ModList getModFromID(String id) {
        if (modIDs.containsKey(id)) {
            return modIDs.get(id);
        }
        for (int i = 0; i < modList.length; ++i) {
            ModList mod = modList[i];
            if (!mod.modLabel.equals(id)) continue;
            modIDs.put(id, mod);
            return mod;
        }
        modIDs.put(id, null);
        return null;
    }

    static {
        modIDs = new HashMap();
        modList = ModList.values();
    }
}

