/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.ModInteract.RecipeHandlers;

import Reika.DragonAPI.Base.ModHandlerBase;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Data.Collections.ChancedOutputList;
import Reika.DragonAPI.Instantiable.Data.Maps.ItemHashMap;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.ModList;
import forestry.api.recipes.ICentrifugeRecipe;
import forestry.api.recipes.RecipeManagers;
import java.util.Collection;
import java.util.Map;
import net.minecraft.item.ItemStack;

public class ForestryRecipeHelper
extends ModHandlerBase {
    private static final ForestryRecipeHelper instance = new ForestryRecipeHelper();
    private final ItemHashMap<ChancedOutputList> centrifuge = new ItemHashMap();

    public static final ForestryRecipeHelper getInstance() {
        return instance;
    }

    private ForestryRecipeHelper() {
        if (this.hasMod()) {
            try {
                Collection c = RecipeManagers.centrifugeManager.recipes();
                for (ICentrifugeRecipe r : c) {
                    ItemStack in = r.getInput();
                    ChancedOutputList outputs = new ChancedOutputList(false);
                    Map out = r.getAllProducts();
                    for (ItemStack is : out.keySet()) {
                        float chance = ((Float)out.get(is)).floatValue() * 100.0f;
                        for (int i = 0; i < is.field_77994_a; ++i) {
                            outputs.addItem(ReikaItemHelper.getSizedItemStack(is, 1), chance);
                        }
                    }
                    this.centrifuge.put(in, outputs);
                }
            }
            catch (Exception e) {
                DragonAPICore.logError("Could not initialize Forestry recipe helper!");
                e.printStackTrace();
            }
        } else {
            this.noMod();
        }
    }

    public Collection<ItemStack> getCentrifugeRecipes() {
        return this.centrifuge.keySet();
    }

    public ChancedOutputList getRecipeOutput(ItemStack in) {
        return this.centrifuge.get(in).copy();
    }

    @Override
    public boolean initializedProperly() {
        return !this.centrifuge.isEmpty();
    }

    @Override
    public ModList getMod() {
        return ModList.FORESTRY;
    }
}

