/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.ModInteract.ItemHandlers;

import Reika.DragonAPI.Base.ModHandlerBase;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.ModList;
import Reika.DragonAPI.ModRegistry.ModOreList;
import java.lang.reflect.Field;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public final class ThaumOreHandler
extends ModHandlerBase {
    public final Block oreID;
    public final Item oreItemID;
    public final Item shardID;
    public final int metaCinnabar = 0;
    public final int metaAir = 1;
    public final int metaFire = 2;
    public final int metaWater = 3;
    public final int metaEarth = 4;
    public final int metaVis = 5;
    public final int metaDull = 6;
    public final int metaAmber = 7;
    public final int metaCinnabarItem = 3;
    public final int metaAmberItem = 6;
    public final int metaAirShard = 0;
    public final int metaFireShard = 1;
    public final int metaWaterShard = 2;
    public final int metaEarthShard = 3;
    public final int metaVisShard = 4;
    public final int metaDullShard = 5;
    private final ItemStack oreCinnabar;
    private final ItemStack oreAir;
    private final ItemStack oreFire;
    private final ItemStack oreWater;
    private final ItemStack oreEarth;
    private final ItemStack oreVis;
    private final ItemStack oreDull;
    private final ItemStack oreAmber;
    private final ItemStack dropCinnabar;
    private final ItemStack dropAmber;
    private final ItemStack shardAir;
    private final ItemStack shardFire;
    private final ItemStack shardWater;
    private final ItemStack shardEarth;
    private final ItemStack shardVis;
    private final ItemStack shardDull;
    private final ArrayList ores = new ArrayList();
    private final ArrayList items = new ArrayList();
    private boolean isOreDict = false;
    private static final ThaumOreHandler instance = new ThaumOreHandler();

    private ThaumOreHandler() {
        Block idore = null;
        Item iditem = null;
        Item idshard = null;
        if (this.hasMod()) {
            Class thaum = ModList.THAUMCRAFT.getBlockClass();
            Class items = ModList.THAUMCRAFT.getItemClass();
            idore = this.loadBlockID(thaum, "blockCustomOre");
            iditem = this.loadItemID(items, "itemResource");
            idshard = this.loadItemID(items, "itemShard");
        } else {
            this.noMod();
        }
        this.oreID = idore;
        this.shardID = idshard;
        this.oreItemID = iditem;
        this.oreCinnabar = new ItemStack(this.oreID, 1, 0);
        this.oreAir = new ItemStack(this.oreID, 1, 1);
        this.oreFire = new ItemStack(this.oreID, 1, 2);
        this.oreWater = new ItemStack(this.oreID, 1, 3);
        this.oreEarth = new ItemStack(this.oreID, 1, 4);
        this.oreVis = new ItemStack(this.oreID, 1, 5);
        this.oreDull = new ItemStack(this.oreID, 1, 6);
        this.oreAmber = new ItemStack(this.oreID, 1, 7);
        this.ores.add(this.oreCinnabar);
        this.ores.add(this.oreAir);
        this.ores.add(this.oreFire);
        this.ores.add(this.oreWater);
        this.ores.add(this.oreEarth);
        this.ores.add(this.oreVis);
        this.ores.add(this.oreDull);
        this.ores.add(this.oreAmber);
        this.dropCinnabar = new ItemStack(this.oreItemID, 1, 3);
        this.dropAmber = new ItemStack(this.oreItemID, 1, 6);
        this.shardAir = new ItemStack(this.shardID, 1, 0);
        this.shardFire = new ItemStack(this.shardID, 1, 1);
        this.shardWater = new ItemStack(this.shardID, 1, 2);
        this.shardEarth = new ItemStack(this.shardID, 1, 3);
        this.shardVis = new ItemStack(this.shardID, 1, 4);
        this.shardDull = new ItemStack(this.shardID, 1, 5);
        this.items.add(this.dropCinnabar);
        this.items.add(this.shardAir);
        this.items.add(this.shardFire);
        this.items.add(this.shardWater);
        this.items.add(this.shardEarth);
        this.items.add(this.shardVis);
        this.items.add(this.shardDull);
        this.items.add(this.dropAmber);
    }

    public static ThaumOreHandler getInstance() {
        return instance;
    }

    @Override
    public boolean initializedProperly() {
        return this.oreID != null && this.shardID != null && this.oreItemID != null;
    }

    @Override
    public ModList getMod() {
        return ModList.THAUMCRAFT;
    }

    public ItemStack getOre(int meta) {
        if (!this.initializedProperly()) {
            return null;
        }
        switch (meta) {
            case 7: {
                return this.oreAmber.func_77946_l();
            }
            case 0: {
                return this.oreCinnabar.func_77946_l();
            }
            case 1: {
                return this.oreAir.func_77946_l();
            }
            case 6: {
                return this.oreDull.func_77946_l();
            }
            case 4: {
                return this.oreEarth.func_77946_l();
            }
            case 2: {
                return this.oreFire.func_77946_l();
            }
            case 5: {
                return this.oreVis.func_77946_l();
            }
            case 3: {
                return this.oreWater.func_77946_l();
            }
        }
        return null;
    }

    public ItemStack getItem(int meta) {
        if (!this.initializedProperly()) {
            return null;
        }
        switch (meta) {
            case 6: {
                return this.dropAmber.func_77946_l();
            }
            case 3: {
                return this.dropCinnabar.func_77946_l();
            }
        }
        return null;
    }

    public ItemStack getShard(int meta) {
        if (!this.initializedProperly()) {
            return null;
        }
        switch (meta) {
            case 0: {
                return this.shardAir.func_77946_l();
            }
            case 5: {
                return this.shardDull.func_77946_l();
            }
            case 3: {
                return this.shardEarth.func_77946_l();
            }
            case 1: {
                return this.shardFire.func_77946_l();
            }
            case 4: {
                return this.shardVis.func_77946_l();
            }
            case 2: {
                return this.shardWater.func_77946_l();
            }
        }
        return null;
    }

    public ItemStack getOre(ModOreList ore) {
        if (!this.initializedProperly()) {
            return null;
        }
        if (!ore.isThaumcraft()) {
            return null;
        }
        switch (ore) {
            case AMBER: {
                return this.oreAmber.func_77946_l();
            }
            case CINNABAR: {
                return this.oreCinnabar.func_77946_l();
            }
            case INFUSEDAIR: {
                return this.oreAir.func_77946_l();
            }
            case INFUSEDENTROPY: {
                return this.oreDull.func_77946_l();
            }
            case INFUSEDEARTH: {
                return this.oreEarth.func_77946_l();
            }
            case INFUSEDFIRE: {
                return this.oreFire.func_77946_l();
            }
            case INFUSEDORDER: {
                return this.oreVis.func_77946_l();
            }
            case INFUSEDWATER: {
                return this.oreWater.func_77946_l();
            }
        }
        return null;
    }

    public ItemStack getItem(ModOreList ore) {
        if (!this.initializedProperly()) {
            return null;
        }
        if (!ore.isThaumcraft()) {
            return null;
        }
        switch (ore) {
            case AMBER: {
                return this.dropAmber.func_77946_l();
            }
            case CINNABAR: {
                return this.dropCinnabar.func_77946_l();
            }
            case INFUSEDAIR: {
                return this.shardAir.func_77946_l();
            }
            case INFUSEDENTROPY: {
                return this.shardDull.func_77946_l();
            }
            case INFUSEDEARTH: {
                return this.shardEarth.func_77946_l();
            }
            case INFUSEDFIRE: {
                return this.shardFire.func_77946_l();
            }
            case INFUSEDORDER: {
                return this.shardVis.func_77946_l();
            }
            case INFUSEDWATER: {
                return this.shardWater.func_77946_l();
            }
        }
        return null;
    }

    public boolean isThaumOre(ItemStack is) {
        if (!this.initializedProperly()) {
            return false;
        }
        if (is == null) {
            return false;
        }
        return ReikaItemHelper.matchStackWithBlock(is, this.oreID);
    }

    public boolean isShard(ItemStack is) {
        if (!this.initializedProperly()) {
            return false;
        }
        return is.func_77973_b() == this.shardID;
    }

    public boolean isShardOre(ItemStack block) {
        if (!this.initializedProperly()) {
            return false;
        }
        if (!this.isThaumOre(block)) {
            return false;
        }
        if (block.func_77960_j() == this.oreAmber.func_77960_j()) {
            return false;
        }
        return block.func_77960_j() != this.oreCinnabar.func_77960_j();
    }

    public void forceOreRegistration() {
        if (!this.isOreDict) {
            DragonAPICore.log("Thaumcraft ores are being registered to Ore Dictionary!");
            for (int i = 0; i < ModOreList.oreList.length; ++i) {
                ModOreList o = ModOreList.oreList[i];
                if (!o.isThaumcraft()) continue;
                OreDictionary.registerOre((String)o.getOreDictNames()[0], (ItemStack)this.getOre(o));
                OreDictionary.registerOre((String)o.getProductOreDictName(), (ItemStack)this.getItem(o));
                o.initialize();
                DragonAPICore.log("Registering " + o.displayName);
            }
        } else {
            DragonAPICore.log("Thaumcraft ores already registered to ore dictionary! No action taken!");
            ReikaJavaLibrary.dumpStack();
        }
    }

    private Block loadBlockID(Class c, String fieldName) {
        Block id = null;
        try {
            Field block = c.getField(fieldName);
            id = (Block)block.get(null);
        }
        catch (Exception e) {
            this.logFailure(e);
            e.printStackTrace();
        }
        return id;
    }

    private Item loadItemID(Class c, String fieldName) {
        Item id = null;
        try {
            Field item = c.getField(fieldName);
            id = (Item)item.get(null);
        }
        catch (Exception e) {
            this.logFailure(e);
            e.printStackTrace();
        }
        return id;
    }
}

