/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.ModInteract.ItemHandlers;

import Reika.DragonAPI.Base.ModHandlerBase;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.ModList;
import java.lang.reflect.Field;
import java.util.HashSet;

public class ThaumIDHandler
extends ModHandlerBase {
    private static final HashSet<Integer> biomeSet = new HashSet();
    private static final HashSet<Integer> potionSet = new HashSet();
    private static final ThaumIDHandler instance = new ThaumIDHandler();
    public final int dimensionID;

    private ThaumIDHandler() {
        int dim = 0;
        if (this.hasMod()) {
            Class thaum = ModList.THAUMCRAFT.getBlockClass();
            try {
                Field f;
                Enum p;
                int i;
                Class<?> config = Class.forName("thaumcraft.common.config.Config");
                try {
                    Field dimid = config.getField("dimensionOuterId");
                    dim = dimid.getInt(null);
                }
                catch (NoSuchFieldException e) {
                    DragonAPICore.logError("Could not load field from ThaumCraft config class!");
                    e.printStackTrace();
                    this.logFailure(e);
                }
                catch (IllegalArgumentException e) {
                    DragonAPICore.logError("Could not read field from ThaumCraft config class!");
                    e.printStackTrace();
                    this.logFailure(e);
                }
                catch (IllegalAccessException e) {
                    DragonAPICore.logError("Could not read field from ThaumCraft config class!");
                    e.printStackTrace();
                    this.logFailure(e);
                }
                for (i = 0; i < Biomes.list.length; ++i) {
                    p = Biomes.list[i];
                    try {
                        f = config.getField(((Biomes)p).tag);
                        ((Biomes)p).ID = f.getInt(null);
                        biomeSet.add(((Biomes)p).ID);
                        continue;
                    }
                    catch (NoSuchFieldException e) {
                        DragonAPICore.logError("Could not load field from ThaumCraft config class!");
                        e.printStackTrace();
                        this.logFailure(e);
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        DragonAPICore.logError("Could not read field from ThaumCraft config class!");
                        e.printStackTrace();
                        this.logFailure(e);
                        continue;
                    }
                    catch (IllegalAccessException e) {
                        DragonAPICore.logError("Could not read field from ThaumCraft config class!");
                        e.printStackTrace();
                        this.logFailure(e);
                    }
                }
                for (i = 0; i < Potions.list.length; ++i) {
                    p = Potions.list[i];
                    try {
                        f = config.getField(((Potions)p).tag);
                        ((Potions)p).ID = f.getInt(null);
                        potionSet.add(((Potions)p).ID);
                        continue;
                    }
                    catch (NoSuchFieldException e) {
                        DragonAPICore.logError("Could not load field from ThaumCraft config class!");
                        e.printStackTrace();
                        this.logFailure(e);
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        DragonAPICore.logError("Could not read field from ThaumCraft config class!");
                        e.printStackTrace();
                        this.logFailure(e);
                        continue;
                    }
                    catch (IllegalAccessException e) {
                        DragonAPICore.logError("Could not read field from ThaumCraft config class!");
                        e.printStackTrace();
                        this.logFailure(e);
                    }
                }
            }
            catch (ClassNotFoundException e) {
                DragonAPICore.logError("Could not load ThaumCraft config class!");
                e.printStackTrace();
                this.logFailure(e);
            }
        } else {
            this.noMod();
        }
        this.dimensionID = dim;
    }

    public static ThaumIDHandler getInstance() {
        return instance;
    }

    @Override
    public boolean initializedProperly() {
        return biomeSet.size() == Biomes.list.length && potionSet.size() == Potions.list.length && this.dimensionID != 0;
    }

    @Override
    public ModList getMod() {
        return ModList.THAUMCRAFT;
    }

    public static enum Biomes {
        EERIE("Eerie"),
        TAINT("Taint"),
        MAGICFOREST("MagicalForest"),
        ELDRITCH("Eldritch");

        private final String tag;
        private int ID = -1;
        private static final Biomes[] list;

        private Biomes(String s) {
            this.tag = "biome" + s + "ID";
        }

        public int getID() {
            return this.ID;
        }

        static {
            list = Biomes.values();
        }
    }

    public static enum Potions {
        FLUXTAINT("TaintPoison"),
        FLUXFLU("VisExhaust"),
        WARPWARD("WarpWard"),
        BLURREDVISION("Blurred"),
        DEATHGAZE("DeathGaze"),
        SUNSCORNED("SunScorned"),
        THAUMARHIA("Thaumarhia"),
        VISPHAGE("InfVisExhaust"),
        HUNGER("UnHunger");

        private final String tag;
        private int ID = -1;
        public static final Potions[] list;

        private Potions(String s) {
            this.tag = "potion" + s + "ID";
        }

        public int getID() {
            return this.ID;
        }

        public boolean isWarpRelated() {
            switch (this) {
                case FLUXTAINT: 
                case WARPWARD: {
                    return false;
                }
            }
            return true;
        }

        static {
            list = Potions.values();
        }
    }
}

