/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.ModInteract.ItemHandlers;

import Reika.DragonAPI.Base.ModHandlerBase;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.ModInteract.ItemHandlers.MekanismHandler;
import Reika.DragonAPI.ModList;
import java.lang.reflect.Field;
import java.util.EnumMap;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public final class MekToolHandler
extends ModHandlerBase {
    private static final MekToolHandler instance = new MekToolHandler();
    private final EnumMap<Tools, EnumMap<Materials, Item>> itemsTool = new EnumMap(Tools.class);
    private final EnumMap<Materials, EnumMap<Tools, Item>> itemsMaterial = new EnumMap(Materials.class);

    private MekToolHandler() {
        if (this.hasMod()) {
            Class item = this.getMod().getItemClass();
            for (int i = 0; i < Materials.list.length; ++i) {
                Materials m = Materials.list[i];
                for (int k = 0; k < Tools.list.length; ++k) {
                    Tools t = Tools.list[k];
                    if (!t.isCombineableWith(m)) continue;
                    String varname = this.getField(m, t);
                    Item tool = this.getID(item, varname);
                    this.addEntry(tool, m, t);
                }
            }
        } else {
            this.noMod();
        }
    }

    private void addEntry(Item tool, Materials m, Tools t) {
        EnumMap<Materials, Object> map1 = this.itemsTool.get((Object)t);
        if (map1 == null) {
            map1 = new EnumMap(Materials.class);
            this.itemsTool.put(t, map1);
        }
        map1.put(m, tool);
        EnumMap<Tools, Object> map2 = this.itemsMaterial.get((Object)t);
        if (map2 == null) {
            map2 = new EnumMap(Tools.class);
            this.itemsMaterial.put(m, map2);
        }
        map2.put(t, tool);
    }

    private String getField(Materials m, Tools t) {
        return m.id + t.id;
    }

    private Item getID(Class c, String varname) {
        try {
            Field f = c.getField(varname);
            Item id = (Item)f.get(null);
            return id;
        }
        catch (NoSuchFieldException e) {
            DragonAPICore.logError(this.getMod() + " field not found! " + e.getMessage());
            e.printStackTrace();
            this.logFailure(e);
        }
        catch (SecurityException e) {
            DragonAPICore.logError("Cannot read " + this.getMod() + " (Security Exception)! " + e.getMessage());
            e.printStackTrace();
            this.logFailure(e);
        }
        catch (IllegalArgumentException e) {
            DragonAPICore.logError("Illegal argument for reading " + this.getMod() + "!");
            e.printStackTrace();
            this.logFailure(e);
        }
        catch (IllegalAccessException e) {
            DragonAPICore.logError("Illegal access exception for reading " + this.getMod() + "!");
            e.printStackTrace();
            this.logFailure(e);
        }
        catch (NullPointerException e) {
            DragonAPICore.logError("Null pointer exception for reading " + this.getMod() + "! Was the class loaded?");
            e.printStackTrace();
            this.logFailure(e);
        }
        return null;
    }

    public static MekToolHandler getInstance() {
        return instance;
    }

    @Override
    public boolean initializedProperly() {
        return !this.itemsMaterial.isEmpty() && !this.itemsTool.isEmpty();
    }

    @Override
    public ModList getMod() {
        return ModList.MEKTOOLS;
    }

    public boolean isArmor(ItemStack is) {
        if (is == null) {
            return false;
        }
        if (!this.initializedProperly()) {
            return false;
        }
        if (this.itemsTool.get((Object)Tools.HELMET).containsValue(is.func_77973_b())) {
            return false;
        }
        if (this.itemsTool.get((Object)Tools.CHEST).containsValue(is.func_77973_b())) {
            return false;
        }
        if (this.itemsTool.get((Object)Tools.LEGS).containsValue(is.func_77973_b())) {
            return false;
        }
        if (this.itemsTool.get((Object)Tools.BOOTS).containsValue(is.func_77973_b())) {
            return false;
        }
        return false;
    }

    public boolean isPickTypeTool(ItemStack held) {
        if (held == null) {
            return false;
        }
        if (!this.initializedProperly()) {
            return false;
        }
        return this.itemsTool.get((Object)Tools.PAXEL).containsValue(held.func_77973_b()) || this.itemsTool.get((Object)Tools.PICK).containsValue(held.func_77973_b());
    }

    public boolean isWood(ItemStack held) {
        if (held == null) {
            return false;
        }
        if (!this.initializedProperly()) {
            return false;
        }
        return this.itemsMaterial.get((Object)Materials.WOOD).containsValue(held.func_77973_b());
    }

    public static enum Tools {
        PICK("Pickaxe"),
        PAXEL("Paxel"),
        SHOVEL("Shovel"),
        AXE("Axe"),
        HOE("Hoe"),
        SWORD("Sword"),
        HELMET("Helmet"),
        CHEST("Chestplate"),
        LEGS("Leggings"),
        BOOTS("Boots");

        private final String id;
        private static final Tools[] list;

        private Tools(String s) {
            this.id = s;
        }

        public boolean isCombineableWith(Materials m) {
            return this == PAXEL ? true : !m.isVanillaMaterial();
        }

        public Item getItem(Materials m) {
            return instance.initializedProperly() ? (Item)((EnumMap)instance.itemsTool.get((Object)this)).get((Object)m) : null;
        }

        public int getNumberIngots(Materials m) {
            switch (this) {
                case AXE: {
                    return 3;
                }
                case HOE: {
                    return 2;
                }
                case PAXEL: {
                    return 6;
                }
                case PICK: {
                    return 3;
                }
                case SHOVEL: {
                    return 1;
                }
                case SWORD: {
                    return 2;
                }
                case BOOTS: {
                    return m == Materials.STEEL ? 2 : 4;
                }
                case CHEST: {
                    return m == Materials.STEEL ? 5 : 8;
                }
                case HELMET: {
                    return m == Materials.STEEL ? 3 : 5;
                }
                case LEGS: {
                    return m == Materials.STEEL ? 5 : 7;
                }
            }
            return 0;
        }

        static {
            list = Tools.values();
        }
    }

    public static enum Materials {
        WOOD("Wood"),
        STONE("Stone"),
        IRON("Iron"),
        DIAMOND("Diamond"),
        GOLD("Gold"),
        GLOWSTONE("Glowstone"),
        BRONZE("Bronze"),
        OSMIUM("Osmium"),
        OBSIDIAN("Obsidian"),
        LAPIS("Lazuli"),
        STEEL("Steel");

        private final String id;
        private static final Materials[] list;

        private Materials(String s) {
            this.id = s;
        }

        public boolean isVanillaMaterial() {
            switch (this) {
                case WOOD: 
                case STONE: 
                case IRON: 
                case DIAMOND: 
                case GOLD: {
                    return true;
                }
            }
            return false;
        }

        public Item getItem(Tools t) {
            return instance.initializedProperly() ? (Item)((EnumMap)instance.itemsMaterial.get((Object)this)).get((Object)t) : null;
        }

        public ItemStack getRawMaterial() {
            switch (this) {
                case BRONZE: {
                    return new ItemStack(MekanismHandler.getInstance().ingotID, 1, 2);
                }
                case GLOWSTONE: {
                    return new ItemStack(MekanismHandler.getInstance().ingotID, 1, 3);
                }
                case OBSIDIAN: {
                    return new ItemStack(MekanismHandler.getInstance().ingotID, 1, 0);
                }
                case OSMIUM: {
                    return new ItemStack(MekanismHandler.getInstance().ingotID, 1, 1);
                }
                case STEEL: {
                    return new ItemStack(MekanismHandler.getInstance().ingotID, 1, 4);
                }
                case STONE: {
                    return new ItemStack(Blocks.field_150347_e);
                }
                case WOOD: {
                    return new ItemStack(Blocks.field_150344_f, 1, Short.MAX_VALUE);
                }
                case GOLD: {
                    return new ItemStack(Items.field_151043_k);
                }
                case IRON: {
                    return new ItemStack(Items.field_151042_j);
                }
                case LAPIS: {
                    return ReikaItemHelper.lapisDye.func_77946_l();
                }
                case DIAMOND: {
                    return new ItemStack(Items.field_151045_i);
                }
            }
            return null;
        }

        static {
            list = Materials.values();
        }
    }
}

