/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.ModInteract.ItemHandlers;

import Reika.DragonAPI.Base.ModHandlerBase;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Libraries.Java.ReikaStringParser;
import Reika.DragonAPI.ModList;
import java.lang.reflect.Field;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ForestryHandler
extends ModHandlerBase {
    private boolean init = false;
    private static final ForestryHandler instance = new ForestryHandler();

    private ForestryHandler() {
        if (this.hasMod()) {
            Object reg;
            Field f;
            Class<?> c;
            Enum ie;
            int i;
            for (i = 0; i < ItemEntry.list.length; ++i) {
                ie = ItemEntry.list[i];
                try {
                    c = Class.forName(((ItemEntry)ie).reg);
                    f = c.getDeclaredField(((ItemEntry)ie).tag);
                    reg = ((ItemEntry)ie).getRegistryObject();
                    ((ItemEntry)ie).item = (Item)f.get(reg);
                    continue;
                }
                catch (NoSuchFieldException e) {
                    DragonAPICore.logError(this.getMod() + " field not found! " + e.getMessage());
                    e.printStackTrace();
                    this.logFailure(e);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    DragonAPICore.logError("Illegal argument for reading " + this.getMod() + "!");
                    e.printStackTrace();
                    this.logFailure(e);
                    continue;
                }
                catch (IllegalAccessException e) {
                    DragonAPICore.logError("Illegal access exception for reading " + this.getMod() + "!");
                    e.printStackTrace();
                    this.logFailure(e);
                    continue;
                }
                catch (NullPointerException e) {
                    DragonAPICore.logError("Null pointer exception for reading " + this.getMod() + "! Was the class loaded?");
                    e.printStackTrace();
                    this.logFailure(e);
                    continue;
                }
                catch (ClassNotFoundException e) {
                    DragonAPICore.logError(this.getMod() + " class not found! " + e.getMessage());
                    e.printStackTrace();
                    this.logFailure(e);
                }
            }
            for (i = 0; i < BlockEntry.list.length; ++i) {
                ie = BlockEntry.list[i];
                try {
                    c = Class.forName(((BlockEntry)ie).reg);
                    f = c.getDeclaredField(((BlockEntry)ie).tag);
                    reg = ((BlockEntry)ie).getRegistryObject();
                    ((BlockEntry)ie).item = (Block)f.get(reg);
                    continue;
                }
                catch (NoSuchFieldException e) {
                    DragonAPICore.logError(this.getMod() + " field not found! " + e.getMessage());
                    e.printStackTrace();
                    this.logFailure(e);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    DragonAPICore.logError("Illegal argument for reading " + this.getMod() + "!");
                    e.printStackTrace();
                    this.logFailure(e);
                    continue;
                }
                catch (IllegalAccessException e) {
                    DragonAPICore.logError("Illegal access exception for reading " + this.getMod() + "!");
                    e.printStackTrace();
                    this.logFailure(e);
                    continue;
                }
                catch (NullPointerException e) {
                    DragonAPICore.logError("Null pointer exception for reading " + this.getMod() + "! Was the class loaded?");
                    e.printStackTrace();
                    this.logFailure(e);
                    continue;
                }
                catch (ClassNotFoundException e) {
                    DragonAPICore.logError(this.getMod() + " class not found! " + e.getMessage());
                    e.printStackTrace();
                    this.logFailure(e);
                }
            }
            this.init = true;
        } else {
            this.noMod();
        }
    }

    public static ForestryHandler getInstance() {
        return instance;
    }

    @Override
    public boolean initializedProperly() {
        return this.init;
    }

    @Override
    public ModList getMod() {
        return ModList.FORESTRY;
    }

    public static enum SoilType {
        HUMUS,
        BOG_EARTH,
        PEAT;


        public static SoilType getTypeFromMeta(int meta) {
            int type = meta & 3;
            int maturity = meta >> 2;
            if (type == 1) {
                if (maturity < 3) {
                    return BOG_EARTH;
                }
                return PEAT;
            }
            return HUMUS;
        }
    }

    public static enum Combs {
        HONEY(0),
        SIMMERING(2),
        STRINGY(3),
        FROZEN(4),
        DRIPPING(5),
        SILKY(6),
        PARCHED(7),
        MOSSY(15),
        MELLOW(16);

        public final int damageValue;

        private Combs(int dmg) {
            this.damageValue = dmg;
        }

        public ItemStack getItem() {
            return new ItemStack(ItemEntry.COMB.getItem(), 1, this.damageValue);
        }
    }

    public static enum CraftingMaterials {
        PULSEDUST,
        PULSEMESH,
        SILKWISP,
        WOVENSILK,
        DISSIPATION,
        ICESHARD,
        SCENTEDPANEL;


        public ItemStack getItem() {
            return new ItemStack(ItemEntry.CRAFTING.getItem(), 1, this.ordinal());
        }
    }

    public static enum BlockEntry {
        SAPLING("forestry.arboriculture.blocks.BlockRegistryArboriculture", "saplingGE"),
        LEAF("forestry.arboriculture.blocks.BlockRegistryArboriculture", "leaves"),
        LOG("forestry.arboriculture.blocks.BlockRegistryArboriculture", "logs"),
        HIVE("forestry.apiculture.blocks.BlockRegistryApiculture", "beehives"),
        SOIL("forestry.core.blocks.BlockRegistryCore", "soil");

        private final String reg;
        private final String tag;
        private Block item;
        private static final BlockEntry[] list;

        private BlockEntry(String c, String id) {
            this.reg = c;
            this.tag = id;
        }

        public Block getBlock() {
            return this.item;
        }

        private Object getRegistryObject() throws ClassNotFoundException, NoSuchFieldException, IllegalAccessException, IllegalArgumentException {
            String n = this.reg.split("\\.")[1];
            n = ReikaStringParser.capFirstChar(n);
            n = "forestry.plugins.Plugin" + n;
            Class<?> c = Class.forName(n);
            Field f = c.getDeclaredField("blocks");
            f.setAccessible(true);
            return f.get(null);
        }

        static {
            list = BlockEntry.values();
        }
    }

    public static enum ItemEntry {
        APATITE("forestry.core.items.ItemRegistryCore", "apatite"),
        FERTILIZER("forestry.core.items.ItemRegistryCore", "fertilizerCompound"),
        SAPLING("forestry.arboriculture.items.ItemRegistryArboriculture", "sapling"),
        COMB("forestry.apiculture.items.ItemRegistryApiculture", "beeComb"),
        HONEY("forestry.apiculture.items.ItemRegistryApiculture", "honeyDrop"),
        HONEYDEW("forestry.apiculture.items.ItemRegistryApiculture", "honeydew"),
        JELLY("forestry.apiculture.items.ItemRegistryApiculture", "royalJelly"),
        PROPOLIS("forestry.apiculture.items.ItemRegistryApiculture", "propolis"),
        WAX("forestry.core.items.ItemRegistryCore", "beeswax"),
        REFWAX("forestry.core.items.ItemRegistryCore", "refractoryWax"),
        POLLEN("forestry.apiculture.items.ItemRegistryApiculture", "pollenCluster"),
        TREEPOLLEN("forestry.arboriculture.items.ItemRegistryArboriculture", "pollenFertile"),
        QUEEN("forestry.apiculture.items.ItemRegistryApiculture", "beeQueenGE"),
        PRINCESS("forestry.apiculture.items.ItemRegistryApiculture", "beePrincessGE"),
        DRONE("forestry.apiculture.items.ItemRegistryApiculture", "beeDroneGE"),
        LARVA("forestry.apiculture.items.ItemRegistryApiculture", "beeLarvaeGE"),
        CRAFTING("forestry.core.items.ItemRegistryCore", "craftingMaterial"),
        BASICFRAME("forestry.apiculture.items.ItemRegistryApiculture", "frameUntreated"),
        IMPREGFRAME("forestry.apiculture.items.ItemRegistryApiculture", "frameImpregnated"),
        PROVENFRAME("forestry.apiculture.items.ItemRegistryApiculture", "frameProven");

        private final String reg;
        private final String tag;
        private Item item;
        private static final ItemEntry[] list;

        private ItemEntry(String c, String id) {
            this.reg = c;
            this.tag = id;
        }

        public Item getItem() {
            return this.item;
        }

        private Object getRegistryObject() throws ClassNotFoundException, NoSuchFieldException, IllegalAccessException, IllegalArgumentException {
            String n = this.reg.split("\\.")[1];
            n = ReikaStringParser.capFirstChar(n);
            n = "forestry.plugins.Plugin" + n;
            Class<?> c = Class.forName(n);
            Field f = c.getDeclaredField("items");
            f.setAccessible(true);
            return f.get(null);
        }

        static {
            list = ItemEntry.values();
        }
    }
}

