/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.ModInteract.ItemHandlers;

import Reika.DragonAPI.Base.ModHandlerBase;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.ModList;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeTransport;
import buildcraft.transport.TileGenericPipe;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;

public class BCPipeHandler
extends ModHandlerBase {
    private static final String[] fluidPipes = new String[]{"pipeFluidsWood", "pipeFluidsCobblestone", "pipeFluidsStone", "pipeFluidsIron", "pipeFluidsGold", "pipeFluidsVoid", "pipeFluidsSandstone", "pipeFluidsEmerald"};
    private static final String[] itemPipes = new String[]{"pipeItemsWood", "pipeItemsEmerald", "pipeItemsStone", "pipeItemsCobblestone", "pipeItemsIron", "pipeItemsQuartz", "pipeItemsGold", "pipeItemsDiamond", "pipeItemsObsidian", "pipeItemsLapis", "pipeItemsDaizuli", "pipeItemsVoid", "pipeItemsSandstone"};
    private static final String[] powerPipes = new String[]{"pipePowerWood", "pipePowerCobblestone", "pipePowerStone", "pipePowerQuartz", "pipePowerGold", "pipePowerIron", "pipePowerDiamond"};
    private final HashMap<String, Item> itemIDs = new HashMap();
    private static final BCPipeHandler instance = new BCPipeHandler();
    public final Block pipeID;

    private BCPipeHandler() {
        Block idpipe = null;
        if (this.hasMod()) {
            Item id;
            String varname;
            int i;
            Class transport = this.getMod().getBlockClass();
            for (i = 0; i < fluidPipes.length; ++i) {
                varname = fluidPipes[i];
                id = this.getPipeItemID(transport, varname);
                this.itemIDs.put(fluidPipes[i], id);
            }
            for (i = 0; i < itemPipes.length; ++i) {
                varname = itemPipes[i];
                id = this.getPipeItemID(transport, varname);
                this.itemIDs.put(itemPipes[i], id);
            }
            for (i = 0; i < powerPipes.length; ++i) {
                varname = powerPipes[i];
                id = this.getPipeItemID(transport, varname);
                this.itemIDs.put(powerPipes[i], id);
            }
            try {
                Field pipe = transport.getField("genericPipeBlock");
                idpipe = (Block)pipe.get(null);
            }
            catch (NoSuchFieldException e) {
                DragonAPICore.logError(this.getMod() + " field not found! " + e.getMessage());
                e.printStackTrace();
                this.logFailure(e);
            }
            catch (SecurityException e) {
                DragonAPICore.logError("Cannot read " + this.getMod() + " (Security Exception)! " + e.getMessage());
                e.printStackTrace();
                this.logFailure(e);
            }
            catch (IllegalArgumentException e) {
                DragonAPICore.logError("Illegal argument for reading " + this.getMod() + "!");
                e.printStackTrace();
                this.logFailure(e);
            }
            catch (IllegalAccessException e) {
                DragonAPICore.logError("Illegal access exception for reading " + this.getMod() + "!");
                e.printStackTrace();
                this.logFailure(e);
            }
            catch (NullPointerException e) {
                DragonAPICore.logError("Null pointer exception for reading " + this.getMod() + "! Was the class loaded?");
                e.printStackTrace();
                this.logFailure(e);
            }
        } else {
            this.noMod();
        }
        this.pipeID = idpipe;
    }

    private Item getPipeItemID(Class c, String varname) {
        try {
            Field f = c.getField(varname);
            Item id = (Item)f.get(null);
            return id;
        }
        catch (NoSuchFieldException e) {
            DragonAPICore.logError(this.getMod() + " field not found! " + e.getMessage());
            e.printStackTrace();
            this.logFailure(e);
        }
        catch (SecurityException e) {
            DragonAPICore.logError("Cannot read " + this.getMod() + " (Security Exception)! " + e.getMessage());
            e.printStackTrace();
            this.logFailure(e);
        }
        catch (IllegalArgumentException e) {
            DragonAPICore.logError("Illegal argument for reading " + this.getMod() + "!");
            e.printStackTrace();
            this.logFailure(e);
        }
        catch (IllegalAccessException e) {
            DragonAPICore.logError("Illegal access exception for reading " + this.getMod() + "!");
            e.printStackTrace();
            this.logFailure(e);
        }
        catch (NullPointerException e) {
            DragonAPICore.log("Null pointer exception for reading " + this.getMod() + "! Was the class loaded?");
            e.printStackTrace();
            this.logFailure(e);
        }
        return null;
    }

    public static BCPipeHandler getInstance() {
        return instance;
    }

    @Override
    public boolean initializedProperly() {
        return this.pipeID != null;
    }

    @Override
    public ModList getMod() {
        return ModList.BCTRANSPORT;
    }

    public Types getPipeType(TileEntity te) {
        if (!this.initializedProperly()) {
            return null;
        }
        try {
            Class<?> test = Class.forName("buildcraft.transport.TileGenericPipe");
        }
        catch (ClassNotFoundException e) {
            DragonAPICore.logError("Pipe reader failed! Class not found!");
            e.printStackTrace();
            this.logFailure(e);
            return null;
        }
        try {
            if (te instanceof TileGenericPipe) {
                TileGenericPipe tp = (TileGenericPipe)te;
                Pipe p = tp.pipe;
                Item id = p.item;
                PipeTransport pt = p.transport;
                switch (pt.getPipeType()) {
                    case FLUID: {
                        return this.getType(id, fluidPipes);
                    }
                    case ITEM: {
                        return this.getType(id, itemPipes);
                    }
                    case POWER: {
                        return this.getType(id, powerPipes);
                    }
                }
                return null;
            }
        }
        catch (Exception e) {
            DragonAPICore.logError("DRAGONAPI: Pipe reader failed!");
            e.printStackTrace();
            this.logFailure(e);
            return null;
        }
        return null;
    }

    private Types getType(Item id, String[] names) {
        for (int i = 0; i < names.length; ++i) {
            String sg = names[i];
            Item item = this.itemIDs.get(sg);
            if (id != item) continue;
            return this.getType(sg);
        }
        return null;
    }

    private Types getType(String sg) {
        sg = sg.toLowerCase(Locale.ENGLISH);
        sg = sg.replaceAll("pipe", "");
        sg = sg.replaceAll("items", "");
        sg = sg.replaceAll("fluids", "");
        sg = sg.replaceAll("power", "");
        for (int i = 0; i < Types.pipeList.length; ++i) {
            String type = Types.pipeList[i].name().toLowerCase(Locale.ENGLISH);
            if (!type.equals(sg)) continue;
            return Types.pipeList[i];
        }
        return null;
    }

    public static enum Types {
        WOOD,
        STONE,
        COBBLESTONE,
        IRON,
        GOLD,
        VOID,
        SANDSTONE,
        EMERALD,
        QUARTZ,
        LAPIS,
        DIAMOND,
        OBSIDIAN;

        public static final Types[] pipeList;

        static {
            pipeList = Types.values();
        }
    }
}

