/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.ModInteract.ItemHandlers;

import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.Base.CropHandlerBase;
import Reika.DragonAPI.Instantiable.Data.WeightedRandom;
import Reika.DragonAPI.ModList;
import com.InfinityRaider.AgriCraft.api.API;
import com.InfinityRaider.AgriCraft.api.APIBase;
import com.InfinityRaider.AgriCraft.api.v2.APIv2;
import com.InfinityRaider.AgriCraft.api.v2.ICrop;
import com.InfinityRaider.AgriCraft.api.v2.ICropPlant;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class AgriCraftHandler
extends CropHandlerBase {
    private static final AgriCraftHandler instance = new AgriCraftHandler();
    private static final WeightedRandom<Integer> tallGrassRand = new WeightedRandom();
    private Object api;
    private final int GROWN = 7;
    private final HashSet<Block> cropBlocks = new HashSet();

    private AgriCraftHandler() {
        try {
            if (this.getMod().isLoaded()) {
                APIBase a = API.getAPI((int)2);
                if (a != null && a.getStatus().isOK() && a.getVersion() == 2) {
                    this.api = a;
                    this.cropBlocks.addAll(((APIv2)this.api).getCropsBlocks());
                } else {
                    this.api = null;
                }
            } else {
                this.api = null;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.api = null;
        }
    }

    public static AgriCraftHandler getInstance() {
        return instance;
    }

    @Override
    public int getHarvestedMeta(World world, int x, int y, int z) {
        return 2;
    }

    @Override
    public boolean isCrop(Block id, int meta) {
        return this.cropBlocks.contains(id);
    }

    @Override
    public boolean isRipeCrop(World world, int x, int y, int z) {
        return this.getGrowthState(world, x, y, z) == 7;
    }

    @Override
    public void makeRipe(World world, int x, int y, int z) {
        world.func_72921_c(x, y, z, 7, 3);
    }

    @Override
    public int getGrowthState(World world, int x, int y, int z) {
        return world.func_72805_g(x, y, z);
    }

    @Override
    public boolean isSeedItem(ItemStack is) {
        return this.api != null && ((APIv2)this.api).isHandledByAgricraft(is);
    }

    @Override
    public ArrayList<ItemStack> getDropsOverride(World world, int x, int y, int z, Block id, int meta, int fortune) {
        if (this.api == null) {
            return null;
        }
        APIv2 apiv2 = (APIv2)this.api;
        short gain = apiv2.getStats(world, x, y, z).getGain();
        ICropPlant plant = apiv2.getCropPlant(world, x, y, z);
        return gain > 0 && plant != null ? plant.getFruitsOnHarvest((int)gain, world.field_73012_v) : new ArrayList();
    }

    @Override
    public ArrayList<ItemStack> getAdditionalDrops(World world, int x, int y, int z, Block id, int meta, int fortune) {
        ICrop ic;
        ArrayList<ItemStack> li = new ArrayList<ItemStack>();
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof ICrop && (ic = (ICrop)te).isMature() && ic.hasWeed()) {
            li.add(new ItemStack((Block)Blocks.field_150329_H, 1, tallGrassRand.getRandomEntry().intValue()));
        }
        return li;
    }

    @Override
    public boolean neverDropsSecondSeed() {
        return true;
    }

    @Override
    public boolean initializedProperly() {
        return this.api != null;
    }

    @Override
    public ModList getMod() {
        return ModList.AGRICRAFT;
    }

    @DependentMethodStripper.ModDependent(value=ModList.AGRICRAFT)
    public ICropPlant getCropObject(World world, int x, int y, int z) {
        if (this.api == null) {
            return null;
        }
        APIv2 apiv2 = (APIv2)this.api;
        return apiv2.getCropPlant(world, x, y, z);
    }

    static {
        tallGrassRand.addEntry(1, 20.0);
        tallGrassRand.addEntry(2, 1.0);
    }
}

