/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.ModInteract.DeepInteract;

import Reika.DragonAPI.Auxiliary.NEI_DragonAPI_Config;
import Reika.DragonAPI.Auxiliary.Trackers.ReflectiveFailureTracker;
import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Exception.IDConflictException;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.ModInteract.ItemHandlers.TinkerBlockHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.TinkerToolHandler;
import Reika.DragonAPI.ModInteract.RecipeHandlers.SmelteryRecipeHandler;
import Reika.DragonAPI.ModList;
import Reika.DragonAPI.ModRegistry.InterfaceCache;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.lang.reflect.Method;
import java.util.EnumSet;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fluids.Fluid;

public class TinkerMaterialHelper {
    private static Method registerMaterial;
    private static Method registerDefaultMaterial;
    private static Method registerChunkMaterial;
    private static Method registerPartMapping;
    private static Method registerTextures;
    private static Method registerBowMaterial;
    private static Method registerBowstringMaterial;
    private static Method registerArrowMaterial;
    private static Item toolShard;
    private static Item toolRod;
    private static Item arrowhead;
    private static Item bowstring;
    private static Object patternBuilder;
    private static Method registerRepairMaterial;
    public static final TinkerMaterialHelper instance;
    private final HashMap<String, AbstractMaterial> materialNames = new HashMap();
    private final HashMap<Integer, AbstractMaterial> materialIDs = new HashMap();

    private TinkerMaterialHelper() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void breakDisallowedTools(BlockEvent.BreakEvent evt) {
        if (TinkerBlockHandler.Pulses.TOOLS.isLoaded()) {
            EntityPlayer ep = evt.getPlayer();
            ItemStack tool = ep.func_71045_bC();
            try {
                TinkerToolHandler.Tools t;
                if (tool != null && InterfaceCache.TINKERTOOL.instanceOf(tool.func_77973_b()) && (t = TinkerToolHandler.getInstance().getTool(tool.func_77973_b())) != null) {
                    for (int i = 0; i < TinkerToolHandler.ToolPartType.types.length; ++i) {
                        CustomTinkerMaterial cm;
                        int id;
                        AbstractMaterial mat;
                        TinkerToolHandler.ToolPartType type = TinkerToolHandler.ToolPartType.types[i];
                        TinkerToolHandler.ToolParts p = TinkerToolHandler.getInstance().getPart(t, type);
                        if (p == null || !((mat = this.materialIDs.get(id = TinkerToolHandler.getInstance().getToolMaterial(tool, type))) instanceof CustomTinkerMaterial) || !(cm = (CustomTinkerMaterial)mat).enforceNoCheating || cm.toolParts.contains(p)) continue;
                        ReikaSoundHelper.playSoundFromServer(ep.field_70170_p, ep.field_70165_t, ep.field_70163_u, ep.field_70161_v, "random.break", 2.0f, 1.0f, true);
                        ep.func_70097_a(DamageSource.field_76377_j, 1.0f);
                        ep.func_70062_b(0, null);
                        evt.setCanceled(true);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public CustomTinkerMaterial createMaterial(int id, DragonAPIMod mod, String name) {
        AbstractMaterial prev = this.materialIDs.get(id);
        if (prev != null) {
            throw new IDConflictException(mod, "Tool material ID " + id + " is already occupied by '" + prev.materialName + "'!");
        }
        CustomTinkerMaterial mat = new CustomTinkerMaterial(id, mod, name);
        if (!TinkerBlockHandler.Pulses.TOOLS.isLoaded()) {
            mat.clearToolParts();
        }
        if (!TinkerBlockHandler.Pulses.WEAPONS.isLoaded()) {
            mat.clearWeaponParts();
        }
        mat.disableWeaponPart(TinkerToolHandler.WeaponParts.FLETCHING).disableWeaponPart(TinkerToolHandler.WeaponParts.BOWSTRING);
        this.materialIDs.put(id, mat);
        this.materialNames.put(name, mat);
        return mat;
    }

    private void addNativeToolMaterial(int id, String name, int harvestLevel, int dura, int speed, int attack, float handleModifier, int reinforced, float stonebound, String chat, int color) {
        NativeTinkerMaterial mat = new NativeTinkerMaterial(id, name, harvestLevel, dura, speed, attack, handleModifier, reinforced, stonebound, chat, color);
        this.materialIDs.put(id, mat);
        this.materialNames.put(name, mat);
    }

    public int getMaterialID(String name) {
        AbstractMaterial mat = this.materialNames.get(name);
        return mat != null ? Integer.valueOf(mat.id) : null;
    }

    public boolean isPartEnabled(int id, TinkerToolHandler.ToolParts p) {
        AbstractMaterial mat = this.materialIDs.get(id);
        return mat instanceof CustomTinkerMaterial ? ((CustomTinkerMaterial)mat).toolParts.contains(p) : true;
    }

    public boolean isPartEnabled(int id, TinkerToolHandler.WeaponParts p) {
        AbstractMaterial mat = this.materialIDs.get(id);
        return mat instanceof CustomTinkerMaterial ? ((CustomTinkerMaterial)mat).weaponParts.contains(p) : true;
    }

    static {
        Class<?> c;
        instance = new TinkerMaterialHelper();
        try {
            c = Class.forName("tconstruct.library.TConstructRegistry");
            registerMaterial = c.getDeclaredMethod("addToolMaterial", Integer.TYPE, String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Float.TYPE, Integer.TYPE, Float.TYPE, String.class, Integer.TYPE);
            registerDefaultMaterial = c.getDeclaredMethod("addDefaultToolPartMaterial", Integer.TYPE);
            registerChunkMaterial = c.getDeclaredMethod("addDefaultShardMaterial", Integer.TYPE);
            registerPartMapping = c.getDeclaredMethod("addPartMapping", Item.class, Integer.TYPE, Integer.TYPE, ItemStack.class);
            registerBowstringMaterial = c.getDeclaredMethod("addBowstringMaterial", Integer.TYPE, Integer.TYPE, ItemStack.class, ItemStack.class, Float.TYPE, Float.TYPE, Float.TYPE, Integer.TYPE);
            registerBowMaterial = c.getDeclaredMethod("addBowMaterial", Integer.TYPE, Integer.TYPE, Float.TYPE);
            registerArrowMaterial = c.getDeclaredMethod("addArrowMaterial", Integer.TYPE, Float.TYPE, Float.TYPE);
            instance.addNativeToolMaterial(0, "Wood", 1, 97, 350, 0, 1.0f, 0, 0.0f, EnumChatFormatting.YELLOW.toString(), 7690273);
            instance.addNativeToolMaterial(1, "Stone", 1, 131, 400, 1, 0.5f, 0, 1.0f, EnumChatFormatting.GRAY.toString(), 0x7F7F7F);
            instance.addNativeToolMaterial(2, "Iron", 2, 250, 600, 2, 1.3f, 1, 0.0f, EnumChatFormatting.WHITE.toString(), 0xDADADA);
            instance.addNativeToolMaterial(3, "Flint", 1, 171, 525, 2, 0.7f, 0, 0.0f, EnumChatFormatting.DARK_GRAY.toString(), 0x484848);
            instance.addNativeToolMaterial(4, "Cactus", 1, 150, 500, 2, 1.0f, 0, -1.0f, EnumChatFormatting.DARK_GREEN.toString(), 1206539);
            instance.addNativeToolMaterial(5, "Bone", 1, 200, 400, 1, 1.0f, 0, 0.0f, EnumChatFormatting.YELLOW.toString(), 15592394);
            instance.addNativeToolMaterial(6, "Obsidian", 3, 89, 700, 2, 0.8f, 3, 0.0f, EnumChatFormatting.LIGHT_PURPLE.toString(), 11173877);
            instance.addNativeToolMaterial(7, "Netherrack", 2, 131, 400, 1, 1.2f, 0, 1.0f, EnumChatFormatting.DARK_RED.toString(), 0x833238);
            instance.addNativeToolMaterial(8, "Slime", 0, 500, 150, 0, 1.5f, 0, 0.0f, EnumChatFormatting.GREEN.toString(), 7254117);
            instance.addNativeToolMaterial(9, "Paper", 0, 30, 200, 0, 0.3f, 0, 0.0f, EnumChatFormatting.WHITE.toString(), 0xFFFFFF);
            instance.addNativeToolMaterial(10, "Cobalt", 4, 800, 1400, 3, 1.75f, 2, 0.0f, EnumChatFormatting.DARK_AQUA.toString(), 2324189);
            instance.addNativeToolMaterial(11, "Ardite", 4, 500, 800, 3, 2.0f, 0, 2.0f, EnumChatFormatting.DARK_RED.toString(), 10825728);
            instance.addNativeToolMaterial(12, "Manyullyn", 5, 1200, 900, 4, 2.5f, 0, 0.0f, EnumChatFormatting.DARK_PURPLE.toString(), 7551141);
            instance.addNativeToolMaterial(13, "Copper", 1, 180, 500, 2, 1.15f, 0, 0.0f, EnumChatFormatting.RED.toString(), 13394960);
            instance.addNativeToolMaterial(14, "Bronze", 2, 550, 800, 2, 1.3f, 1, 0.0f, EnumChatFormatting.GOLD.toString(), 13277526);
            instance.addNativeToolMaterial(15, "Alumite", 4, 700, 800, 3, 1.3f, 2, 0.0f, EnumChatFormatting.LIGHT_PURPLE.toString(), 16754665);
            instance.addNativeToolMaterial(16, "Steel", 4, 750, 1000, 4, 1.3f, 2, 0.0f, EnumChatFormatting.GRAY.toString(), 0xA0A0A0);
            instance.addNativeToolMaterial(17, "BlueSlime", 0, 1200, 150, 0, 2.0f, 0, 0.0f, EnumChatFormatting.AQUA.toString(), 6729392);
            instance.addNativeToolMaterial(18, "PigIron", 3, 250, 600, 2, 1.3f, 1, 0.0f, EnumChatFormatting.RED.toString(), 15771812);
            if (ModList.THAUMCRAFT.isLoaded()) {
                instance.addNativeToolMaterial(31, "Thaumium", 3, 400, 700, 2, 1.3f, 0, 0.0f, "\u00a75", 5325692);
            }
        }
        catch (Exception e) {
            DragonAPICore.logError("Could not load Tool Material Handler!");
            e.printStackTrace();
            ReflectiveFailureTracker.instance.logModReflectiveFailure(ModList.TINKERER, e);
        }
        try {
            c = Class.forName("tconstruct.library.client.TConstructClientRegistry");
            registerTextures = c.getDeclaredMethod("addMaterialRenderMapping", Integer.TYPE, String.class, String.class, Boolean.TYPE);
        }
        catch (Exception e) {
            DragonAPICore.logError("Could not load Tool Material Handler!");
            e.printStackTrace();
            ReflectiveFailureTracker.instance.logModReflectiveFailure(ModList.TINKERER, e);
        }
        try {
            c = Class.forName("tconstruct.tools.TinkerTools");
            toolShard = (Item)c.getDeclaredField("toolShard").get(null);
            toolRod = (Item)c.getDeclaredField("toolRod").get(null);
        }
        catch (Exception e) {
            DragonAPICore.logError("Could not load Tool Material Handler!");
            e.printStackTrace();
            ReflectiveFailureTracker.instance.logModReflectiveFailure(ModList.TINKERER, e);
        }
        try {
            c = Class.forName("tconstruct.weaponry.TinkerWeaponry");
            arrowhead = (Item)c.getDeclaredField("arrowhead").get(null);
            bowstring = (Item)c.getDeclaredField("bowstring").get(null);
        }
        catch (Exception e) {
            DragonAPICore.logError("Could not load Tool Material Handler!");
            e.printStackTrace();
            ReflectiveFailureTracker.instance.logModReflectiveFailure(ModList.TINKERER, e);
        }
        try {
            c = Class.forName("tconstruct.library.crafting.PatternBuilder");
            patternBuilder = c.getDeclaredField("instance").get(null);
            registerRepairMaterial = c.getDeclaredMethod("registerFullMaterial", ItemStack.class, Integer.TYPE, String.class, ItemStack.class, ItemStack.class, Integer.TYPE);
        }
        catch (Exception e) {
            DragonAPICore.logError("Could not load Tool Material Handler!");
            e.printStackTrace();
            ReflectiveFailureTracker.instance.logModReflectiveFailure(ModList.TINKERER, e);
        }
    }

    public static class CustomTinkerMaterial
    extends AbstractMaterial {
        public final DragonAPIMod mod;
        public int harvestLevel = 2;
        public int durability = 300;
        public int miningSpeed = 800;
        public int reinforced = 0;
        public float handleModifier = 1.0f;
        public float stonebound = 0.0f;
        public int damageBoost = 2;
        public int renderColor = 0xFFFFFF;
        public String chatColor = "";
        private boolean enforceNoCheating = false;
        private final EnumSet<TinkerToolHandler.ToolParts> toolParts = EnumSet.allOf(TinkerToolHandler.ToolParts.class);
        private final EnumSet<TinkerToolHandler.WeaponParts> weaponParts = EnumSet.allOf(TinkerToolHandler.WeaponParts.class);

        private CustomTinkerMaterial(int id, DragonAPIMod mod, String name) {
            super(id, name);
            this.mod = mod;
        }

        public CustomTinkerMaterial setUnbreakable() {
            this.reinforced = 10;
            return this;
        }

        public CustomTinkerMaterial setDisallowCheatedParts() {
            this.enforceNoCheating = true;
            return this;
        }

        public CustomTinkerMaterial addToolPart(TinkerToolHandler.ToolParts tool) {
            this.toolParts.add(tool);
            return this;
        }

        public CustomTinkerMaterial addWeaponPart(TinkerToolHandler.WeaponParts weapon) {
            this.weaponParts.add(weapon);
            return this;
        }

        public CustomTinkerMaterial disableToolPart(TinkerToolHandler.ToolParts tool) {
            this.toolParts.remove(tool);
            return this;
        }

        public CustomTinkerMaterial disableWeaponPart(TinkerToolHandler.WeaponParts weapon) {
            this.weaponParts.remove(weapon);
            return this;
        }

        public CustomTinkerMaterial clearToolParts() {
            this.toolParts.clear();
            return this;
        }

        public CustomTinkerMaterial clearWeaponParts() {
            this.weaponParts.clear();
            return this;
        }

        public CustomTinkerMaterial register(boolean shard) {
            try {
                registerMaterial.invoke(null, this.id, this.materialName, this.harvestLevel, this.durability, this.miningSpeed, this.damageBoost, Float.valueOf(this.handleModifier), this.reinforced, Float.valueOf(this.stonebound), this.chatColor, this.renderColor);
                registerDefaultMaterial.invoke(null, this.id);
                if (shard) {
                    registerChunkMaterial.invoke(null, this.id);
                }
                if (ModList.NEI.isLoaded()) {
                    ItemStack is;
                    Enum p;
                    int i;
                    for (i = 0; i < TinkerToolHandler.ToolParts.partList.length; ++i) {
                        p = TinkerToolHandler.ToolParts.partList[i];
                        if (this.toolParts.contains(p) || (is = ((TinkerToolHandler.ToolParts)p).getItem(this.id)) == null) continue;
                        NEI_DragonAPI_Config.hideItem(is);
                    }
                    for (i = 0; i < TinkerToolHandler.WeaponParts.partList.length; ++i) {
                        p = TinkerToolHandler.WeaponParts.partList[i];
                        if (this.weaponParts.contains(p) || (is = ((TinkerToolHandler.WeaponParts)p).getItem(this.id)) == null) continue;
                        NEI_DragonAPI_Config.hideItem(is);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                ReflectiveFailureTracker.instance.logModReflectiveFailure(ModList.TINKERER, e);
            }
            return this;
        }

        public CustomTinkerMaterial registerTexture(String path, boolean prependToolType) {
            try {
                registerTextures.invoke(null, this.id, this.mod.getDisplayName(), path, prependToolType);
            }
            catch (Exception e) {
                e.printStackTrace();
                ReflectiveFailureTracker.instance.logModReflectiveFailure(ModList.TINKERER, e);
            }
            return this;
        }

        public CustomTinkerMaterial registerRepairMaterial(ItemStack input) {
            try {
                registerRepairMaterial.invoke(patternBuilder, input, 2, this.materialName, new ItemStack(toolShard, 1, this.id), new ItemStack(toolRod, 1, this.id), this.id);
            }
            catch (Exception e) {
                e.printStackTrace();
                ReflectiveFailureTracker.instance.logModReflectiveFailure(ModList.TINKERER, e);
            }
            return this;
        }

        public CustomTinkerMaterial registerPatternBuilder(ItemStack input) {
            try {
                for (TinkerToolHandler.ToolParts toolParts : this.toolParts) {
                    registerPartMapping.invoke(null, TinkerToolHandler.getInstance().toolWoodPattern, toolParts.castMeta, this.id, toolParts.getItem(this.id));
                }
                for (TinkerToolHandler.WeaponParts weaponParts : this.weaponParts) {
                    registerPartMapping.invoke(null, TinkerToolHandler.getInstance().weaponWoodPattern, weaponParts.castMeta, this.id, weaponParts.getItem(this.id));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                ReflectiveFailureTracker.instance.logModReflectiveFailure(ModList.TINKERER, e);
            }
            return this;
        }

        public CustomTinkerMaterial registerSmelteryCasting(ItemStack input, Fluid molten, int temp, ItemStack render) {
            ItemStack item;
            ItemStack cast;
            int base = 144;
            SmelteryRecipeHandler.addIngotMelting(input, render, temp, molten);
            SmelteryRecipeHandler.addIngotCasting(input, molten, 40);
            for (TinkerToolHandler.ToolParts toolParts : this.toolParts) {
                cast = toolParts.getCast();
                item = toolParts.getItem(this.id);
                SmelteryRecipeHandler.addReversibleCasting(cast, item, render, temp, molten, (int)((float)base * toolParts.ingotCost), 80);
            }
            for (TinkerToolHandler.WeaponParts weaponParts : this.weaponParts) {
                cast = weaponParts.getCast();
                item = weaponParts.getItem(this.id);
                SmelteryRecipeHandler.addReversibleCasting(cast, item, render, temp, molten, (int)((float)base * weaponParts.ingotCost), 80);
            }
            return this;
        }

        public CustomTinkerMaterial registerWeapons(ItemStack input, int drawSpeed, float drawSpeedMult, float arrowMass, float flightSpeed, float maxSpeed, float breakChance) {
            try {
                registerBowstringMaterial.invoke(null, 1, 2, input, new ItemStack(bowstring, 1, 1), this.durability, Float.valueOf(drawSpeedMult), Float.valueOf(flightSpeed), this.renderColor);
                registerBowMaterial.invoke(null, this.id, drawSpeed, Float.valueOf(maxSpeed));
                registerArrowMaterial.invoke(null, this.id, Float.valueOf(arrowMass), Float.valueOf(this.reinforced == 10 ? 0.0f : breakChance));
            }
            catch (Exception e) {
                e.printStackTrace();
                ReflectiveFailureTracker.instance.logModReflectiveFailure(ModList.TINKERER, e);
            }
            return this;
        }
    }

    public static class NativeTinkerMaterial
    extends AbstractMaterial {
        public final int harvestLevel;
        public final int durability;
        public final int miningSpeed;
        public final int reinforced;
        public final float handleModifier;
        public final float stonebound;
        public final int damageBoost;
        public final int renderColor;
        public final String chatColor;

        private NativeTinkerMaterial(int id, String name, int harvestLevel, int dura, int speed, int attack, float handleModifier, int reinforced, float stonebound, String chat, int color) {
            super(id, name);
            this.harvestLevel = harvestLevel;
            this.miningSpeed = speed;
            this.durability = dura;
            this.reinforced = reinforced;
            this.handleModifier = handleModifier;
            this.stonebound = stonebound;
            this.damageBoost = attack;
            this.renderColor = color;
            this.chatColor = chat;
        }
    }

    private static abstract class AbstractMaterial {
        public final int id;
        public final String materialName;

        protected AbstractMaterial(int id, String name) {
            this.id = id;
            this.materialName = name;
        }
    }
}

