/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.ModInteract.DeepInteract;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Data.Maps.ItemHashMap;
import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingCallback;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.crafting.ICraftingJob;
import appeng.api.networking.crafting.ICraftingLink;
import appeng.api.networking.crafting.ICraftingRequester;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.MachineSource;
import appeng.api.networking.security.PlayerSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class MESystemReader {
    private final IGridNode node;
    private final BaseActionSource actionSource;
    private ICraftingRequester requester = null;
    private final IdentityHashMap<Future<ICraftingJob>, CraftCompleteCallback> crafting = new IdentityHashMap();
    private final MultiMap<CraftCompleteCallback, ICraftingLink> craftingLinks = new MultiMap().setNullEmpty();

    public MESystemReader(IGridNode ign, EntityPlayer ep) {
        this(ign, new PlayerSource(ep, null));
    }

    public MESystemReader(IGridNode ign, IActionHost iah) {
        this(ign, new MachineSource(iah));
    }

    public MESystemReader(IGridNode ign, MESystemReader reader) {
        this(ign, reader.actionSource);
        this.crafting.putAll(reader.crafting);
        this.craftingLinks.putAll(reader.craftingLinks);
        this.requester = reader.requester;
    }

    private MESystemReader(IGridNode ign, BaseActionSource src) {
        this.node = ign;
        this.actionSource = src;
    }

    public MESystemReader setRequester(ICraftingRequester icr) {
        this.requester = icr;
        return this;
    }

    private IMEMonitor<IAEItemStack> getStorage() {
        if (this.node == null || this.node.getGrid() == null) {
            return null;
        }
        return ((IStorageGrid)this.node.getGrid().getCache(IStorageGrid.class)).getItemInventory();
    }

    private ICraftingGrid getCraftingGrid() {
        if (this.node == null || this.node.getGrid() == null) {
            return null;
        }
        return (ICraftingGrid)this.node.getGrid().getCache(ICraftingGrid.class);
    }

    public ItemHashMap<Long> getMESystemContents() {
        ItemHashMap<Long> map = new ItemHashMap<Long>();
        if (this.node == null || this.node.getGrid() == null || this.getStorage() == null) {
            return map;
        }
        for (IAEItemStack iae : this.getStorage().getStorageList()) {
            if (!iae.isItem() || !iae.isMeaningful()) continue;
            map.put(iae.getItemStack(), (Long)iae.getStackSize());
        }
        return map;
    }

    public Collection<ItemStack> getRawMESystemContents() {
        ArrayList<ItemStack> c = new ArrayList<ItemStack>();
        if (this.node == null || this.node.getGrid() == null || this.getStorage() == null) {
            return c;
        }
        for (IAEItemStack iae : this.getStorage().getStorageList()) {
            if (!iae.isItem() || !iae.isMeaningful()) continue;
            c.add(iae.getItemStack());
        }
        return c;
    }

    private IAEItemStack createAEStack(ItemStack is) {
        return AEApi.instance().storage().createItemStack(is);
    }

    public long removeItem(ItemStack is, boolean simulate, boolean nbt) {
        IMEMonitor<IAEItemStack> mon = this.getStorage();
        if (!nbt) {
            Collection<IAEItemStack> c = this.getFuzzyItemList(is, FuzzyMode.IGNORE_ALL);
            IAEStack most = null;
            for (IAEItemStack iae : c) {
                if (most != null && iae.getStackSize() < most.getStackSize() || is.func_77973_b() != iae.getItem() || is.func_77960_j() != iae.getItemDamage()) continue;
                most = iae;
            }
            if (most == null) {
                return 0L;
            }
            most.setStackSize(is.field_77994_a);
            return most != null ? this.extract((IAEItemStack)most, simulate) : 0L;
        }
        return this.extract(this.createAEStack(is), simulate);
    }

    public long removeItemFuzzy(ItemStack is, boolean simulate, FuzzyMode fz, boolean oredict, boolean nbt) {
        IMEMonitor<IAEItemStack> mon = this.getStorage();
        IAEItemStack ae = this.createAEStack(is);
        Collection<IAEItemStack> c = this.getFuzzyItemList(is, fz);
        IAEStack most = null;
        for (IAEItemStack iae : c) {
            if (most != null && iae.getStackSize() < most.getStackSize() || !oredict && is.func_77973_b() != iae.getItem() || nbt && !ReikaNBTHelper.areNBTTagsEqual(is.field_77990_d, iae.getTagCompound().getNBTTagCompoundCopy())) continue;
            most = iae;
        }
        if (most == null) {
            return 0L;
        }
        most.setStackSize(is.field_77994_a);
        return most != null ? this.extract((IAEItemStack)most, simulate) : 0L;
    }

    private Collection<IAEItemStack> getFuzzyItemList(ItemStack is, FuzzyMode fz) {
        IMEMonitor<IAEItemStack> mon = this.getStorage();
        IAEItemStack ae = this.createAEStack(is);
        ArrayList<IAEItemStack> c = new ArrayList<IAEItemStack>(mon.getStorageList().findFuzzy(ae, fz));
        if (is.func_77960_j() == Short.MAX_VALUE) {
            ItemStack cp = is.func_77946_l();
            cp.func_77964_b(0);
            ae = this.createAEStack(cp);
            c.addAll(mon.getStorageList().findFuzzy(ae, fz));
        }
        return c;
    }

    private long extract(IAEItemStack ae, boolean simulate) {
        IAEItemStack is = this.getStorage().extractItems(ae, simulate ? Actionable.SIMULATE : Actionable.MODULATE, this.actionSource);
        return is != null ? is.getStackSize() : 0L;
    }

    public long addItem(ItemStack is, boolean simulate) {
        IAEItemStack ret = this.getStorage().injectItems(this.createAEStack(is), simulate ? Actionable.SIMULATE : Actionable.MODULATE, this.actionSource);
        return ret != null ? ret.getStackSize() : 0L;
    }

    public long getItemCount(ItemStack is, boolean nbt) {
        return this.removeItem(ReikaItemHelper.getSizedItemStack(is, Integer.MAX_VALUE), true, nbt);
    }

    public long getFuzzyItemCount(ItemStack is, FuzzyMode fz, boolean ore, boolean nbt) {
        return this.removeItemFuzzy(ReikaItemHelper.getSizedItemStack(is, Integer.MAX_VALUE), true, fz, ore, nbt);
    }

    public void triggerFuzzyCrafting(World world, ItemStack is, long amt, ICraftingCallback callback, CraftCompleteCallback callback2) {
        this.triggerCrafting(world, is, amt, callback, callback2);
    }

    public void triggerCrafting(World world, ItemStack is, long amt, ICraftingCallback callback, CraftCompleteCallback callback2) {
        if (this.node == null || this.node.getGrid() == null) {
            return;
        }
        IAEItemStack iae = this.createAEStack(is);
        iae.setStackSize(amt);
        if (callback == null) {
            callback = new NoopCraftingCallback();
        }
        Future<ICraftingJob> f = this.getCraftingGrid().beginCraftingJob(world, this.node.getGrid(), this.actionSource, iae, callback);
        if (callback2 != null) {
            this.crafting.put(f, callback2);
        }
    }

    public void tick() {
        ICraftingGrid cache = this.getCraftingGrid();
        if (cache != null) {
            Collection<ICraftingLink> c;
            HashSet<Future<ICraftingJob>> removeCalls = new HashSet<Future<ICraftingJob>>();
            for (Future<ICraftingJob> f : this.crafting.keySet()) {
                if (!f.isDone()) continue;
                try {
                    ICraftingJob job = f.get();
                    ICraftingLink l = cache.submitJob(job, this.requester, null, true, this.actionSource);
                    if (l == null) {
                        DragonAPICore.logError(job + " to craft " + job.getOutput() + " returned a null link!");
                    } else {
                        CraftCompleteCallback ccc = this.crafting.get(f);
                        if (ccc != null) {
                            this.craftingLinks.addValue(ccc, l);
                            ccc.onCraftingLinkReturned(l);
                        }
                    }
                    removeCalls.add(f);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
            }
            for (Future<ICraftingJob> f : removeCalls) {
                this.crafting.remove(f);
            }
            MultiMap<CraftCompleteCallback, ICraftingLink> removeLinks = new MultiMap().setNullEmpty();
            for (CraftCompleteCallback ccc : this.craftingLinks.keySet()) {
                c = this.craftingLinks.get(ccc);
                if (c == null || c.isEmpty()) continue;
                for (ICraftingLink l : c) {
                    if (!l.isDone()) continue;
                    ccc.onCraftingComplete(l);
                    removeLinks.addValue(ccc, l);
                }
            }
            for (CraftCompleteCallback ccc : removeLinks.keySet()) {
                c = removeLinks.get(ccc);
                if (c == null) continue;
                for (ICraftingLink l : c) {
                    this.craftingLinks.remove(ccc, l);
                }
            }
        }
    }

    public static enum MatchMode {
        EXACT(0xFFCC00, "Exact Match"),
        FUZZY(43775, "Fuzzy Match"),
        FUZZYORE(65280, "Fuzzy/Ore Match"),
        FUZZYNBT(0xAA00FF, "Fuzzy/Ore Match, Ignore NBT");

        public final int color;
        public final String desc;
        public static final MatchMode[] list;

        private MatchMode(int c, String s) {
            this.color = c;
            this.desc = s;
        }

        public long countItems(MESystemReader net, ItemStack is) {
            switch (this) {
                case EXACT: {
                    return net.getItemCount(is, true);
                }
                case FUZZY: {
                    return net.getFuzzyItemCount(is, FuzzyMode.IGNORE_ALL, false, true);
                }
                case FUZZYORE: {
                    return net.getFuzzyItemCount(is, FuzzyMode.IGNORE_ALL, true, true);
                }
                case FUZZYNBT: {
                    return net.getFuzzyItemCount(is, FuzzyMode.IGNORE_ALL, true, false);
                }
            }
            return 0L;
        }

        public long removeItems(MESystemReader net, ItemStack is, boolean simulate) {
            switch (this) {
                case EXACT: {
                    return net.removeItem(is, simulate, true);
                }
                case FUZZY: {
                    return net.removeItemFuzzy(is, simulate, FuzzyMode.IGNORE_ALL, false, true);
                }
                case FUZZYORE: {
                    return net.removeItemFuzzy(is, simulate, FuzzyMode.IGNORE_ALL, true, true);
                }
                case FUZZYNBT: {
                    return net.removeItemFuzzy(is, simulate, FuzzyMode.IGNORE_ALL, true, false);
                }
            }
            return 0L;
        }

        public MatchMode next() {
            return list[(this.ordinal() + 1) % list.length];
        }

        public boolean compare(ItemStack is1, ItemStack is2) {
            switch (this) {
                case EXACT: {
                    return ReikaItemHelper.matchStacks(is1, is2) && ItemStack.func_77970_a((ItemStack)is1, (ItemStack)is2);
                }
                case FUZZY: {
                    return is1.func_77973_b() == is2.func_77973_b() && ItemStack.func_77970_a((ItemStack)is1, (ItemStack)is2);
                }
                case FUZZYNBT: {
                    return is1.func_77973_b() == is2.func_77973_b();
                }
                case FUZZYORE: {
                    return ReikaItemHelper.checkOreDictOverlap(is1, is2);
                }
            }
            return false;
        }

        static {
            list = MatchMode.values();
        }
    }

    private static class NoopCraftingCallback
    implements ICraftingCallback {
        private NoopCraftingCallback() {
        }

        @Override
        public void calculationComplete(ICraftingJob job) {
        }
    }

    public static interface CraftCompleteCallback {
        public void onCraftingLinkReturned(ICraftingLink var1);

        public void onCraftingComplete(ICraftingLink var1);
    }
}

