/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.ModInteract.Bees;

import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModInteract.Bees.AlleleRegistry;
import Reika.DragonAPI.ModInteract.ItemHandlers.ForestryHandler;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeRoot;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.EnumTolerance;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleArea;
import forestry.api.genetics.IAlleleBoolean;
import forestry.api.genetics.IAlleleFloat;
import forestry.api.genetics.IAlleleInteger;
import forestry.api.genetics.IAlleleTolerance;
import forestry.api.genetics.IChromosome;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IIndividual;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ReikaBeeHelper {
    public static final ItemStack getBeeItem(String bee, EnumBeeType type) {
        return ReikaBeeHelper.getBeeItem(ReikaWorldHelper.getBasicReferenceWorld(), bee, type);
    }

    public static final ItemStack getBeeItem(World world, String bee, EnumBeeType type) {
        IBeeRoot root = BeeManager.beeRoot;
        return root.getMemberStack((IIndividual)root.getBee(world, root.templateAsGenome(root.getTemplate(bee))), type.ordinal());
    }

    public static void analyzeBee(ItemStack is) {
        IIndividual bee;
        if (is != null && (bee = AlleleManager.alleleRegistry.getIndividual(is)) != null) {
            bee.analyze();
            ReikaBeeHelper.saveBee(bee, is);
        }
    }

    public static void ageBee(World world, ItemStack is, float modifier) {
        IIndividual bee;
        if (is != null && (bee = AlleleManager.alleleRegistry.getIndividual(is)) instanceof IBee) {
            ((IBee)bee).age(world, modifier);
            ReikaBeeHelper.saveBee(bee, is);
        }
    }

    public static boolean isBee(ItemStack is) {
        return is.func_77973_b() == ForestryHandler.ItemEntry.DRONE.getItem() || is.func_77973_b() == ForestryHandler.ItemEntry.PRINCESS.getItem() || is.func_77973_b() == ForestryHandler.ItemEntry.QUEEN.getItem();
    }

    public static void setPristine(ItemStack is, boolean flag) {
        IIndividual bee = AlleleManager.alleleRegistry.getIndividual(is);
        if (bee instanceof IBee) {
            ((IBee)bee).setIsNatural(flag);
            ReikaBeeHelper.saveBee(bee, is);
        }
    }

    private static void saveBee(IIndividual bee, ItemStack is) {
        NBTTagCompound tag = new NBTTagCompound();
        bee.writeToNBT(tag);
        is.field_77990_d = tag;
    }

    private static void saveBee(IGenome bee, ItemStack is) {
        NBTTagCompound tag = new NBTTagCompound();
        bee.writeToNBT(tag);
        if (is.field_77990_d == null) {
            is.field_77990_d = new NBTTagCompound();
        }
        is.field_77990_d.func_74782_a("Genome", (NBTBase)tag);
    }

    public static int getToleranceValue(EnumTolerance t) {
        return t == EnumTolerance.NONE ? 0 : ReikaMathLibrary.getWithinBoundsElse(Character.getNumericValue(t.name().charAt(t.name().length() - 1)), 0, 5, 0);
    }

    public static AlleleRegistry.Tolerance getToleranceType(EnumTolerance t) {
        if (t == EnumTolerance.NONE) {
            return AlleleRegistry.Tolerance.NONE;
        }
        String s = t.name().substring(0, t.name().indexOf(95));
        return AlleleRegistry.Tolerance.valueOf(s);
    }

    public static EnumTolerance getOneBetterTolerance(EnumTolerance t) {
        AlleleRegistry.Tolerance type = ReikaBeeHelper.getToleranceType(t);
        int val = ReikaBeeHelper.getToleranceValue(t);
        if (val > 0 && val < 5) {
            return ReikaBeeHelper.getTolerance(type, ++val);
        }
        return null;
    }

    public static EnumTolerance getTolerance(AlleleRegistry.Tolerance type, int val) {
        String s = val > 0 ? type.name() + "_" + val : type.name();
        return EnumTolerance.valueOf((String)s);
    }

    public static void setGene(ItemStack queen, IBeeGenome ibg, EnumBeeChromosome gene, IAllele value, boolean inactive) {
        boolean ana = AlleleManager.alleleRegistry.getIndividual(queen).isAnalyzed();
        IChromosome[] ic = ibg.getChromosomes();
        IAllele[] arr = BeeManager.beeRoot.getDefaultTemplate();
        IAllele[] arr2 = BeeManager.beeRoot.getDefaultTemplate();
        for (int i = 0; i < arr.length; ++i) {
            if (ic[i] == null) continue;
            arr[i] = ic[i].getActiveAllele();
            arr2[i] = ic[i].getInactiveAllele();
        }
        arr[gene.ordinal()] = value;
        if (inactive) {
            arr2[gene.ordinal()] = value;
        }
        IBeeGenome repl = BeeManager.beeRoot.templateAsGenome(arr, arr2);
        ReikaBeeHelper.saveBee((IGenome)repl, queen);
        if (ana) {
            ReikaBeeHelper.analyzeBee(queen);
        }
    }

    public static AlleleRegistry.BeeGene getGeneEnum(EnumBeeChromosome gene, IBeeGenome ibg) {
        switch (gene) {
            case EFFECT: {
                return AlleleRegistry.getEnum(ibg.getActiveAllele((IChromosomeType)gene), AlleleRegistry.Effect.class);
            }
            case FERTILITY: {
                return AlleleRegistry.getEnum(ibg.getActiveAllele((IChromosomeType)gene), AlleleRegistry.Fertility.class);
            }
            case FLOWERING: {
                return AlleleRegistry.getEnum(ibg.getActiveAllele((IChromosomeType)gene), AlleleRegistry.Flowering.class);
            }
            case FLOWER_PROVIDER: {
                return AlleleRegistry.getEnum(ibg.getActiveAllele((IChromosomeType)gene), AlleleRegistry.Flower.class);
            }
            case HUMIDITY_TOLERANCE: {
                return ReikaBeeHelper.getToleranceType(ibg.getToleranceHumid());
            }
            case TEMPERATURE_TOLERANCE: {
                return ReikaBeeHelper.getToleranceType(ibg.getToleranceTemp());
            }
            case LIFESPAN: {
                return AlleleRegistry.getEnum(ibg.getActiveAllele((IChromosomeType)gene), AlleleRegistry.Life.class);
            }
            case SPEED: {
                return AlleleRegistry.getEnum(ibg.getActiveAllele((IChromosomeType)gene), AlleleRegistry.Speeds.class);
            }
            case TERRITORY: {
                return AlleleRegistry.getEnum(ibg.getActiveAllele((IChromosomeType)gene), AlleleRegistry.Territory.class);
            }
        }
        return null;
    }

    public static IAllele getToleranceGene(EnumTolerance t) {
        return ReikaBeeHelper.getToleranceGene(ReikaBeeHelper.getToleranceType(t), ReikaBeeHelper.getToleranceValue(t));
    }

    public static IAllele getToleranceGene(AlleleRegistry.Tolerance d, int i) {
        String s = i > 0 ? String.format("%s%d", d.tag, Math.min(Math.abs(i), 5)) : AlleleRegistry.Tolerance.NONE.tag;
        return AlleleManager.alleleRegistry.getAllele(s);
    }

    public static void runProductionCycle(IBeeHousing ibh) {
        ItemStack[] ret;
        IIndividual bee;
        ItemStack is;
        if (ibh.getBeekeepingLogic().canWork() && (is = ibh.getBeeInventory().getQueen()) != null && (bee = AlleleManager.alleleRegistry.getIndividual(is)) instanceof IBee && (ret = ((IBee)bee).produceStacks(ibh)) != null) {
            for (int i = 0; i < ret.length; ++i) {
                ItemStack in = ret[i];
                ibh.getBeeInventory().addProduct(in, false);
            }
        }
    }

    public static void setBeeMate(IBee ii, IBee repl) {
        ii.mate((IIndividual)repl);
    }

    public static ArrayList<String> getGenesAsStringList(ItemStack is) {
        IIndividual ii = AlleleManager.alleleRegistry.getIndividual(is);
        return ii != null ? ReikaBeeHelper.getGenesAsStringList(ii.getGenome()) : new ArrayList<String>();
    }

    public static ArrayList<String> getGenesAsStringList(IGenome ig) {
        ArrayList<String> li = new ArrayList<String>();
        IAlleleBeeSpecies sp1 = (IAlleleBeeSpecies)ig.getPrimary();
        IAlleleBeeSpecies sp2 = (IAlleleBeeSpecies)ig.getSecondary();
        EnumBeeChromosome[] order = new EnumBeeChromosome[]{EnumBeeChromosome.SPECIES, EnumBeeChromosome.LIFESPAN, EnumBeeChromosome.SPEED, EnumBeeChromosome.FLOWERING, EnumBeeChromosome.FLOWER_PROVIDER, EnumBeeChromosome.FERTILITY, EnumBeeChromosome.TERRITORY, EnumBeeChromosome.EFFECT, EnumBeeChromosome.NOCTURNAL, EnumBeeChromosome.TOLERANT_FLYER, EnumBeeChromosome.CAVE_DWELLING};
        for (int i = 0; i < order.length; ++i) {
            IAllele ia1 = ig.getActiveAllele((IChromosomeType)order[i]);
            IAllele ia2 = ig.getInactiveAllele((IChromosomeType)order[i]);
            li.add(ReikaBeeHelper.getGeneDisplay(ia1, order[i], true, true) + " / " + ReikaBeeHelper.getGeneDisplay(ia2, order[i], false, false));
            if (order[i] != EnumBeeChromosome.EFFECT) continue;
            String t1 = ReikaBeeHelper.getTemperatureDisplay(sp1, (IAlleleTolerance)ig.getActiveAllele((IChromosomeType)EnumBeeChromosome.TEMPERATURE_TOLERANCE), true, true);
            String t2 = ReikaBeeHelper.getTemperatureDisplay(sp2, (IAlleleTolerance)ig.getInactiveAllele((IChromosomeType)EnumBeeChromosome.TEMPERATURE_TOLERANCE), false, false);
            li.add(t1 + " / " + t2);
            String h1 = ReikaBeeHelper.getHumidityDisplay(sp1, (IAlleleTolerance)ig.getActiveAllele((IChromosomeType)EnumBeeChromosome.HUMIDITY_TOLERANCE), true, true);
            String h2 = ReikaBeeHelper.getHumidityDisplay(sp2, (IAlleleTolerance)ig.getInactiveAllele((IChromosomeType)EnumBeeChromosome.HUMIDITY_TOLERANCE), false, false);
            li.add(h1 + " / " + h2);
        }
        return li;
    }

    public static String getTemperatureDisplay(IAlleleBeeSpecies bee, IAlleleTolerance tol, boolean title, boolean primary) {
        EnumChatFormatting ec = primary ? EnumChatFormatting.GREEN : EnumChatFormatting.RED;
        String ret = ec + AlleleManager.climateHelper.toDisplay(bee.getTemperature()) + "/" + tol.getName() + EnumChatFormatting.RESET;
        if (title) {
            ret = EnumChatFormatting.LIGHT_PURPLE + "Temperature: " + EnumChatFormatting.RESET + ret;
        }
        return ret;
    }

    public static String getHumidityDisplay(IAlleleBeeSpecies bee, IAlleleTolerance tol, boolean title, boolean primary) {
        EnumChatFormatting ec = primary ? EnumChatFormatting.GREEN : EnumChatFormatting.RED;
        String ret = ec + AlleleManager.climateHelper.toDisplay(bee.getHumidity()) + "/" + tol.getName() + EnumChatFormatting.RESET;
        if (title) {
            ret = EnumChatFormatting.LIGHT_PURPLE + "Humidity: " + EnumChatFormatting.RESET + ret;
        }
        return ret;
    }

    public static String getGeneDisplay(IAllele gene, EnumBeeChromosome type, boolean title, boolean primary) {
        EnumChatFormatting ec = primary ? EnumChatFormatting.GREEN : EnumChatFormatting.RED;
        String tag = "";
        String val = gene.getName();
        switch (type) {
            case EFFECT: {
                tag = "for.gui.effect";
                break;
            }
            case FERTILITY: {
                tag = "for.gui.fertility";
                val = val + " (" + ((IAlleleInteger)gene).getValue() + ")";
                break;
            }
            case FLOWERING: {
                tag = "for.gui.pollination";
                val = val + " (" + ((IAlleleInteger)gene).getValue() * 20 * 60 / 550 + "/min)";
                break;
            }
            case FLOWER_PROVIDER: {
                tag = "for.gui.flowers";
                break;
            }
            case HUMIDITY_TOLERANCE: {
                tag = "for.gui.tolerance";
                break;
            }
            case TEMPERATURE_TOLERANCE: {
                tag = "for.gui.tolerance";
                break;
            }
            case LIFESPAN: {
                tag = "for.gui.life";
                val = val + " (" + ((IAlleleInteger)gene).getValue() + ")";
                break;
            }
            case SPECIES: {
                tag = "for.gui.species";
                break;
            }
            case SPEED: {
                tag = "for.gui.worker";
                val = val + " (" + ((IAlleleFloat)gene).getValue() + "x)";
                break;
            }
            case TERRITORY: {
                tag = "for.gui.area";
                IAlleleArea ia = (IAlleleArea)gene;
                val = val + " (" + ia.getValue()[0] + "x" + ia.getValue()[1] + "x" + ia.getValue()[2] + ")";
                break;
            }
            case NOCTURNAL: {
                tag = "for.gui.nocturnal";
                val = StatCollector.func_74838_a((String)(((IAlleleBoolean)gene).getValue() ? "for.yes" : "for.no"));
                break;
            }
            case CAVE_DWELLING: {
                tag = "for.gui.cave";
                val = StatCollector.func_74838_a((String)(((IAlleleBoolean)gene).getValue() ? "for.yes" : "for.no"));
                break;
            }
            case TOLERANT_FLYER: {
                tag = "for.gui.flyer";
                val = StatCollector.func_74838_a((String)(((IAlleleBoolean)gene).getValue() ? "for.yes" : "for.no"));
                break;
            }
        }
        return title ? EnumChatFormatting.LIGHT_PURPLE + StatCollector.func_74838_a((String)tag) + ": " + EnumChatFormatting.RESET + ec + val + EnumChatFormatting.RESET : ec + val + EnumChatFormatting.RESET;
    }

    public static IBeeRoot getBeeRoot() {
        return (IBeeRoot)AlleleManager.alleleRegistry.getSpeciesRoot("rootBees");
    }

    public static boolean isPristine(ItemStack is) {
        IIndividual bee = AlleleManager.alleleRegistry.getIndividual(is);
        return bee instanceof IBee && ((IBee)bee).isNatural();
    }

    public static IBeeGenome getGenome(ItemStack is) {
        IIndividual bee = AlleleManager.alleleRegistry.getIndividual(is);
        return bee instanceof IBee ? ((IBee)bee).getGenome() : null;
    }

    public static IBee getBee(ItemStack is) {
        IIndividual bee = AlleleManager.alleleRegistry.getIndividual(is);
        return bee instanceof IBee ? (IBee)bee : null;
    }

    public static IAlleleBeeSpecies getSpecies(ItemStack is) {
        IBeeGenome ig = ReikaBeeHelper.getGenome(is);
        return ig != null ? ig.getPrimary() : null;
    }

    public static float getTemperatureRangeCenter(EnumTemperature t) {
        switch (t) {
            case ICY: {
                return -0.1f;
            }
            case COLD: {
                return 0.175f;
            }
            case NORMAL: {
                return 0.6f;
            }
            case WARM: {
                return 0.925f;
            }
            case HOT: {
                return 1.1f;
            }
            case HELLISH: {
                return 2.0f;
            }
        }
        return Float.NaN;
    }

    public static float getHumidityRangeCenter(EnumHumidity h) {
        switch (h) {
            case ARID: {
                return 0.15f;
            }
            case NORMAL: {
                return 0.5f;
            }
            case DAMP: {
                return 1.0f;
            }
        }
        return Float.NaN;
    }
}

