/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.ModInteract;

import Reika.DragonAPI.IO.ReikaFileReader;
import Reika.DragonAPI.Instantiable.Data.Collections.OneWayCollections;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public final class BannedItemReader {
    public static final BannedItemReader instance = new BannedItemReader();
    private final OneWayCollections.OneWayList<ItemBanEntry> allEntries = new OneWayCollections.OneWayList();
    private final OneWayCollections.OneWaySet<Integer> allIds = new OneWayCollections.OneWaySet();

    private BannedItemReader() {
    }

    public void initWith(String path) {
        String main = System.getProperty("user.dir").replaceAll("\\\\", "/");
        String file = main + "/plugins/" + path;
        File f = new File(file);
        if (f.exists() && f.isDirectory()) {
            try {
                this.parseDirectory(f);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public boolean containsID(Block id) {
        return this.containsID(Block.func_149682_b((Block)id));
    }

    public boolean containsID(Item item) {
        return this.containsID(Item.func_150891_b((Item)item));
    }

    private boolean containsID(int id) {
        return this.allIds.contains(id);
    }

    public boolean containsItem(ItemStack is) {
        for (int i = 0; i < this.allEntries.size(); ++i) {
            ItemBanEntry e = (ItemBanEntry)this.allEntries.get(i);
            if (!e.matches(is)) continue;
            return true;
        }
        return false;
    }

    private void parseDirectory(File f) throws Exception {
        ArrayList<File> li = ReikaFileReader.getAllFilesInFolder(f, "yml", "txt", "dat", "cfg");
        for (int i = 0; i < li.size(); ++i) {
            this.parseFile(li.get(i));
        }
    }

    private void parseFile(File f) throws Exception {
        BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
        String line = in.readLine();
        while (line != null) {
            String[] parts;
            String oline = line;
            while (!line.isEmpty() && !Character.isDigit(line.charAt(0))) {
                line = line.substring(1);
            }
            if (!line.isEmpty() && (parts = line.split(":")) != null && parts.length > 1) {
                try {
                    String id = parts[0];
                    String meta = parts[1];
                    int intid = Integer.parseInt(id);
                    int intmeta = meta.equals("*") ? -1 : Integer.parseInt(meta);
                    this.allEntries.add(new ItemBanEntry(intid, intmeta));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            line = in.readLine();
        }
        in.close();
    }

    private static final class ItemBanEntry {
        public final int itemID;
        public final int itemDamage;

        private ItemBanEntry(int id, int meta) {
            this.itemID = id;
            this.itemDamage = meta;
        }

        private ItemBanEntry(int id) {
            this(id, -1);
        }

        public boolean hasMeta() {
            return this.itemDamage >= 0;
        }

        public String toString() {
            return this.itemID + ":" + this.itemDamage;
        }

        public boolean matches(ItemStack is) {
            return this.itemID == Item.func_150891_b((Item)is.func_77973_b()) && (this.itemDamage < 0 || this.itemDamage == is.func_77960_j());
        }
    }
}

