/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Libraries.World;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.ReikaEntityHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public final class ReikaChunkHelper
extends DragonAPICore {
    public static Chunk getChunk(World world, int x, int z) {
        Chunk in = world.func_72938_d(x, z);
        return in;
    }

    public static void regenChunk(World world, int x, int z) {
        Chunk in = world.func_72938_d(x, z);
        in.func_76630_e();
    }

    public static void emptyChunk(World world, int x, int z) {
        while (x % 16 > 0) {
            --x;
        }
        while (z % 16 > 0) {
            --z;
        }
        AxisAlignedBB chunk = AxisAlignedBB.func_72330_a((double)x, (double)0.0, (double)z, (double)(x + 16), (double)255.0, (double)(z + 16));
        List inChunk = world.func_72872_a(Entity.class, chunk);
        for (int i = 0; i < inChunk.size(); ++i) {
            Entity ent = (Entity)inChunk.get(i);
            if (ent instanceof EntityPlayer) continue;
            ent.func_70106_y();
        }
    }

    public static void deleteChunk(World world, int x, int z, Block id) {
        for (Block b : Block.field_149771_c) {
            if (id == b) continue;
            ReikaChunkHelper.removeIDFromChunk(world, x, z, b);
        }
    }

    public static void removeFromChunk(World world, int x, int z, Class entityClass) {
        while (x % 16 > 0) {
            --x;
        }
        while (z % 16 > 0) {
            --z;
        }
        AxisAlignedBB chunk = AxisAlignedBB.func_72330_a((double)x, (double)0.0, (double)z, (double)(x + 16), (double)255.0, (double)(z + 16));
        List inChunk = world.func_72872_a(entityClass, chunk);
        for (int i = 0; i < inChunk.size(); ++i) {
            Entity ent = (Entity)inChunk.get(i);
            ent.func_70106_y();
        }
    }

    public static void removeBlocksFromChunk(World world, int x, int z, Block id, int meta) {
        if (meta == -1) {
            ReikaChunkHelper.removeIDFromChunk(world, x, z, id);
            return;
        }
        ReikaChunkHelper.replaceBlocksInChunk(world, x, z, id, meta, Blocks.field_150350_a, 0);
    }

    public static void replaceBlocksInChunk(World world, int x, int z, Block id, int meta, Block setid, int setmeta) {
        boolean nx = false;
        boolean nz = false;
        if (x < 0) {
            x = -x;
            nx = true;
        }
        if (z < 0) {
            z = -z;
            nz = true;
        }
        while (x % 16 > 0) {
            if (nx) {
                ++x;
                continue;
            }
            --x;
        }
        while (z % 16 > 0) {
            if (nx) {
                ++z;
                continue;
            }
            --z;
        }
        if (nx) {
            x = -x;
        }
        if (nz) {
            z = -z;
        }
        if (meta == -1) {
            ReikaChunkHelper.replaceIDInChunk(world, x, z, id, setid, setmeta);
            return;
        }
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                for (int k = 0; k < 256; ++k) {
                    Block idread = world.func_147439_a(x + i, k, z + j);
                    int metaread = world.func_72805_g(x + i, k, z + j);
                    if (idread != id || metaread != meta) continue;
                    world.func_147465_d(x + i, k, z + j, setid, setmeta, 3);
                }
            }
        }
    }

    private static void replaceIDInChunk(World world, int x, int z, Block id, Block setid, int setmeta) {
        boolean nx = false;
        boolean nz = false;
        if (x < 0) {
            x = -x;
            nx = true;
        }
        if (z < 0) {
            z = -z;
            nz = true;
        }
        while (x % 16 > 0) {
            if (nx) {
                ++x;
                continue;
            }
            --x;
        }
        while (z % 16 > 0) {
            if (nx) {
                ++z;
                continue;
            }
            --z;
        }
        if (nx) {
            x = -x;
        }
        if (nz) {
            z = -z;
        }
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                for (int k = 0; k < 256; ++k) {
                    Block idread = world.func_147439_a(x + i, k, z + j);
                    if (idread != id) continue;
                    world.func_147465_d(x + i, k, z + j, setid, setmeta, 3);
                }
            }
        }
    }

    private static void removeIDFromChunk(World world, int x, int z, Block id) {
        ReikaChunkHelper.replaceIDInChunk(world, x, z, id, Blocks.field_150350_a, 0);
    }

    public static double getPoplnDensity(World world, Entity entity, double x, double y, double z, double r) {
        Entity entityfound = world.func_72857_a(entity.getClass(), AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1.0), (double)(y + 1.0), (double)(z + 1.0)).func_72314_b(r, r, r), entity);
        if (entityfound == null) {
            return -1.0;
        }
        double dist = ReikaMathLibrary.py3d(x - entityfound.field_70165_t, y - entityfound.field_70163_u, z - entityfound.field_70161_v);
        return dist;
    }

    public static int getChunkPopln(World world, Class entity, int x, int z) {
        while (x % 16 > 0) {
            --x;
        }
        while (z % 16 > 0) {
            --z;
        }
        int entitiesfound = world.func_72872_a(entity, AxisAlignedBB.func_72330_a((double)x, (double)0.0, (double)z, (double)(x + 16), (double)255.0, (double)(z + 16))).size();
        return entitiesfound;
    }

    public static int getChunkRangePopln(World world, Class entity, int x, int z, int x2, int z2) {
        while (x % 16 > 0) {
            --x;
        }
        while (z % 16 > 0) {
            --z;
        }
        while (x % 16 > 0) {
            --x2;
        }
        while (z % 16 > 0) {
            ++z2;
        }
        int entitiesfound = world.func_72872_a(entity, AxisAlignedBB.func_72330_a((double)x, (double)0.0, (double)z, (double)x2, (double)255.0, (double)z2)).size();
        return entitiesfound;
    }

    public static Collection<Entity> getEntities(Chunk ch, ReikaEntityHelper.ClassEntitySelector sel) {
        ArrayList<Entity> c = new ArrayList<Entity>();
        for (int i = 0; i < ch.field_76645_j.length; ++i) {
            List li = ch.field_76645_j[i];
            for (Entity e : li) {
                if (sel != null && !sel.func_82704_a(e)) continue;
                c.add(e);
            }
        }
        return c;
    }

    public static void clearEntities(Chunk ch, ReikaEntityHelper.ClassEntitySelector sel) {
        for (int i = 0; i < ch.field_76645_j.length; ++i) {
            List li = ch.field_76645_j[i];
            for (Entity e : li) {
                if (sel != null && !sel.func_82704_a(e)) continue;
                e.func_70106_y();
            }
        }
    }
}

