/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Libraries.World;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Data.Immutable.RGB;
import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import Reika.DragonAPI.Libraries.IO.ReikaColorAPI;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Java.ReikaStringParser;
import Reika.DragonAPI.ModInteract.DeepInteract.ModSeasonHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;

public class ReikaBiomeHelper
extends DragonAPICore {
    private static final MultiMap<BiomeGenBase, BiomeGenBase> children = new MultiMap();
    private static final MultiMap<BiomeGenBase, BiomeGenBase> similarity = new MultiMap();
    private static final HashMap<BiomeGenBase, BiomeGenBase> parents = new HashMap();
    private static final int[] biomeColors = new int[40];
    private static final HashMap<String, BiomeGenBase> nameMap = new HashMap();
    private static final HashMap<BiomeGenBase, BiomeTemperatures> temperatures = new HashMap();

    private static void addChildBiome(BiomeGenBase parent, BiomeGenBase child) {
        ReikaBiomeHelper.addChildBiome(parent, child, true);
    }

    private static void addChildBiome(BiomeGenBase parent, BiomeGenBase child, boolean isChild) {
        similarity.addValue(parent, child);
        if (isChild) {
            children.addValue(parent, child);
            parents.put(child, parent);
        }
    }

    public static int getFirstEmptyBiomeIndex() {
        for (int i = 0; i < BiomeGenBase.field_76773_a.length; ++i) {
            if (BiomeGenBase.field_76773_a[i] != null) continue;
            return i;
        }
        throw new RuntimeException("Error: Biome Limit Exceeded!");
    }

    public static List<BiomeGenBase> getAllBiomes() {
        ArrayList<BiomeGenBase> li = new ArrayList<BiomeGenBase>();
        for (int i = 0; i < BiomeGenBase.field_76773_a.length; ++i) {
            if (BiomeGenBase.field_76773_a[i] == null) continue;
            li.add(BiomeGenBase.field_76773_a[i]);
        }
        return li;
    }

    public static Collection<BiomeGenBase> getAllAssociatedBiomes(BiomeGenBase biome, boolean loose) {
        return Collections.unmodifiableCollection(loose ? similarity.get(biome) : children.get(biome));
    }

    public static Collection<BiomeGenBase> getChildBiomes(BiomeGenBase biome) {
        return ReikaBiomeHelper.getAllAssociatedBiomes(biome, false);
    }

    public static BiomeGenBase getParentBiomeType(BiomeGenBase biome) {
        return parents.containsKey(biome) ? parents.get(biome) : biome;
    }

    public static boolean isChildBiome(BiomeGenBase biome) {
        return parents.containsKey(biome);
    }

    public static int[] biomeToRGB(IBlockAccess world, int x, int y, int z, String material) {
        int color = ReikaBiomeHelper.biomeToHex(world, x, y, z, material);
        return ReikaColorAPI.HexToRGB(color);
    }

    public static int biomeToHexColor(IBlockAccess world, int x, int y, int z, String material) {
        int color = ReikaBiomeHelper.biomeToHex(world, x, y, z, material);
        return color;
    }

    private static int biomeToHex(IBlockAccess world, int x, int y, int z, String mat) {
        BiomeGenBase biome = world.func_72807_a(x, z);
        int color = 0;
        if (mat == "Leaves") {
            color = biome.func_150571_c(x, y, z);
        }
        if (mat == "Grass") {
            color = biome.func_150558_b(x, y, z);
        }
        if (mat == "Water") {
            color = biome.getWaterColorMultiplier();
        }
        if (mat == "Sky") {
            color = biome.func_76731_a(biome.func_150564_a(x, y, z));
        }
        return color;
    }

    public static boolean isCoolBiome(BiomeGenBase biome) {
        if (biome == BiomeGenBase.field_76768_g) {
            return true;
        }
        if (biome == BiomeGenBase.field_76784_u) {
            return true;
        }
        if (biome.field_76791_y.toLowerCase(Locale.ENGLISH).contains("maple woods")) {
            return true;
        }
        BiomeDictionary.Type[] types = BiomeDictionary.getTypesForBiome((BiomeGenBase)biome);
        for (int i = 0; i < types.length; ++i) {
        }
        return false;
    }

    public static boolean isSnowBiome(BiomeGenBase biome) {
        if (biome == BiomeGenBase.field_76776_l) {
            return true;
        }
        if (biome == BiomeGenBase.field_76777_m) {
            return true;
        }
        if (biome == BiomeGenBase.field_76775_o) {
            return true;
        }
        if (biome == BiomeGenBase.field_76774_n) {
            return true;
        }
        if (biome == BiomeGenBase.field_150584_S) {
            return true;
        }
        if (biome == BiomeGenBase.field_150579_T) {
            return true;
        }
        if (biome == BiomeGenBase.field_76768_g) {
            return false;
        }
        if (biome == BiomeGenBase.field_76784_u) {
            return false;
        }
        if (biome.field_76791_y.toLowerCase(Locale.ENGLISH).contains("maple woods")) {
            return false;
        }
        if (biome.func_76746_c()) {
            return true;
        }
        if (biome.field_76791_y.toLowerCase(Locale.ENGLISH).contains("arctic")) {
            return true;
        }
        if (biome.field_76791_y.toLowerCase(Locale.ENGLISH).contains("tundra")) {
            return true;
        }
        if (biome.field_76791_y.toLowerCase(Locale.ENGLISH).contains("alpine")) {
            return true;
        }
        if (biome.field_76791_y.toLowerCase(Locale.ENGLISH).contains("frozen")) {
            return true;
        }
        BiomeDictionary.Type[] types = BiomeDictionary.getTypesForBiome((BiomeGenBase)biome);
        for (int i = 0; i < types.length; ++i) {
            if (types[i] == BiomeDictionary.Type.FROZEN) {
                return true;
            }
            if (types[i] == BiomeDictionary.Type.COLD) {
                return true;
            }
            if (types[i] != BiomeDictionary.Type.SNOWY) continue;
            return true;
        }
        return false;
    }

    public static boolean isHotBiome(BiomeGenBase biome) {
        if (biome == BiomeGenBase.field_76769_d) {
            return true;
        }
        if (biome == BiomeGenBase.field_76786_s) {
            return true;
        }
        if (biome == BiomeGenBase.field_76778_j) {
            return true;
        }
        if (biome == BiomeGenBase.field_76782_w) {
            return true;
        }
        if (biome == BiomeGenBase.field_76792_x) {
            return true;
        }
        if (biome == BiomeGenBase.field_150589_Z) {
            return true;
        }
        BiomeDictionary.Type[] types = BiomeDictionary.getTypesForBiome((BiomeGenBase)biome);
        for (int i = 0; i < types.length; ++i) {
            if (types[i] == BiomeDictionary.Type.WASTELAND) {
                return true;
            }
            if (types[i] == BiomeDictionary.Type.DESERT) {
                return true;
            }
            if (types[i] == BiomeDictionary.Type.HOT) {
                return true;
            }
            if (types[i] != BiomeDictionary.Type.JUNGLE) continue;
            return true;
        }
        return false;
    }

    public static int getBiomeTemp(World world, BiomeGenBase biome) {
        BiomeTemperatures temp = temperatures.get(biome = ReikaBiomeHelper.getParentBiomeType(biome));
        if (temp == null) {
            temp = ReikaBiomeHelper.calcBiomeTemp(biome);
            temperatures.put(biome, temp);
        }
        int Tamb = temp.ambientTemperature;
        if (ModSeasonHandler.isLoaded()) {
            Tamb = (int)((float)Tamb + ReikaBiomeHelper.getBiomeSeasonStrength(biome, temp) * ModSeasonHandler.getSeasonTemperatureModifier(world));
        }
        return Tamb;
    }

    private static float getBiomeSeasonStrength(BiomeGenBase biome, BiomeTemperatures temp) {
        if (temp == BiomeTemperatures.FIERY || temp == BiomeTemperatures.LUNAR) {
            return 0.0f;
        }
        if (temp == BiomeTemperatures.HOT || temp == BiomeTemperatures.ICY) {
            return 0.2f;
        }
        if (temp == BiomeTemperatures.COOL || temp == BiomeTemperatures.WARM) {
            return 0.75f;
        }
        if (temp == BiomeTemperatures.TEMPERATE) {
            return 1.0f;
        }
        return 1.0f;
    }

    private static BiomeTemperatures calcBiomeTemp(BiomeGenBase biome) {
        if (biome == BiomeGenBase.field_76778_j) {
            return BiomeTemperatures.FIERY;
        }
        if (biome == BiomeGenBase.field_76779_k) {
            return BiomeTemperatures.LUNAR;
        }
        BiomeDictionary.Type[] types = BiomeDictionary.getTypesForBiome((BiomeGenBase)biome);
        for (int i = 0; i < types.length; ++i) {
            if (types[i] == BiomeDictionary.Type.NETHER) {
                return BiomeTemperatures.FIERY;
            }
            if (types[i] != BiomeDictionary.Type.END) continue;
            return BiomeTemperatures.LUNAR;
        }
        if (ReikaBiomeHelper.isSnowBiome(biome)) {
            return BiomeTemperatures.ICY;
        }
        if (ReikaBiomeHelper.isHotBiome(biome)) {
            return BiomeTemperatures.HOT;
        }
        if (ReikaBiomeHelper.isCoolBiome(biome)) {
            return BiomeTemperatures.COOL;
        }
        return BiomeTemperatures.TEMPERATE;
    }

    public static int getBiomeTemp(World world, int x, int z) {
        BiomeGenBase biome = world.func_72807_a(x, z);
        return ReikaBiomeHelper.getBiomeTemp(world, biome);
    }

    public static float getBiomeHumidity(BiomeGenBase biome) {
        if ((biome = ReikaBiomeHelper.getParentBiomeType(biome)) == BiomeGenBase.field_76782_w) {
            return 0.95f;
        }
        if (biome == BiomeGenBase.field_76771_b) {
            return 1.0f;
        }
        if (biome == BiomeGenBase.field_150575_M) {
            return 1.0f;
        }
        if (biome == BiomeGenBase.field_76780_h) {
            return 0.85f;
        }
        if (biome == BiomeGenBase.field_76767_f) {
            return 0.6f;
        }
        if (biome == BiomeGenBase.field_150583_P) {
            return 0.55f;
        }
        if (biome == BiomeGenBase.field_150585_R) {
            return 0.7f;
        }
        if (biome == BiomeGenBase.field_76772_c) {
            return 0.4f;
        }
        if (biome == BiomeGenBase.field_150588_X) {
            return 0.3f;
        }
        if (biome == BiomeGenBase.field_76769_d) {
            return 0.2f;
        }
        if (biome == BiomeGenBase.field_150589_Z) {
            return 0.2f;
        }
        if (biome == BiomeGenBase.field_76778_j) {
            return 0.1f;
        }
        if (biome == BiomeGenBase.field_76779_k) {
            return 0.1f;
        }
        if (biome == BiomeGenBase.field_76787_r) {
            return 0.98f;
        }
        if (biome == BiomeGenBase.field_76774_n) {
            return 0.4f;
        }
        if (biome == BiomeGenBase.field_76789_p) {
            return 0.75f;
        }
        BiomeDictionary.Type[] types = BiomeDictionary.getTypesForBiome((BiomeGenBase)biome);
        float val = 0.5f;
        for (int i = 0; i < types.length; ++i) {
            if (types[i] == BiomeDictionary.Type.BEACH) {
                val = Math.max(val, 0.95f);
            }
            if (types[i] == BiomeDictionary.Type.OCEAN || types[i] == BiomeDictionary.Type.RIVER || types[i] == BiomeDictionary.Type.WATER) {
                val = Math.max(val, 1.0f);
            }
            if (types[i] == BiomeDictionary.Type.JUNGLE) {
                val = Math.max(val, 0.95f);
            }
            if (types[i] == BiomeDictionary.Type.DESERT || types[i] == BiomeDictionary.Type.SANDY) {
                val = Math.min(val, 0.2f);
            }
            if (types[i] == BiomeDictionary.Type.NETHER || types[i] == BiomeDictionary.Type.END) {
                val = Math.min(val, 0.1f);
            }
            if (types[i] == BiomeDictionary.Type.WASTELAND) {
                val = Math.min(val, 0.1f);
            }
            if (types[i] == BiomeDictionary.Type.LUSH) {
                val = Math.max(val, 0.6f);
            }
            if (types[i] == BiomeDictionary.Type.WET) {
                val = Math.max(val, 0.7f);
            }
            if (types[i] != BiomeDictionary.Type.DRY) continue;
            val = Math.min(val, 0.3f);
        }
        return val;
    }

    public static float getBiomeHumidity(World world, int x, int z) {
        return ReikaBiomeHelper.getBiomeHumidity(world.func_72807_a(x, z));
    }

    public static boolean isOcean(BiomeGenBase biome) {
        if (biome == BiomeGenBase.field_76771_b || biome == BiomeGenBase.field_76776_l || biome == BiomeGenBase.field_150575_M) {
            return true;
        }
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST)) {
            return false;
        }
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DRY)) {
            return false;
        }
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DENSE)) {
            return false;
        }
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN)) {
            return true;
        }
        return ReikaStringParser.containsWord(biome.field_76791_y.toLowerCase(Locale.ENGLISH), "ocean");
    }

    public static void removeBiomeWithAssociates(BiomeGenBase biome) {
        BiomeManager.removeSpawnBiome((BiomeGenBase)biome);
        Collection<BiomeGenBase> c = ReikaBiomeHelper.getChildBiomes(biome);
        for (BiomeGenBase b : c) {
            BiomeManager.removeSpawnBiome((BiomeGenBase)b);
        }
    }

    public static void removeAllBiomesBut(Collection<BiomeGenBase> biomes) {
        for (int i = 0; i < BiomeGenBase.field_76773_a.length; ++i) {
            BiomeGenBase b = BiomeGenBase.field_76773_a[i];
            if (biomes.contains(b)) continue;
            BiomeManager.removeSpawnBiome((BiomeGenBase)b);
        }
    }

    public static void removeAllBiomesBut(BiomeGenBase ... biomes) {
        ReikaBiomeHelper.removeAllBiomesBut(ReikaJavaLibrary.makeListFromArray(biomes));
    }

    public static void removeAllBiomesBut(BiomeGenBase biome) {
        for (int i = 0; i < BiomeGenBase.field_76773_a.length; ++i) {
            BiomeGenBase b = BiomeGenBase.field_76773_a[i];
            if (b == biome) continue;
            BiomeManager.removeSpawnBiome((BiomeGenBase)b);
        }
    }

    public static int getBiomeNaturalColor(BiomeGenBase b) {
        Block top = b.field_76752_A;
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)b, (BiomeDictionary.Type)BiomeDictionary.Type.WATER)) {
            top = Blocks.field_150355_j;
        }
        int mat = top.func_149688_o().func_151565_r().field_76291_p;
        if (top == Blocks.field_150349_c) {
            mat = b.func_150558_b(0, 0, 0);
        }
        RGB rgb = new RGB(mat);
        return rgb.getInt();
    }

    public static int getBiomeUniqueColor(BiomeGenBase b) {
        return biomeColors[b.field_76756_M];
    }

    public static BiomeGenBase getBiomeByName(String s) {
        return nameMap.get(s);
    }

    static {
        ReikaBiomeHelper.addChildBiome(BiomeGenBase.field_76769_d, BiomeGenBase.field_76786_s);
        ReikaBiomeHelper.addChildBiome(BiomeGenBase.field_76767_f, BiomeGenBase.field_76785_t);
        ReikaBiomeHelper.addChildBiome(BiomeGenBase.field_76768_g, BiomeGenBase.field_76784_u);
        ReikaBiomeHelper.addChildBiome(BiomeGenBase.field_76768_g, BiomeGenBase.field_150584_S, false);
        ReikaBiomeHelper.addChildBiome(BiomeGenBase.field_76768_g, BiomeGenBase.field_150578_U, false);
        ReikaBiomeHelper.addChildBiome(BiomeGenBase.field_76782_w, BiomeGenBase.field_76792_x);
        ReikaBiomeHelper.addChildBiome(BiomeGenBase.field_76782_w, BiomeGenBase.field_150574_L);
        ReikaBiomeHelper.addChildBiome(BiomeGenBase.field_150578_U, BiomeGenBase.field_150581_V);
        ReikaBiomeHelper.addChildBiome(BiomeGenBase.field_150584_S, BiomeGenBase.field_150579_T);
        ReikaBiomeHelper.addChildBiome(BiomeGenBase.field_76774_n, BiomeGenBase.field_76775_o);
        ReikaBiomeHelper.addChildBiome(BiomeGenBase.field_150583_P, BiomeGenBase.field_150582_Q);
        ReikaBiomeHelper.addChildBiome(BiomeGenBase.field_76770_e, BiomeGenBase.field_76783_v);
        ReikaBiomeHelper.addChildBiome(BiomeGenBase.field_76770_e, BiomeGenBase.field_150580_W);
        ReikaBiomeHelper.addChildBiome(BiomeGenBase.field_150589_Z, BiomeGenBase.field_150608_ab);
        ReikaBiomeHelper.addChildBiome(BiomeGenBase.field_150589_Z, BiomeGenBase.field_150607_aa);
        ReikaBiomeHelper.addChildBiome(BiomeGenBase.field_76787_r, BiomeGenBase.field_150577_O, false);
        ReikaBiomeHelper.addChildBiome(BiomeGenBase.field_76787_r, BiomeGenBase.field_150576_N);
        ReikaBiomeHelper.addChildBiome(BiomeGenBase.field_76771_b, BiomeGenBase.field_150575_M, false);
        ReikaBiomeHelper.addChildBiome(BiomeGenBase.field_76771_b, BiomeGenBase.field_76776_l, false);
        ReikaBiomeHelper.addChildBiome(BiomeGenBase.field_76781_i, BiomeGenBase.field_76777_m, false);
        ReikaBiomeHelper.addChildBiome(BiomeGenBase.field_150588_X, BiomeGenBase.field_150587_Y);
        ReikaBiomeHelper.biomeColors[BiomeGenBase.field_76771_b.field_76756_M] = 255;
        ReikaBiomeHelper.biomeColors[BiomeGenBase.field_150575_M.field_76756_M] = 176;
        ReikaBiomeHelper.biomeColors[BiomeGenBase.field_76781_i.field_76756_M] = 23295;
        ReikaBiomeHelper.biomeColors[BiomeGenBase.field_76776_l.field_76756_M] = 38143;
        ReikaBiomeHelper.biomeColors[BiomeGenBase.field_76777_m.field_76756_M] = 50943;
        ReikaBiomeHelper.biomeColors[BiomeGenBase.field_76774_n.field_76756_M] = 6326130;
        ReikaBiomeHelper.biomeColors[BiomeGenBase.field_76772_c.field_76756_M] = 7048258;
        ReikaBiomeHelper.biomeColors[BiomeGenBase.field_76768_g.field_76756_M] = 6457455;
        ReikaBiomeHelper.biomeColors[BiomeGenBase.field_76780_h.field_76756_M] = 4476474;
        ReikaBiomeHelper.biomeColors[BiomeGenBase.field_76770_e.field_76756_M] = 0x668766;
        ReikaBiomeHelper.biomeColors[BiomeGenBase.field_76782_w.field_76756_M] = 4102185;
        ReikaBiomeHelper.biomeColors[BiomeGenBase.field_76767_f.field_76756_M] = 6000964;
        ReikaBiomeHelper.biomeColors[BiomeGenBase.field_150588_X.field_76756_M] = 0xBCB555;
        ReikaBiomeHelper.biomeColors[BiomeGenBase.field_150583_P.field_76756_M] = 7912547;
        ReikaBiomeHelper.biomeColors[BiomeGenBase.field_150585_R.field_76756_M] = 3702564;
        ReikaBiomeHelper.biomeColors[BiomeGenBase.field_76769_d.field_76756_M] = 15656881;
        ReikaBiomeHelper.biomeColors[BiomeGenBase.field_76789_p.field_76756_M] = 7499137;
        ReikaBiomeHelper.biomeColors[BiomeGenBase.field_150589_Z.field_76756_M] = 10248775;
        ReikaBiomeHelper.biomeColors[BiomeGenBase.field_76787_r.field_76756_M] = 15590030;
        ReikaBiomeHelper.biomeColors[BiomeGenBase.field_150576_N.field_76756_M] = 0x949494;
        ReikaBiomeHelper.biomeColors[BiomeGenBase.field_150577_O.field_76756_M] = 11318995;
        ReikaBiomeHelper.biomeColors[BiomeGenBase.field_150578_U.field_76756_M] = 6457450;
        ReikaBiomeHelper.biomeColors[BiomeGenBase.field_150581_V.field_76756_M] = 0x82B28B;
        ReikaBiomeHelper.biomeColors[BiomeGenBase.field_150584_S.field_76756_M] = 6457464;
        ReikaBiomeHelper.biomeColors[BiomeGenBase.field_150579_T.field_76756_M] = 8565405;
        ReikaBiomeHelper.biomeColors[BiomeGenBase.field_150587_Y.field_76756_M] = 13879905;
        ReikaBiomeHelper.biomeColors[BiomeGenBase.field_76775_o.field_76756_M] = 8434327;
        ReikaBiomeHelper.biomeColors[BiomeGenBase.field_76788_q.field_76756_M] = 7499158;
        ReikaBiomeHelper.biomeColors[BiomeGenBase.field_76786_s.field_76756_M] = 0xFFF7BF;
        ReikaBiomeHelper.biomeColors[BiomeGenBase.field_76785_t.field_76756_M] = 7385683;
        ReikaBiomeHelper.biomeColors[BiomeGenBase.field_76784_u.field_76756_M] = 8565394;
        ReikaBiomeHelper.biomeColors[BiomeGenBase.field_76792_x.field_76756_M] = 5027633;
        ReikaBiomeHelper.biomeColors[BiomeGenBase.field_150574_L.field_76756_M] = 5027716;
        ReikaBiomeHelper.biomeColors[BiomeGenBase.field_76783_v.field_76756_M] = 0x9BCC9B;
        ReikaBiomeHelper.biomeColors[BiomeGenBase.field_150580_W.field_76756_M] = 8893063;
        ReikaBiomeHelper.biomeColors[BiomeGenBase.field_150582_Q.field_76756_M] = 9560182;
        ReikaBiomeHelper.biomeColors[BiomeGenBase.field_150608_ab.field_76756_M] = 13402205;
        ReikaBiomeHelper.biomeColors[BiomeGenBase.field_150607_aa.field_76756_M] = 16752245;
        ReikaBiomeHelper.biomeColors[BiomeGenBase.field_76778_j.field_76756_M] = 9392979;
        ReikaBiomeHelper.biomeColors[BiomeGenBase.field_76779_k.field_76756_M] = 14080411;
        temperatures.put(BiomeGenBase.field_76768_g, BiomeTemperatures.COOL);
        temperatures.put(BiomeGenBase.field_76770_e, BiomeTemperatures.COOL);
        temperatures.put(BiomeGenBase.field_150578_U, BiomeTemperatures.COOL);
        temperatures.put(BiomeGenBase.field_76767_f, BiomeTemperatures.TEMPERATE);
        temperatures.put(BiomeGenBase.field_76772_c, BiomeTemperatures.TEMPERATE);
        temperatures.put(BiomeGenBase.field_150583_P, BiomeTemperatures.TEMPERATE);
        temperatures.put(BiomeGenBase.field_76771_b, BiomeTemperatures.TEMPERATE);
        temperatures.put(BiomeGenBase.field_150575_M, BiomeTemperatures.TEMPERATE);
        temperatures.put(BiomeGenBase.field_76789_p, BiomeTemperatures.TEMPERATE);
        temperatures.put(BiomeGenBase.field_76780_h, BiomeTemperatures.TEMPERATE);
        temperatures.put(BiomeGenBase.field_76781_i, BiomeTemperatures.TEMPERATE);
        temperatures.put(BiomeGenBase.field_150585_R, BiomeTemperatures.WARM);
        temperatures.put(BiomeGenBase.field_150588_X, BiomeTemperatures.WARM);
        temperatures.put(BiomeGenBase.field_76769_d, BiomeTemperatures.HOT);
        temperatures.put(BiomeGenBase.field_150589_Z, BiomeTemperatures.HOT);
        temperatures.put(BiomeGenBase.field_76782_w, BiomeTemperatures.HOT);
        temperatures.put(BiomeGenBase.field_150584_S, BiomeTemperatures.ICY);
        temperatures.put(BiomeGenBase.field_150577_O, BiomeTemperatures.ICY);
        temperatures.put(BiomeGenBase.field_76774_n, BiomeTemperatures.ICY);
        temperatures.put(BiomeGenBase.field_76775_o, BiomeTemperatures.ICY);
        temperatures.put(BiomeGenBase.field_76776_l, BiomeTemperatures.ICY);
        temperatures.put(BiomeGenBase.field_76777_m, BiomeTemperatures.ICY);
        temperatures.put(BiomeGenBase.field_76775_o, BiomeTemperatures.ICY);
        temperatures.put(BiomeGenBase.field_76778_j, BiomeTemperatures.FIERY);
        temperatures.put(BiomeGenBase.field_76779_k, BiomeTemperatures.LUNAR);
        for (int i = 0; i < BiomeGenBase.field_76773_a.length; ++i) {
            BiomeGenBase b = BiomeGenBase.field_76773_a[i];
            if (b == null) continue;
            nameMap.put(b.field_76791_y, b);
        }
    }

    public static enum BiomeTemperatures {
        LUNAR(-100),
        ICY(-20),
        COOL(10),
        TEMPERATE(25),
        WARM(30),
        HOT(40),
        FIERY(300);

        public final int ambientTemperature;

        private BiomeTemperatures(int t) {
            this.ambientTemperature = t;
        }
    }
}

