/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Libraries;

import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.ReikaEntityHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.world.World;

public class ReikaSpawnerHelper {
    public static String getMobSpawnerMobName(TileEntityMobSpawner spw) {
        return spw.func_145881_a().func_98276_e();
    }

    public static void setMobSpawnerMob(TileEntityMobSpawner spw, String name) {
        spw.func_145881_a().func_98272_a(name);
    }

    public static String getSpawnerTypeName(World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (!(te instanceof TileEntityMobSpawner)) {
            return null;
        }
        return ReikaSpawnerHelper.getMobSpawnerMobName((TileEntityMobSpawner)te);
    }

    public static int getSpawnerTypeID(World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (!(te instanceof TileEntityMobSpawner)) {
            return -1;
        }
        TileEntityMobSpawner spw = (TileEntityMobSpawner)te;
        String name = ReikaSpawnerHelper.getMobSpawnerMobName(spw);
        return ReikaEntityHelper.mobNameToID(name);
    }

    public static void addMobNBTToItem(ItemStack is, TileEntityMobSpawner spw) {
        if (is == null) {
            return;
        }
        String name = ReikaSpawnerHelper.getMobSpawnerMobName(spw);
        ReikaSpawnerHelper.setSpawnerItemNBT(is, name, false);
    }

    public static void setSpawnerFromItemNBT(ItemStack is, TileEntityMobSpawner spw) {
        if (is == null) {
            return;
        }
        if (is.field_77990_d == null) {
            return;
        }
        if (!is.field_77990_d.func_74764_b("Spawner")) {
            return;
        }
        String name = is.field_77990_d.func_74779_i("Spawner");
        ReikaSpawnerHelper.setMobSpawnerMob(spw, name);
    }

    public static void setSpawnerItemNBT(ItemStack is, String mob, boolean force) {
        if (is.field_77990_d == null) {
            is.func_77982_d(new NBTTagCompound());
        }
        if (force || !is.field_77990_d.func_74764_b("Spawner")) {
            is.field_77990_d.func_74778_a("Spawner", mob);
        }
    }

    public static void forceSpawn(TileEntityMobSpawner spw, int num, PotionEffect ... potions) {
        World world = spw.field_145850_b;
        if (world.field_72995_K) {
            return;
        }
        String name = ReikaSpawnerHelper.getMobSpawnerMobName(spw);
        for (int i = 0; i < num; ++i) {
            Entity e = EntityList.func_75620_a((String)name, (World)world);
            double ex = ReikaRandomHelper.getRandomPlusMinus((double)spw.field_145851_c + 0.5, 3.5);
            double ez = ReikaRandomHelper.getRandomPlusMinus((double)spw.field_145849_e + 0.5, 3.5);
            double ey = ReikaRandomHelper.getRandomPlusMinus((double)spw.field_145848_d + 0.5, 1.5);
            e.func_70080_a(ex, ey, ez, 0.0f, 0.0f);
            if (e instanceof EntityLivingBase && potions != null) {
                for (int m = 0; m < potions.length; ++m) {
                    ((EntityLivingBase)e).func_70690_d(potions[m]);
                }
            }
            if (e instanceof EntityLivingBase && e.field_70170_p != null) {
                ((EntityLiving)e).func_110161_a((IEntityLivingData)null);
            }
            world.func_72838_d(e);
        }
    }

    public static String getSpawnerFromItemNBT(ItemStack is) {
        if (is == null) {
            return null;
        }
        if (is.field_77990_d == null) {
            return null;
        }
        if (!is.field_77990_d.func_74764_b("Spawner")) {
            return null;
        }
        String name = is.field_77990_d.func_74779_i("Spawner");
        return name;
    }
}

