/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Libraries.MathSci;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.DoubleMatrix;
import Reika.DragonAPI.Instantiable.LineClipper;
import Reika.DragonAPI.Libraries.Java.ReikaArrayHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Point;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Vector3f;

public final class ReikaVectorHelper
extends DragonAPICore {
    public static Vec3 getVec2Pt(double x1, double y1, double z1, double x2, double y2, double z2) {
        Vec3 p1 = Vec3.func_72443_a((double)x1, (double)y1, (double)z1);
        Vec3 p2 = Vec3.func_72443_a((double)x2, (double)y2, (double)z2);
        return ReikaVectorHelper.subtract(p2, p1);
    }

    public static Vec3 subtract(Vec3 p1, Vec3 p2) {
        return Vec3.func_72443_a((double)(p2.field_72450_a - p1.field_72450_a), (double)(p2.field_72448_b - p1.field_72448_b), (double)(p2.field_72449_c - p1.field_72449_c));
    }

    public static double[] components(Vec3 vec) {
        double[] xyz = new double[]{vec.field_72450_a, vec.field_72448_b, vec.field_72449_c};
        return xyz;
    }

    public static double[] getPlayerLookCoords(EntityPlayer ep, double scale) {
        Vec3 look = ep.func_70040_Z();
        double dx = ep.field_70165_t;
        double dy = ep.field_70163_u + (double)ep.func_70047_e();
        double dz = ep.field_70161_v;
        look.field_72450_a *= scale;
        look.field_72448_b *= scale;
        look.field_72449_c *= scale;
        double[] xyz = new double[]{dx + look.field_72450_a, dy + look.field_72448_b, dz + look.field_72449_c};
        return xyz;
    }

    public static int[] getPlayerLookBlockCoords(EntityPlayer ep, double scale) {
        Vec3 look = ep.func_70040_Z();
        double dx = ep.field_70165_t;
        double dy = ep.field_70163_u + (double)ep.func_70047_e();
        double dz = ep.field_70161_v;
        look.field_72450_a *= scale;
        look.field_72448_b *= scale;
        look.field_72449_c *= scale;
        double[] xyz = new double[]{dx + look.field_72450_a, dy + look.field_72448_b, dz + look.field_72449_c};
        int x = (int)Math.floor(xyz[0]);
        int y = (int)Math.floor(xyz[1]);
        int z = (int)Math.floor(xyz[2]);
        return new int[]{x, y, z};
    }

    public static int[] getPlayerLookBlock(World world, EntityPlayer ep, double range, boolean passthru) {
        int[] xyz = new int[3];
        float i = 0.0f;
        while ((double)i <= range) {
            int z;
            int y;
            double[] look = ReikaVectorHelper.getPlayerLookCoords(ep, i);
            int x = MathHelper.func_76128_c((double)look[0]);
            Block id = world.func_147439_a(x, y = MathHelper.func_76128_c((double)look[1]), z = MathHelper.func_76128_c((double)look[2]));
            if (!(id == Blocks.field_150350_a || passthru && ReikaWorldHelper.softBlocks((IBlockAccess)world, x, y, z))) {
                xyz[0] = x;
                xyz[1] = y;
                xyz[2] = z;
                return xyz;
            }
            i = (float)((double)i + 0.5);
        }
        return xyz;
    }

    public static double[] findIntersection(Vec3 v1, Vec3 v2) {
        double[] xyz = new double[3];
        if (ReikaVectorHelper.areParallel(v1, v2)) {
            return ReikaArrayHelper.fillArray(xyz, Double.POSITIVE_INFINITY);
        }
        if (ReikaVectorHelper.areNonParallelNonIntersecting(v1, v2)) {
            return ReikaArrayHelper.fillArray(xyz, Double.NEGATIVE_INFINITY);
        }
        return xyz;
    }

    public static double getSlope(Vec3 vec, int axis) {
        switch (axis) {
            case 0: {
                return vec.field_72450_a / vec.func_72433_c();
            }
            case 1: {
                return vec.field_72448_b / vec.func_72433_c();
            }
            case 2: {
                return vec.field_72449_c / vec.func_72433_c();
            }
        }
        return Double.POSITIVE_INFINITY;
    }

    public static boolean areParallel(Vec3 vec1, Vec3 vec2) {
        for (int i = 0; i < 3; ++i) {
            if (ReikaVectorHelper.getSlope(vec1, i) == ReikaVectorHelper.getSlope(vec2, i)) continue;
            return false;
        }
        return true;
    }

    public static boolean areNonParallelNonIntersecting(Vec3 vec1, Vec3 vec2) {
        if (ReikaVectorHelper.areParallel(vec1, vec2)) {
            return false;
        }
        if (ReikaVectorHelper.getSlope(vec1, 0) == ReikaVectorHelper.getSlope(vec2, 0)) {
            // empty if block
        }
        return false;
    }

    public static double getDistFromPointToLine(double x1, double y1, double z1, double x2, double y2, double z2, double x, double y, double z) {
        Vec3 v01 = ReikaVectorHelper.getVec2Pt(x, y, z, x1, y1, z1);
        Vec3 v02 = ReikaVectorHelper.getVec2Pt(x, y, z, x2, y2, z2);
        Vec3 v21 = ReikaVectorHelper.getVec2Pt(x2, y2, z2, x1, y1, z1);
        return Math.abs(v01.func_72431_c(v02).func_72433_c() / v21.func_72433_c());
    }

    public static Vec3 scaleVector(Vec3 vec, double len) {
        Vec3 ret = vec.func_72432_b();
        ret.field_72450_a *= len;
        ret.field_72448_b *= len;
        ret.field_72449_c *= len;
        return ret;
    }

    public static Vector3f multiplyVectorByMatrix(Vector3f vector, Matrix4f matrix) {
        float newX = matrix.m00 * vector.x + matrix.m01 * vector.y + matrix.m02 * vector.z + matrix.m03;
        float newY = matrix.m10 * vector.x + matrix.m11 * vector.y + matrix.m12 * vector.z + matrix.m13;
        float newZ = matrix.m20 * vector.x + matrix.m21 * vector.y + matrix.m22 * vector.z + matrix.m23;
        return new Vector3f(newX, newY, newZ);
    }

    public static void euler321Sequence(Matrix4f mat, double rx, double ry, double rz) {
        float z = (float)Math.toRadians(rz);
        float y = (float)Math.toRadians(ry);
        float x = (float)Math.toRadians(rx);
        mat.rotate(z, new Vector3f(0.0f, 0.0f, 1.0f)).rotate(y, new Vector3f(0.0f, 1.0f, 0.0f)).rotate(x, new Vector3f(1.0f, 0.0f, 0.0f));
    }

    public static void euler213Sequence(Matrix4f mat, double rx, double ry, double rz) {
        float z = (float)Math.toRadians(rz);
        float y = (float)Math.toRadians(ry);
        float x = (float)Math.toRadians(rx);
        mat.rotate(y, new Vector3f(0.0f, 1.0f, 0.0f)).rotate(x, new Vector3f(1.0f, 0.0f, 0.0f)).rotate(z, new Vector3f(0.0f, 0.0f, 1.0f));
    }

    public static Vec3 multiplyVectorByMatrix(Vec3 vector, DoubleMatrix matrix) {
        double newX = matrix.m00 * vector.field_72450_a + matrix.m01 * vector.field_72448_b + matrix.m02 * vector.field_72449_c + matrix.m03;
        double newY = matrix.m10 * vector.field_72450_a + matrix.m11 * vector.field_72448_b + matrix.m12 * vector.field_72449_c + matrix.m13;
        double newZ = matrix.m20 * vector.field_72450_a + matrix.m21 * vector.field_72448_b + matrix.m22 * vector.field_72449_c + matrix.m23;
        return Vec3.func_72443_a((double)newX, (double)newY, (double)newZ);
    }

    public static void euler321Sequence(DoubleMatrix mat, double rx, double ry, double rz) {
        double z = Math.toRadians(rz);
        double y = Math.toRadians(ry);
        double x = Math.toRadians(rx);
        mat.rotate(z, Vec3.func_72443_a((double)0.0, (double)0.0, (double)1.0)).rotate(y, Vec3.func_72443_a((double)0.0, (double)1.0, (double)0.0)).rotate(x, Vec3.func_72443_a((double)1.0, (double)0.0, (double)0.0));
    }

    public static void euler213Sequence(DoubleMatrix mat, double rx, double ry, double rz) {
        double z = Math.toRadians(rz);
        double y = Math.toRadians(ry);
        double x = Math.toRadians(rx);
        mat.rotate(y, Vec3.func_72443_a((double)0.0, (double)1.0, (double)0.0)).rotate(x, Vec3.func_72443_a((double)1.0, (double)0.0, (double)0.0)).rotate(z, Vec3.func_72443_a((double)0.0, (double)0.0, (double)1.0));
    }

    public static Vec3 getXYProjection(Vec3 vec) {
        return Vec3.func_72443_a((double)vec.field_72450_a, (double)vec.field_72448_b, (double)0.0);
    }

    public static Vec3 getYZProjection(Vec3 vec) {
        return Vec3.func_72443_a((double)0.0, (double)vec.field_72448_b, (double)vec.field_72449_c);
    }

    public static Vec3 getXZProjection(Vec3 vec) {
        return Vec3.func_72443_a((double)vec.field_72450_a, (double)0.0, (double)vec.field_72449_c);
    }

    public static Vec3 getInverseVector(Vec3 vec) {
        return Vec3.func_72443_a((double)(-vec.field_72450_a), (double)(-vec.field_72448_b), (double)(-vec.field_72449_c));
    }

    @SideOnly(value=Side.CLIENT)
    public static Vector3f rotateVector(Vector3f vec, double rx, double ry, double rz) {
        Matrix4f mat = new Matrix4f();
        ReikaVectorHelper.euler321Sequence(mat, rx, ry, rz);
        return ReikaVectorHelper.multiplyVectorByMatrix(new Vector3f(vec.x, vec.y, vec.z), mat);
    }

    public static Vec3 rotateVector(Vec3 vec, double rx, double ry, double rz) {
        DoubleMatrix mat = new DoubleMatrix();
        ReikaVectorHelper.euler321Sequence(mat, rx, ry, rz);
        return ReikaVectorHelper.multiplyVectorByMatrix(vec, mat);
    }

    public static HashSet<Coordinate> getCoordsAlongVector(double x1, double y1, double z1, double x2, double y2, double z2) {
        HashSet<Coordinate> set = new HashSet<Coordinate>();
        double dd = ReikaMathLibrary.py3d(x2 - x1, y2 - y1, z2 - z1);
        for (double d = 0.0; d <= dd; d += 0.25) {
            double f = d / dd;
            double dx = x1 + f * (x2 - x1);
            double dy = y1 + f * (y2 - y1);
            double dz = z1 + f * (z2 - z1);
            Coordinate c = new Coordinate(dx, dy, dz);
            set.add(c);
        }
        return set;
    }

    public static ImmutablePair<Point, Point> clipLine(int x0, int x1, int y0, int y1, int minX, int minY, int maxX, int maxY) {
        return new LineClipper(minX, minY, maxX, maxY).clip(x0, y0, x1, y1);
    }

    public static double getAngleBetween(Vec3 v1, Vec3 v2) {
        return Math.toDegrees(Math.acos(v1.func_72430_b(v2) / (v1.func_72433_c() * v2.func_72433_c())));
    }
}

