/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Libraries.Java;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Libraries.Java.ReikaStringWrapper;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class ReikaStringParser
extends DragonAPICore {
    private static final String NUMBER_VARIABLE_CODE = "PARSE_NUMBER_VARIABLE";
    private static final String NUMBER_METHOD_CODE = "PARSE_NUMBER_METHOD";
    private static final String STRING_FORMAT_CODE = "PARSE_STRING_FORMAT";
    private static final String ENUM_FUNCTION_CODE = "PARSE_ENUM";

    public static String getStringWithEmbeddedReferences(String sg) {
        String[] parts = sg.split("\\+");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < parts.length; ++i) {
            if (ReikaStringParser.isReference(parts[i])) {
                sb.append(ReikaStringParser.parseReference(parts[i]));
                continue;
            }
            sb.append(parts[i]);
        }
        return sb.toString().replaceAll("\\\\n", "\n").replaceAll("\\\\t", "\t");
    }

    private static String parseReference(String sg) {
        if (sg.startsWith(NUMBER_VARIABLE_CODE)) {
            return ReikaStringParser.parseStaticNumberVariable(sg);
        }
        if (sg.startsWith(NUMBER_METHOD_CODE)) {
            return ReikaStringParser.parseNumberMethod(sg);
        }
        if (sg.startsWith(STRING_FORMAT_CODE)) {
            return ReikaStringParser.parseStringFormat(sg);
        }
        if (sg.startsWith(ENUM_FUNCTION_CODE)) {
            return ReikaStringParser.parseEnum(sg);
        }
        return null;
    }

    private static String parseEnum(String sg) {
        String[] parts = sg.split("\\$");
        if (parts.length != 3) {
            throw new RuntimeException("This method does not support multi-layer class calls! " + sg);
        }
        String enumClassName = ReikaStringParser.subtractFrom(parts[0], "PARSE_ENUM(");
        parts[2] = parts[2].substring(0, parts[2].length() - 1);
        try {
            Class<?> enumClass = Class.forName(enumClassName);
            Object e = Enum.valueOf(enumClass, parts[1]);
            Method m = enumClass.getDeclaredMethod(parts[2], null);
            Object o = m.invoke(e, (Object[])null);
            return o.toString();
        }
        catch (ClassNotFoundException e1) {
            e1.printStackTrace();
            throw new RuntimeException("Enum Class \"" + enumClassName + "\" does not exist!");
        }
        catch (NoSuchMethodException e1) {
            e1.printStackTrace();
            throw new RuntimeException("Enum Class " + enumClassName + " does not contain method \"" + parts[2] + "\"!");
        }
        catch (SecurityException e1) {
            e1.printStackTrace();
            throw new RuntimeException("Enum Class " + enumClassName + "'s method " + parts[2] + " threw security exception!");
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new RuntimeException("Class " + enumClassName + "'s method " + parts[2] + " threw illegal access exception!");
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new RuntimeException("Class " + enumClassName + "'s method " + parts[2] + " is not parameterless!");
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            throw new RuntimeException("Class " + enumClassName + "'s method " + parts[2] + " threw invocation target exception!");
        }
    }

    public static String parseStringFormat(String sg) {
        String[] parts = sg.split(",");
        String str = parts[0].replaceAll("\\s", "");
        Object[] args = new Object[parts.length - 1];
        for (int i = 1; i < parts.length; ++i) {
            parts[i].replaceAll("\\s", "");
            args[i - 1] = ReikaStringParser.parseReference(parts[i]);
        }
        return String.format(str, args);
    }

    private static String parseNumberMethod(String sg) {
        String obj;
        String[] parts = sg.split("\\$");
        if (parts.length > 2) {
            throw new RuntimeException("This method does not support multi-layer class calls! " + sg);
        }
        parts[1] = parts[1].substring(0, parts[1].length() - 1);
        String cl = ReikaStringParser.subtractFrom(parts[0], "PARSE_NUMBER_METHOD(");
        try {
            Class<?> c = Class.forName(cl);
            Method m = c.getMethod(parts[1], null);
            Object g = new Object();
            Object o = m.invoke(g, (Object[])null);
            obj = o.toString();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new RuntimeException("Class \"" + cl + "\" does not exist!");
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new RuntimeException("Class " + cl + " does not contain method \"" + parts[1] + "\"!");
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new RuntimeException("Class " + cl + "'s method " + parts[1] + " threw security exception!");
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new RuntimeException("Class " + cl + "'s method " + parts[1] + " threw illegal access exception!");
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new RuntimeException("Class " + cl + "'s method " + parts[1] + " is not parameterless!");
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            throw new RuntimeException("Class " + cl + "'s method " + parts[1] + " threw invocation target exception!");
        }
        return obj;
    }

    private static String parseStaticNumberVariable(String sg) {
        String[] parts = sg.split("\\$");
        if (parts.length > 2) {
            throw new RuntimeException("This method does not support multi-layer class calls! " + sg);
        }
        parts[1] = parts[1].substring(0, parts[1].length() - 1);
        String cl = ReikaStringParser.subtractFrom(parts[0], "PARSE_NUMBER_VARIABLE(");
        String obj = "NOT FOUND";
        try {
            Class<?> c = Class.forName(cl);
            Field f = c.getField(parts[1]);
            Class<?> type = f.getType();
            if (type == Integer.TYPE) {
                int val = f.getInt(c);
                obj = String.valueOf(val);
            }
            if (type == Float.TYPE) {
                float val = f.getFloat(c);
                obj = String.valueOf(val);
            }
            if (type == Double.TYPE) {
                double val = f.getDouble(c);
                obj = String.valueOf(val);
            }
            if (type == Long.TYPE) {
                long val = f.getLong(c);
                obj = String.valueOf(val);
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new RuntimeException("Class \"" + cl + "\" does not exist!");
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
            throw new RuntimeException("Class " + cl + " does not contain field \"" + parts[1] + "\"!");
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new RuntimeException("Class " + cl + "'s field " + parts[1] + " threw security exception!");
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new RuntimeException("Class " + cl + "'s field " + parts[1] + " threw illegal argument exception!");
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new RuntimeException("Class " + cl + "'s field " + parts[1] + " threw illegal access exception!");
        }
        return obj;
    }

    private static boolean isReference(String sg) {
        if (sg.startsWith(NUMBER_VARIABLE_CODE)) {
            return true;
        }
        if (sg.startsWith(NUMBER_METHOD_CODE)) {
            return true;
        }
        if (sg.startsWith(STRING_FORMAT_CODE)) {
            return true;
        }
        return sg.startsWith(ENUM_FUNCTION_CODE);
    }

    public static String splitCamelCase(String s) {
        s = s.replaceAll(" ", "");
        String cap = String.format("%s|%s|%s", "(?<=[A-Z])(?=[A-Z][a-z])", "(?<=[^A-Z])(?=[A-Z])", "(?<=[A-Za-z])(?=[^A-Za-z])");
        String spl = s.replaceAll(cap, " ");
        return spl;
    }

    public static String stripSpaces(String s) {
        return s.replaceAll("\\s", "");
    }

    public static String capFirstChar(String s) {
        return s.toUpperCase().substring(0, 1) + s.toLowerCase().substring(1);
    }

    public static String subtractFrom(String src, String p) {
        int len = p.length();
        return src.substring(len);
    }

    public static List<String> splitStringByLength(String str, int len) {
        return ReikaStringWrapper.listFormattedStringToWidth(str, len);
    }

    public static boolean isSplittingChar(char c) {
        return c == '.' || c == ',' || c == '-' || c == ' ';
    }

    public static String getFirstWord(String s) {
        return s.split(" ")[0];
    }

    public static boolean containsWord(String s, String word) {
        return Pattern.compile("\\s" + word + "[\\s]|\\s" + word + "$|^" + word + "\\s|^" + word + "$").matcher(s).find();
    }

    public static String getLongestString(String[] sgs) {
        int idx = 0;
        for (int i = 0; i < sgs.length; ++i) {
            String sg = sgs[i];
            if (sg.length() <= sgs[idx].length()) continue;
            idx = i;
        }
        return sgs[idx];
    }

    public static String getDelimited(String delimiter, ArrayList<Object> args) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < args.size(); ++i) {
            sb.append(args.get(i).toString());
            if (i >= args.size() - 1) continue;
            sb.append(delimiter);
        }
        return sb.toString();
    }

    public static String getDelimited(String delimiter, Object ... args) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < args.length; ++i) {
            sb.append(args[i].toString());
            if (i >= args.length - 1) continue;
            sb.append(delimiter);
        }
        return sb.toString();
    }

    public static String getNOf(String s, int n) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            sb.append(s);
        }
        return sb.toString();
    }

    public static String getAutoDecimal(double n) {
        String s = Double.toString(n);
        while (s.indexOf(46) != -1 && (s.charAt(s.length() - 1) == '0' || s.charAt(s.length() - 1) == '.')) {
            s = s.substring(0, s.length() - 1);
        }
        return s.isEmpty() ? "0" : s;
    }

    public static ArrayList<String> splitStringByNewlines(String s) {
        ArrayList<String> li = new ArrayList<String>();
        String[] parts = s.split("\\n");
        for (int i = 0; i < parts.length; ++i) {
            li.add(parts[i]);
        }
        return li;
    }

    public static char intToAlphaChar(int n) {
        return (char)(97 + n);
    }

    public static String clipStringBefore(String s, String clip) {
        int idx = s.indexOf(clip);
        if (idx == -1) {
            idx = s.length();
        }
        return s.substring(0, idx);
    }

    public static boolean isWholeWord(String s, String lv) {
        int idx1 = lv.indexOf(s);
        int idx2 = lv.indexOf(s) + s.length();
        return !(idx1 != 0 && !ReikaStringParser.isWordSeparator(lv.charAt(idx1 - 1)) || idx2 != lv.length() && !ReikaStringParser.isWordSeparator(lv.charAt(idx2)));
    }

    public static boolean isWordSeparator(char c) {
        return c == ' ' || c == '.' || c == '!' || c == '?' || c == ',' || c == ';';
    }
}

