/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Libraries.IO;

import Reika.DragonAPI.APIPacketHandler;
import Reika.DragonAPI.Auxiliary.Trackers.CustomSoundHandler;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Exception.MisuseException;
import Reika.DragonAPI.Instantiable.Data.Immutable.DecimalPosition;
import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import Reika.DragonAPI.Instantiable.IO.EnumSound;
import Reika.DragonAPI.Interfaces.Registry.SoundEnum;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.MusicTicker;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.audio.SoundManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import paulscode.sound.Library;
import paulscode.sound.SoundSystem;
import paulscode.sound.StreamThread;

public class ReikaSoundHelper {
    private static final MultiMap<SoundEnum, SoundPlay> plays = new MultiMap();
    private static Field soundLibraryField;
    private static Field streamThreadField;
    @SideOnly(value=Side.CLIENT)
    private static HashMap<ResourceLocation, MusicTicker.MusicType> musicTypes;

    public static void playBreakSound(World world, int x, int y, int z, Block b) {
        Block.SoundType s = b.field_149762_H;
        String f = s.func_150495_a();
        world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, f, s.func_150497_c(), s.func_150494_d());
    }

    public static void playStepSound(World world, int x, int y, int z, Block b) {
        Block.SoundType s = b.field_149762_H;
        String f = s.func_150498_e();
        world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, f, s.func_150497_c(), s.func_150494_d());
    }

    public static void playPlaceSound(World world, int x, int y, int z, Block b) {
        Block.SoundType s = b.field_149762_H;
        String f = s.func_150498_e();
        world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, f, s.func_150497_c(), s.func_150494_d());
    }

    public static void playBreakSound(World world, int x, int y, int z, Block b, float vol, float pitch) {
        Block.SoundType s = b.field_149762_H;
        String f = s.func_150495_a();
        world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, f, s.func_150497_c() * vol, s.func_150494_d() * pitch);
    }

    public static void playStepSound(World world, int x, int y, int z, Block b, float vol, float pitch) {
        Block.SoundType s = b.field_149762_H;
        String f = s.func_150498_e();
        world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, f, s.func_150497_c() * vol, s.func_150494_d() * pitch);
    }

    public static void playPlaceSound(World world, int x, int y, int z, Block b, float vol, float pitch) {
        Block.SoundType s = b.field_149762_H;
        String f = s.func_150498_e();
        world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, f, s.func_150497_c() * vol, s.func_150494_d() * pitch);
    }

    public static void playSoundAtBlock(World world, int x, int y, int z, String snd, float vol, float pit) {
        world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, snd, vol, pit);
    }

    public static void playSoundAtBlock(World world, int x, int y, int z, String snd) {
        world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, snd, 1.0f, 1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public static void playCustomSoundAtBlock(String file, TileEntity te) {
        ReikaSoundHelper.playCustomSoundAtBlock(file, te.field_145851_c, te.field_145848_d, te.field_145849_e);
    }

    @SideOnly(value=Side.CLIENT)
    public static void playCustomSoundAtBlock(String file, int x, int y, int z) {
        ReikaSoundHelper.playCustomSoundAtBlock(file, x, y, z, 1.0f, 1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public static void playCustomSoundAtBlock(String file, int x, int y, int z, float vol, float pitch) {
        ReikaSoundHelper.playCustomSound(file, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, vol, pitch);
    }

    @SideOnly(value=Side.CLIENT)
    public static void playCustomSound(String file, Entity e, float vol, float pitch) {
        ReikaSoundHelper.playCustomSound(file, e.field_70165_t, e.field_70163_u, e.field_70161_v, vol, pitch);
    }

    @SideOnly(value=Side.CLIENT)
    public static void playCustomSound(String file, double x, double y, double z, float vol, float pitch) {
        ResourceLocation rl = CustomSoundHandler.instance.getSoundResource(file);
        try {
            FMLClientHandler.instance().getClient().func_147118_V().func_147682_a((ISound)new PositionedSoundRecord(rl, (float)x, (float)y, (float)z, vol, pitch));
        }
        catch (ConcurrentModificationException e) {
            e.printStackTrace();
        }
    }

    public static void playSound(SoundEnum s, String ch, World world, Entity e, float vol, float pitch) {
        ReikaSoundHelper.playSound(s, ch, world, e.field_70165_t, e.field_70163_u, e.field_70161_v, vol, pitch);
    }

    public static void playSound(SoundEnum s, String ch, World world, double x, double y, double z, float vol, float pitch) {
        ReikaSoundHelper.playSound(s, ch, world, x, y, z, vol, pitch, s.attenuate());
    }

    public static void playSound(SoundEnum s, String ch, World world, double x, double y, double z, float vol, float pitch, boolean atten) {
        long time = world.func_82737_E();
        if (!s.canOverlap()) {
            Collection<SoundPlay> c = plays.get(s);
            Iterator<SoundPlay> it = c.iterator();
            while (it.hasNext()) {
                SoundPlay p = it.next();
                if (time - p.time < 20L) {
                    if (!(p.loc.getDistanceTo(x, y, z) < 12.0) || p.loc.sharesBlock(x, y, z)) continue;
                    return;
                }
                it.remove();
            }
            plays.addValue(s, new SoundPlay(time, x, y, z));
        }
        ReikaSoundHelper.sendSound(ch, s, world, x, y, z, vol, pitch, atten);
    }

    private static void sendSound(String ch, SoundEnum s, World world, double x, double y, double z, float vol, float pitch, boolean atten) {
        ReikaPacketHelper.sendSoundPacket(ch, s, world, x, y, z, vol, pitch, atten);
    }

    @SideOnly(value=Side.CLIENT)
    public static void playClientSound(SoundEnum s, double x, double y, double z, float vol, float pitch) {
        ReikaSoundHelper.playClientSound(s, x, y, z, vol, pitch, true);
    }

    @SideOnly(value=Side.CLIENT)
    public static void playClientSound(SoundEnum s, double x, double y, double z, float vol, float pitch, boolean att) {
        float v = vol * s.getModulatedVolume();
        if (v <= 0.0f) {
            return;
        }
        try {
            FMLClientHandler.instance().getClient().func_147118_V().func_147682_a((ISound)new EnumSound(s, x, y, z, v, pitch, att));
        }
        catch (ConcurrentModificationException e) {
            e.printStackTrace();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void playClientSound(SoundEnum s, Entity e, float vol, float pitch, boolean att) {
        ReikaSoundHelper.playClientSound(s, e.field_70165_t, e.field_70163_u, e.field_70161_v, vol, pitch, att);
    }

    @SideOnly(value=Side.CLIENT)
    public static void playClientSound(SoundEnum s, Entity e, float vol, float pitch) {
        ReikaSoundHelper.playClientSound(s, e.field_70165_t, e.field_70163_u, e.field_70161_v, vol, pitch, true);
    }

    @SideOnly(value=Side.CLIENT)
    public static void playNormalClientSound(World world, double x, double y, double z, String name, float vol, float pitch, boolean flag) {
        world.func_72980_b(x, y, z, name, vol, pitch, flag);
    }

    public static void broadcastSound(SoundEnum s, String ch, float vol, float pitch) {
        WorldServer[] worlds;
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            throw new MisuseException("You cannot call this from the client!");
        }
        for (WorldServer world : worlds = DimensionManager.getWorlds()) {
            for (EntityPlayer ep : world.field_73010_i) {
                ReikaSoundHelper.playSound(s, ch, (World)world, (Entity)ep, vol, pitch);
            }
        }
    }

    public static void playSoundAtEntity(World world, Entity e, String snd) {
        ReikaSoundHelper.playSoundAtEntity(world, e, snd, 1.0f, 1.0f);
    }

    public static void playSoundAtEntity(World world, Entity e, String snd, float vol, float p) {
        world.func_72908_a(e.field_70165_t, e.field_70163_u, e.field_70161_v, snd, vol, p);
    }

    public static void playSoundFromServer(World world, double x, double y, double z, String name, float vol, float pitch, boolean scale) {
        ReikaPacketHelper.writeDirectSound("DragonAPIData", APIPacketHandler.PacketIDs.SERVERSOUND.ordinal(), world, x, y, z, name, vol, pitch, scale);
    }

    public static void playSoundFromServerAtBlock(World world, int x, int y, int z, String name, float vol, float pitch, boolean scale) {
        ReikaSoundHelper.playSoundFromServer(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, name, vol, pitch, scale);
    }

    @SideOnly(value=Side.CLIENT)
    public static StreamThread getStreamingThread(SoundHandler sh) {
        try {
            SoundManager.SoundSystemStarterThread sys = sh.field_147694_f.field_148620_e;
            Library lib = (Library)soundLibraryField.get(sys);
            StreamThread s = (StreamThread)streamThreadField.get(lib);
            return s;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void restartStreamingSystem(SoundHandler sh) {
        DragonAPICore.log("Restarting sound streaming thread.");
        StreamThread thread = new StreamThread();
        try {
            SoundManager.SoundSystemStarterThread sys = sh.field_147694_f.field_148620_e;
            Library lib = (Library)soundLibraryField.get(sys);
            streamThreadField.set(lib, thread);
            thread.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void injectPaulscodeAccesses() {
        try {
            DragonAPICore.log("Injecting accesses into paulscode...");
            soundLibraryField = SoundSystem.class.getDeclaredField("soundLibrary");
            streamThreadField = Library.class.getDeclaredField("streamThread");
            soundLibraryField.setAccessible(true);
            streamThreadField.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static MusicTicker.MusicType getMusicTypeByResourceLocation(ResourceLocation loc) {
        return musicTypes.get(loc);
    }

    @SideOnly(value=Side.CLIENT)
    private static void doClientInit() {
        musicTypes = new HashMap();
        for (MusicTicker.MusicType type : MusicTicker.MusicType.values()) {
            musicTypes.put(type.func_148635_a(), type);
        }
    }

    static {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            ReikaSoundHelper.doClientInit();
        }
    }

    private static class SoundPlay {
        private final long time;
        private final DecimalPosition loc;

        private SoundPlay(long t, double x, double y, double z) {
            this.time = t;
            this.loc = new DecimalPosition(x, y, z);
        }
    }
}

